/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.awt.Insets;
import org.pushingpixels.radiance.component.api.common.model.ImmutablePresentationModel;

public class RichTooltipPresentationModel
implements ImmutablePresentationModel {
    public static final Insets DEFAULT_CONTENT_PADDING = new Insets(6, 6, 6, 6);
    public static final int LARGE_ICON_SIZE = 32;
    public static final int SMALL_ICON_SIZE = 16;
    private Insets contentPadding;
    private int mainIconSize;
    private int footerIconSize;

    private RichTooltipPresentationModel() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMainIconSize() {
        return this.mainIconSize;
    }

    public int getFooterIconSize() {
        return this.footerIconSize;
    }

    public Insets getContentPadding() {
        return this.contentPadding;
    }

    public static class Builder {
        private Insets contentPadding = DEFAULT_CONTENT_PADDING;
        private int mainIconSize = 32;
        private int footerIconSize = 16;

        public Builder setContentPadding(Insets contentPadding) {
            if (contentPadding == null) {
                throw new IllegalArgumentException("Content padding cannot be null");
            }
            this.contentPadding = contentPadding;
            return this;
        }

        public Builder setMainIconSize(int mainIconSize) {
            this.mainIconSize = mainIconSize;
            return this;
        }

        public Builder setFooterIconSize(int footerIconSize) {
            this.footerIconSize = footerIconSize;
            return this;
        }

        public RichTooltipPresentationModel build() {
            RichTooltipPresentationModel presentationModel = new RichTooltipPresentationModel();
            presentationModel.contentPadding = this.contentPadding;
            presentationModel.mainIconSize = this.mainIconSize;
            presentationModel.footerIconSize = this.footerIconSize;
            return presentationModel;
        }
    }
}

