/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.model.ChangeAware;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.internal.utils.WeakChangeSupport;

public class CommandPanelContentModel
implements ContentModel,
ChangeAware {
    private List<CommandGroup> commandGroups;
    private boolean isSingleSelectionMode;
    private Command.CommandActionPreview commandPreviewListener;
    private final WeakChangeSupport weakChangeSupport = new WeakChangeSupport(this);
    private CommandGroup.CommandGroupListener commandGroupListener;
    private PropertyChangeListener commandGroupPropertyChangeListener;

    public CommandPanelContentModel(List<CommandGroup> commands) {
        this.commandGroups = new ArrayList<CommandGroup>(commands);
        this.commandGroupListener = new CommandGroup.CommandGroupListener(){

            @Override
            public void onCommandAdded(Command command) {
                CommandPanelContentModel.this.fireStateChanged();
            }

            @Override
            public void onCommandRemoved(Command command) {
                CommandPanelContentModel.this.fireStateChanged();
            }

            @Override
            public void onAllCommandsRemoved() {
                CommandPanelContentModel.this.fireStateChanged();
            }
        };
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        }
        this.commandGroupPropertyChangeListener = propertyChangeEvent -> this.fireStateChanged();
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.addPropertyChangeListener(this.commandGroupPropertyChangeListener);
        }
    }

    public void addCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.add(commandGroupModel);
        commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        commandGroupModel.addPropertyChangeListener(this.commandGroupPropertyChangeListener);
        this.fireStateChanged();
    }

    public void removeCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.remove(commandGroupModel);
        commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
        commandGroupModel.removePropertyChangeListener(this.commandGroupPropertyChangeListener);
        this.fireStateChanged();
    }

    public void removeAllCommandGroups() {
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
            commandGroupModel.removePropertyChangeListener(this.commandGroupPropertyChangeListener);
        }
        this.commandGroups.clear();
        this.fireStateChanged();
    }

    public List<CommandGroup> getCommandGroups() {
        return Collections.unmodifiableList(this.commandGroups);
    }

    public int getCommandCount() {
        int result = 0;
        for (CommandGroup commandGroupModel : this.getCommandGroups()) {
            result += commandGroupModel.getCommands().size();
        }
        return result;
    }

    public Command findFirstMatch(CommandGroup.CommandFilter commandFilter) {
        for (CommandGroup commandGroup : this.commandGroups) {
            Command result = commandGroup.findFirstMatch(commandFilter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setSingleSelectionMode(boolean isSingleSelectionMode) {
        if (this.isSingleSelectionMode == isSingleSelectionMode) {
            return;
        }
        this.isSingleSelectionMode = isSingleSelectionMode;
        this.fireStateChanged();
    }

    public boolean isSingleSelectionMode() {
        return this.isSingleSelectionMode;
    }

    public void setCommandPreviewListener(Command.CommandActionPreview commandPreviewListener) {
        this.commandPreviewListener = commandPreviewListener;
    }

    public Command.CommandActionPreview getCommandPreviewListener() {
        return this.commandPreviewListener;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.weakChangeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.weakChangeSupport.removeChangeListener(l);
    }

    private void fireStateChanged() {
        this.weakChangeSupport.fireStateChanged();
    }
}

