/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.api.common.model.PropertyChangeAware;
import org.pushingpixels.radiance.component.internal.utils.WeakPropertyChangeSupport;

public class CommandGroup
implements ContentModel,
PropertyChangeAware {
    private String title;
    private List<Command> commands;
    private EventListenerList listenerList = new EventListenerList();
    private final WeakPropertyChangeSupport weakPropertyChangeSupport = new WeakPropertyChangeSupport(this);

    public CommandGroup(Command ... commands) {
        this((String)null, commands);
    }

    public CommandGroup(List<Command> commands) {
        this(null, commands);
    }

    public CommandGroup(String title, Command ... commands) {
        this(title, Arrays.asList(commands));
    }

    public CommandGroup(String title, List<Command> commands) {
        this.title = title;
        this.commands = new ArrayList<Command>(commands);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (!this.title.equals(title)) {
            String old = this.title;
            this.title = title;
            this.weakPropertyChangeSupport.firePropertyChange("title", old, this.title);
        }
    }

    public List<Command> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public Command findFirstMatch(CommandFilter filter) {
        for (Command command : this.commands) {
            if (!filter.matches(command)) continue;
            return command;
        }
        return null;
    }

    public void addCommand(Command command) {
        if (command != null && !this.commands.contains(command)) {
            this.commands.add(command);
            this.fireCommandAdded(command);
        }
    }

    public void removeCommand(Command command) {
        if (this.commands.remove(command)) {
            this.fireCommandRemoved(command);
        }
    }

    public void removeAllCommands() {
        this.commands.clear();
        this.fireAllCommandsRemoved();
    }

    public void addCommandGroupListener(CommandGroupListener l) {
        this.listenerList.add(CommandGroupListener.class, l);
    }

    public void removeCommandGroupListener(CommandGroupListener l) {
        this.listenerList.remove(CommandGroupListener.class, l);
    }

    private void fireCommandAdded(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandGroupListener.class) continue;
            ((CommandGroupListener)listeners[i + 1]).onCommandAdded(command);
        }
    }

    private void fireCommandRemoved(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandGroupListener.class) continue;
            ((CommandGroupListener)listeners[i + 1]).onCommandRemoved(command);
        }
    }

    private void fireAllCommandsRemoved() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandGroupListener.class) continue;
            ((CommandGroupListener)listeners[i + 1]).onAllCommandsRemoved();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.weakPropertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.weakPropertyChangeSupport.removePropertyChangeListener(l);
    }

    public static interface CommandFilter {
        public boolean matches(Command var1);
    }

    public static interface CommandGroupListener
    extends EventListener {
        public void onCommandAdded(Command var1);

        public void onCommandRemoved(Command var1);

        public void onAllCommandsRemoved();
    }
}

