/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.RichTooltipManager;
import org.pushingpixels.radiance.component.api.common.model.RichTooltipPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.SwitchContentModel;
import org.pushingpixels.radiance.component.api.common.model.SwitchPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceSwitchUI;

public class JSwitch
extends JToggleButton
implements RichTooltipManager.WithRichTooltip {
    public static final String uiClassID = "SwitchUI";
    private Projection<JSwitch, SwitchContentModel, SwitchPresentationModel> projection;
    private SwitchContentModel contentModel;
    private SwitchPresentationModel presentationModel;
    private ButtonModel buttonModel;

    public JSwitch(Projection<JSwitch, SwitchContentModel, SwitchPresentationModel> projection) {
        this.projection = projection;
        this.contentModel = (SwitchContentModel)projection.getContentModel();
        this.presentationModel = (SwitchPresentationModel)projection.getPresentationModel();
        this.buttonModel = new JToggleButton.ToggleButtonModel();
        this.buttonModel.setEnabled(this.contentModel.isEnabled());
        this.buttonModel.setSelected(this.contentModel.isSelected());
        this.buttonModel.addItemListener(this.contentModel.getItemListener());
        this.buttonModel.addActionListener(this.contentModel.getActionListener());
        this.setModel(this.buttonModel);
        RichTooltipManager.sharedInstance();
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceSwitchUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Projection<JSwitch, SwitchContentModel, SwitchPresentationModel> getProjection() {
        return this.projection;
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.contentModel.getRichTooltip();
    }

    @Override
    public RichTooltipPresentationModel getRichTooltipPresentationModel(MouseEvent mouseEvent) {
        return this.presentationModel.getRichTooltipPresentationModel();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }
}

