/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelLayoutSpec;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceCommandButtonPanelUI;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonPanelUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class JCommandButtonPanel
extends JComponent
implements Scrollable {
    public static final String uiClassID = "CommandButtonPanelUI";
    private Projection<JCommandButtonPanel, CommandPanelContentModel, CommandPanelPresentationModel> projection;
    private CommandPanelContentModel panelContentModel;
    private CommandPanelPresentationModel panelPresentationModel;
    private List<String> groupTitles;
    private List<List<JCommandButton>> buttons;
    private ChangeListener contentChangeListener;
    private Insets contentPadding;
    private int contentGap;
    private CommandToggleGroupModel buttonGroup;

    public JCommandButtonPanel(Projection<JCommandButtonPanel, CommandPanelContentModel, CommandPanelPresentationModel> projection) {
        this.projection = projection;
        this.panelContentModel = (CommandPanelContentModel)projection.getContentModel();
        this.panelPresentationModel = (CommandPanelPresentationModel)projection.getPresentationModel();
        this.buttons = new ArrayList<List<JCommandButton>>();
        this.groupTitles = new ArrayList<String>();
        this.contentPadding = this.panelPresentationModel.getContentPadding();
        this.contentGap = this.panelPresentationModel.getContentGap();
        this.populateContent();
        this.contentChangeListener = changeEvent -> this.populateContent();
        this.panelContentModel.addChangeListener(this.contentChangeListener);
        this.updateUI();
    }

    public Projection<JCommandButtonPanel, CommandPanelContentModel, CommandPanelPresentationModel> getProjection() {
        return this.projection;
    }

    private CommandButtonPresentationModel createBaseCommandPresentation() {
        return CommandButtonPresentationModel.builder().setPresentationState(this.panelPresentationModel.getCommandPresentationState()).setIconDimension(this.panelPresentationModel.getCommandIconDimension()).setContentPadding(this.panelPresentationModel.getCommandContentPadding()).setHorizontalGapScaleFactor(this.panelPresentationModel.getCommandHorizontalGapScaleFactor()).setVerticalGapScaleFactor(this.panelPresentationModel.getCommandVerticalGapScaleFactor()).setBackgroundAppearanceStrategy(this.panelPresentationModel.getBackgroundAppearanceStrategy()).setIconFilterStrategies(this.panelPresentationModel.getActiveIconFilterStrategy(), this.panelPresentationModel.getEnabledIconFilterStrategy(), this.panelPresentationModel.getDisabledIconFilterStrategy()).setMenu(this.panelPresentationModel.isMenu()).setHorizontalAlignment(this.panelPresentationModel.getCommandHorizontalAlignment()).setPopupPlacementStrategy(this.panelPresentationModel.getPopupPlacementStrategy()).build();
    }

    private void populateContent() {
        this.groupTitles.clear();
        this.buttons.clear();
        this.removeAll();
        this.buttonGroup = this.panelContentModel.isSingleSelectionMode() ? new CommandToggleGroupModel() : null;
        int groupIndex = 0;
        CommandButtonPresentationModel baseCommandPresentation = this.createBaseCommandPresentation();
        final Command.CommandActionPreview commandPreviewListener = this.panelContentModel.getCommandPreviewListener();
        for (CommandGroup groupModel : this.panelContentModel.getCommandGroups()) {
            this.groupTitles.add(groupIndex, groupModel.getTitle());
            ArrayList list = new ArrayList();
            this.buttons.add(groupIndex, list);
            for (final Command command : groupModel.getCommands()) {
                CommandButtonPresentationModel commandPresentation = this.projection.getCommandOverlays().containsKey(command) ? baseCommandPresentation.overlayWith(this.projection.getCommandOverlays().get(command)) : baseCommandPresentation;
                CommandButtonProjection<Command> commandProjection = command.project(commandPresentation);
                commandProjection.setCommandOverlays(this.projection.getCommandOverlays());
                final JCommandButton button = (JCommandButton)commandProjection.buildComponent();
                if (commandPreviewListener != null) {
                    button.getActionModel().addChangeListener(new ChangeListener(){
                        boolean wasRollover = false;

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            boolean isRollover = button.getActionModel().isRollover();
                            if (this.wasRollover && !isRollover) {
                                commandPreviewListener.onCommandPreviewCanceled(command);
                            }
                            if (!this.wasRollover && isRollover) {
                                commandPreviewListener.onCommandPreviewActivated(command);
                            }
                            this.wasRollover = isRollover;
                        }
                    });
                }
                this.addButtonToLastGroup(command, button);
            }
            ++groupIndex;
        }
    }

    private void addButtonToLastGroup(Command command, JCommandButton commandButton) {
        if (this.groupTitles.size() == 0) {
            return;
        }
        int groupIndex = this.groupTitles.size() - 1;
        this.addButtonToGroup(this.groupTitles.get(groupIndex), this.buttons.get(groupIndex).size(), command, commandButton);
    }

    private void addButtonToGroup(String buttonGroupName, int indexInGroup, Command command, JCommandButton commandButton) {
        int groupIndex = this.groupTitles.indexOf(buttonGroupName);
        if (groupIndex < 0) {
            return;
        }
        commandButton.setIconDimension(this.panelPresentationModel.getCommandIconDimension());
        commandButton.setContentPadding(this.panelPresentationModel.getCommandContentPadding());
        commandButton.setPresentationState(this.panelPresentationModel.getCommandPresentationState());
        commandButton.setHGapScaleFactor(this.panelPresentationModel.getCommandHorizontalGapScaleFactor());
        commandButton.setVGapScaleFactor(this.panelPresentationModel.getCommandVerticalGapScaleFactor());
        commandButton.setBackgroundAppearanceStrategy(this.panelPresentationModel.getBackgroundAppearanceStrategy());
        RadianceThemingCortex.ComponentScope.setIconFilterStrategies((JComponent)commandButton, (RadianceThemingSlices.IconFilterStrategy)this.panelPresentationModel.getActiveIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)this.panelPresentationModel.getEnabledIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)this.panelPresentationModel.getDisabledIconFilterStrategy());
        this.add(commandButton);
        this.buttons.get(groupIndex).add(indexInGroup, commandButton);
        if (this.panelContentModel.isSingleSelectionMode() && command.isToggle()) {
            this.buttonGroup.add(command);
        }
    }

    public int getGroupCount() {
        return this.groupTitles != null ? this.groupTitles.size() : 0;
    }

    public String getGroupTitleAt(int index) {
        return this.panelContentModel.getCommandGroups().get(index).getTitle();
    }

    @Override
    public CommandButtonPanelUI getUI() {
        return (CommandButtonPanelUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceCommandButtonPanelUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public List<JCommandButton> getGroupButtons(int groupIndex) {
        return Collections.unmodifiableList(this.buttons.get(groupIndex));
    }

    public Command getSelectedCommand() {
        if (this.panelContentModel.isSingleSelectionMode()) {
            for (List<JCommandButton> commandButtons : this.buttons) {
                for (JCommandButton commandButton : commandButtons) {
                    Command curr = (Command)commandButton.getProjection().getContentModel();
                    if (!curr.isToggleSelected()) continue;
                    return curr;
                }
            }
        }
        return null;
    }

    public void scrollToSelectedCommand() {
        if (this.panelContentModel.isSingleSelectionMode()) {
            for (List<JCommandButton> commandButtons : this.buttons) {
                for (JCommandButton commandButton : commandButtons) {
                    Command curr = (Command)commandButton.getProjection().getContentModel();
                    if (!curr.isToggleSelected()) continue;
                    Rectangle selectionButtonBounds = commandButton.getBounds();
                    this.scrollRectToVisible(selectionButtonBounds);
                    return;
                }
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return ((CommandPanelPresentationModel)this.getProjection().getPresentationModel()).getLayoutSpec() instanceof PanelLayoutSpec.ColumnFill;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return ((CommandPanelPresentationModel)this.getProjection().getPresentationModel()).getLayoutSpec() instanceof PanelLayoutSpec.RowFill;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }
}

