/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonLayoutManagerBig;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonLayoutManagerFitToIcon;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonLayoutManagerMedium;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonLayoutManagerSmall;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonLayoutManagerTile;

public abstract class CommandButtonPresentationState {
    public static final CommandButtonPresentationState FIT_TO_ICON = new CommandButtonPresentationState("Fit to icon", -1){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton commandButton) {
            return new CommandButtonLayoutManagerFitToIcon(commandButton);
        }
    };
    public static final CommandButtonPresentationState BIG = new CommandButtonPresentationState("Big", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton commandButton) {
            return new CommandButtonLayoutManagerBig(commandButton);
        }
    };
    public static final CommandButtonPresentationState TILE = new CommandButtonPresentationState("Tile", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton arg0) {
            return new CommandButtonLayoutManagerTile();
        }
    };
    public static final CommandButtonPresentationState MEDIUM = new CommandButtonPresentationState("Medium", 16){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton arg0) {
            return new CommandButtonLayoutManagerMedium();
        }
    };
    public static final CommandButtonPresentationState SMALL = new CommandButtonPresentationState("Small", 16){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton arg0) {
            return new CommandButtonLayoutManagerSmall();
        }
    };
    private int preferredIconSize;
    private String displayName;

    protected CommandButtonPresentationState(String displayName, int preferredIconSize) {
        this.displayName = displayName;
        this.preferredIconSize = preferredIconSize;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    public abstract CommandButtonLayoutManager createLayoutManager(JCommandButton var1);

    public String toString() {
        return this.getDisplayName();
    }
}

