/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JScrollablePanel;
import org.pushingpixels.radiance.component.api.common.RichTooltipManager;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.popup.JCommandPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceCommandButtonUI;
import org.pushingpixels.radiance.component.internal.ui.common.popup.BasicPopupPanelUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel1;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.RibbonApplicationMenuPanelPanelProjection;
import org.pushingpixels.radiance.component.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public abstract class BasicRibbonApplicationMenuPopupPanelUI
extends BasicPopupPanelUI {
    private JPanel panelLevel1;
    protected JScrollablePanel<JPanel> panelScrollerLevel2;
    protected JPanel panelLevel2;
    private JPanel footerPanel;
    private static final CommandButtonPresentationState MENU_TILE_LEVEL_1 = new CommandButtonPresentationState("Ribbon application menu tile level 1", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel1();
        }
    };
    protected JRibbonApplicationMenuPopupPanel applicationMenuPopupPanel;
    protected JPanel mainPanel;

    @Override
    public void installUI(JComponent c) {
        this.applicationMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)c;
        this.popupPanel = (JPopupPanel)c;
        this.applicationMenuPopupPanel.setLayout(new BorderLayout());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.applicationMenuPopupPanel = null;
    }

    @Override
    protected void installComponents() {
        Map<Command, CommandButtonPresentationModel.Overlay> commandOverlays;
        RibbonApplicationMenu ribbonAppMenu;
        super.installComponents();
        this.mainPanel = new JPanel(new BorderLayout());
        this.panelLevel1 = new JPanel();
        this.panelLevel1.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int height = 0;
                int width = 0;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Dimension pref = parent.getComponent(i).getPreferredSize();
                    height += pref.height;
                    width = Math.max(width, pref.width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets ins = parent.getInsets();
                int topY = ins.top;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension pref = comp.getPreferredSize();
                    comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, pref.height);
                    topY += pref.height;
                }
            }
        });
        RibbonApplicationMenuPanelPanelProjection ribbonAppMenuProjection = (RibbonApplicationMenuPanelPanelProjection)this.applicationMenuPopupPanel.getRibbonAppMenuProjection();
        RibbonApplicationMenu ribbonApplicationMenu = ribbonAppMenu = ribbonAppMenuProjection != null ? (RibbonApplicationMenu)ribbonAppMenuProjection.getContentModel() : null;
        if (ribbonAppMenu != null) {
            commandOverlays = ribbonAppMenuProjection.getCommandOverlays();
            CommandButtonPresentationModel baseCommandPresentation = CommandButtonPresentationModel.builder().setMenu(true).build();
            List<CommandGroup> primaryEntries = ribbonAppMenu.getCommandGroups();
            int primaryGroupCount = primaryEntries.size();
            for (int i = 0; i < primaryGroupCount; ++i) {
                for (Command menuEntry : primaryEntries.get(i).getCommands()) {
                    CommandButtonPresentationModel commandPresentation = baseCommandPresentation;
                    if (commandOverlays.containsKey(menuEntry)) {
                        commandPresentation = commandPresentation.overlayWith(commandOverlays.get(menuEntry));
                    }
                    JCommandButton commandButton = (JCommandButton)menuEntry.project(commandPresentation).buildComponent();
                    if (menuEntry.getSecondaryContentModel() == null) {
                        commandButton.addRolloverActionListener(event -> {
                            this.panelLevel2.removeAll();
                            this.panelScrollerLevel2.applyComponentOrientation(this.applicationMenuPopupPanel.getComponentOrientation());
                            this.panelLevel2.revalidate();
                            this.panelLevel2.repaint();
                        });
                    } else {
                        commandButton.addRolloverActionListener(event -> {
                            this.panelLevel2.removeAll();
                            this.panelLevel2.setLayout(new BorderLayout());
                            CommandButtonPresentationState secondaryMenuPresentationState = ribbonAppMenuProjection.getSecondaryLevelCommandPresentationState().get(menuEntry);
                            if (secondaryMenuPresentationState == null) {
                                secondaryMenuPresentationState = CommandButtonPresentationState.MEDIUM;
                            }
                            JRibbonApplicationMenuPopupPanelSecondary secondary = JRibbonApplicationMenuPopupPanelSecondary.getPanel(menuEntry, commandOverlays, secondaryMenuPresentationState, commandButton);
                            secondary.applyComponentOrientation(this.applicationMenuPopupPanel.getComponentOrientation());
                            this.panelLevel2.add((Component)secondary, "Center");
                            this.panelLevel2.revalidate();
                            this.panelLevel2.repaint();
                            commandButton.getPopupModel().setPopupShowing(true);
                        });
                    }
                    commandButton.setPresentationState(MENU_TILE_LEVEL_1);
                    commandButton.setHorizontalAlignment(10);
                    commandButton.setPopupOrientationKind(CommandButtonPresentationModel.PopupOrientationKind.SIDEWARD);
                    this.panelLevel1.add(commandButton);
                }
                if (i >= primaryGroupCount - 1) continue;
                this.panelLevel1.add(new JPopupMenu.Separator());
            }
        }
        this.mainPanel.add((Component)this.panelLevel1, "Before");
        this.panelLevel2 = new JPanel();
        this.panelScrollerLevel2 = new JScrollablePanel<JPanel>(this.panelLevel2, JScrollablePanel.ScrollType.VERTICALLY);
        this.panelScrollerLevel2.setPreferredSize(new Dimension(30 * this.panelLevel1.getFont().getSize() - 30, 10));
        this.mainPanel.add(this.panelScrollerLevel2, "Center");
        this.applicationMenuPopupPanel.add((Component)this.mainPanel, "Center");
        this.footerPanel = new JPanel(new FlowLayout(4)){

            @Override
            protected void paintComponent(Graphics g) {
                RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this);
                RadianceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)this));
                Color backgroundFill = scheme.getAccentedBackgroundFillColor();
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(backgroundFill);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.dispose();
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Component child = this.getComponent(i);
                    if (!(child instanceof JCommandButton)) continue;
                    JCommandButton button = (JCommandButton)child;
                    g.translate(button.getX(), button.getY() + 4);
                    KeyTipRenderingUtilities.renderButtonKeyTips(g, button, button.getUI().getLayoutManager());
                    g.translate(-button.getX(), -button.getY() - 4);
                }
            }
        };
        if (ribbonAppMenu != null) {
            commandOverlays = ribbonAppMenuProjection.getCommandOverlays();
            for (Command footerCommand : ribbonAppMenu.getFooterCommands().getCommands()) {
                CommandButtonPresentationModel commandPresentation = CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.MEDIUM).setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy.ALWAYS).build();
                if (commandOverlays.containsKey(footerCommand)) {
                    commandPresentation = commandPresentation.overlayWith(commandOverlays.get(footerCommand));
                }
                JCommandButton commandFooterButton = (JCommandButton)footerCommand.project(commandPresentation).buildComponent();
                this.footerPanel.add(commandFooterButton);
            }
        }
        this.applicationMenuPopupPanel.add((Component)this.footerPanel, "South");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    public JPanel getPanelLevel1() {
        return this.panelLevel1;
    }

    public JPanel getPanelLevel2() {
        return this.panelLevel2;
    }

    public JPanel getFooterPanel() {
        return this.footerPanel;
    }

    private boolean getCommandPath(CommandMenuContentModel commandMenuContentModel, Command command, List<Command> pathTo) {
        for (CommandGroup group : commandMenuContentModel.getCommandGroups()) {
            if (!group.getCommands().contains(command)) continue;
            return true;
        }
        for (CommandGroup group : commandMenuContentModel.getCommandGroups()) {
            for (Command secondary : group.getCommands()) {
                CommandMenuContentModel secondaryMenuContentModel = secondary.getSecondaryContentModel();
                if (secondaryMenuContentModel == null) continue;
                pathTo.add(secondary);
                if (this.getCommandPath(secondaryMenuContentModel, command, pathTo)) {
                    return true;
                }
                pathTo.remove(pathTo.size() - 1);
            }
        }
        return false;
    }

    private <T extends RichTooltipManager.JTrackableComponent> T getPrimaryForCommand(Command command) {
        for (int topLevelIndex = 0; topLevelIndex < this.panelLevel1.getComponentCount(); ++topLevelIndex) {
            JCommandButton button;
            Component topLevel = this.panelLevel1.getComponent(topLevelIndex);
            if (!(topLevel instanceof JCommandButton) || (button = (JCommandButton)topLevel).getProjection().getContentModel() != command) continue;
            return (T)button;
        }
        return null;
    }

    private <T extends RichTooltipManager.JTrackableComponent> T getSecondaryForCommand(Command command) {
        JRibbonApplicationMenuPopupPanelSecondary secondaryPanel = (JRibbonApplicationMenuPopupPanelSecondary)this.panelLevel2.getComponent(0);
        for (int secondLevelIndex = 0; secondLevelIndex < secondaryPanel.getComponentCount(); ++secondLevelIndex) {
            JCommandButton secondLevelButton;
            Component secondLevel = secondaryPanel.getComponent(secondLevelIndex);
            if (!(secondLevel instanceof JCommandButton) || (secondLevelButton = (JCommandButton)secondLevel).getProjection().getContentModel() != command) continue;
            return (T)secondLevelButton;
        }
        return null;
    }

    private <T extends RichTooltipManager.JTrackableComponent> T getMenuButtonForCommand(Command command) {
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() > 0) {
            PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
            JPopupPanel popupPanel = last.getPopupPanel();
            if (!(popupPanel instanceof JCommandPopupMenuPanel)) {
                return null;
            }
            JCommandPopupMenuPanel popupMenu = (JCommandPopupMenuPanel)popupPanel;
            for (Component child : popupMenu.getMenuComponents()) {
                JCommandButton button;
                if (!(child instanceof JCommandButton) || (button = (JCommandButton)child).getProjection().getContentModel() != command) continue;
                return (T)button;
            }
        }
        return null;
    }

    public Runnable getPathToSequence(Command command) {
        RibbonApplicationMenu ribbonAppMenu;
        RibbonApplicationMenuPanelPanelProjection ribbonAppMenuProjection = (RibbonApplicationMenuPanelPanelProjection)this.applicationMenuPopupPanel.getRibbonAppMenuProjection();
        RibbonApplicationMenu ribbonApplicationMenu = ribbonAppMenu = ribbonAppMenuProjection != null ? (RibbonApplicationMenu)ribbonAppMenuProjection.getContentModel() : null;
        if (ribbonAppMenu == null) {
            return null;
        }
        int footerIndex = ribbonAppMenu.getFooterCommands().getCommands().indexOf(command);
        if (footerIndex >= 0) {
            JCommandButton footerButton = (JCommandButton)this.footerPanel.getComponent(footerIndex);
            return () -> {
                footerButton.getActionModel().setRollover(true);
                footerButton.getActionModel().setArmed(true);
            };
        }
        ArrayList<Command> pathToCommand = new ArrayList<Command>();
        boolean found = this.getCommandPath(ribbonAppMenu, command, pathToCommand);
        if (!found) {
            return null;
        }
        int pathLength = pathToCommand.size();
        if (pathLength == 0) {
            JCommandButton primary = (JCommandButton)this.getPrimaryForCommand(command);
            if (primary == null) {
                throw new IllegalStateException("Should have found the command at top level");
            }
            return () -> {
                primary.getActionModel().setRollover(true);
                primary.getActionModel().setArmed(true);
            };
        }
        JCommandButton primary = (JCommandButton)this.getPrimaryForCommand((Command)pathToCommand.get(0));
        if (primary == null) {
            throw new IllegalStateException("Should have found the command at top level");
        }
        if (pathLength == 1) {
            return () -> {
                primary.getPopupModel().setRollover(true);
                primary.getPopupModel().setArmed(true);
                RadianceCommandButtonUI buttonUI = (RadianceCommandButtonUI)primary.getUI();
                buttonUI.fireRolloverActionPerformed(new ActionEvent(this, 1001, primary.getActionModel().getActionCommand(), EventQueue.getMostRecentEventTime(), 0));
                SwingUtilities.invokeLater(() -> {
                    JCommandButton secondLevelButton = (JCommandButton)this.getSecondaryForCommand(command);
                    Rectangle selectionButtonBounds = secondLevelButton.getBounds();
                    this.panelScrollerLevel2.scrollToIfNecessary(selectionButtonBounds.y, selectionButtonBounds.height);
                    secondLevelButton.getActionModel().setRollover(true);
                    secondLevelButton.getActionModel().setArmed(true);
                });
            };
        }
        return () -> {
            primary.getPopupModel().setRollover(true);
            primary.getPopupModel().setArmed(true);
            RadianceCommandButtonUI buttonUI = (RadianceCommandButtonUI)primary.getUI();
            buttonUI.fireRolloverActionPerformed(new ActionEvent(this, 1001, primary.getActionModel().getActionCommand(), EventQueue.getMostRecentEventTime(), 0));
            SwingUtilities.invokeLater(() -> {
                JCommandButton secondLevelButton = (JCommandButton)this.getSecondaryForCommand((Command)pathToCommand.get(1));
                Rectangle selectionButtonBounds = secondLevelButton.getBounds();
                this.panelScrollerLevel2.scrollToIfNecessary(selectionButtonBounds.y, selectionButtonBounds.height);
                secondLevelButton.getPopupModel().setRollover(true);
                secondLevelButton.getPopupModel().setArmed(true);
                RadianceCommandButtonUI secondLevelButtonUI = (RadianceCommandButtonUI)secondLevelButton.getUI();
                secondLevelButtonUI.processPopupAction();
                int levelsToGo = pathLength - 2;
                for (int i = 0; i <= levelsToGo; ++i) {
                    int currLevel = 2 + i;
                    SwingUtilities.invokeLater(() -> {
                        if (currLevel == pathLength) {
                            JCommandButton lastLevelButton = (JCommandButton)this.getMenuButtonForCommand(command);
                            lastLevelButton.getActionModel().setRollover(true);
                            lastLevelButton.getActionModel().setArmed(true);
                        } else {
                            JCommandButton currLevelButton = (JCommandButton)this.getMenuButtonForCommand((Command)pathToCommand.get(currLevel));
                            currLevelButton.getPopupModel().setRollover(true);
                            currLevelButton.getPopupModel().setArmed(true);
                            RadianceCommandButtonUI currLevelButtonUI = (RadianceCommandButtonUI)currLevelButton.getUI();
                            currLevelButtonUI.processPopupAction();
                        }
                    });
                }
            });
        };
    }

    private int getFocusedIndex(Component[] components) {
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].hasFocus()) continue;
                return i;
            }
        }
        return -1;
    }

    private Component findFirstFocusableAfter(Component[] components, int index, boolean onlyMenuButtons) {
        if (components == null) {
            return null;
        }
        for (int i = index + 1; i < components.length; ++i) {
            if (!components[i].isFocusable() || onlyMenuButtons && !(components[i] instanceof JCommandButton)) continue;
            return components[i];
        }
        return null;
    }

    private Component findLastFocusableBefore(Component[] components, int index, boolean onlyMenuButtons) {
        if (components == null) {
            return null;
        }
        for (int i = index - 1; i >= 0; --i) {
            if (!components[i].isFocusable() || onlyMenuButtons && !(components[i] instanceof JCommandButton)) continue;
            return components[i];
        }
        return null;
    }

    private int getSecondaryFocusedIndex() {
        if (this.panelLevel2.getComponentCount() == 0) {
            return -1;
        }
        JRibbonApplicationMenuPopupPanelSecondary secondary = (JRibbonApplicationMenuPopupPanelSecondary)this.panelLevel2.getComponent(0);
        return this.getFocusedIndex(secondary.getComponents());
    }

    @Override
    public void focusDown() {
        int primaryFocused = this.getFocusedIndex(this.panelLevel1.getComponents());
        int secondaryFocused = this.getSecondaryFocusedIndex();
        int footerFocused = this.getFocusedIndex(this.footerPanel.getComponents());
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() == 1 && primaryFocused < 0 && secondaryFocused < 0 && footerFocused < 0) {
            Component firstFocusablePrimary = this.findFirstFocusableAfter(this.panelLevel1.getComponents(), -1, true);
            if (firstFocusablePrimary != null) {
                firstFocusablePrimary.requestFocus();
                ((JCommandButton)firstFocusablePrimary).doActionRollover();
            }
            return;
        }
        if (primaryFocused >= 0) {
            Component nextFocusablePrimary = this.findFirstFocusableAfter(this.panelLevel1.getComponents(), primaryFocused, true);
            if (nextFocusablePrimary != null) {
                nextFocusablePrimary.requestFocus();
                ((JCommandButton)nextFocusablePrimary).doActionRollover();
            } else {
                Component firstFocusableFooter = this.findFirstFocusableAfter(this.footerPanel.getComponents(), -1, false);
                if (firstFocusableFooter != null) {
                    firstFocusableFooter.requestFocus();
                }
            }
            return;
        }
        if (secondaryFocused >= 0) {
            JRibbonApplicationMenuPopupPanelSecondary secondary = (JRibbonApplicationMenuPopupPanelSecondary)this.panelLevel2.getComponent(0);
            Component nextFocusableSecondary = this.findFirstFocusableAfter(secondary.getComponents(), secondaryFocused, true);
            if (nextFocusableSecondary != null) {
                nextFocusableSecondary.requestFocus();
                this.panelScrollerLevel2.scrollToIfNecessary(nextFocusableSecondary.getY(), nextFocusableSecondary.getHeight());
            } else {
                Component firstFocusableFooter = this.findFirstFocusableAfter(this.footerPanel.getComponents(), -1, false);
                if (firstFocusableFooter != null) {
                    firstFocusableFooter.requestFocus();
                }
            }
        }
    }

    @Override
    public void focusUp() {
        JRibbonApplicationMenuPopupPanelSecondary secondary;
        Component nextFocusableSecondary;
        int primaryFocused = this.getFocusedIndex(this.panelLevel1.getComponents());
        int secondaryFocused = this.getSecondaryFocusedIndex();
        int footerFocused = this.getFocusedIndex(this.footerPanel.getComponents());
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() == 1 && primaryFocused < 0 && secondaryFocused < 0 && footerFocused < 0) {
            Component firstFocusableFooter = this.findFirstFocusableAfter(this.footerPanel.getComponents(), -1, false);
            if (firstFocusableFooter != null) {
                firstFocusableFooter.requestFocus();
            }
            return;
        }
        if (footerFocused >= 0) {
            Component lastFocusablePrimary = this.findLastFocusableBefore(this.panelLevel1.getComponents(), this.panelLevel1.getComponentCount(), true);
            if (lastFocusablePrimary != null) {
                lastFocusablePrimary.requestFocus();
                ((JCommandButton)lastFocusablePrimary).doActionRollover();
            }
            return;
        }
        if (primaryFocused >= 0) {
            Component nextFocusablePrimary = this.findLastFocusableBefore(this.panelLevel1.getComponents(), primaryFocused, true);
            if (nextFocusablePrimary != null) {
                nextFocusablePrimary.requestFocus();
                ((JCommandButton)nextFocusablePrimary).doActionRollover();
            }
            return;
        }
        if (secondaryFocused >= 0 && (nextFocusableSecondary = this.findLastFocusableBefore((secondary = (JRibbonApplicationMenuPopupPanelSecondary)this.panelLevel2.getComponent(0)).getComponents(), secondaryFocused, true)) != null) {
            nextFocusableSecondary.requestFocus();
            this.panelScrollerLevel2.scrollToIfNecessary(nextFocusableSecondary.getY(), nextFocusableSecondary.getHeight());
        }
    }

    @Override
    public void focusRight() {
        int primaryFocused = this.getFocusedIndex(this.panelLevel1.getComponents());
        int secondaryFocused = this.getSecondaryFocusedIndex();
        int footerFocused = this.getFocusedIndex(this.footerPanel.getComponents());
        boolean isLtr = this.mainPanel.getComponentOrientation().isLeftToRight();
        if (footerFocused >= 0) {
            Component nextFocusableFooter;
            Component component = nextFocusableFooter = isLtr ? this.findFirstFocusableAfter(this.footerPanel.getComponents(), footerFocused, false) : this.findLastFocusableBefore(this.footerPanel.getComponents(), footerFocused, false);
            if (nextFocusableFooter != null) {
                nextFocusableFooter.requestFocus();
            }
            return;
        }
        if (primaryFocused >= 0 && isLtr && this.panelLevel2.getComponentCount() > 0) {
            JRibbonApplicationMenuPopupPanelSecondary secondary = (JRibbonApplicationMenuPopupPanelSecondary)this.panelLevel2.getComponent(0);
            Component firstFocusableSecondary = this.findFirstFocusableAfter(secondary.getComponents(), -1, true);
            if (firstFocusableSecondary != null) {
                firstFocusableSecondary.requestFocus();
                JCommandButton secondaryMenuButton = (JCommandButton)firstFocusableSecondary;
                secondaryMenuButton.getActionModel().setRollover(true);
                secondaryMenuButton.getActionModel().setArmed(true);
            }
            return;
        }
        if (secondaryFocused >= 0 && isLtr) {
            JRibbonApplicationMenuPopupPanelSecondary secondary = (JRibbonApplicationMenuPopupPanelSecondary)this.panelLevel2.getComponent(0);
            JCommandButton secondaryMenuButton = (JCommandButton)secondary.getComponent(secondaryFocused);
            secondaryMenuButton.getPopupModel().setRollover(true);
            secondaryMenuButton.getPopupModel().setArmed(true);
            RadianceCommandButtonUI secondaryMenuButtonUI = (RadianceCommandButtonUI)secondaryMenuButton.getUI();
            secondaryMenuButtonUI.processPopupAction();
        }
    }
}

