/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.HorizontalAlignment;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.RichTooltipManager;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentPresentationModel;
import org.pushingpixels.radiance.component.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonComponentUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonComponentUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.SequentialFocusTraversalPolicy;

public class JRibbonComponent
extends RichTooltipManager.JTrackableComponent {
    private ComponentProjection<? extends JComponent, ? extends ComponentContentModel> projection;
    private RadianceIcon icon;
    private String caption;
    private JComponent mainComponent;
    private String keyTip;
    private RichTooltip richTooltip;
    private HorizontalAlignment horizontalAlignment;
    private JRibbonBand.PresentationPriority presentationPriority;
    private boolean isResizingAware;
    public static final String uiClassID = "RibbonComponentUI";

    public JRibbonComponent(ComponentProjection<? extends JComponent, ? extends ComponentContentModel> projection) {
        this.projection = projection;
        this.mainComponent = projection.buildComponent();
        this.keyTip = ((ComponentPresentationModel)projection.getPresentationModel()).getKeyTip();
        this.isResizingAware = ((ComponentPresentationModel)projection.getPresentationModel()).isResizingAware();
        this.horizontalAlignment = ((ComponentPresentationModel)projection.getPresentationModel()).getHorizontalAlignment();
        if (((ComponentContentModel)projection.getContentModel()).getIconFactory() != null) {
            RadianceIcon icon = ((ComponentContentModel)projection.getContentModel()).getIconFactory().createNewIcon();
            icon.setDimension(new Dimension(16, 16));
            this.icon = icon;
        }
        this.caption = ((ComponentContentModel)projection.getContentModel()).getCaption();
        this.richTooltip = ((ComponentContentModel)projection.getContentModel()).getRichTooltip();
        this.setEnabled(((ComponentContentModel)projection.getContentModel()).isEnabled());
        this.presentationPriority = JRibbonBand.PresentationPriority.TOP;
        this.setFocusTraversalPolicyProvider(true);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(this.mainComponent);
        this.setFocusTraversalPolicy(new SequentialFocusTraversalPolicy(comps));
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceRibbonComponentUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public RibbonComponentUI getUI() {
        return (RibbonComponentUI)this.ui;
    }

    public ComponentProjection<? extends JComponent, ? extends ComponentContentModel> getProjection() {
        return this.projection;
    }

    public RadianceIcon getIcon() {
        return this.icon;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        String old = this.caption;
        this.caption = caption;
        this.firePropertyChange("caption", old, this.caption);
    }

    public void setIcon(RadianceIcon icon) {
        RadianceIcon old = this.icon;
        this.icon = icon;
        this.firePropertyChange("icon", old, this.icon);
    }

    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public boolean isSimpleWrapper() {
        return this.caption == null || this.caption.length() == 0;
    }

    public String getKeyTip() {
        return this.keyTip;
    }

    public void setKeyTip(String keyTip) {
        String old = this.keyTip;
        this.keyTip = keyTip;
        this.firePropertyChange("keyTip", old, this.keyTip);
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.richTooltip;
    }

    public void setRichTooltip(RichTooltip richTooltip) {
        this.richTooltip = richTooltip;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public JRibbonBand.PresentationPriority getPresentationPriority() {
        return this.presentationPriority;
    }

    public void setPresentationPriority(JRibbonBand.PresentationPriority presentationPriority) {
        JRibbonBand.PresentationPriority old = this.presentationPriority;
        this.presentationPriority = presentationPriority;
        if (old != presentationPriority) {
            this.firePropertyChange("presentationPriority", (Object)old, (Object)this.presentationPriority);
        }
    }

    public boolean isResizingAware() {
        return this.isResizingAware;
    }

    public void setResizingAware(boolean isResizingAware) {
        this.isResizingAware = isResizingAware;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }
}

