/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.HorizontalAlignment;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonComponentUI;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;

public abstract class BasicRibbonComponentUI
extends RibbonComponentUI {
    protected JRibbonComponent ribbonComponent;
    private JLabel captionLabel;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener projectionPropertyChangeListener;

    @Override
    public void installUI(JComponent c) {
        this.ribbonComponent = (JRibbonComponent)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
    }

    protected void installDefaults() {
        RadianceIcon icon;
        if (!this.ribbonComponent.isSimpleWrapper() && (icon = this.ribbonComponent.getIcon()) != null) {
            icon.setDimension(new Dimension(16, 16));
        }
        this.ribbonComponent.getMainComponent().setOpaque(false);
        this.ribbonComponent.setOpaque(false);
    }

    protected void installComponents() {
        this.captionLabel = new JLabel(this.ribbonComponent.getCaption());
        this.captionLabel.setEnabled(this.ribbonComponent.isEnabled());
        this.ribbonComponent.add(this.captionLabel);
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        this.ribbonComponent.add(mainComponent);
        this.propagateEnabled(this.ribbonComponent.isEnabled());
    }

    protected void installListeners() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.propagateEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
            if ("caption".equals(propertyChangeEvent.getPropertyName())) {
                this.captionLabel.setText((String)propertyChangeEvent.getNewValue());
                this.ribbonComponent.revalidate();
                this.ribbonComponent.doLayout();
            }
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                RadianceIcon newIcon = (RadianceIcon)propertyChangeEvent.getNewValue();
                if (newIcon != null) {
                    newIcon.setDimension(new Dimension(16, 16));
                }
                this.ribbonComponent.revalidate();
                this.ribbonComponent.doLayout();
            }
            if ("presentationPriority".equals(propertyChangeEvent.getPropertyName())) {
                this.ribbonComponent.revalidate();
                this.ribbonComponent.doLayout();
            }
        };
        this.ribbonComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.projectionPropertyChangeListener = propertyChangeEvent -> {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.propagateEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        ((ComponentContentModel)this.ribbonComponent.getProjection().getContentModel()).addPropertyChangeListener(this.projectionPropertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        this.ribbonComponent.remove(mainComponent);
        this.ribbonComponent.remove(this.captionLabel);
        this.captionLabel = null;
    }

    protected void uninstallListeners() {
        this.ribbonComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        ((ComponentContentModel)this.ribbonComponent.getProjection().getContentModel()).removePropertyChangeListener(this.projectionPropertyChangeListener);
        this.projectionPropertyChangeListener = null;
    }

    private void propagateEnabled(boolean enabled) {
        this.ribbonComponent.getMainComponent().setEnabled(enabled);
        if (!this.ribbonComponent.isSimpleWrapper()) {
            this.captionLabel.setEnabled(enabled);
        }
        this.ribbonComponent.repaint();
    }

    @Override
    public Point getKeyTipAnchorCenterPoint() {
        boolean hasCaption;
        int smallIconSize = ComponentUtilities.getCommandButtonSmallIconSize(this.ribbonComponent.getFont().getSize());
        int tipCenterY = (this.ribbonComponent.getHeight() + smallIconSize) / 2;
        String caption = this.ribbonComponent.getCaption();
        boolean bl = hasCaption = caption != null && caption.length() > 0;
        if (hasCaption) {
            return new Point(this.captionLabel.getX(), tipCenterY);
        }
        return new Point(this.ribbonComponent.getMainComponent().getX() + this.ribbonComponent.getMainComponent().getWidth() / 2, tipCenterY);
    }

    protected LayoutManager createLayoutManager() {
        return new ExtComponentLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        JRibbonComponent ribbonComp = (JRibbonComponent)c;
        if (this.isIconVisible(this.ribbonComponent.getPresentationPriority())) {
            Insets ins = ribbonComp.getInsets();
            RadianceIcon icon = ribbonComp.getIcon();
            if (icon != null) {
                int availableHeight = ribbonComp.getHeight() - ins.top - ins.bottom;
                int iconY = Math.max(0, ins.top + (availableHeight - icon.getIconHeight()) / 2);
                if (ribbonComp.getComponentOrientation().isLeftToRight()) {
                    this.paintIcon(graphics, ribbonComp, (Icon)icon, ins.left, iconY);
                } else {
                    this.paintIcon(graphics, ribbonComp, (Icon)icon, ribbonComp.getWidth() - ins.right - icon.getIconWidth(), iconY);
                }
            }
        }
        graphics.dispose();
    }

    protected abstract void paintIcon(Graphics var1, JRibbonComponent var2, Icon var3, int var4, int var5);

    private int getLayoutGap() {
        return 4;
    }

    private boolean isIconVisible(JRibbonBand.PresentationPriority presentationPriority) {
        if (this.ribbonComponent.isSimpleWrapper()) {
            return false;
        }
        return presentationPriority == JRibbonBand.PresentationPriority.TOP || presentationPriority == JRibbonBand.PresentationPriority.MEDIUM;
    }

    private boolean isCaptionVisible(JRibbonBand.PresentationPriority presentationPriority) {
        if (this.ribbonComponent.isSimpleWrapper()) {
            return false;
        }
        return presentationPriority == JRibbonBand.PresentationPriority.TOP;
    }

    @Override
    public Dimension getPreferredSize(JRibbonBand.PresentationPriority priority) {
        RadianceIcon icon;
        Insets ins = this.ribbonComponent.getInsets();
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        Dimension prefMain = mainComponent.getPreferredSize();
        int width = ins.left;
        int height = prefMain.height;
        if (this.isIconVisible(priority) && (icon = this.ribbonComponent.getIcon()) != null) {
            width += icon.getIconWidth() + this.getLayoutGap();
            height = Math.max(height, icon.getIconHeight());
        }
        if (this.isCaptionVisible(priority)) {
            Dimension prefCaption = this.captionLabel.getPreferredSize();
            width += prefCaption.width + this.getLayoutGap();
            height = Math.max(height, prefCaption.height);
        }
        width += prefMain.width;
        return new Dimension(width += ins.right, height += ins.top + ins.bottom);
    }

    protected class ExtComponentLayout
    implements LayoutManager {
        protected ExtComponentLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            RadianceIcon icon;
            Insets ins = BasicRibbonComponentUI.this.ribbonComponent.getInsets();
            JComponent mainComponent = BasicRibbonComponentUI.this.ribbonComponent.getMainComponent();
            Dimension minMain = mainComponent.getMinimumSize();
            int width = ins.left;
            int height = minMain.height;
            if (BasicRibbonComponentUI.this.isIconVisible(BasicRibbonComponentUI.this.ribbonComponent.getPresentationPriority()) && (icon = BasicRibbonComponentUI.this.ribbonComponent.getIcon()) != null) {
                width += icon.getIconWidth() + BasicRibbonComponentUI.this.getLayoutGap();
                height = Math.max(height, icon.getIconHeight());
            }
            if (BasicRibbonComponentUI.this.isCaptionVisible(BasicRibbonComponentUI.this.ribbonComponent.getPresentationPriority())) {
                Dimension minCaption = BasicRibbonComponentUI.this.captionLabel.getMinimumSize();
                width += minCaption.width + BasicRibbonComponentUI.this.getLayoutGap();
                height = Math.max(height, minCaption.height);
            }
            width += minMain.width;
            return new Dimension(width += ins.right, height += ins.top + ins.bottom);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return BasicRibbonComponentUI.this.getPreferredSize(BasicRibbonComponentUI.this.ribbonComponent.getPresentationPriority());
        }

        @Override
        public void layoutContainer(Container parent) {
            JRibbonComponent ribbonComp = (JRibbonComponent)parent;
            Insets ins = ribbonComp.getInsets();
            int gap = BasicRibbonComponentUI.this.getLayoutGap();
            int availableHeight = ribbonComp.getHeight() - ins.top - ins.bottom;
            int availableWidth = ribbonComp.getWidth() - ins.left - ins.right;
            HorizontalAlignment horizAlignment = ribbonComp.getHorizontalAlignment();
            JComponent mainComp = ribbonComp.getMainComponent();
            Dimension prefMainDim = mainComp.getPreferredSize();
            int prefMainWidth = prefMainDim.width;
            int finalHeight = Math.min(prefMainDim.height, availableHeight);
            boolean ltr = ribbonComp.getComponentOrientation().isLeftToRight();
            if (ribbonComp.isSimpleWrapper()) {
                int finalMainWidth = Math.min(availableWidth, prefMainWidth);
                int offset = availableWidth - prefMainWidth;
                int topMain = ins.top + (availableHeight - finalHeight) / 2;
                int x = ltr ? ins.left : ribbonComp.getWidth() - ins.right;
                switch (horizAlignment) {
                    case LEADING: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case TRAILING: {
                        if (ltr) {
                            mainComp.setBounds(x + offset, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case CENTER: {
                        if (ltr) {
                            mainComp.setBounds(x + offset / 2, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset / 2, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case FILL: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, availableWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - availableWidth, topMain, availableWidth, finalHeight);
                    }
                }
                mainComp.doLayout();
            } else {
                int x;
                int n = x = ltr ? ins.left : ribbonComp.getWidth() - ins.right;
                if (BasicRibbonComponentUI.this.isIconVisible(BasicRibbonComponentUI.this.ribbonComponent.getPresentationPriority()) && ribbonComp.getIcon() != null) {
                    int iconW = ribbonComp.getIcon().getIconWidth();
                    int n2 = x = ltr ? x + iconW + gap : x - iconW - gap;
                }
                if (BasicRibbonComponentUI.this.isCaptionVisible(BasicRibbonComponentUI.this.ribbonComponent.getPresentationPriority())) {
                    BasicRibbonComponentUI.this.captionLabel.setVisible(true);
                    Dimension prefCaptionDim = BasicRibbonComponentUI.this.captionLabel.getPreferredSize();
                    if (ltr) {
                        BasicRibbonComponentUI.this.captionLabel.setBounds(x, ins.top + (availableHeight - prefCaptionDim.height) / 2, prefCaptionDim.width, prefCaptionDim.height);
                        x += prefCaptionDim.width + gap;
                    } else {
                        BasicRibbonComponentUI.this.captionLabel.setBounds(x - prefCaptionDim.width, ins.top + (availableHeight - prefCaptionDim.height) / 2, prefCaptionDim.width, prefCaptionDim.height);
                        x -= prefCaptionDim.width + gap;
                    }
                } else {
                    BasicRibbonComponentUI.this.captionLabel.setVisible(false);
                }
                int topMain = ins.top + (availableHeight - finalHeight) / 2;
                int finalMainWidth = ltr ? Math.min(ribbonComp.getWidth() - ins.right - x, prefMainWidth) : Math.min(x - ins.left, prefMainWidth);
                int offset = ltr ? ribbonComp.getWidth() - ins.right - x - prefMainWidth : x - prefMainWidth - ins.left;
                switch (horizAlignment) {
                    case LEADING: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case TRAILING: {
                        if (ltr) {
                            mainComp.setBounds(x + offset, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case CENTER: {
                        if (ltr) {
                            mainComp.setBounds(x + offset / 2, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset / 2, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case FILL: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, ribbonComp.getWidth() - ins.right - x, finalHeight);
                            break;
                        }
                        mainComp.setBounds(ins.left, topMain, x - ins.left, finalHeight);
                    }
                }
                mainComp.doLayout();
            }
        }
    }
}

