/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.component.api.common.CommandAction;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.radiance.component.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.radiance.component.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadiancePopupContainer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public abstract class BasicRibbonBandUI
extends RibbonBandUI {
    protected AbstractRibbonBand ribbonBand;
    private JCommandButton collapsedButton;
    protected JCommandButton expandButton;
    protected Command expandCommand;
    private MouseListener mouseListener;
    private PropertyChangeListener propertyChangeListener;

    @Override
    public void installUI(JComponent c) {
        this.ribbonBand = (AbstractRibbonBand)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
        AWTRibbonEventListener.install();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        if (!AWTRibbonEventListener.uninstall()) {
            // empty if block
        }
    }

    protected void installDefaults() {
        this.ribbonBand.setBorder(null);
    }

    protected void installComponents() {
        Command collapseCommand = ((Command.Builder)((Command.Builder)Command.builder().setText(this.ribbonBand.getTitle())).setIconFactory(this.ribbonBand.getIconFactory())).build();
        this.collapsedButton = (JCommandButton)collapseCommand.project(CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.BIG).setPopupKeyTip(this.ribbonBand.getCollapsedStateKeyTip()).build()).buildComponent();
        this.ribbonBand.add(this.collapsedButton);
        if (this.ribbonBand.getExpandCommandListener() != null) {
            this.expandCommand = this.createExpandCommand();
            this.expandButton = this.createExpandButton();
            this.ribbonBand.add(this.expandButton);
        }
    }

    protected abstract JCommandButton createExpandButton();

    protected abstract Command createExpandCommand();

    protected abstract void syncExpandButtonIcon();

    protected void installListeners() {
        this.mouseListener = new MouseAdapter(){};
        this.ribbonBand.addMouseListener(this.mouseListener);
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("title".equals(propertyChangeEvent.getPropertyName())) {
                this.ribbonBand.repaint();
            }
            if ("expandButtonKeyTip".equals(propertyChangeEvent.getPropertyName()) && this.expandButton != null) {
                this.expandButton.setActionKeyTip((String)propertyChangeEvent.getNewValue());
            }
            if ("expandButtonRichTooltip".equals(propertyChangeEvent.getPropertyName()) && this.expandCommand != null) {
                this.expandCommand.setActionRichTooltip((RichTooltip)propertyChangeEvent.getNewValue());
            }
            if ("collapsedStateKeyTip".equals(propertyChangeEvent.getPropertyName()) && this.collapsedButton != null) {
                this.collapsedButton.setPopupKeyTip((String)propertyChangeEvent.getNewValue());
            }
            if ("expandCommandListener".equals(propertyChangeEvent.getPropertyName())) {
                CommandAction oldListener = (CommandAction)propertyChangeEvent.getOldValue();
                CommandAction newListener = (CommandAction)propertyChangeEvent.getNewValue();
                if (oldListener != null && newListener == null) {
                    this.ribbonBand.remove(this.expandButton);
                    this.expandButton = null;
                    this.ribbonBand.revalidate();
                }
                if (oldListener == null && newListener != null) {
                    this.expandCommand = this.createExpandCommand();
                    this.expandButton = this.createExpandButton();
                    this.ribbonBand.add(this.expandButton);
                    this.ribbonBand.revalidate();
                }
                if (oldListener != null && newListener != null) {
                    this.expandCommand.setAction(newListener);
                }
            }
            if ("componentOrientation".equals(propertyChangeEvent.getPropertyName()) && this.expandButton != null) {
                this.syncExpandButtonIcon();
            }
        };
        this.ribbonBand.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.ribbonBand);
    }

    protected void uninstallComponents() {
        if (this.collapsedButton.isVisible()) {
            CollapsedButtonPopupPanel popupPanel;
            CollapsedButtonPopupPanel collapsedButtonPopupPanel = popupPanel = this.collapsedButton.getPopupCallback() == null ? null : (CollapsedButtonPopupPanel)this.collapsedButton.getPopupCallback().getPopupPanel(this.collapsedButton);
            if (popupPanel != null) {
                AbstractRibbonBand bandFromPopup = (AbstractRibbonBand)popupPanel.removeComponent();
                this.ribbonBand.setControlPanel(bandFromPopup.getControlPanel());
                this.ribbonBand.setPopupRibbonBand(null);
                this.collapsedButton.setPopupCallback(null);
            }
        }
        this.ribbonBand.remove(this.collapsedButton);
        this.collapsedButton = null;
        if (this.expandButton != null) {
            this.ribbonBand.remove(this.expandButton);
        }
        this.expandButton = null;
        this.ribbonBand = null;
    }

    protected void uninstallListeners() {
        this.ribbonBand.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.ribbonBand.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonBandLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        BackgroundPaintingUtils.update((Graphics)graphics, (JComponent)c, (boolean)false);
        Insets ins = this.ribbonBand.getInsets();
        this.paintBandTrailingSeparator(graphics, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        if (!(this.ribbonBand.getCurrentResizePolicy() instanceof CoreRibbonResizePolicies.IconRibbonBandResizePolicy)) {
            String title = this.ribbonBand.getTitle();
            int titleHeight = this.getBandTitleHeight();
            int bandTitleTopY = c.getHeight() - titleHeight;
            boolean ltr = this.ribbonBand.getComponentOrientation().isLeftToRight();
            int titleWidth = c.getWidth() - 2 * ins.left - 2 * ins.right;
            int titleX = 2 * ins.left;
            if (this.expandButton != null) {
                if (ltr) {
                    titleWidth = this.expandButton.getX() - 2 * ins.right - 2 * ins.left;
                } else {
                    titleWidth = this.ribbonBand.getWidth() - this.expandButton.getX() - this.expandButton.getWidth() - 2 * ins.right - 2 * ins.left;
                    titleX = this.expandButton.getX() + this.expandButton.getWidth() + 2 * ins.left;
                }
            }
            this.paintBandTitle(graphics, new Rectangle(titleX, bandTitleTopY, titleWidth, titleHeight), title);
        }
        graphics.dispose();
    }

    protected abstract void paintBandTitle(Graphics var1, Rectangle var2, String var3);

    protected abstract void paintBandTrailingSeparator(Graphics var1, Rectangle var2);

    @Override
    public int getPreferredCollapsedWidth() {
        Dimension collapsedPreferredSize = this.collapsedButton.getPreferredSize();
        return Math.min((int)((double)collapsedPreferredSize.height * 1.25), collapsedPreferredSize.width + 2);
    }

    private static class AWTRibbonEventListener
    implements AWTEventListener {
        private static AWTRibbonEventListener instance;
        private int installCount = 0;

        private AWTRibbonEventListener() {
        }

        public static void install() {
            if (instance == null) {
                instance = new AWTRibbonEventListener();
                RadianceCoreUtilities.registerAWTEventListener((AWTEventListener)instance);
            }
            ++AWTRibbonEventListener.instance.installCount;
        }

        public static boolean uninstall() {
            if (instance != null) {
                --AWTRibbonEventListener.instance.installCount;
                if (AWTRibbonEventListener.instance.installCount == 0) {
                    RadianceCoreUtilities.unregisterAWTEventListener((AWTEventListener)instance);
                    instance = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (!(event instanceof MouseEvent)) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getID() == 507) {
                if (PopupPanelManager.defaultManager().getShownPath().size() > 0) {
                    return;
                }
                Object object = event.getSource();
                if (!(object instanceof Component)) {
                    return;
                }
                Component component = (Component)object;
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                Component deepest = SwingUtilities.getDeepestComponentAt(component, mouseWheelEvent.getX(), mouseWheelEvent.getY());
                JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, deepest);
                if (ribbon != null) {
                    ribbon.getUI().handleMouseWheelEvent((MouseWheelEvent)mouseEvent);
                    mouseEvent.consume();
                }
            }
        }
    }

    private class RibbonBandLayout
    implements LayoutManager {
        private RibbonBandLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            AbstractBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean useCollapsedButton = controlPanel == null || !controlPanel.isVisible();
            int width = useCollapsedButton ? ((BasicRibbonBandUI)BasicRibbonBandUI.this).collapsedButton.getPreferredSize().width : controlPanel.getPreferredSize().width;
            int height = (useCollapsedButton ? ((BasicRibbonBandUI)BasicRibbonBandUI.this).collapsedButton.getPreferredSize().height : controlPanel.getPreferredSize().height) + BasicRibbonBandUI.this.getBandTitleHeight();
            int extraTop = RadianceSizeUtils.getDefaultBorderInsets((int)RadianceSizeUtils.getComponentFontSize((Component)controlPanel)).top;
            return new Dimension(width + ins.left + ins.right, height + extraTop + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            AbstractBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean useCollapsedButton = controlPanel == null || !controlPanel.isVisible();
            int width = useCollapsedButton ? ((BasicRibbonBandUI)BasicRibbonBandUI.this).collapsedButton.getMinimumSize().width : controlPanel.getMinimumSize().width;
            int height = useCollapsedButton ? ((BasicRibbonBandUI)BasicRibbonBandUI.this).collapsedButton.getMinimumSize().height + BasicRibbonBandUI.this.getBandTitleHeight() : controlPanel.getMinimumSize().height + BasicRibbonBandUI.this.getBandTitleHeight();
            int extraTop = RadianceSizeUtils.getDefaultBorderInsets((int)RadianceSizeUtils.getComponentFontSize((Component)controlPanel)).top;
            return new Dimension(width + ins.left + ins.right, height + extraTop + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container c) {
            if (!c.isVisible()) {
                return;
            }
            Insets ins = c.getInsets();
            int extraTop = RadianceSizeUtils.getDefaultBorderInsets((int)RadianceSizeUtils.getComponentFontSize((Component)BasicRibbonBandUI.this.ribbonBand.getControlPanel())).top;
            int availableHeight = c.getHeight() - extraTop - ins.top - ins.bottom;
            RibbonBandResizePolicy resizePolicy = ((AbstractRibbonBand)c).getCurrentResizePolicy();
            if (resizePolicy instanceof CoreRibbonResizePolicies.IconRibbonBandResizePolicy) {
                BasicRibbonBandUI.this.collapsedButton.setVisible(true);
                int collapsedButtonWidth = c.getWidth() - ins.left - ins.right - 2;
                BasicRibbonBandUI.this.collapsedButton.setBounds((c.getWidth() - collapsedButtonWidth) / 2, extraTop + ins.top, collapsedButtonWidth, c.getHeight() - extraTop - ins.top - ins.bottom);
                if (BasicRibbonBandUI.this.collapsedButton.getPopupCallback() == null) {
                    AbstractRibbonBand popupBand = BasicRibbonBandUI.this.ribbonBand.cloneBand();
                    popupBand.setControlPanel(BasicRibbonBandUI.this.ribbonBand.getControlPanel());
                    List<RibbonBandResizePolicy> resizePolicies = BasicRibbonBandUI.this.ribbonBand.getResizePolicies();
                    popupBand.setResizePolicies(resizePolicies);
                    RibbonBandResizePolicy largest = resizePolicies.get(0);
                    popupBand.setCurrentResizePolicy(largest);
                    int gap = popupBand.getControlPanel().getUI().getLayoutGap();
                    Dimension size = new Dimension(ins.left + ins.right + gap + largest.getPreferredWidth(availableHeight, gap), ins.top + ins.bottom + Math.max(c.getHeight(), BasicRibbonBandUI.this.ribbonBand.getControlPanel().getPreferredSize().height + BasicRibbonBandUI.this.getBandTitleHeight()));
                    BasicRibbonBandUI.this.collapsedButton.setPopupCallback(commandButton -> new CollapsedButtonPopupPanel(popupBand, size));
                    BasicRibbonBandUI.this.ribbonBand.setControlPanel(null);
                    BasicRibbonBandUI.this.ribbonBand.setPopupRibbonBand(popupBand);
                }
                if (BasicRibbonBandUI.this.expandButton != null) {
                    BasicRibbonBandUI.this.expandButton.setBounds(0, 0, 0, 0);
                }
                return;
            }
            if (BasicRibbonBandUI.this.collapsedButton.isVisible()) {
                CollapsedButtonPopupPanel popupPanel;
                CollapsedButtonPopupPanel collapsedButtonPopupPanel = popupPanel = BasicRibbonBandUI.this.collapsedButton.getPopupCallback() != null ? (CollapsedButtonPopupPanel)BasicRibbonBandUI.this.collapsedButton.getPopupCallback().getPopupPanel(BasicRibbonBandUI.this.collapsedButton) : null;
                if (popupPanel != null) {
                    AbstractRibbonBand bandFromPopup = (AbstractRibbonBand)popupPanel.removeComponent();
                    BasicRibbonBandUI.this.ribbonBand.setControlPanel(bandFromPopup.getControlPanel());
                    BasicRibbonBandUI.this.ribbonBand.setPopupRibbonBand(null);
                    BasicRibbonBandUI.this.collapsedButton.setPopupCallback(null);
                }
            }
            BasicRibbonBandUI.this.collapsedButton.setVisible(false);
            AbstractBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            controlPanel.setVisible(true);
            controlPanel.setBounds(ins.left, extraTop + ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - BasicRibbonBandUI.this.getBandTitleHeight() - extraTop - ins.top - ins.bottom);
            controlPanel.doLayout();
            if (BasicRibbonBandUI.this.expandButton != null) {
                int ebpw = BasicRibbonBandUI.this.expandButton.getPreferredSize().width;
                int ebph = BasicRibbonBandUI.this.expandButton.getPreferredSize().height;
                int maxHeight = BasicRibbonBandUI.this.getBandTitleHeight() - 4;
                if (ebph > maxHeight) {
                    ebph = maxHeight;
                }
                int expandButtonBottomY = c.getHeight() - (BasicRibbonBandUI.this.getBandTitleHeight() - ebph) / 2;
                boolean ltr = BasicRibbonBandUI.this.ribbonBand.getComponentOrientation().isLeftToRight();
                if (ltr) {
                    BasicRibbonBandUI.this.expandButton.setBounds(c.getWidth() - ins.right - ebpw - 1, expandButtonBottomY - ebph, ebpw, ebph);
                } else {
                    BasicRibbonBandUI.this.expandButton.setBounds(ins.left + 1, expandButtonBottomY - ebph, ebpw, ebph);
                }
            }
        }
    }

    @RadiancePopupContainer
    protected static class CollapsedButtonPopupPanel
    extends JPopupPanel {
        protected Component component;

        private CollapsedButtonPopupPanel(Component component, Dimension originalSize) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setPreferredSize(originalSize);
            this.setSize(originalSize);
            RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
        }

        public Component removeComponent() {
            this.remove(this.component);
            return this.component;
        }
    }
}

