/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.ribbon.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonFrame;
import org.pushingpixels.radiance.component.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTask;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonApplicationMenuCommandButtonProjection;
import org.pushingpixels.radiance.component.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceRibbonUI
extends BasicRibbonUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceRibbonUI();
    }

    private RadianceRibbonUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.ribbon, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.HEADER);
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.ribbon);
        DecorationPainterUtils.clearDecorationType((JComponent)this.bandScrollablePanel);
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.bandScrollablePanel, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
    }

    @Override
    protected BasicRibbonUI.TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new RadianceTaskToggleButtonsHostPanel();
    }

    @Override
    protected void paintBackground(Graphics g) {
        BackgroundPaintingUtils.update((Graphics)g, (JComponent)this.ribbon, (boolean)false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)this.ribbon.getWidth(), (int)this.ribbon.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceColorScheme compScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.ribbon, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.ENABLED);
            graphics1X.setColor(compScheme.getSeparatorPrimaryColor());
            int separatorY = (int)(scaleFactor * (double)(this.taskToggleButtonsScrollablePanel.getY() + this.taskToggleButtonsScrollablePanel.getHeight())) - 1;
            graphics1X.drawLine(0, separatorY, scaledWidth, separatorY);
        });
        graphics.dispose();
    }

    @Override
    protected int getTabButtonGap() {
        return RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)this.ribbon), (int)super.getTabButtonGap(), (int)3, (int)1, (boolean)false);
    }

    @Override
    protected void syncApplicationMenuTips() {
        RibbonApplicationMenuCommandButtonProjection applicationMenuProjection;
        if (this.applicationMenuButton == null || !this.applicationMenuButton.isVisible()) {
            return;
        }
        JRibbonRootPane ribbonRootPane = (JRibbonRootPane)SwingUtilities.getRootPane(this.ribbon);
        if (ribbonRootPane == null) {
            return;
        }
        JRibbonFrame ribbonFrame = (JRibbonFrame)ribbonRootPane.getParent();
        JRibbon ribbon = ribbonFrame.getRibbon();
        if (ribbon != null && (applicationMenuProjection = ribbon.getApplicationMenuCommandProjection()) != null) {
            this.applicationMenuButton.setPopupRichTooltip(((Command)ribbon.getApplicationMenuCommandProjection().getContentModel()).getSecondaryRichTooltip());
            this.applicationMenuButton.setPopupKeyTip(((CommandButtonPresentationModel)ribbon.getApplicationMenuCommandProjection().getPresentationModel()).getPopupKeyTip());
        }
    }

    @Override
    protected void paintMinimizedRibbonSeparator(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(0, this.ribbon.getHeight() - 1);
        SeparatorPainterUtils.paintSeparator((Component)this.ribbon, (Graphics)g2d, (int)this.ribbon.getWidth(), (int)0, (int)0, (boolean)false, (int)0);
        g2d.dispose();
    }

    protected class RadianceTaskToggleButtonsHostPanel
    extends BasicRibbonUI.TaskToggleButtonsHostPanel {
        protected RadianceTaskToggleButtonsHostPanel() {
            super(RadianceRibbonUI.this);
        }

        @Override
        protected void paintContextualTaskGroupOutlines(Graphics g, RibbonContextualTaskGroup group, Rectangle groupBounds) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(groupBounds.x, 0);
            SeparatorPainterUtils.paintSeparator((Component)RadianceRibbonUI.this.ribbon, (Graphics)g2d, (int)2, (int)(groupBounds.height * 3 / 4), (int)1, (boolean)false, (int)0, (int)(groupBounds.height / 3), (boolean)true);
            g2d.translate(groupBounds.width - 1, 0);
            SeparatorPainterUtils.paintSeparator((Component)RadianceRibbonUI.this.ribbon, (Graphics)g2d, (int)2, (int)(groupBounds.height * 3 / 4), (int)1, (boolean)false, (int)0, (int)(groupBounds.height / 3), (boolean)true);
            g2d.dispose();
        }

        @Override
        protected void paintTaskOutlines(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g.create();
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme((Component)RadianceRibbonUI.this.ribbon, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.ENABLED);
            HashSet<RibbonTask> tasksWithTrailingSeparators = new HashSet<RibbonTask>();
            for (i = 0; i < RadianceRibbonUI.this.ribbon.getTaskCount() - 1; ++i) {
                RibbonTask task = RadianceRibbonUI.this.ribbon.getTask(i);
                tasksWithTrailingSeparators.add(task);
            }
            for (i = 0; i < RadianceRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = RadianceRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!RadianceRibbonUI.this.ribbon.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount() - 1; ++j) {
                    RibbonTask task = group.getTask(j);
                    tasksWithTrailingSeparators.add(task);
                }
            }
            for (RibbonTask taskWithTrailingSeparator : tasksWithTrailingSeparators) {
                JComponent taskToggleButton = (JComponent)RadianceRibbonUI.this.taskToggleButtons.get(taskWithTrailingSeparator);
                Rectangle bounds = taskToggleButton.getBounds();
                int x = bounds.x + bounds.width + RadianceRibbonUI.this.getTabButtonGap() / 2 - 1;
                g2d.translate(x, 0);
                SeparatorPainterUtils.paintSeparator((Component)RadianceRibbonUI.this.ribbon, (Graphics)g2d, (RadianceColorScheme)scheme, (int)2, (int)this.getHeight(), (int)1, (boolean)false, (int)(this.getHeight() / 3), (int)0, (boolean)true);
                g2d.translate(-x, 0);
            }
            g2d.dispose();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
                RadianceColorScheme compScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.ENABLED);
                graphics1X.setColor(compScheme.getSeparatorPrimaryColor());
                int separatorY = scaledHeight - 1;
                graphics1X.drawLine(0, separatorY, scaledWidth, separatorY);
            });
            graphics.dispose();
        }
    }
}

