/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.ribbon.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JScrollablePanel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonFrame;
import org.pushingpixels.radiance.component.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTaskbarKeyTipPolicy;
import org.pushingpixels.radiance.component.internal.theming.common.BladeTransitionAwareRadianceIcon;
import org.pushingpixels.radiance.component.internal.theming.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonLayoutManagerSmall;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRootPaneUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadiancePopupContainer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePane;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePaneUtilities;

public class RadianceRibbonFrameTitlePane
extends RadianceTitlePane {
    private static final double TASKBAR_WIDTH_MAX_RATIO = 0.25;
    private Map<RibbonContextualTaskGroup, RadianceContextualGroupComponent> taskComponentMap = new HashMap<RibbonContextualTaskGroup, RadianceContextualGroupComponent>();
    private ChangeListener ribbonFrameChangeListener;
    private TaskbarPanel taskbarPanel = new TaskbarPanel();

    public RadianceRibbonFrameTitlePane(JRootPane root, RadianceRootPaneUI ui) {
        super(root, ui);
        this.taskbarPanel.setComponentOrientation(root.getComponentOrientation());
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent((JComponent)this.taskbarPanel, (RadianceTitlePaneUtilities.ExtraComponentKind)RadianceTitlePaneUtilities.ExtraComponentKind.LEADING);
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.taskbarPanel, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.HEADER);
        this.add(this.taskbarPanel);
    }

    protected LayoutManager createLayout() {
        return new RibbonFrameTitlePaneLayout();
    }

    public void addNotify() {
        super.addNotify();
        JRibbon ribbon = this.getRibbon();
        this.syncRibbonState();
        this.ribbonFrameChangeListener = changeEvent -> {
            this.syncRibbonState();
            this.invalidate();
            this.revalidate();
            this.repaint();
        };
        ribbon.addChangeListener(this.ribbonFrameChangeListener);
    }

    public void removeNotify() {
        JRibbon ribbon = this.getRibbon();
        for (RadianceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        ribbon.removeChangeListener(this.ribbonFrameChangeListener);
        this.ribbonFrameChangeListener = null;
        super.removeNotify();
    }

    private void syncRibbonState() {
        for (RadianceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        this.taskComponentMap.clear();
        JRibbon ribbon = this.getRibbon();
        for (int i = 0; i < ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup group = ribbon.getContextualTaskGroup(i);
            if (!ribbon.isVisible(group)) continue;
            RadianceContextualGroupComponent taskGroupComponent = new RadianceContextualGroupComponent(group);
            taskGroupComponent.applyComponentOrientation(this.getRibbon().getComponentOrientation());
            this.add(taskGroupComponent);
            this.taskComponentMap.put(group, taskGroupComponent);
            RadianceTitlePaneUtilities.markTitlePaneExtraComponent((JComponent)taskGroupComponent, (RadianceTitlePaneUtilities.ExtraComponentKind)RadianceTitlePaneUtilities.ExtraComponentKind.TRAILING);
        }
        this.taskbarPanel.removeAll();
        this.taskbarPanel.setPreferredSize(null);
    }

    public Container getTaskbarPanel() {
        return this.taskbarPanel;
    }

    private JRibbon getRibbon() {
        JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
        return ribbonFrame.getRibbon();
    }

    private int getTaskBarLayoutGap(Container c) {
        return RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)c), (int)1, (int)6, (int)1, (boolean)false);
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = RadianceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            for (Component regComp : c.getComponents()) {
                if (!regComp.isVisible()) continue;
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, c.getParent().getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = RadianceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            int x = ltr ? ins.left : c.getWidth() - ins.right;
            for (Component regComp : c.getComponents()) {
                if (!regComp.isVisible()) continue;
                int pw = regComp.getPreferredSize().width;
                if (ltr) {
                    regComp.setBounds(x, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                    x += pw + gap;
                    continue;
                }
                regComp.setBounds(x - pw, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                x -= pw + gap;
            }
        }
    }

    protected class RibbonFrameTitlePaneLayout
    extends RadianceTitlePane.TitlePaneLayout {
        protected RibbonFrameTitlePaneLayout() {
            super((RadianceTitlePane)RadianceRibbonFrameTitlePane.this);
        }

        public void layoutContainer(Container c) {
            super.layoutContainer(c);
            JRibbon ribbon = RadianceRibbonFrameTitlePane.this.getRibbon();
            boolean ltr = ribbon.getComponentOrientation().isLeftToRight();
            RibbonUI ribbonUI = ribbon.getUI();
            if (ltr) {
                for (Map.Entry entry : RadianceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds((RibbonContextualTaskGroup)entry.getKey());
                    int minTrailingX = c.getWidth();
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        RadianceTitlePaneUtilities.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (RadianceTitlePaneUtilities.ExtraComponentKind)((JComponent)child).getClientProperty("radiance.theming.internal.titlePane.extraComponentKind")) == RadianceTitlePaneUtilities.ExtraComponentKind.LEADING || child instanceof RadianceContextualGroupComponent) continue;
                        minTrailingX = Math.min(child.getX(), minTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    if (taskGroupBounds.x + width > minTrailingX - 5) {
                        width = minTrailingX - 5 - taskGroupBounds.x;
                    }
                    ((RadianceContextualGroupComponent)entry.getValue()).setBounds(new Rectangle(taskGroupBounds.x, 0, width, c.getHeight()));
                    ((RadianceContextualGroupComponent)entry.getValue()).setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                RadianceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = RadianceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                int availableForTaskbarPanel = (int)(0.25 * (double)c.getBounds().width);
                if (pref.width <= availableForTaskbarPanel) {
                    RadianceRibbonFrameTitlePane.this.taskbarPanel.showAll();
                } else {
                    RadianceRibbonFrameTitlePane.this.taskbarPanel.showAsMuchAsPossible(availableForTaskbarPanel);
                    pref.width = availableForTaskbarPanel;
                }
                if (RadianceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                if (RadianceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                    if (pref.width == 0) {
                        RadianceRibbonFrameTitlePane.this.taskbarPanel.setBounds(RadianceRibbonFrameTitlePane.this.menuBar.getX() + RadianceRibbonFrameTitlePane.this.menuBar.getWidth(), 0, pref.width, c.getHeight());
                    } else {
                        RadianceRibbonFrameTitlePane.this.taskbarPanel.setBounds(RadianceRibbonFrameTitlePane.this.menuBar.getX() + RadianceRibbonFrameTitlePane.this.menuBar.getWidth() + 5, 0, pref.width, c.getHeight());
                    }
                    RadianceRibbonFrameTitlePane.this.taskbarPanel.doLayout();
                }
            } else {
                for (Map.Entry entry : RadianceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds((RibbonContextualTaskGroup)entry.getKey());
                    int maxTrailingX = 0;
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        RadianceTitlePaneUtilities.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (RadianceTitlePaneUtilities.ExtraComponentKind)((JComponent)child).getClientProperty("radiance.theming.internal.titlePane.extraComponentKind")) == RadianceTitlePaneUtilities.ExtraComponentKind.LEADING || child instanceof RadianceContextualGroupComponent) continue;
                        maxTrailingX = Math.max(child.getX() + child.getWidth(), maxTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    int x = taskGroupBounds.x;
                    if (taskGroupBounds.x < maxTrailingX + 5) {
                        int diff = maxTrailingX + 5 - taskGroupBounds.x;
                        x += diff;
                        width -= diff;
                    }
                    ((RadianceContextualGroupComponent)entry.getValue()).setBounds(new Rectangle(x, 0, width, c.getHeight()));
                    ((RadianceContextualGroupComponent)entry.getValue()).setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                RadianceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = RadianceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                int availableForTaskbarPanel = (int)(0.25 * (double)c.getBounds().width);
                if (pref.width <= availableForTaskbarPanel) {
                    RadianceRibbonFrameTitlePane.this.taskbarPanel.showAll();
                } else {
                    RadianceRibbonFrameTitlePane.this.taskbarPanel.showAsMuchAsPossible(availableForTaskbarPanel);
                    pref.width = availableForTaskbarPanel;
                }
                if (RadianceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                if (RadianceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                    if (pref.width == 0) {
                        RadianceRibbonFrameTitlePane.this.taskbarPanel.setBounds(RadianceRibbonFrameTitlePane.this.menuBar.getX(), 0, pref.width, c.getHeight());
                    } else {
                        RadianceRibbonFrameTitlePane.this.taskbarPanel.setBounds(RadianceRibbonFrameTitlePane.this.menuBar.getX() - 5 - pref.width, 0, pref.width, c.getHeight());
                    }
                    RadianceRibbonFrameTitlePane.this.taskbarPanel.doLayout();
                }
            }
            RadianceRibbonFrameTitlePane.this.menuBar.setVisible(true);
        }
    }

    private class TaskbarPanel
    extends JPanel {
        private TaskbarOverflowButton overflowButton;
        private List<Component> overflowComponents;

        private TaskbarPanel() {
            super(new TaskbarLayout());
            this.setFont(RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
            this.overflowComponents = new ArrayList<Component>();
            this.setOpaque(false);
            int insets = RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)this), (int)2, (int)3, (int)1, (boolean)false);
            this.setBorder(new EmptyBorder(2, insets, 2, insets));
            int defaultIconSize = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)this.getFont().getSize());
            CommandButtonProjection<Command> overflowProjection = ((Command.Builder)Command.builder().setAction(commandActionEvent -> SwingUtilities.invokeLater(() -> this.showOverflowTaskbarContent(commandActionEvent.getButtonSource())))).build().project(CommandButtonPresentationModel.builder().setPresentationState(new CommandButtonPresentationState("overflow", defaultIconSize){

                @Override
                public CommandButtonLayoutManager createLayoutManager(JCommandButton commandButton) {
                    return new CommandButtonLayoutManagerTaskbarOverflow();
                }
            }).build());
            overflowProjection.setComponentCustomizer(button -> {
                int fontSize = RadianceSizeUtils.getComponentFontSize((Component)button);
                int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
                int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
                BladeTransitionAwareRadianceIcon arrowIcon = new BladeTransitionAwareRadianceIcon((JCommandButton)button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (g, scheme, width, height) -> BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)arrowIconWidth, (float)arrowIconHeight, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.getComponentOrientation().isLeftToRight() ? 3 : 7), (RadianceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight));
                button.setIcon(arrowIcon);
                button.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
                button.setCursor(Cursor.getPredefinedCursor(12));
                RadianceThemingCortex.ComponentScope.setButtonStraightSides((JComponent)button, EnumSet.allOf(RadianceThemingSlices.Side.class));
            });
            overflowProjection.setComponentSupplier(projection -> TaskbarOverflowButton::new);
            this.overflowButton = (TaskbarOverflowButton)overflowProjection.buildComponent();
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            int pw = 0;
            int gap = RadianceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this);
            for (Component component : RadianceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                pw += component.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, this.getParent().getHeight());
        }

        private void showOverflowTaskbarContent(JCommandButton overflowButton) {
            int popupX;
            int gap;
            int overflowFullWidth = gap = RadianceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this);
            for (Component overflow : this.overflowComponents) {
                overflowFullWidth += overflow.getPreferredSize().width + gap;
            }
            int ribbonWidth = RadianceRibbonFrameTitlePane.this.getWidth();
            int popupWidth = Math.min(overflowFullWidth += 2 * gap, ribbonWidth);
            int overflowButtonX = overflowButton.getLocationOnScreen().x;
            int titlePaneX = RadianceRibbonFrameTitlePane.this.getLocationOnScreen().x;
            int titlePaneY = RadianceRibbonFrameTitlePane.this.getLocationOnScreen().y;
            int titlePaneHeight = RadianceRibbonFrameTitlePane.this.getHeight();
            if (this.getComponentOrientation().isLeftToRight()) {
                if (overflowButtonX + popupWidth > titlePaneX + ribbonWidth) {
                    int delta = overflowButtonX + popupWidth - (titlePaneX + ribbonWidth);
                    popupX = overflowButtonX - delta;
                } else {
                    popupX = overflowButtonX;
                }
            } else {
                int overflowButtonWidth = overflowButton.getWidth();
                if (overflowButtonX + overflowButtonWidth - popupWidth < titlePaneX) {
                    int delta = titlePaneX - (overflowButtonX + overflowButtonWidth - popupWidth);
                    popupX = overflowButtonX + overflowButtonWidth - popupWidth + delta;
                } else {
                    popupX = overflowButtonX + overflowButtonWidth - popupWidth;
                }
            }
            TaskbarOverflowPopupPanel overflowPopupPanel = new TaskbarOverflowPopupPanel(this.overflowComponents, new Dimension(popupWidth, ComponentUtilities.getTaskToggleButtonHeight(RadianceRibbonFrameTitlePane.this.getRibbon())), overflowFullWidth > ribbonWidth);
            overflowPopupPanel.applyComponentOrientation(this.getComponentOrientation());
            PopupPanelManager.defaultManager().showPopup(overflowButton, overflowPopupPanel, popupX, titlePaneY + titlePaneHeight);
        }

        private void showAsMuchAsPossible(int availableWidth) {
            this.removeAll();
            this.overflowComponents.clear();
            Insets ins = this.getInsets();
            int gap = RadianceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this);
            boolean isInOverflow = false;
            int pw = ins.left + ins.right + this.overflowButton.getPreferredSize().width + gap;
            for (Component component : RadianceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                int componentWidth = component.getPreferredSize().width;
                if (!isInOverflow && pw + componentWidth + gap <= availableWidth) {
                    this.add(component);
                    pw += componentWidth + gap;
                    continue;
                }
                isInOverflow = true;
                this.overflowComponents.add(component);
            }
            this.add(this.overflowButton);
            this.overflowButton.setActionKeyTip(RadianceRibbonFrameTitlePane.this.getRibbon().getTaskbarKeyTipPolicy().getOverflowButtonKeyTip());
            this.updateKeyTips();
            this.revalidate();
        }

        private void showAll() {
            this.removeAll();
            this.overflowComponents.clear();
            for (Component component : RadianceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                this.add(component);
            }
            this.updateKeyTips();
            this.revalidate();
        }

        private void updateKeyTips() {
            RibbonTaskbarKeyTipPolicy policy = RadianceRibbonFrameTitlePane.this.getRibbon().getTaskbarKeyTipPolicy();
            List<Component> taskbarComponents = RadianceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents();
            int index = 1;
            for (Component taskbarComp : taskbarComponents) {
                if (taskbarComp instanceof JCommandButton) {
                    JCommandButton button = (JCommandButton)taskbarComp;
                    switch (button.getCommandButtonKind()) {
                        case ACTION_ONLY: {
                            button.setActionKeyTip(policy.getContentKeyTip(index++));
                            break;
                        }
                        case ACTION_AND_POPUP_MAIN_ACTION: 
                        case ACTION_AND_POPUP_MAIN_POPUP: {
                            button.setActionKeyTip(policy.getContentKeyTip(index++));
                            button.setPopupKeyTip(policy.getContentKeyTip(index++));
                            break;
                        }
                        case POPUP_ONLY: {
                            button.setPopupKeyTip(policy.getContentKeyTip(index++));
                        }
                    }
                    continue;
                }
                if (!(taskbarComp instanceof JRibbonComponent)) continue;
                ((JRibbonComponent)taskbarComp).setKeyTip(policy.getContentKeyTip(index++));
            }
        }
    }

    public static class TaskbarOverflowButton
    extends JCommandButton {
        public TaskbarOverflowButton(Projection<JCommandButton, ? extends Command, CommandButtonPresentationModel> projection) {
            super(projection);
        }
    }

    @RadiancePopupContainer
    public class TaskbarOverflowPopupPanel
    extends JPopupPanel {
        private TaskbarOverflowPopupPanel(List<Component> overflowComponents, Dimension size, boolean hasScrolling) {
            this.setLayout(new BorderLayout());
            TaskbarOverflowPopupPanelContent overflowPanel = new TaskbarOverflowPopupPanelContent(new FlowLayout(1, RadianceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this), 0));
            for (Component overflow : overflowComponents) {
                overflowPanel.add(overflow);
            }
            if (hasScrolling) {
                this.add(new JScrollablePanel<TaskbarOverflowPopupPanelContent>(overflowPanel, JScrollablePanel.ScrollType.HORIZONTALLY), "Center");
            } else {
                this.add((Component)overflowPanel, "Center");
            }
            this.setPreferredSize(size);
            this.setSize(size);
            RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.HEADER);
        }
    }

    @RadiancePopupContainer
    private class TaskbarOverflowPopupPanelContent
    extends JPanel {
        public TaskbarOverflowPopupPanelContent(LayoutManager layout) {
            super(layout);
        }
    }

    private static class CommandButtonLayoutManagerTaskbarOverflow
    extends CommandButtonLayoutManagerSmall {
        private CommandButtonLayoutManagerTaskbarOverflow() {
        }

        @Override
        public int getPreferredIconSize(JCommandButton commandButton) {
            int fontSize = commandButton.getFont().getSize();
            int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
            int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
            return Math.max(arrowIconWidth, arrowIconHeight);
        }
    }

    private class RadianceContextualGroupComponent
    extends JComponent {
        RibbonContextualTaskGroup taskGroup;

        private RadianceContextualGroupComponent(RibbonContextualTaskGroup taskGroup) {
            this.taskGroup = taskGroup;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Color hueColor = this.taskGroup.getHueColor();
            Graphics2D g2d = (Graphics2D)g.create();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, RadianceColorUtilities.getAlphaColor((Color)hueColor, (int)0), 0.0f, height, RadianceColorUtilities.getAlphaColor((Color)hueColor, (int)63));
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setColor(hueColor);
            g2d.drawLine(1, height - 1, width, height - 1);
            JRibbon ribbon = RadianceRibbonFrameTitlePane.this.getRibbon();
            RadianceColorScheme scheme = RadianceCoreUtilities.getSkin((Component)RadianceRibbonFrameTitlePane.this.rootPane).getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
            FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)ribbon), (Font)ribbon.getFont());
            int yOffset = (height - fm.getHeight()) / 2;
            RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)ribbon.getFont());
            int offset = RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)this), (int)5, (int)2, (int)1, (boolean)false);
            if (this.getComponentOrientation().isLeftToRight()) {
                RadianceTextUtilities.paintText((Graphics)g2d, (Rectangle)new Rectangle(offset, yOffset, width, height - yOffset), (String)this.taskGroup.getTitle(), (int)-1, (Font)ribbon.getFont(), (Color)RadianceColorUtilities.getForegroundColor((RadianceColorScheme)scheme), null);
            } else {
                RadianceTextUtilities.paintText((Graphics)g2d, (Rectangle)new Rectangle(width - offset - g2d.getFontMetrics().stringWidth(this.taskGroup.getTitle()), yOffset, width, height - yOffset), (String)this.taskGroup.getTitle(), (int)-1, (Font)ribbon.getFont(), (Color)RadianceColorUtilities.getForegroundColor((RadianceColorScheme)scheme), null);
            }
            SeparatorPainterUtils.paintSeparator((Component)ribbon, (Graphics)g2d, (int)2, (int)height, (int)1, (boolean)false, (int)(height / 3), (int)0, (boolean)true);
            g2d.translate(width - 1, 0);
            SeparatorPainterUtils.paintSeparator((Component)ribbon, (Graphics)g2d, (int)2, (int)height, (int)1, (boolean)false, (int)(height / 3), (int)0, (boolean)true);
            g2d.dispose();
        }
    }
}

