/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JScrollablePanel;
import org.pushingpixels.radiance.component.internal.theming.common.BladeTransitionAwareRadianceIcon;
import org.pushingpixels.radiance.component.internal.theming.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.radiance.component.internal.ui.common.BasicScrollablePanelUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceScrollablePanelUI
extends BasicScrollablePanelUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceScrollablePanelUI();
    }

    private RadianceScrollablePanelUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g, JComponent c) {
        if (!c.isShowing()) {
            return;
        }
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (c.isOpaque()) {
                BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
                super.paint(g, c);
            } else {
                super.paint(g, c);
            }
        }
    }

    @Override
    protected void configureLeadingScrollerButton(JCommandButton button) {
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        BladeTransitionAwareRadianceIcon arrowIcon = new BladeTransitionAwareRadianceIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (g, scheme, width, height) -> BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 7 : 1), (RadianceColorScheme)scheme), new Dimension(arrowIconHeight, arrowIconWidth));
        button.setIcon(arrowIcon);
        RadianceThemingCortex.ComponentScope.setButtonStraightSides((JComponent)button, this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(RadianceThemingSlices.Side.RIGHT) : EnumSet.of(RadianceThemingSlices.Side.BOTTOM));
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void configureTrailingScrollerButton(JCommandButton button) {
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        BladeTransitionAwareRadianceIcon arrowIcon = new BladeTransitionAwareRadianceIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (g, scheme, width, height) -> BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 3 : 5), (RadianceColorScheme)scheme), new Dimension(arrowIconHeight, arrowIconWidth));
        button.setIcon(arrowIcon);
        RadianceThemingCortex.ComponentScope.setButtonStraightSides((JComponent)button, this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(RadianceThemingSlices.Side.LEFT) : EnumSet.of(RadianceThemingSlices.Side.TOP));
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setCursor(Cursor.getPredefinedCursor(12));
    }
}

