/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.component.internal.ui.common.BasicCommandButtonPanelUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceCommandButtonPanelUI
extends BasicCommandButtonPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceCommandButtonPanelUI();
    }

    private RadianceCommandButtonPanelUI() {
    }

    @Override
    protected Insets getGroupInsets() {
        int extraPadding = RadianceSizeUtils.getExtraPadding((int)RadianceSizeUtils.getComponentFontSize((Component)this.buttonPanel));
        Insets result = BasicCommandButtonPanelUI.GROUP_INSETS;
        return new Insets(result.top + extraPadding, result.left + extraPadding, result.bottom + extraPadding, result.right + extraPadding);
    }

    @Override
    protected int getGroupTitleHeight(int groupIndex) {
        int extraPadding = RadianceSizeUtils.getExtraPadding((int)RadianceSizeUtils.getComponentFontSize((Component)this.buttonPanel));
        return this.groupLabels[groupIndex].getPreferredSize().height + 2 * extraPadding;
    }

    @Override
    protected void paintGroupBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this.buttonPanel);
        RadianceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)this.buttonPanel));
        Color background = groupIndex % 2 == 0 ? scheme.getBackgroundFillColor() : scheme.getAccentedBackgroundFillColor();
        BackgroundPaintingUtils.fillBackground((Graphics)g, (JComponent)this.buttonPanel, (Color)background, (Rectangle)new Rectangle(x, y, width, height));
    }

    @Override
    protected void paintGroupTitleBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        EnumSet<RadianceThemingSlices.Side> openSides = EnumSet.of(RadianceThemingSlices.Side.LEFT, RadianceThemingSlices.Side.RIGHT);
        if (groupIndex == 0) {
            openSides.add(RadianceThemingSlices.Side.TOP);
        }
        RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this.buttonPanel);
        RadianceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)this.buttonPanel));
        Color backgroundFill = scheme.getAccentedBackgroundFillColor();
        Graphics2D g2d = (Graphics2D)g.create(x, y, width, height);
        g2d.setColor(backgroundFill);
        g2d.fillRect(0, 0, width, height);
        HighlightPainterUtils.paintHighlightBorder1X((Graphics2D)g2d, (Component)this.buttonPanel, (int)width, (int)height, (float)1.0f, openSides, (RadianceBorderPainter)RadianceCoreUtilities.getBorderPainter((Component)this.buttonPanel), (RadianceColorScheme)RadianceColorSchemeUtilities.getColorScheme((Component)this.buttonPanel, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED));
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque((Graphics)g, (JComponent)c);
        this.paint(g, c);
    }
}

