/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Taskbar;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.pushingpixels.radiance.common.api.AsynchronousLoadListener;
import org.pushingpixels.radiance.common.api.AsynchronousLoading;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.popup.JCommandPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.CommandPopupMenuPanelProjection;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTask;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.radiance.component.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonFrameTitlePane;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonUI;
import org.pushingpixels.radiance.component.internal.ui.common.RadianceInternalButton;
import org.pushingpixels.radiance.component.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.radiance.component.internal.utils.KeyTipManager;
import org.pushingpixels.radiance.component.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadiancePopupContainer;

public class JRibbonFrame
extends JFrame {
    private JRibbon ribbon;
    private boolean wasSetIconImagesCalled;
    private AWTEventListener awtEventListener;
    private KeyTipManager.KeyTipListener keyTipListener;

    public JRibbonFrame() throws HeadlessException {
        this.initRibbon();
    }

    public JRibbonFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initRibbon();
    }

    public JRibbonFrame(String title) throws HeadlessException {
        super(title);
        this.initRibbon();
    }

    public JRibbonFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initRibbon();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        LayoutManager currManager;
        if (manager.getClass() != RibbonFrameLayout.class && (currManager = this.getLayout()) != null) {
            throw new IllegalArgumentException("Can't set a custom layout manager on JRibbonFrame");
        }
        super.setLayout(manager);
    }

    @Override
    public void setJMenuBar(JMenuBar menubar) {
        throw new IllegalArgumentException("Can't set a menu bar on JRibbonFrame");
    }

    @Override
    public void setContentPane(Container contentPane) {
        throw new IllegalArgumentException("Can't set the content pane on JRibbonFrame");
    }

    private void initRibbon() {
        this.setLayout(new RibbonFrameLayout());
        this.ribbon = new JRibbon(this);
        this.add((Component)this.ribbon, "North");
        final KeyTipManager keyTipManager = KeyTipManager.defaultManager();
        this.awtEventListener = new AWTEventListener(){
            private boolean prevAltModif = false;

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void eventDispatched(AWTEvent event) {
                Object src = event.getSource();
                if (!(src instanceof Component)) return;
                Component c = (Component)src;
                if (c != JRibbonFrame.this) {
                    if (SwingUtilities.getWindowAncestor(c) != JRibbonFrame.this) return;
                }
                if (event instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)event;
                    switch (keyEvent.getID()) {
                        case 402: {
                            boolean wasAltModif = this.prevAltModif;
                            boolean bl = this.prevAltModif = keyEvent.getModifiersEx() == 512;
                            if (wasAltModif && keyEvent.getKeyCode() == 18) break;
                            char keyChar = keyEvent.getKeyChar();
                            if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                                keyTipManager.handleKeyPress(keyChar);
                            }
                            if (keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 121) {
                                if (keyEvent.getModifiersEx() != 0) break;
                                boolean hadPopups = !PopupPanelManager.defaultManager().getShownPath().isEmpty();
                                PopupPanelManager.defaultManager().hidePopups(null);
                                if (hadPopups || keyTipManager.isShowingKeyTips()) {
                                    keyTipManager.hideAllKeyTips();
                                } else {
                                    keyTipManager.showRootKeyTipChain(JRibbonFrame.this);
                                }
                            }
                            if (keyEvent.getKeyCode() == 27 && keyTipManager.isShowingKeyTips()) {
                                keyTipManager.showPreviousChain();
                            }
                            if (!keyTipManager.isShowingKeyTips()) break;
                            switch (keyEvent.getKeyCode()) {
                                case 37: {
                                    RibbonTask previous = JRibbonFrame.this.getPreviousRibbonTask();
                                    if (previous == null) break;
                                    JRibbonFrame.this.ribbon.setSelectedTask(previous);
                                    break;
                                }
                                case 39: {
                                    RibbonTask next = JRibbonFrame.this.getNextRibbonTask();
                                    if (next == null) break;
                                    JRibbonFrame.this.ribbon.setSelectedTask(next);
                                }
                            }
                            break;
                        }
                    }
                }
                if (!(event instanceof MouseEvent)) return;
                MouseEvent mouseEvent = (MouseEvent)event;
                switch (mouseEvent.getID()) {
                    case 500: 
                    case 506: {
                        keyTipManager.hideAllKeyTips();
                        return;
                    }
                    case 501: 
                    case 502: {
                        JCommandButton commandButton;
                        CommandButtonUI commandButtonUI;
                        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo;
                        keyTipManager.hideAllKeyTips();
                        if (mouseEvent.isPopupTrigger()) {
                            JRibbonFrame.this.handlePopupTrigger(mouseEvent, SwingUtilities.getDeepestComponentAt(c, mouseEvent.getX(), mouseEvent.getY()));
                            return;
                        }
                        if (mouseEvent.getID() != 501) return;
                        if (SwingUtilities.getAncestorOfClass(JPopupPanel.class, c) != null) return;
                        if (src instanceof JCommandButton && (layoutInfo = (commandButtonUI = (commandButton = (JCommandButton)src).getUI()).getLayoutInfo()) != null && layoutInfo.popupClickArea != null && layoutInfo.popupClickArea.contains(mouseEvent.getPoint()) && commandButton.getPopupModel().isPopupShowing()) {
                            return;
                        }
                        PopupPanelManager.defaultManager().hidePopups(null);
                        return;
                    }
                }
            }
        };
        final KeyTipLayer keyTipLayer = new KeyTipLayer();
        JRootPane rootPane = this.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        final LayoutManager currLM = rootPane.getLayout();
        rootPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                currLM.addLayoutComponent(name, comp);
            }

            @Override
            public void layoutContainer(Container parent) {
                currLM.layoutContainer(parent);
                JRibbonFrame ribbonFrame = JRibbonFrame.this;
                if (ribbonFrame.getRootPane().getWindowDecorationStyle() != 0) {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getBounds());
                } else {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getContentPane().getBounds());
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return currLM.minimumLayoutSize(parent);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return currLM.preferredLayoutSize(parent);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                currLM.removeLayoutComponent(comp);
            }
        });
        layeredPane.add((Component)keyTipLayer, (Object)(JLayeredPane.DEFAULT_LAYER + 60));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                KeyTipManager keyTipManager = KeyTipManager.defaultManager();
                if (keyTipManager.isShowingKeyTips()) {
                    keyTipManager.hideAllKeyTips();
                }
            }
        });
        this.keyTipListener = new KeyTipManager.KeyTipListener(){

            @Override
            public void keyTipsHidden(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(false);
                }
            }

            @Override
            public void keyTipsShown(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(true);
                }
            }
        };
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        super.setIconImages(Collections.singletonList(RadianceCoreUtilities.getBlankImage((double)RadianceCommonCortex.getScaleFactor(null), (int)16, (int)16)));
    }

    @Override
    public void dispose() {
        RadianceCoreUtilities.unregisterAWTEventListener((AWTEventListener)this.awtEventListener);
        KeyTipManager.defaultManager().removeKeyTipListener(this.keyTipListener);
        super.dispose();
    }

    @Override
    public void show() {
        super.show();
        RadianceCoreUtilities.registerAWTEventListener((AWTEventListener)this.awtEventListener);
        KeyTipManager.defaultManager().addKeyTipListener(this.keyTipListener);
    }

    @Override
    public void hide() {
        RadianceCoreUtilities.unregisterAWTEventListener((AWTEventListener)this.awtEventListener);
        KeyTipManager.defaultManager().removeKeyTipListener(this.keyTipListener);
        super.hide();
    }

    private boolean isValidPopupTriggerSource(Component c) {
        JComponent popupOriginator;
        if (SwingUtilities.getAncestorOfClass(GlobalPopupMenuPanel.class, c) != null) {
            return false;
        }
        if (SwingUtilities.getAncestorOfClass(JRibbon.class, c) != null || SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.class, c) != null) {
            return true;
        }
        JPopupPanel popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, c);
        if (popupPanel == null) {
            return false;
        }
        do {
            if ((popupOriginator = popupPanel.getOriginator()) != null) continue;
            return false;
        } while ((popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, popupOriginator)) != null);
        boolean isValidChainRoot = SwingUtilities.getAncestorOfClass(JRibbon.class, popupOriginator) != null || SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.class, popupOriginator) != null;
        return isValidChainRoot;
    }

    private boolean isInTaskbar(Component c) {
        JComponent popupOriginator;
        if (SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.class, c) != null) {
            return true;
        }
        JPopupPanel popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, c);
        if (popupPanel == null) {
            return false;
        }
        do {
            if ((popupOriginator = popupPanel.getOriginator()) != null) continue;
            return false;
        } while ((popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, popupOriginator)) != null);
        return SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.class, popupOriginator) != null;
    }

    private void handlePopupTrigger(MouseEvent event, Component c) {
        int ph;
        if (!this.isValidPopupTriggerSource(c)) {
            return;
        }
        JRibbon.OnShowContextualMenuListener onShowContextualMenuListener = this.ribbon.getOnShowContextualMenuListener();
        if (onShowContextualMenuListener == null) {
            return;
        }
        CommandMenuContentModel menuContentModel = null;
        if (this.isInTaskbar(c)) {
            Object projection2 = null;
            JRibbonComponent taskbarWrapped = (JRibbonComponent)SwingUtilities.getAncestorOfClass(JRibbonComponent.class, c);
            projection2 = taskbarWrapped != null ? taskbarWrapped.getClientProperty("radiance.component.internal.ribbon.taskbarProjection") : ((JComponent)c).getClientProperty("radiance.component.internal.ribbon.taskbarProjection");
            if (projection2 instanceof RibbonGalleryProjection) {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon, (RibbonGalleryProjection)projection2);
            } else if (projection2 instanceof ComponentProjection) {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon, (ComponentProjection)projection2);
            } else if (projection2 instanceof CommandButtonProjection) {
                CommandButtonProjection commandButtonProjection = (CommandButtonProjection)projection2;
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon, commandButtonProjection);
            } else {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon);
            }
        } else {
            JRibbonGallery gallery = (JRibbonGallery)SwingUtilities.getAncestorOfClass(JRibbonGallery.class, c);
            if (gallery != null) {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon, gallery.getProjection());
            } else {
                JRibbonComponent component = (JRibbonComponent)SwingUtilities.getAncestorOfClass(JRibbonComponent.class, c);
                if (component != null) {
                    menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon, component.getProjection());
                } else if (c instanceof JCommandButton && !(c instanceof RadianceInternalButton)) {
                    menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon, ((JCommandButton)c).getProjection());
                }
            }
        }
        if (menuContentModel == null) {
            menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(this.ribbon);
        }
        CommandPopupMenuPanelProjection globalContextMenuProjection = new CommandPopupMenuPanelProjection(menuContentModel, CommandPopupMenuPresentationModel.builder().setMenuPresentationState(CommandButtonPresentationState.MEDIUM).build());
        globalContextMenuProjection.setComponentSupplier(projection -> GlobalPopupMenuPanel::new);
        JCommandPopupMenuPanel menu = (JCommandPopupMenuPanel)globalContextMenuProjection.buildComponent();
        int x = event.getXOnScreen();
        int y = event.getYOnScreen();
        Rectangle scrBounds = this.ribbon.getGraphicsConfiguration().getBounds();
        int pw = menu.getPreferredSize().width;
        if (x + pw > scrBounds.x + scrBounds.width) {
            x = scrBounds.x + scrBounds.width - pw;
        }
        if (y + (ph = menu.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
            y = scrBounds.y + scrBounds.height - ph;
        }
        PopupPanelManager.defaultManager().hidePopups(c);
        PopupPanelManager.defaultManager().showPopup((JComponent)c, menu, x, y);
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }

    @Override
    protected JRootPane createRootPane() {
        JRibbonRootPane rp = new JRibbonRootPane();
        rp.setOpaque(true);
        return rp;
    }

    public void setKeyboardActions(Set<RibbonKeyboardAction> actions) {
        JRibbonRootPane rootPane = (JRibbonRootPane)this.getRootPane();
        rootPane.setKeyboardActions(actions);
    }

    @Override
    public synchronized void setIconImages(List<? extends Image> icons) {
        super.setIconImages(icons);
        this.wasSetIconImagesCalled = true;
    }

    public synchronized void setApplicationIcon(RadianceIcon.Factory iconFactory) {
        if (iconFactory == null) {
            return;
        }
        new Thread(() -> this.setApplicationAndMenuButtonIcon(iconFactory)).start();
    }

    private void setApplicationAndMenuButtonIcon(RadianceIcon.Factory iconFactory) {
        Image icon16 = JRibbonFrame.getImage(iconFactory, 16);
        if (RadianceCommonCortex.getPlatform() == RadianceCommonCortex.Platform.MACOS) {
            SwingUtilities.invokeLater(() -> this.setLegacyIconImages(Collections.singletonList(icon16)));
        } else {
            SwingUtilities.invokeLater(() -> this.setLegacyIconImages(Arrays.asList(icon16, JRibbonFrame.getImage(iconFactory, 32), JRibbonFrame.getImage(iconFactory, 64))));
        }
        SwingUtilities.invokeLater(() -> {
            Taskbar taskbar = Taskbar.getTaskbar();
            if (taskbar.isSupported(Taskbar.Feature.ICON_IMAGE)) {
                taskbar.setIconImage(JRibbonFrame.getImage(iconFactory, 256));
            }
        });
    }

    private void setLegacyIconImages(List<Image> images) {
        if (this.wasSetIconImagesCalled) {
            return;
        }
        super.setIconImages(images);
    }

    private static Image getImage(RadianceIcon.Factory iconFactory, int size) {
        AsynchronousLoading async;
        RadianceIcon icon = iconFactory.createNewIcon();
        icon.setDimension(new Dimension(size, size));
        if (icon instanceof AsynchronousLoading && (async = (AsynchronousLoading)icon).isLoading()) {
            CountDownLatch latch = new CountDownLatch(1);
            boolean[] status = new boolean[1];
            AsynchronousLoadListener all = success -> {
                status[0] = success;
                latch.countDown();
            };
            async.addAsynchronousLoadListener(all);
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            async.removeAsynchronousLoadListener(all);
            if (!status[0]) {
                return null;
            }
            if (async.isLoading()) {
                return null;
            }
        }
        BufferedImage result = RadianceCoreUtilities.getBlankImage((double)RadianceCommonCortex.getScaleFactor(null), (int)size, (int)size);
        Graphics2D g2d = (Graphics2D)((Image)result).getGraphics().create();
        icon.paintIcon(null, (Graphics)g2d, 0, 0);
        g2d.dispose();
        return result;
    }

    public boolean isShowingKeyTips() {
        return KeyTipManager.defaultManager().isShowingKeyTips();
    }

    private List<RibbonTask> getAllShownRibbonTasks() {
        int i;
        ArrayList<RibbonTask> result = new ArrayList<RibbonTask>();
        for (i = 0; i < this.ribbon.getTaskCount(); ++i) {
            result.add(this.ribbon.getTask(i));
        }
        for (i = 0; i < this.ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup curr = this.ribbon.getContextualTaskGroup(i);
            if (!this.ribbon.isVisible(curr)) continue;
            for (int j = 0; j < curr.getTaskCount(); ++j) {
                result.add(curr.getTask(j));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private RibbonTask getNextRibbonTask() {
        List<RibbonTask> all = this.getAllShownRibbonTasks();
        int indexOfCurrent = all.indexOf(this.ribbon.getSelectedTask());
        if (indexOfCurrent < 0) {
            return null;
        }
        if (indexOfCurrent == all.size() - 1) {
            return null;
        }
        return all.get(indexOfCurrent + 1);
    }

    private RibbonTask getPreviousRibbonTask() {
        List<RibbonTask> all = this.getAllShownRibbonTasks();
        int indexOfCurrent = all.indexOf(this.ribbon.getSelectedTask());
        if (indexOfCurrent < 0) {
            return null;
        }
        if (indexOfCurrent == 0) {
            return null;
        }
        return all.get(indexOfCurrent - 1);
    }

    @RadiancePopupContainer
    public static class GlobalPopupMenuPanel
    extends JCommandPopupMenuPanel {
        public GlobalPopupMenuPanel(Projection<JCommandPopupMenuPanel, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection) {
            super(projection);
        }
    }

    public static class RibbonKeyboardAction {
        private String actionName;
        private KeyStroke actionKeyStroke;
        private Command command;

        public RibbonKeyboardAction(String actionName, KeyStroke actionKeyStroke, Command command) {
            this.actionName = actionName;
            this.actionKeyStroke = actionKeyStroke;
            this.command = command;
        }

        public String getActionName() {
            return this.actionName;
        }

        public KeyStroke getActionKeyStroke() {
            return this.actionKeyStroke;
        }

        public Command getCommand() {
            return this.command;
        }
    }

    private static class KeyTipLayer
    extends JComponent {
        public KeyTipLayer() {
            this.setOpaque(false);
            this.setMixingCutoutShape(new Rectangle());
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener l) {
        }

        @Override
        public synchronized void addKeyListener(KeyListener l) {
        }

        @Override
        protected void paintComponent(Graphics g) {
            JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(this);
            if (!ribbonFrame.isShowingKeyTips()) {
                return;
            }
            if (!ribbonFrame.isActive()) {
                return;
            }
            Collection<KeyTipManager.KeyTipLink> keyTips = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
            if (keyTips != null) {
                Graphics2D g2d = (Graphics2D)g.create();
                RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.getFont());
                for (KeyTipManager.KeyTipLink keyTip : keyTips) {
                    Container titlePane;
                    Container taskbarOverflowPanel;
                    boolean isInPopup;
                    boolean bl = isInPopup = SwingUtilities.getAncestorOfClass(JPopupPanel.class, keyTip.comp) != null;
                    if (isInPopup && SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.TaskbarOverflowPopupPanel.class, keyTip.comp) == null) continue;
                    Rectangle compBounds = keyTip.comp.getBounds();
                    if (!keyTip.comp.isShowing() || compBounds.getWidth() == 0.0 || compBounds.getHeight() == 0.0) continue;
                    Dimension pref = KeyTipRenderingUtilities.getPrefSize(g2d.getFontMetrics(), keyTip.keyTipString);
                    Point prefCenter = keyTip.prefAnchorPoint;
                    Point loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, this);
                    Container bandControlPanel = SwingUtilities.getAncestorOfClass(AbstractBandControlPanel.class, keyTip.comp);
                    if (bandControlPanel != null) {
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "radiance.component.internal.ribbonBandControlPanel.topRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = 0;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "radiance.component.internal.ribbonBandControlPanel.midRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight() / 2;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "radiance.component.internal.ribbonBandControlPanel.bottomRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight();
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                    }
                    if ((taskbarOverflowPanel = SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.TaskbarOverflowPopupPanel.class, keyTip.comp)) != null) {
                        loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, taskbarOverflowPanel);
                        loc.y = pref.height / 2 + taskbarOverflowPanel.getHeight();
                        loc = SwingUtilities.convertPoint(taskbarOverflowPanel, loc, this);
                    }
                    if ((titlePane = SwingUtilities.getAncestorOfClass(RadianceRibbonFrameTitlePane.class, keyTip.comp)) != null) {
                        loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, titlePane);
                        loc.y = pref.height / 2 + titlePane.getHeight() / 2;
                        loc = SwingUtilities.convertPoint(titlePane, loc, this);
                    }
                    KeyTipRenderingUtilities.renderKeyTip(g2d, this, new Rectangle(loc.x - pref.width / 2, loc.y - pref.height / 2, pref.width, pref.height), keyTip.keyTipString, keyTip.enabled);
                }
                g2d.dispose();
            }
        }

        private boolean hasClientPropertySetToTrue(Component c, String clientPropName) {
            while (c != null) {
                JComponent jc;
                if (c instanceof JComponent && Boolean.TRUE.equals((jc = (JComponent)c).getClientProperty(clientPropName))) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        @Override
        public boolean contains(int x, int y) {
            return false;
        }
    }

    private static class RibbonFrameLayout
    extends BorderLayout {
        private RibbonFrameLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints != null && constraints.equals("North")) {
                if (this.getLayoutComponent("North") != null) {
                    throw new IllegalArgumentException("Already has a NORTH JRibbon component");
                }
                if (!(comp instanceof JRibbon)) {
                    throw new IllegalArgumentException("Can't add non-JRibbon component to NORTH location");
                }
            }
            super.addLayoutComponent(comp, constraints);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp instanceof JRibbon) {
                throw new IllegalArgumentException("Can't remove JRibbon component");
            }
            super.removeLayoutComponent(comp);
        }
    }
}

