/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.popup;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.internal.ui.common.popup.ScrollableHost;

public abstract class AbstractPopupMenuPanel
extends JPopupPanel
implements ScrollableHost {
    private List<Component> menuComponents = new ArrayList<Component>();

    protected AbstractPopupMenuPanel() {
    }

    void addMenuButton(JCommandButton menuButton) {
        menuButton.setHorizontalAlignment(10);
        this.menuComponents.add(menuButton);
        this.fireStateChanged();
    }

    void addMenuSeparator() {
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        separator.setFocusable(false);
        this.menuComponents.add(separator);
        this.fireStateChanged();
    }

    void addMenuPanel(JPanel menuPanel) {
        this.menuComponents.add(menuPanel);
        this.fireStateChanged();
    }

    public List<Component> getMenuComponents() {
        if (this.menuComponents == null) {
            return null;
        }
        return Collections.unmodifiableList(this.menuComponents);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }
}

