/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.model.Command;

public class CommandToggleGroupModel {
    private Vector<Command> commands = new Vector();
    private Map<Command, ChangeListener> modelChangeListeners = new HashMap<Command, ChangeListener>();
    private Command selection;
    private boolean allowsClearingSelection = true;

    public Collection<Command> getCommands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    public void setAllowsClearingSelection(boolean allowsClearingSelection) {
        this.allowsClearingSelection = allowsClearingSelection;
    }

    public boolean isAllowsClearingSelection() {
        return this.allowsClearingSelection;
    }

    public void add(final Command command) {
        boolean wasSelectionNull;
        if (command == null) {
            return;
        }
        this.commands.addElement(command);
        boolean bl = wasSelectionNull = this.selection == null;
        if (command.isToggleSelected()) {
            if (wasSelectionNull) {
                this.selection = command;
            } else {
                command.setToggleSelected(false);
            }
        }
        ChangeListener cl = new ChangeListener(){
            boolean wasSelected;
            {
                this.wasSelected = command.isToggleSelected();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = command.isToggleSelected();
                if (this.wasSelected != isSelected) {
                    CommandToggleGroupModel.this.setSelected(command, isSelected);
                }
                this.wasSelected = isSelected;
            }
        };
        command.addChangeListener(cl);
        this.modelChangeListeners.put(command, cl);
    }

    public void remove(Command command) {
        boolean wasSelected;
        if (command == null) {
            return;
        }
        this.commands.removeElement(command);
        boolean bl = wasSelected = command == this.selection;
        if (wasSelected) {
            this.selection = null;
        }
        command.removeChangeListener(this.modelChangeListeners.get(command));
        this.modelChangeListeners.remove(command);
    }

    public void removeAll() {
        this.commands.clear();
        this.selection = null;
    }

    public void setSelected(Command command, boolean isSelected) {
        if (isSelected && command != null && command != this.selection) {
            Command oldSelection = this.selection;
            this.selection = command;
            if (oldSelection != null) {
                oldSelection.setToggleSelected(false);
            }
            command.setToggleSelected(true);
        }
        if (!isSelected && command != null && command == this.selection) {
            if (this.allowsClearingSelection) {
                this.selection = null;
                command.setToggleSelected(false);
            } else {
                command.setToggleSelected(true);
            }
        }
    }

    public Command getSelected() {
        return this.selection;
    }

    public void clearSelection() {
        if (this.allowsClearingSelection && this.selection != null) {
            this.selection.setToggleSelected(false);
        }
    }
}

