/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.model.ImmutablePresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.model.AbstractPopupMenuPresentationModel;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class CommandButtonPresentationModel
implements ImmutablePresentationModel {
    public static final int DEFAULT_AUTO_REPEAT_INITIAL_INTERVAL_MS = 500;
    public static final int DEFAULT_AUTO_REPEAT_SUBSEQUENT_INTERVAL_MS = 100;
    private CommandButtonPresentationState presentationState;
    private Integer iconDimension;
    private RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy;
    private RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy;
    private RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy;
    private RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy;
    private boolean isFocusable;
    private int horizontalAlignment;
    private double horizontalGapScaleFactor;
    private double verticalGapScaleFactor;
    private boolean isMenu;
    private PopupOrientationKind popupOrientationKind;
    private PopupHorizontalGravity popupHorizontalGravity;
    private String actionKeyTip;
    private String popupKeyTip;
    private boolean toDismissPopupsOnActivation;
    private AbstractPopupMenuPresentationModel popupMenuPresentationModel;
    private TextClick textClick;
    private boolean isAutoRepeatAction;
    private boolean hasAutoRepeatIntervalsSet;
    private int autoRepeatInitialInterval;
    private int autoRepeatSubsequentInterval;
    private FireActionTrigger fireActionTrigger;

    private CommandButtonPresentationModel() {
    }

    public CommandButtonPresentationModel overlayWith(Overlay overlay) {
        CommandButtonPresentationModel result = new CommandButtonPresentationModel();
        result.presentationState = overlay.presentationState != null ? overlay.presentationState : this.presentationState;
        result.backgroundAppearanceStrategy = overlay.backgroundAppearanceStrategy != null ? overlay.backgroundAppearanceStrategy : this.backgroundAppearanceStrategy;
        result.isFocusable = overlay.isFocusable != null ? overlay.isFocusable : this.isFocusable;
        result.horizontalAlignment = overlay.horizontalAlignment != null ? overlay.horizontalAlignment : this.horizontalAlignment;
        result.horizontalGapScaleFactor = overlay.horizontalGapScaleFactor != null ? overlay.horizontalGapScaleFactor : this.horizontalGapScaleFactor;
        result.verticalGapScaleFactor = overlay.verticalGapScaleFactor != null ? overlay.verticalGapScaleFactor : this.verticalGapScaleFactor;
        result.iconDimension = overlay.iconDimension != null ? overlay.iconDimension : this.iconDimension;
        result.activeIconFilterStrategy = overlay.activeIconFilterStrategy != null ? overlay.activeIconFilterStrategy : this.activeIconFilterStrategy;
        result.enabledIconFilterStrategy = overlay.enabledIconFilterStrategy != null ? overlay.enabledIconFilterStrategy : this.enabledIconFilterStrategy;
        result.disabledIconFilterStrategy = overlay.disabledIconFilterStrategy != null ? overlay.disabledIconFilterStrategy : this.disabledIconFilterStrategy;
        result.isMenu = overlay.isMenu != null ? overlay.isMenu : this.isMenu;
        result.popupOrientationKind = overlay.popupOrientationKind != null ? overlay.popupOrientationKind : this.popupOrientationKind;
        result.popupHorizontalGravity = overlay.popupHorizontalGravity != null ? overlay.popupHorizontalGravity : this.popupHorizontalGravity;
        result.toDismissPopupsOnActivation = overlay.toDismissPopupsOnActivation != null ? overlay.toDismissPopupsOnActivation : this.toDismissPopupsOnActivation;
        result.popupMenuPresentationModel = overlay.popupMenuPresentationModel != null ? overlay.popupMenuPresentationModel : this.popupMenuPresentationModel;
        result.actionKeyTip = overlay.actionKeyTip != null ? overlay.actionKeyTip : this.actionKeyTip;
        result.popupKeyTip = overlay.popupKeyTip != null ? overlay.popupKeyTip : this.popupKeyTip;
        result.textClick = overlay.textClick != null ? overlay.textClick : this.textClick;
        result.isAutoRepeatAction = overlay.isAutoRepeatAction != null ? overlay.isAutoRepeatAction : this.isAutoRepeatAction;
        result.hasAutoRepeatIntervalsSet = overlay.hasAutoRepeatIntervalsSet != null ? overlay.hasAutoRepeatIntervalsSet : this.hasAutoRepeatIntervalsSet;
        result.autoRepeatInitialInterval = overlay.autoRepeatInitialInterval != null ? overlay.autoRepeatInitialInterval : this.autoRepeatInitialInterval;
        result.autoRepeatSubsequentInterval = overlay.autoRepeatSubsequentInterval != null ? overlay.autoRepeatSubsequentInterval : this.autoRepeatSubsequentInterval;
        result.fireActionTrigger = overlay.fireActionTrigger != null ? overlay.fireActionTrigger : this.fireActionTrigger;
        return result;
    }

    public static CommandButtonPresentationModel withDefaults() {
        return CommandButtonPresentationModel.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Overlay overlay() {
        return new Overlay();
    }

    public CommandButtonPresentationState getPresentationState() {
        return this.presentationState;
    }

    public RadianceThemingSlices.BackgroundAppearanceStrategy getBackgroundAppearanceStrategy() {
        return this.backgroundAppearanceStrategy;
    }

    public boolean isFocusable() {
        return this.isFocusable;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public double getHorizontalGapScaleFactor() {
        return this.horizontalGapScaleFactor;
    }

    public double getVerticalGapScaleFactor() {
        return this.verticalGapScaleFactor;
    }

    public Integer getIconDimension() {
        return this.iconDimension;
    }

    public RadianceThemingSlices.IconFilterStrategy getActiveIconFilterStrategy() {
        return this.activeIconFilterStrategy;
    }

    public RadianceThemingSlices.IconFilterStrategy getEnabledIconFilterStrategy() {
        return this.enabledIconFilterStrategy;
    }

    public RadianceThemingSlices.IconFilterStrategy getDisabledIconFilterStrategy() {
        return this.disabledIconFilterStrategy;
    }

    public PopupOrientationKind getPopupOrientationKind() {
        return this.popupOrientationKind;
    }

    public PopupHorizontalGravity getPopupHorizontalGravity() {
        return this.popupHorizontalGravity;
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public boolean isToDismissPopupsOnActivation() {
        return this.toDismissPopupsOnActivation;
    }

    public AbstractPopupMenuPresentationModel getPopupMenuPresentationModel() {
        return this.popupMenuPresentationModel;
    }

    public String getActionKeyTip() {
        return this.actionKeyTip;
    }

    public String getPopupKeyTip() {
        return this.popupKeyTip;
    }

    public TextClick getTextClick() {
        return this.textClick;
    }

    public FireActionTrigger getFireActionTrigger() {
        return this.fireActionTrigger;
    }

    public boolean isAutoRepeatAction() {
        return this.isAutoRepeatAction;
    }

    public boolean hasAutoRepeatIntervalsSet() {
        return this.hasAutoRepeatIntervalsSet;
    }

    public int getAutoRepeatInitialInterval() {
        return this.hasAutoRepeatIntervalsSet ? this.autoRepeatInitialInterval : -1;
    }

    public int getAutoRepeatSubsequentInterval() {
        return this.hasAutoRepeatIntervalsSet ? this.autoRepeatSubsequentInterval : -1;
    }

    public static class Builder {
        private CommandButtonPresentationState presentationState = CommandButtonPresentationState.FIT_TO_ICON;
        private RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy = RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT;
        private boolean isFocusable = true;
        private int horizontalAlignment = 0;
        private double horizontalGapScaleFactor = 1.0;
        private double verticalGapScaleFactor = 1.0;
        private Integer iconDimension;
        private RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy = RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
        private RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy = RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
        private RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy = RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
        private boolean isMenu = false;
        private PopupOrientationKind popupOrientationKind = PopupOrientationKind.DOWNWARD;
        private PopupHorizontalGravity popupHorizontalGravity = PopupHorizontalGravity.START;
        private String actionKeyTip;
        private String popupKeyTip;
        private boolean toDismissPopupsOnActivation = true;
        private AbstractPopupMenuPresentationModel popupMenuPresentationModel;
        private TextClick textClick = TextClick.ACTION;
        private boolean isAutoRepeatAction;
        private boolean hasAutoRepeatIntervalsSet;
        private int autoRepeatInitialInterval = 500;
        private int autoRepeatSubsequentInterval = 100;
        private FireActionTrigger fireActionTrigger = FireActionTrigger.ON_PRESS_RELEASED;

        public Builder setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy) {
            this.backgroundAppearanceStrategy = backgroundAppearanceStrategy;
            return this;
        }

        public Builder setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return this;
        }

        public Builder setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Builder setHorizontalGapScaleFactor(double horizontalGapScaleFactor) {
            this.horizontalGapScaleFactor = horizontalGapScaleFactor;
            return this;
        }

        public Builder setVerticalGapScaleFactor(double verticalGapScaleFactor) {
            this.verticalGapScaleFactor = verticalGapScaleFactor;
            return this;
        }

        public Builder setPresentationState(CommandButtonPresentationState presentationState) {
            this.presentationState = presentationState;
            return this;
        }

        public Builder setIconDimension(Integer iconDimension) {
            this.iconDimension = iconDimension;
            return this;
        }

        public Builder setIconFilterStrategies(RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy) {
            this.activeIconFilterStrategy = activeIconFilterStrategy;
            this.enabledIconFilterStrategy = enabledIconFilterStrategy;
            this.disabledIconFilterStrategy = disabledIconFilterStrategy;
            return this;
        }

        public Builder setPopupOrientationKind(PopupOrientationKind popupOrientationKind) {
            this.popupOrientationKind = popupOrientationKind;
            return this;
        }

        public Builder setPopupHorizontalGravity(PopupHorizontalGravity popupHorizontalGravity) {
            this.popupHorizontalGravity = popupHorizontalGravity;
            return this;
        }

        public Builder setMenu(boolean isMenu) {
            this.isMenu = isMenu;
            return this;
        }

        public Builder setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return this;
        }

        public Builder setPopupMenuPresentationModel(AbstractPopupMenuPresentationModel popupMenuPresentationModel) {
            this.popupMenuPresentationModel = popupMenuPresentationModel;
            return this;
        }

        public Builder setActionKeyTip(String actionKeyTip) {
            this.actionKeyTip = actionKeyTip;
            return this;
        }

        public Builder setPopupKeyTip(String popupKeyTip) {
            this.popupKeyTip = popupKeyTip;
            return this;
        }

        public Builder setTextClick(TextClick textClick) {
            this.textClick = textClick;
            return this;
        }

        public Builder setAutoRepeatAction(boolean isAutoRepeatAction) {
            this.isAutoRepeatAction = isAutoRepeatAction;
            return this;
        }

        public Builder setAutoRepeatActionIntervals(int initial, int subsequent) {
            this.hasAutoRepeatIntervalsSet = true;
            this.autoRepeatInitialInterval = initial;
            this.autoRepeatSubsequentInterval = subsequent;
            return this;
        }

        public Builder setFireActionTrigger(FireActionTrigger fireActionTrigger) {
            this.fireActionTrigger = fireActionTrigger;
            return this;
        }

        public CommandButtonPresentationModel build() {
            CommandButtonPresentationModel commandPresentation = new CommandButtonPresentationModel();
            commandPresentation.presentationState = this.presentationState;
            commandPresentation.horizontalAlignment = this.horizontalAlignment;
            commandPresentation.horizontalGapScaleFactor = this.horizontalGapScaleFactor;
            commandPresentation.verticalGapScaleFactor = this.verticalGapScaleFactor;
            commandPresentation.backgroundAppearanceStrategy = this.backgroundAppearanceStrategy;
            commandPresentation.isFocusable = this.isFocusable;
            commandPresentation.iconDimension = this.iconDimension;
            commandPresentation.activeIconFilterStrategy = this.activeIconFilterStrategy;
            commandPresentation.enabledIconFilterStrategy = this.enabledIconFilterStrategy;
            commandPresentation.disabledIconFilterStrategy = this.disabledIconFilterStrategy;
            commandPresentation.isMenu = this.isMenu;
            commandPresentation.popupOrientationKind = this.popupOrientationKind;
            commandPresentation.popupHorizontalGravity = this.popupHorizontalGravity;
            commandPresentation.actionKeyTip = this.actionKeyTip;
            commandPresentation.popupKeyTip = this.popupKeyTip;
            commandPresentation.toDismissPopupsOnActivation = this.toDismissPopupsOnActivation;
            commandPresentation.popupMenuPresentationModel = this.popupMenuPresentationModel;
            commandPresentation.textClick = this.textClick;
            commandPresentation.isAutoRepeatAction = this.isAutoRepeatAction;
            commandPresentation.hasAutoRepeatIntervalsSet = this.hasAutoRepeatIntervalsSet;
            commandPresentation.autoRepeatInitialInterval = this.autoRepeatInitialInterval;
            commandPresentation.autoRepeatSubsequentInterval = this.autoRepeatSubsequentInterval;
            commandPresentation.fireActionTrigger = this.fireActionTrigger;
            return commandPresentation;
        }
    }

    public static class Overlay {
        private CommandButtonPresentationState presentationState;
        private RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy;
        private Boolean isFocusable;
        private Integer horizontalAlignment;
        private Double horizontalGapScaleFactor;
        private Double verticalGapScaleFactor;
        private Integer iconDimension;
        private RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy;
        private RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy;
        private RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy;
        private Boolean isMenu;
        private PopupOrientationKind popupOrientationKind;
        private PopupHorizontalGravity popupHorizontalGravity;
        private Boolean toDismissPopupsOnActivation;
        private String actionKeyTip;
        private String popupKeyTip;
        private AbstractPopupMenuPresentationModel popupMenuPresentationModel;
        private TextClick textClick;
        private Boolean isAutoRepeatAction;
        private Boolean hasAutoRepeatIntervalsSet;
        private Integer autoRepeatInitialInterval;
        private Integer autoRepeatSubsequentInterval;
        private FireActionTrigger fireActionTrigger;

        public Overlay setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy) {
            this.backgroundAppearanceStrategy = backgroundAppearanceStrategy;
            return this;
        }

        public Overlay setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return this;
        }

        public Overlay setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Overlay setHorizontalGapScaleFactor(double horizontalGapScaleFactor) {
            this.horizontalGapScaleFactor = horizontalGapScaleFactor;
            return this;
        }

        public Overlay setVerticalGapScaleFactor(double verticalGapScaleFactor) {
            this.verticalGapScaleFactor = verticalGapScaleFactor;
            return this;
        }

        public Overlay setPresentationState(CommandButtonPresentationState presentationState) {
            this.presentationState = presentationState;
            return this;
        }

        public Overlay setIconDimension(Integer iconDimension) {
            this.iconDimension = iconDimension;
            return this;
        }

        public Overlay setIconFilterStrategies(RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy) {
            this.activeIconFilterStrategy = activeIconFilterStrategy;
            this.enabledIconFilterStrategy = enabledIconFilterStrategy;
            this.disabledIconFilterStrategy = disabledIconFilterStrategy;
            return this;
        }

        public Overlay setPopupOrientationKind(PopupOrientationKind popupOrientationKind) {
            this.popupOrientationKind = popupOrientationKind;
            return this;
        }

        public Overlay setPopupHorizontalGravity(PopupHorizontalGravity popupHorizontalGravity) {
            this.popupHorizontalGravity = popupHorizontalGravity;
            return this;
        }

        public Overlay setMenu(boolean isMenu) {
            this.isMenu = isMenu;
            return this;
        }

        public Overlay setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return this;
        }

        public Overlay setPopupMenuPresentationModel(AbstractPopupMenuPresentationModel popupMenuPresentationModel) {
            this.popupMenuPresentationModel = popupMenuPresentationModel;
            return this;
        }

        public Overlay setActionKeyTip(String actionKeyTip) {
            this.actionKeyTip = actionKeyTip;
            return this;
        }

        public Overlay setPopupKeyTip(String popupKeyTip) {
            this.popupKeyTip = popupKeyTip;
            return this;
        }

        public Overlay setTextClick(TextClick textClick) {
            this.textClick = textClick;
            return this;
        }

        public Overlay setAutoRepeatAction(boolean isAutoRepeatAction) {
            this.isAutoRepeatAction = isAutoRepeatAction;
            return this;
        }

        public Overlay setAutoRepeatActionIntervals(int initial, int subsequent) {
            this.hasAutoRepeatIntervalsSet = true;
            this.autoRepeatInitialInterval = initial;
            this.autoRepeatSubsequentInterval = subsequent;
            return this;
        }

        public Overlay setFireActionTrigger(FireActionTrigger fireActionTrigger) {
            this.fireActionTrigger = fireActionTrigger;
            return this;
        }
    }

    public static enum TextClick {
        ACTION,
        POPUP;

    }

    public static enum FireActionTrigger {
        ON_ROLLOVER,
        ON_PRESSED,
        ON_PRESS_RELEASED;

    }

    public static enum PopupHorizontalGravity {
        START,
        END;

    }

    public static enum PopupOrientationKind {
        DOWNWARD,
        SIDEWARD;

    }
}

