/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;

public class ColorRadianceIcon
implements RadianceIcon {
    protected int width;
    protected int height;
    private final Color color;

    public ColorRadianceIcon(Dimension initialDim, Color color) {
        this.width = initialDim.width;
        this.height = initialDim.height;
        this.color = color;
    }

    public ColorRadianceIcon(int initialDim, Color color) {
        this(new Dimension(initialDim, initialDim), color);
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public boolean supportsColorFilter() {
        return false;
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
    }

    public static RadianceIcon.Factory factory(Color color) {
        return () -> new ColorRadianceIcon(16, color);
    }
}

