/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import java.awt.Dimension;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import org.pushingpixels.radiance.common.api.AsynchronousLoading;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbItem;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButtonPanel;
import org.pushingpixels.radiance.component.api.common.ProgressEvent;
import org.pushingpixels.radiance.component.api.common.ProgressListener;
import org.pushingpixels.radiance.component.api.common.icon.EmptyRadianceIcon;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandPanelProjection;

public abstract class AbstractFileViewPanel<T>
extends JCommandButtonPanel {
    private ProgressListener progressListener;
    private Set<Command> loadedSet = new HashSet<Command>();
    private SwingWorker<Void, Leaf> mainWorker;

    public AbstractFileViewPanel(int startingDimension) {
        super(new CommandPanelProjection(new CommandPanelContentModel(new ArrayList<CommandGroup>()), CommandPanelPresentationModel.builder().setCommandPresentationState(CommandButtonPresentationState.FIT_TO_ICON).setCommandIconDimension(startingDimension).setToShowGroupLabels(false).build()));
    }

    public AbstractFileViewPanel(CommandButtonPresentationState startingState) {
        super(new CommandPanelProjection(new CommandPanelContentModel(new ArrayList<CommandGroup>()), CommandPanelPresentationModel.builder().setCommandHorizontalAlignment(10).setCommandPresentationState(startingState).setToShowGroupLabels(false).build()));
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setFolder(final List<BreadcrumbItem<T>> leaves) {
        final CommandPanelContentModel contentModel = (CommandPanelContentModel)this.getProjection().getContentModel();
        contentModel.removeAllCommandGroups();
        CommandGroup commandGroup = new CommandGroup(new Command[0]);
        contentModel.addCommandGroup(commandGroup);
        int fileCount = 0;
        for (BreadcrumbItem<T> leaf : leaves) {
            if (!this.toShowFile(leaf)) continue;
            Command command = ((Command.Builder)((Command.Builder)Command.builder().setText(leaf.getDisplayName())).setIconFactory(EmptyRadianceIcon.factory())).build();
            commandGroup.addCommand(command);
            ++fileCount;
        }
        this.doLayout();
        this.repaint();
        final int totalCount = fileCount;
        this.mainWorker = new SwingWorker<Void, Leaf>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (totalCount > 0 && AbstractFileViewPanel.this.progressListener != null) {
                    AbstractFileViewPanel.this.progressListener.onProgress(new ProgressEvent(AbstractFileViewPanel.this, 0, totalCount, 0));
                }
                for (BreadcrumbItem leafItem : leaves) {
                    if (this.isCancelled()) break;
                    if (!AbstractFileViewPanel.this.toShowFile(leafItem)) continue;
                    InputStream stream = AbstractFileViewPanel.this.getLeafContent(leafItem.getData());
                    Leaf leaf = new Leaf(leafItem.getDisplayName(), stream);
                    this.publish(leaf);
                }
                return null;
            }

            @Override
            protected void process(List<Leaf> leaves2) {
                for (Leaf leaf : leaves2) {
                    String name = leaf.getLeafName();
                    InputStream stream = leaf.getLeafStream();
                    int iconDimension = ((CommandPanelPresentationModel)AbstractFileViewPanel.this.getProjection().getPresentationModel()).getCommandIconDimension();
                    Dimension dim = new Dimension(iconDimension, iconDimension);
                    RadianceIcon icon = AbstractFileViewPanel.this.getRadianceIcon(leaf, stream, ((CommandPanelPresentationModel)AbstractFileViewPanel.this.getProjection().getPresentationModel()).getCommandPresentationState(), dim);
                    if (icon == null) continue;
                    Command matchingCommand = contentModel.findFirstMatch(command -> name.equals(command.getText()));
                    matchingCommand.setIconFactory(() -> icon);
                    if (icon instanceof AsynchronousLoading) {
                        ((AsynchronousLoading)icon).addAsynchronousLoadListener(success -> {
                            AbstractFileViewPanel abstractFileViewPanel = AbstractFileViewPanel.this;
                            synchronized (abstractFileViewPanel) {
                                if (AbstractFileViewPanel.this.loadedSet.contains(matchingCommand)) {
                                    return;
                                }
                                AbstractFileViewPanel.this.loadedSet.add(matchingCommand);
                                if (AbstractFileViewPanel.this.progressListener != null) {
                                    AbstractFileViewPanel.this.progressListener.onProgress(new ProgressEvent(AbstractFileViewPanel.this, 0, totalCount, AbstractFileViewPanel.this.loadedSet.size()));
                                }
                            }
                        });
                    }
                    AbstractFileViewPanel.this.configureCommand(leaf, matchingCommand, icon);
                }
            }
        };
        this.mainWorker.execute();
    }

    public int getLoadedIconCount() {
        return this.loadedSet.size();
    }

    public void cancelMainWorker() {
        if (this.mainWorker == null) {
            return;
        }
        if (this.mainWorker.isDone() || this.mainWorker.isCancelled()) {
            return;
        }
        this.mainWorker.cancel(false);
    }

    protected abstract boolean toShowFile(BreadcrumbItem<T> var1);

    protected abstract RadianceIcon getRadianceIcon(Leaf var1, InputStream var2, CommandButtonPresentationState var3, Dimension var4);

    protected void configureCommand(Leaf leaf, Command command, RadianceIcon icon) {
    }

    protected abstract InputStream getLeafContent(T var1);

    public static class Leaf {
        protected String leafName;
        protected InputStream leafStream;
        protected Map<String, Object> leafProps;

        public Leaf(String leafName, InputStream leafStream) {
            this.leafName = leafName;
            this.leafStream = leafStream;
            this.leafProps = new HashMap<String, Object>();
        }

        public String getLeafName() {
            return this.leafName;
        }

        public InputStream getLeafStream() {
            return this.leafStream;
        }

        public Object getLeafProp(String propName) {
            return this.leafProps.get(propName);
        }
    }
}

