/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.bcb.core;

import java.awt.Component;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarContentModel;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarContentProvider;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarPresentationModel;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbItem;
import org.pushingpixels.radiance.component.api.bcb.JBreadcrumbBar;

public class BreadcrumbTreeAdapterSelector<T>
extends JBreadcrumbBar<T> {
    public BreadcrumbTreeAdapterSelector(TreeModel treeModel, TreeAdapter<T> treeAdapter, boolean isRootVisible, BreadcrumbBarPresentationModel presentationModel) {
        super(null, presentationModel);
        this.contentModel = new BreadcrumbBarContentModel();
        this.contentProvider = new TreeContentProvider(treeModel, treeAdapter, isRootVisible);
        this.updateUI();
    }

    public BreadcrumbTreeAdapterSelector(JTree tree, TreeAdapter<T> treeAdapter) {
        this(tree.getModel(), treeAdapter, tree.isRootVisible(), BreadcrumbBarPresentationModel.withDefaults());
    }

    public BreadcrumbTreeAdapterSelector(final JTree tree) {
        this(tree, new TreeAdapter<T>(){

            private JLabel getRenderer(Object node) {
                Component renderer = tree.getCellRenderer().getTreeCellRendererComponent(tree, node, false, false, tree.getModel().isLeaf(node), 0, false);
                if (renderer instanceof JLabel) {
                    return (JLabel)renderer;
                }
                return null;
            }

            @Override
            public String toString(Object node) {
                JLabel label = this.getRenderer(node);
                if (label != null) {
                    return label.getText();
                }
                return null;
            }

            @Override
            public RadianceIcon.Factory getIconFactory(T node) {
                return null;
            }
        });
    }

    private class TreeContentProvider
    extends BreadcrumbBarContentProvider<T> {
        private TreeModel treeModel;
        private TreeAdapter<T> treeAdapter;
        private boolean isRootVisible;

        private TreeContentProvider(TreeModel treeModel, TreeAdapter<T> treeAdapter, boolean isRootVisible) {
            this.treeModel = treeModel;
            this.treeAdapter = treeAdapter;
            this.isRootVisible = isRootVisible;
        }

        @Override
        public List<BreadcrumbItem<T>> getPathChoices(List<BreadcrumbItem<T>> path) {
            if (path == null) {
                Object root = this.treeModel.getRoot();
                LinkedList bRoots = new LinkedList();
                if (this.isRootVisible) {
                    BreadcrumbItem<Object> rootItem = new BreadcrumbItem<Object>(this.treeAdapter.toString(root), this.treeAdapter.getIconFactory(root), root);
                    bRoots.add(rootItem);
                } else {
                    for (int i = 0; i < this.treeModel.getChildCount(root); ++i) {
                        Object rootChild = this.treeModel.getChild(root, i);
                        BreadcrumbItem<Object> rootItem = new BreadcrumbItem<Object>(this.treeAdapter.toString(rootChild), this.treeAdapter.getIconFactory(rootChild), rootChild);
                        bRoots.add(rootItem);
                    }
                }
                return bRoots;
            }
            if (path.size() == 0) {
                return null;
            }
            Object lastInPath = path.get(path.size() - 1).getData();
            if (this.treeModel.isLeaf(lastInPath)) {
                return null;
            }
            LinkedList lResult = new LinkedList();
            for (int i = 0; i < this.treeModel.getChildCount(lastInPath); ++i) {
                Object child = this.treeModel.getChild(lastInPath, i);
                if (this.treeModel.isLeaf(child)) continue;
                BreadcrumbItem<Object> item = new BreadcrumbItem<Object>(this.treeAdapter.toString(child), this.treeAdapter.getIconFactory(child), child);
                lResult.add(item);
            }
            return lResult;
        }

        @Override
        public List<BreadcrumbItem<T>> getLeaves(List<BreadcrumbItem<T>> path) {
            Object lastInPath = path.get(path.size() - 1).getData();
            if (this.treeModel.isLeaf(lastInPath)) {
                return null;
            }
            LinkedList lResult = new LinkedList();
            for (int i = 0; i < this.treeModel.getChildCount(lastInPath); ++i) {
                Object child = this.treeModel.getChild(lastInPath, i);
                if (!this.treeModel.isLeaf(child)) continue;
                BreadcrumbItem<Object> item = new BreadcrumbItem<Object>(this.treeAdapter.toString(child), this.treeAdapter.getIconFactory(child), child);
                lResult.add(item);
            }
            return lResult;
        }

        @Override
        public InputStream getLeafContent(T leaf) {
            return null;
        }
    }

    public static interface TreeAdapter<T> {
        public String toString(T var1);

        default public RadianceIcon.Factory getIconFactory(T node) {
            return null;
        }
    }
}

