/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.bcb.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarContentModel;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarContentProvider;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarPresentationModel;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbItem;
import org.pushingpixels.radiance.component.api.bcb.JBreadcrumbBar;
import org.pushingpixels.radiance.component.internal.svg.ic_folder_open_black_24px;
import org.pushingpixels.radiance.component.internal.svg.ic_insert_drive_file_black_24px;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class BreadcrumbFileSelector
extends JBreadcrumbBar<File> {
    private IconProvider iconProvider;

    public BreadcrumbFileSelector() {
        this(FileSystemView.getFileSystemView(), new FixedIconProvider(), BreadcrumbBarPresentationModel.builder().setIconFilterStrategies(RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT, RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT, RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT).build());
    }

    public BreadcrumbFileSelector(FileSystemView fileSystemView, IconProvider iconProvider, BreadcrumbBarPresentationModel presentationModel) {
        super(null, presentationModel);
        this.contentModel = new BreadcrumbBarContentModel();
        this.iconProvider = iconProvider;
        this.contentProvider = new FileSystemContentProvider(fileSystemView);
        this.updateUI();
    }

    public void setPath(File dir) {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        if (dir == null || !dir.isDirectory()) {
            dir = fsv.getHomeDirectory();
        }
        ArrayList path = new ArrayList();
        File parent = dir;
        BreadcrumbItem<File> bci = new BreadcrumbItem<File>(fsv.getSystemDisplayName(dir), this.iconProvider.getIconFactory(dir), dir);
        path.add(bci);
        while ((parent = fsv.getParentDirectory(parent)) != null) {
            bci = new BreadcrumbItem<File>(fsv.getSystemDisplayName(parent), this.iconProvider.getIconFactory(parent), parent);
            path.add(bci);
        }
        Collections.reverse(path);
        this.setPath(path);
    }

    private class FileSystemContentProvider
    extends BreadcrumbBarContentProvider<File> {
        private final FileSystemView fsv;

        public FileSystemContentProvider() {
            this(FileSystemView.getFileSystemView());
        }

        public FileSystemContentProvider(FileSystemView fileSystemView) {
            this.fsv = fileSystemView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<BreadcrumbItem<File>> getPathChoices(List<BreadcrumbItem<File>> path) {
            FileSystemView fileSystemView = this.fsv;
            synchronized (fileSystemView) {
                if (path == null) {
                    LinkedList<BreadcrumbItem<File>> bRoots = new LinkedList<BreadcrumbItem<File>>();
                    for (File root : this.fsv.getRoots()) {
                        if (this.fsv.isHiddenFile(root)) continue;
                        String systemName = this.fsv.getSystemDisplayName(root);
                        if (systemName.length() == 0) {
                            systemName = root.getAbsolutePath();
                        }
                        BreadcrumbItem<File> rootItem = new BreadcrumbItem<File>(systemName, BreadcrumbFileSelector.this.iconProvider.getIconFactory(root), root);
                        bRoots.add(rootItem);
                    }
                    return bRoots;
                }
                if (path.size() == 0) {
                    return null;
                }
                File lastInPath = path.get(path.size() - 1).getData();
                if (!lastInPath.exists()) {
                    return new ArrayList<BreadcrumbItem<File>>();
                }
                if (!lastInPath.isDirectory()) {
                    return null;
                }
                LinkedList<BreadcrumbItem<File>> lResult = new LinkedList<BreadcrumbItem<File>>();
                for (File child : lastInPath.listFiles()) {
                    if (!child.isDirectory() || this.fsv.isHiddenFile(child)) continue;
                    String childFileName = this.fsv.getSystemDisplayName(child);
                    if (childFileName == null || childFileName.isEmpty()) {
                        childFileName = child.getName();
                    }
                    BreadcrumbItem<File> item = new BreadcrumbItem<File>(childFileName, BreadcrumbFileSelector.this.iconProvider.getIconFactory(child), child);
                    lResult.add(item);
                }
                lResult.sort(new Comparator<BreadcrumbItem<File>>(){

                    @Override
                    public int compare(BreadcrumbItem<File> o1, BreadcrumbItem<File> o2) {
                        String key1 = FileSystemContentProvider.this.fsv.isFileSystemRoot(o1.getData()) ? o1.getData().getAbsolutePath() : o1.getData().getName();
                        String key2 = FileSystemContentProvider.this.fsv.isFileSystemRoot(o2.getData()) ? o2.getData().getAbsolutePath() : o2.getData().getName();
                        return key1.toLowerCase().compareTo(key2.toLowerCase());
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return super.equals(obj);
                    }
                });
                return lResult;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<BreadcrumbItem<File>> getLeaves(List<BreadcrumbItem<File>> path) {
            FileSystemView fileSystemView = this.fsv;
            synchronized (fileSystemView) {
                if (path == null || path.size() == 0) {
                    return null;
                }
                File lastInPath = path.get(path.size() - 1).getData();
                if (!lastInPath.exists()) {
                    return new ArrayList<BreadcrumbItem<File>>();
                }
                if (!lastInPath.isDirectory()) {
                    return null;
                }
                LinkedList<BreadcrumbItem<File>> lResult = new LinkedList<BreadcrumbItem<File>>();
                for (File child : lastInPath.listFiles()) {
                    if (child.isDirectory() || this.fsv.isHiddenFile(child)) continue;
                    String childFileName = this.fsv.getSystemDisplayName(child);
                    if (childFileName == null || childFileName.isEmpty()) {
                        childFileName = child.getName();
                    }
                    BreadcrumbItem<File> item = new BreadcrumbItem<File>(childFileName, BreadcrumbFileSelector.this.iconProvider.getIconFactory(child), child);
                    lResult.add(item);
                }
                lResult.sort(new Comparator<BreadcrumbItem<File>>(){

                    @Override
                    public int compare(BreadcrumbItem<File> o1, BreadcrumbItem<File> o2) {
                        String key1 = FileSystemContentProvider.this.fsv.isFileSystemRoot(o1.getData()) ? o1.getData().getAbsolutePath() : o1.getData().getName();
                        String key2 = FileSystemContentProvider.this.fsv.isFileSystemRoot(o2.getData()) ? o2.getData().getAbsolutePath() : o2.getData().getName();
                        return key1.toLowerCase().compareTo(key2.toLowerCase());
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return super.equals(obj);
                    }
                });
                return lResult;
            }
        }

        @Override
        public InputStream getLeafContent(File leaf) {
            try {
                return new FileInputStream(leaf);
            }
            catch (FileNotFoundException fnfe) {
                return null;
            }
        }
    }

    public static class EmptyIconProvider
    implements IconProvider {
        @Override
        public RadianceIcon.Factory getIconFactory(File file) {
            return null;
        }
    }

    public static class FixedIconProvider
    implements IconProvider {
        @Override
        public RadianceIcon.Factory getIconFactory(File file) {
            if (file.isDirectory()) {
                return ic_folder_open_black_24px.factory();
            }
            return ic_insert_drive_file_black_24px.factory();
        }
    }

    public static interface IconProvider {
        public RadianceIcon.Factory getIconFactory(File var1);
    }
}

