/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.internal.font;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Locale;
import org.pushingpixels.radiance.common.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.radiance.common.internal.font.FontSets;

public final class Fonts {
    static final String WINDOWS_DEFAULT_GUI_FONT_KEY = "win.defaultGUI.font";
    static final String WINDOWS_ICON_FONT_KEY = "win.icon.font";

    private Fonts() {
    }

    public static Font getWindowsControlFont() {
        if (!LookUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException();
        }
        Font defaultGUIFont = Fonts.getDefaultGUIFont();
        if (LookUtils.IS_OS_WINDOWS_95 || LookUtils.IS_OS_WINDOWS_98 || LookUtils.IS_OS_WINDOWS_NT || LookUtils.IS_OS_WINDOWS_ME) {
            return defaultGUIFont;
        }
        Font iconFont = Fonts.getDesktopFont(WINDOWS_ICON_FONT_KEY);
        return Boolean.TRUE.equals(Fonts.canDisplayLocalizedText(iconFont, Locale.getDefault())) ? iconFont : defaultGUIFont;
    }

    private static Font getDefaultGUIFont() {
        Font font = Fonts.getDesktopFont(WINDOWS_DEFAULT_GUI_FONT_KEY);
        if (font != null) {
            return font;
        }
        return new FontSets.DefaultUIResourceFont("Dialog", 0, 12);
    }

    public static Boolean canDisplayLocalizedText(Font font, Locale locale) {
        if (Fonts.localeHasLocalizedDisplayLanguage(locale)) {
            return Fonts.canDisplayLocalizedDisplayLanguage(font, locale);
        }
        String fontName = font.getName();
        String language = locale.getLanguage();
        if ("Tahoma".equals(fontName)) {
            if ("hi".equals(language)) {
                return Boolean.FALSE;
            }
            if ("ja".equals(language)) {
                return Boolean.FALSE;
            }
            if ("ko".equals(language)) {
                return Boolean.FALSE;
            }
            if ("zh".equals(language)) {
                return Boolean.FALSE;
            }
        }
        if ("Microsoft Sans Serif".equals(fontName)) {
            if ("ja".equals(language)) {
                return Boolean.FALSE;
            }
            if ("ko".equals(language)) {
                return Boolean.FALSE;
            }
            if ("zh".equals(language)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static boolean canDisplayLocalizedDisplayLanguage(Font font, Locale locale) {
        String testString = locale.getDisplayLanguage(locale);
        int index = font.canDisplayUpTo(testString);
        return index == -1;
    }

    private static boolean localeHasLocalizedDisplayLanguage(Locale locale) {
        String localizedDisplayLanguage;
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return true;
        }
        String englishDisplayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
        return !englishDisplayLanguage.equals(localizedDisplayLanguage = locale.getDisplayLanguage(locale));
    }

    private static Font getDesktopFont(String fontName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Font font = (Font)toolkit.getDesktopProperty(fontName);
        return new FontSets.DefaultUIResourceFont(font.getFamily(), font.getStyle(), font.getSize());
    }
}

