/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.internal.contrib.flatlaf;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;

public class HiDPIUtils {
    public static void paintAtScale1x(Graphics2D g, JComponent c, RadianceCommonCortex.PainterScale1X painterScale1X) {
        HiDPIUtils.paintAtScale1x(g, 0, 0, c.getWidth(), c.getHeight(), painterScale1X);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAtScale1x(Graphics2D g, int x, int y, int width, int height, RadianceCommonCortex.PainterScale1X painterScale1X) {
        boolean rotated;
        AffineTransform t = g.getTransform();
        double scaleX = t.getScaleX();
        double scaleY = t.getScaleY();
        double shearX = t.getShearX();
        double shearY = t.getShearY();
        boolean bl = rotated = shearX != 0.0 || shearY != 0.0 || scaleX <= 0.0 || scaleY <= 0.0;
        if (rotated) {
            scaleX = Math.hypot(scaleX, shearX);
            scaleY = Math.hypot(scaleY, shearY);
        } else {
            scaleX = Math.abs(scaleX);
            scaleY = Math.abs(scaleY);
        }
        if (scaleX == 1.0 && scaleY == 1.0) {
            painterScale1X.paint(g, x, y, width, height, 1.0);
            return;
        }
        Rectangle2D.Double scaledRect = HiDPIUtils.scale(scaleX, scaleY, t, x, y, width, height);
        try {
            AffineTransform t1x;
            if (rotated) {
                t1x = new AffineTransform(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY(), Math.floor(scaledRect.x), Math.floor(scaledRect.y));
                t1x.scale(1.0 / scaleX, 1.0 / scaleY);
            } else {
                t1x = new AffineTransform(1.0, 0.0, 0.0, 1.0, Math.floor(scaledRect.x), Math.floor(scaledRect.y));
            }
            g.setTransform(t1x);
            int swidth = (int)scaledRect.width;
            int sheight = (int)scaledRect.height;
            painterScale1X.paint(g, 0, 0, swidth, sheight, scaleX);
        }
        finally {
            g.setTransform(t);
        }
    }

    private static Rectangle2D.Double scale(double scaleX, double scaleY, AffineTransform t, int x, int y, int width, int height) {
        double px = (double)x * scaleX + t.getTranslateX();
        double py = (double)y * scaleY + t.getTranslateY();
        double newX = HiDPIUtils.normalize(px);
        double newY = HiDPIUtils.normalize(py);
        double newWidth = HiDPIUtils.normalize(px + (double)width * scaleX) - newX;
        double newHeight = HiDPIUtils.normalize(py + (double)height * scaleY) - newY;
        return new Rectangle2D.Double(newX, newY, newWidth, newHeight);
    }

    private static double normalize(double value) {
        return Math.floor(value + 0.25) + 0.25;
    }
}

