/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.api.model;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pushingpixels.radiance.common.api.model.TriStateButtonModel;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionChangeEvent;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionChangeListener;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionCycler;

public class DefaultTriStateButtonModel
implements TriStateButtonModel {
    private boolean isEnabled = true;
    private boolean isRollover = false;
    private boolean isPressed = false;
    private TriStateButtonModel.SelectionState selectionState;
    private TriStateSelectionCycler selectionCycler;
    private EventListenerList listenerList = new EventListenerList();

    public DefaultTriStateButtonModel(TriStateSelectionCycler selectionCycler) {
        this.selectionState = TriStateButtonModel.SelectionState.OFF;
        this.selectionCycler = selectionCycler;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.isEnabled == isEnabled) {
            return;
        }
        this.isEnabled = isEnabled;
        this.isPressed = false;
        this.isRollover = false;
        this.fireStateChanged();
    }

    @Override
    public boolean isRollover() {
        return this.isRollover;
    }

    @Override
    public void setRollover(boolean isRollover) {
        if (!this.isEnabled || this.isRollover == isRollover) {
            return;
        }
        this.isRollover = isRollover;
        this.fireStateChanged();
    }

    @Override
    public boolean isPressed() {
        return this.isPressed;
    }

    @Override
    public void setPressed(boolean isPressed) {
        if (!this.isEnabled || this.isPressed == isPressed) {
            return;
        }
        if (!this.isPressed) {
            this.selectionState = this.selectionCycler.getNextSelectionState(this.selectionState);
            this.fireItemStateChanged(new TriStateSelectionChangeEvent(this, 701, this, this.selectionState));
        }
        this.isPressed = isPressed;
        if (!this.isPressed) {
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiersEx();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, null, EventQueue.getMostRecentEventTime(), modifiers));
        }
        this.fireStateChanged();
    }

    @Override
    public TriStateButtonModel.SelectionState getSelectionState() {
        return this.selectionState;
    }

    @Override
    public void setSelectionState(TriStateButtonModel.SelectionState selectionState) {
        if (this.selectionState == selectionState) {
            return;
        }
        this.selectionState = selectionState;
        this.fireItemStateChanged(new TriStateSelectionChangeEvent(this, 701, this, selectionState));
        this.fireStateChanged();
    }

    @Override
    public TriStateSelectionCycler getSelectionCycler() {
        return this.selectionCycler;
    }

    @Override
    public void setSelectionCycler(TriStateSelectionCycler selectionCycler) {
        if (this.selectionCycler != selectionCycler) {
            this.selectionCycler = selectionCycler;
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void fireActionPerformed(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void addSelectionChangeListener(TriStateSelectionChangeListener l) {
        this.listenerList.add(TriStateSelectionChangeListener.class, l);
    }

    @Override
    public void removeSelectionChangeListener(TriStateSelectionChangeListener l) {
        this.listenerList.remove(TriStateSelectionChangeListener.class, l);
    }

    private void fireItemStateChanged(TriStateSelectionChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TriStateSelectionChangeListener.class) continue;
            ((TriStateSelectionChangeListener)listeners[i + 1]).itemTriStateSelectionChanged(e);
        }
    }
}

