/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.internal.contrib.jgoodies.looks;

public final class LookUtils {
    private static final String OS_NAME = LookUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = LookUtils.getSystemProperty("os.version");
    public static final boolean IS_OS_MAC = LookUtils.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OS_WINDOWS = LookUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_95 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_98 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.1");
    public static final boolean IS_OS_WINDOWS_NT = LookUtils.startsWith(OS_NAME, "Windows NT");
    public static final boolean IS_OS_WINDOWS_ME = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "4.9");
    public static final boolean IS_OS_MAC_YOSEMITE = IS_OS_MAC && LookUtils.startsWith(OS_VERSION, "10.10");
    public static final boolean IS_OS_MAC_EL_CAPITAN_OR_LATER = IS_OS_MAC && (LookUtils.startsWith(OS_VERSION, "10.11") || LookUtils.startsWith(OS_VERSION, "10.12") || LookUtils.startsWith(OS_VERSION, "10.13") || LookUtils.startsWith(OS_VERSION, "10.14")) || LookUtils.startsWith(OS_VERSION, "10.15") || LookUtils.startsWith(OS_VERSION, "10.16");
    public static final boolean IS_OS_MAC_MOJAVE_OR_LATER = IS_OS_MAC && (LookUtils.startsWith(OS_VERSION, "10.14") || LookUtils.startsWith(OS_VERSION, "10.15") || LookUtils.startsWith(OS_VERSION, "10.16"));
    public static final boolean IS_OS_MAC_CATALINA_OR_LATER = IS_OS_MAC && (LookUtils.startsWith(OS_VERSION, "10.15") || LookUtils.startsWith(OS_VERSION, "10.16") || LookUtils.startsWith(OS_VERSION, "11.") || LookUtils.startsWith(OS_VERSION, "12."));

    private LookUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }
}

