/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.api.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.event.EventListenerList;
import org.pushingpixels.radiance.common.api.AsynchronousLoadListener;
import org.pushingpixels.radiance.common.api.AsynchronousLoading;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.filter.RadianceAbstractFilter;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;

public class ImageBackedFilterableRadianceIcon
implements RadianceIcon,
AsynchronousLoading {
    private RadianceIcon.Factory sourceFactory;
    private int width;
    private int height;
    private RadianceIcon currDelegate;
    private EventListenerList listenerList;
    private RadianceIcon.ColorFilter colorFilter;
    private BufferedImage currColorized;

    public ImageBackedFilterableRadianceIcon(RadianceIcon.Factory sourceFactory, RadianceIcon.ColorFilter colorFilter) {
        this.sourceFactory = sourceFactory;
        this.colorFilter = colorFilter;
        this.listenerList = new EventListenerList();
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
        this.currDelegate = this.sourceFactory.createNewIcon();
        if (this.currDelegate.supportsColorFilter()) {
            throw new IllegalStateException("Do not use this class for icons that support color filter directly");
        }
        this.currDelegate.setDimension(newDimension);
        final AsynchronousLoading async = (AsynchronousLoading)((Object)this.currDelegate);
        if (async.isLoading()) {
            this.currColorized = null;
            async.addAsynchronousLoadListener(new AsynchronousLoadListener(){

                @Override
                public void completed(boolean success) {
                    if (success) {
                        ImageBackedFilterableRadianceIcon.this.makeColorized();
                    }
                    async.removeAsynchronousLoadListener(this);
                    Object[] listeners = ImageBackedFilterableRadianceIcon.this.listenerList.getListenerList();
                    for (int i = listeners.length - 2; i >= 0; i -= 2) {
                        if (listeners[i] != AsynchronousLoadListener.class) continue;
                        ((AsynchronousLoadListener)listeners[i + 1]).completed(success);
                    }
                }
            });
        } else {
            this.makeColorized();
        }
    }

    @Override
    public boolean supportsColorFilter() {
        return true;
    }

    @Override
    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
        if (!this.isLoading()) {
            this.makeColorized();
        }
    }

    private void makeColorized() {
        BufferedImage flat = RadianceCommonCortex.getBlankScaledImage(RadianceCommonCortex.getScaleFactor(null), this.width, this.height);
        this.currDelegate.paintIcon(null, flat.getGraphics(), 0, 0);
        this.currColorized = new InternalColorFilter(this.colorFilter).filter(flat, null);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.currColorized != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            double scaleFactor = RadianceCommonCortex.getScaleFactor(c);
            RadianceCommonCortex.drawImageWithScale(g2d, scaleFactor, this.currColorized, 0, 0);
            g2d.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.add(AsynchronousLoadListener.class, l);
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.remove(AsynchronousLoadListener.class, l);
    }

    @Override
    public boolean isLoading() {
        return this.currDelegate != null && ((AsynchronousLoading)((Object)this.currColorized)).isLoading();
    }

    private class InternalColorFilter
    extends RadianceAbstractFilter {
        private RadianceIcon.ColorFilter colorFilter;

        public InternalColorFilter(RadianceIcon.ColorFilter colorFilter) {
            this.colorFilter = colorFilter;
        }

        @Override
        public BufferedImage filter(BufferedImage src, BufferedImage dst) {
            if (dst == null) {
                dst = this.createCompatibleDestImage(src, null);
            }
            int width = src.getWidth();
            int height = src.getHeight();
            int[] pixels = new int[width * height];
            this.getPixels(src, 0, 0, width, height, pixels);
            for (int i = 0; i < pixels.length; ++i) {
                int argb = pixels[i];
                int a = argb >>> 24 & 0xFF;
                int r = argb >>> 16 & 0xFF;
                int g = argb >>> 8 & 0xFF;
                int b = argb >>> 0 & 0xFF;
                Color filtered = this.colorFilter.filter(new Color(r, g, b, a));
                pixels[i] = a * filtered.getAlpha() / 256 << 24 | filtered.getRed() << 16 | filtered.getGreen() << 8 | filtered.getBlue();
            }
            this.setPixels(dst, 0, 0, width, height, pixels);
            return dst;
        }
    }
}

