/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.animation.api;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import org.pushingpixels.radiance.animation.api.RadianceAnimationCortex;
import org.pushingpixels.radiance.animation.api.interpolator.KeyFrames;
import org.pushingpixels.radiance.animation.api.interpolator.PropertyInterpolator;

public class TimelinePropertyBuilder<T> {
    private Object target;
    private final String propertyName;
    private T from;
    private Supplier<T> fromSupplier;
    private boolean isFromCurrent;
    private T to;
    private Supplier<T> toSupplier;
    private PropertyInterpolator<T> interpolator;
    private PropertyGetter<T> getter;
    private PropertySetter<T> setter;
    private KeyFrames<? extends T> keyFrames;

    TimelinePropertyBuilder(String propertyName) {
        this.propertyName = propertyName;
        this.isFromCurrent = false;
    }

    public TimelinePropertyBuilder<T> from(T startValue) {
        if (this.from != null) {
            throw new IllegalArgumentException("from() can only be called once");
        }
        if (this.isFromCurrent) {
            throw new IllegalArgumentException("from() cannot be called after fromCurrent()");
        }
        if (this.fromSupplier != null) {
            throw new IllegalArgumentException("from() cannot be called after fromSupplier()");
        }
        if (this.keyFrames != null) {
            throw new IllegalArgumentException("from() cannot be called after goingThrough()");
        }
        this.from = startValue;
        return this;
    }

    public TimelinePropertyBuilder<T> fromSupplier(Supplier<T> supplier) {
        if (this.fromSupplier != null) {
            throw new IllegalArgumentException("fromSupplier() can only be called once");
        }
        if (this.isFromCurrent) {
            throw new IllegalArgumentException("fromSupplier() cannot be called after fromCurrent()");
        }
        if (this.from != null) {
            throw new IllegalArgumentException("fromSupplier() cannot be called after from()");
        }
        if (this.keyFrames != null) {
            throw new IllegalArgumentException("fromSupplier() cannot be called after goingThrough()");
        }
        this.fromSupplier = supplier;
        return this;
    }

    public TimelinePropertyBuilder<T> fromCurrent() {
        if (this.isFromCurrent) {
            throw new IllegalArgumentException("fromCurrent() can only be called once");
        }
        if (this.from != null) {
            throw new IllegalArgumentException("fromCurrent() cannot be called after from()");
        }
        if (this.fromSupplier != null) {
            throw new IllegalArgumentException("fromCurrent() cannot be called after fromSupplier()");
        }
        if (this.keyFrames != null) {
            throw new IllegalArgumentException("fromCurrent() cannot be called after goingThrough()");
        }
        this.isFromCurrent = true;
        return this;
    }

    public TimelinePropertyBuilder<T> to(T endValue) {
        if (this.to != null) {
            throw new IllegalArgumentException("to() can only be called once");
        }
        if (this.toSupplier != null) {
            throw new IllegalArgumentException("to() cannot be called after toSupplier()");
        }
        if (this.keyFrames != null) {
            throw new IllegalArgumentException("to() cannot be called after goingThrough()");
        }
        this.to = endValue;
        return this;
    }

    public TimelinePropertyBuilder<T> toSupplier(Supplier<T> supplier) {
        if (this.toSupplier != null) {
            throw new IllegalArgumentException("toSupplier() can only be called once");
        }
        if (this.to != null) {
            throw new IllegalArgumentException("toSupplier() cannot be called after to()");
        }
        if (this.keyFrames != null) {
            throw new IllegalArgumentException("toSupplier() cannot be called after goingThrough()");
        }
        this.toSupplier = supplier;
        return this;
    }

    public TimelinePropertyBuilder<T> on(Object object) {
        this.target = object;
        return this;
    }

    public TimelinePropertyBuilder<T> interpolatedWith(PropertyInterpolator<T> pInterpolator) {
        if (this.interpolator != null) {
            throw new IllegalArgumentException("interpolatedWith() can only be called once");
        }
        this.interpolator = pInterpolator;
        return this;
    }

    public TimelinePropertyBuilder<T> setWith(PropertySetter<T> pSetter) {
        if (this.setter != null) {
            throw new IllegalArgumentException("setWith() can only be called once");
        }
        this.setter = pSetter;
        return this;
    }

    public TimelinePropertyBuilder<T> getWith(PropertyGetter<T> pGetter) {
        if (this.getter != null) {
            throw new IllegalArgumentException("getWith() can only be called once");
        }
        this.getter = pGetter;
        return this;
    }

    public TimelinePropertyBuilder<T> accessWith(PropertyAccessor<T> pAccessor) {
        if (this.setter != null || this.getter != null) {
            throw new IllegalArgumentException("accessWith() can only be called once");
        }
        this.setter = pAccessor;
        this.getter = pAccessor;
        return this;
    }

    public TimelinePropertyBuilder<T> goingThrough(KeyFrames<? extends T> keyFrames) {
        if (this.keyFrames != null) {
            throw new IllegalArgumentException("goingThrough() can only be called once");
        }
        if (this.isFromCurrent) {
            throw new IllegalArgumentException("goingThrough() cannot be called after fromCurrent()");
        }
        if (this.from != null) {
            throw new IllegalArgumentException("goingThrough() cannot be called after from()");
        }
        if (this.fromSupplier != null) {
            throw new IllegalArgumentException("goingThrough() cannot be called after fromSupplier()");
        }
        if (this.to != null) {
            throw new IllegalArgumentException("goingThrough() cannot be called after to()");
        }
        if (this.toSupplier != null) {
            throw new IllegalArgumentException("goingThrough() cannot be called after toSupplier()");
        }
        this.keyFrames = keyFrames;
        return this;
    }

    AbstractFieldInfo<T> getFieldInfo(Object mainObject) {
        if (this.target == null) {
            this.target = mainObject;
        }
        if (this.keyFrames != null) {
            return new KeyFramesFieldInfo<T>(this.target, this.propertyName, this.keyFrames, this.setter);
        }
        if (this.isFromCurrent) {
            if (this.interpolator == null) {
                this.interpolator = RadianceAnimationCortex.getPropertyInterpolator(Collections.singleton(this.to != null ? this.to : this.toSupplier.get()));
                if (this.interpolator == null) {
                    throw new IllegalArgumentException("No interpolator found for " + this.to.getClass().getName());
                }
            }
            return new GenericFieldInfoTo<T>(this.target, this.propertyName, this.to, this.toSupplier, this.interpolator, this.getter, this.setter);
        }
        if (this.interpolator == null) {
            this.interpolator = RadianceAnimationCortex.getPropertyInterpolator(Arrays.asList(this.from != null ? this.from : this.fromSupplier.get(), this.to != null ? this.to : this.toSupplier.get()));
            if (this.interpolator == null) {
                throw new IllegalArgumentException("No interpolator found for " + this.from.getClass().getName() + ":" + this.to.getClass().getName());
            }
        }
        return new GenericFieldInfo<T>(this.target, this.propertyName, this.from, this.fromSupplier, this.to, this.toSupplier, this.interpolator, this.setter);
    }

    private static <T> PropertyGetter<T> getPropertyGetter(Object obj, String fieldName, PropertyGetter<T> pGetter) {
        if (pGetter != null) {
            return pGetter;
        }
        return new DefaultPropertyGetter(obj, fieldName);
    }

    private static <T> PropertySetter<T> getPropertySetter(Object obj, String fieldName, PropertySetter<T> pSetter) {
        if (pSetter != null) {
            return pSetter;
        }
        return new DefaultPropertySetter(obj, fieldName);
    }

    private static Method getSetter(Object object, String propertyName) {
        String setterMethodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (Class<?> oClazz = object.getClass(); oClazz != null; oClazz = oClazz.getSuperclass()) {
            for (Method m : oClazz.getMethods()) {
                if (!setterMethodName.equals(m.getName()) || m.getParameterTypes().length != 1 || m.getReturnType() != Void.TYPE || Modifier.isStatic(m.getModifiers())) continue;
                return m;
            }
        }
        return null;
    }

    private static Method getGetter(Object object, String propertyName) {
        String getterMethodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (Class<?> oClazz = object.getClass(); oClazz != null; oClazz = oClazz.getSuperclass()) {
            for (Method m : oClazz.getMethods()) {
                if (!getterMethodName.equals(m.getName()) || m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers())) continue;
                return m;
            }
        }
        return null;
    }

    private static class KeyFramesFieldInfo<T>
    extends AbstractFieldInfo<T> {
        KeyFrames<? extends T> keyFrames;

        KeyFramesFieldInfo(Object obj, String fieldName, KeyFrames<? extends T> keyFrames, PropertySetter<T> propertySetter) {
            super(obj, fieldName, null, TimelinePropertyBuilder.getPropertySetter(obj, fieldName, propertySetter));
            this.keyFrames = keyFrames;
        }

        @Override
        void onStart() {
        }

        @Override
        void updateFrom() {
        }

        @Override
        void updateTo() {
        }

        @Override
        boolean isFromCurrent() {
            return false;
        }

        @Override
        void updateFieldValue(float timelinePosition) {
            if (this.setter != null) {
                try {
                    T value = this.keyFrames.getValue(timelinePosition);
                    this.setter.set(this.object, this.fieldName, value);
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    private static class GenericFieldInfo<T>
    extends AbstractFieldInfo<T> {
        private PropertyInterpolator<T> propertyInterpolator;

        GenericFieldInfo(Object obj, String fieldName, T from, Supplier<T> fromSupplier, T to, Supplier<T> toSupplier, PropertyInterpolator<T> propertyInterpolator, PropertySetter<T> propertySetter) {
            super(obj, fieldName, null, TimelinePropertyBuilder.getPropertySetter(obj, fieldName, propertySetter));
            this.propertyInterpolator = propertyInterpolator;
            this.setValues(from, fromSupplier, to, toSupplier);
        }

        @Override
        void onStart() {
            this.updateFrom();
            this.updateTo();
        }

        @Override
        void updateFrom() {
            if (this.fromSupplier != null) {
                this.from = this.fromSupplier.get();
            }
        }

        @Override
        void updateTo() {
            if (this.toSupplier != null) {
                this.to = this.toSupplier.get();
            }
        }

        @Override
        boolean isFromCurrent() {
            return false;
        }

        @Override
        void updateFieldValue(float timelinePosition) {
            try {
                Object value = this.propertyInterpolator.interpolate(this.from, this.to, timelinePosition);
                this.setter.set(this.object, this.fieldName, value);
            }
            catch (Throwable exc) {
                System.err.println("Exception occurred in updating field '" + this.fieldName + "' of object " + (this.object == null ? "[NONE]" : this.object.getClass().getCanonicalName()) + " at timeline position " + timelinePosition);
                exc.printStackTrace();
            }
        }
    }

    private static class GenericFieldInfoTo<T>
    extends AbstractFieldInfo<T> {
        private PropertyInterpolator<T> propertyInterpolator;

        GenericFieldInfoTo(Object obj, String fieldName, T to, Supplier<T> toSupplier, PropertyInterpolator<T> propertyInterpolator, PropertyGetter<T> propertyGetter, PropertySetter<T> propertySetter) {
            super(obj, fieldName, TimelinePropertyBuilder.getPropertyGetter(obj, fieldName, propertyGetter), TimelinePropertyBuilder.getPropertySetter(obj, fieldName, propertySetter));
            this.propertyInterpolator = propertyInterpolator;
            this.toSupplier = toSupplier;
            this.to = this.toSupplier == null ? to : this.toSupplier.get();
        }

        @Override
        void onStart() {
            this.from = this.getter.get(this.object, this.fieldName);
            this.updateTo();
        }

        @Override
        void updateFrom() {
        }

        @Override
        void updateTo() {
            if (this.toSupplier != null) {
                this.to = this.toSupplier.get();
            }
        }

        @Override
        boolean isFromCurrent() {
            return true;
        }

        @Override
        void updateFieldValue(float timelinePosition) {
            try {
                Object value = this.propertyInterpolator.interpolate(this.from, this.to, timelinePosition);
                this.setter.set(this.object, this.fieldName, value);
            }
            catch (Throwable exc) {
                System.err.println("Exception occurred in updating field '" + this.fieldName + "' of object " + (this.object == null ? "[NONE]" : this.object.getClass().getCanonicalName()) + " at timeline position " + timelinePosition);
                exc.printStackTrace();
            }
        }
    }

    static abstract class AbstractFieldInfo<F> {
        protected Object object;
        protected String fieldName;
        protected PropertyGetter<F> getter;
        protected PropertySetter<F> setter;
        protected F from;
        protected Supplier<F> fromSupplier;
        protected F to;
        protected Supplier<F> toSupplier;

        AbstractFieldInfo(Object obj, String fieldName, PropertyGetter<F> pGetter, PropertySetter<F> pSetter) {
            this.object = obj;
            this.fieldName = fieldName;
            this.getter = pGetter;
            this.setter = pSetter;
        }

        void setValues(F from, Supplier<F> fromSupplier, F to, Supplier<F> toSupplier) {
            this.fromSupplier = fromSupplier;
            this.from = this.fromSupplier == null ? from : this.fromSupplier.get();
            this.toSupplier = toSupplier;
            this.to = this.toSupplier == null ? to : this.toSupplier.get();
        }

        abstract void onStart();

        abstract void updateTo();

        abstract void updateFrom();

        abstract boolean isFromCurrent();

        abstract void updateFieldValue(float var1);
    }

    public static class DefaultPropertyGetter<T>
    implements PropertyGetter<T> {
        private Method getterMethod;

        public DefaultPropertyGetter(Object obj, String fieldName) {
            this.getterMethod = TimelinePropertyBuilder.getGetter(obj, fieldName);
        }

        @Override
        public T get(Object obj, String fieldName) {
            try {
                return (T)this.getterMethod.invoke(obj, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to get the value of the field '" + fieldName + "'", t);
            }
        }
    }

    public static class DefaultPropertySetter<T>
    implements PropertySetter<T> {
        private Method setterMethod;

        public DefaultPropertySetter(Object obj, String fieldName) {
            this.setterMethod = TimelinePropertyBuilder.getSetter(obj, fieldName);
        }

        @Override
        public void set(Object obj, String fieldName, T value) {
            try {
                this.setterMethod.invoke(obj, value);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to set the value of the field '" + fieldName + "'", t);
            }
        }
    }

    public static interface PropertyAccessor<T>
    extends PropertyGetter<T>,
    PropertySetter<T> {
    }

    @FunctionalInterface
    public static interface PropertyGetter<T> {
        public T get(Object var1, String var2);
    }

    @FunctionalInterface
    public static interface PropertySetter<T> {
        public void set(Object var1, String var2, T var3);
    }
}

