/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.tools.svgtranscoder.gradle;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.tools.svgtranscoder.SvgBatchBaseConverter;
import org.pushingpixels.aurora.tools.svgtranscoder.SvgTranscoder;
import org.pushingpixels.aurora.tools.svgtranscoder.TranscoderListener;
import org.pushingpixels.aurora.tools.svgtranscoder.gradle.TranscodeBaseTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0004\u00a8\u0006\f"}, d2={"Lorg/pushingpixels/aurora/tools/svgtranscoder/gradle/TranscodeBaseTask;", "Lorg/gradle/api/DefaultTask;", "()V", "transcodeAllFilesInFolder", "", "inputFolder", "Ljava/io/File;", "outputFolder", "outputClassNamePrefix", "", "outputPackageName", "templateFileName", "svg-transcoder-gradle-plugin"})
public abstract class TranscodeBaseTask
extends DefaultTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void transcodeAllFilesInFolder(@NotNull File inputFolder, @NotNull File outputFolder, @NotNull String outputClassNamePrefix, @NotNull String outputPackageName, @NotNull String templateFileName) {
        File[] svgFiles2;
        Intrinsics.checkNotNullParameter((Object)inputFolder, (String)"inputFolder");
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        Intrinsics.checkNotNullParameter((Object)outputClassNamePrefix, (String)"outputClassNamePrefix");
        Intrinsics.checkNotNullParameter((Object)outputPackageName, (String)"outputPackageName");
        Intrinsics.checkNotNullParameter((Object)templateFileName, (String)"templateFileName");
        File[] fileArray = inputFolder.listFiles(transcodeAllFilesInFolder.svgFiles.1.INSTANCE);
        if (fileArray == null) {
            return;
        }
        for (File file : svgFiles2 = fileArray) {
            void svgClassName;
            String string;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            StringBuilder stringBuilder = new StringBuilder().append(outputClassNamePrefix);
            Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"file.name");
            int n = 0;
            int n2 = file.getName().length() - 4;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            objectRef.element = stringBuilder.append(string3).toString();
            svgClassName.element = StringsKt.replace$default((String)((String)svgClassName.element), (char)'-', (char)'_', (boolean)false, (int)4, null);
            svgClassName.element = StringsKt.replace$default((String)((String)svgClassName.element), (char)' ', (char)'_', (boolean)false, (int)4, null);
            String classFilename = outputFolder.toString() + File.separator + (String)svgClassName.element + ".kt";
            this.getLogger().trace("Processing " + file.getName());
            try {
                Closeable closeable = new PrintWriter(classFilename);
                n2 = 0;
                bl = false;
                Throwable throwable = null;
                try {
                    boolean bl2;
                    PrintWriter writer = (PrintWriter)closeable;
                    boolean bl3 = false;
                    Closeable closeable2 = SvgBatchBaseConverter.class.getResourceAsStream(templateFileName);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStream templateStream = (InputStream)closeable2;
                        boolean bl6 = false;
                        if (templateStream == null) {
                            this.getLogger().error("Couldn't load " + templateFileName);
                            return;
                        }
                        CountDownLatch latch = new CountDownLatch(1);
                        String string4 = file.toURI().toURL().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.toURI().toURL().toString()");
                        SvgTranscoder transcoder = new SvgTranscoder(string4, (String)svgClassName.element);
                        transcoder.setPackageName(outputPackageName);
                        transcoder.setListener(new TranscoderListener(latch, writer, this, templateFileName, file, (Ref.ObjectRef)svgClassName, outputPackageName){
                            @NotNull
                            private final PrintWriter writer;
                            final /* synthetic */ CountDownLatch $latch;
                            final /* synthetic */ PrintWriter $writer$inlined;
                            final /* synthetic */ TranscodeBaseTask this$0;
                            final /* synthetic */ String $templateFileName$inlined;
                            final /* synthetic */ File $file$inlined;
                            final /* synthetic */ Ref.ObjectRef $svgClassName$inlined;
                            final /* synthetic */ String $outputPackageName$inlined;
                            {
                                this.$latch = $captured_local_variable$1;
                                this.$writer$inlined = printWriter;
                                this.this$0 = transcodeBaseTask;
                                this.$templateFileName$inlined = string;
                                this.$file$inlined = file;
                                this.$svgClassName$inlined = objectRef;
                                this.$outputPackageName$inlined = string2;
                                this.writer = this.$writer$inlined;
                            }

                            @NotNull
                            public PrintWriter getWriter() {
                                return this.writer;
                            }

                            public void finished() {
                                this.$latch.countDown();
                            }
                        });
                        transcoder.transcode(templateStream);
                        bl2 = latch.await(10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    boolean bl7 = bl2;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Transcoding failed", (Throwable)e);
            }
        }
    }
}

