/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.tools.svgtranscoder.gradle;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pushingpixels.aurora.tools.svgtranscoder.gradle.TranscodeBaseTask;
import org.pushingpixels.aurora.tools.svgtranscoder.gradle.TranscodeDeepTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0004J\b\u0010\u001c\u001a\u00020\u0017H\u0007R*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR*\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\n8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/pushingpixels/aurora/tools/svgtranscoder/gradle/TranscodeDeepTask;", "Lorg/pushingpixels/aurora/tools/svgtranscoder/gradle/TranscodeBaseTask;", "()V", "<set-?>", "Ljava/io/File;", "inputRootDirectory", "getInputRootDirectory", "()Ljava/io/File;", "setInputRootDirectory", "(Ljava/io/File;)V", "", "outputClassNamePrefix", "getOutputClassNamePrefix", "()Ljava/lang/String;", "setOutputClassNamePrefix", "(Ljava/lang/String;)V", "outputRootDirectory", "getOutputRootDirectory", "setOutputRootDirectory", "outputRootPackageName", "getOutputRootPackageName", "setOutputRootPackageName", "processFolder", "", "inputFolder", "outputFolder", "outputPackageName", "templateFile", "transcode", "svg-transcoder-gradle-plugin"})
public final class TranscodeDeepTask
extends TranscodeBaseTask {
    @Nullable
    private String outputRootPackageName;
    @NotNull
    private String outputClassNamePrefix = "";
    @Nullable
    private File inputRootDirectory;
    @Nullable
    private File outputRootDirectory;

    @Input
    @Nullable
    public final String getOutputRootPackageName() {
        return this.outputRootPackageName;
    }

    @Option(option="outputRootPackageName", description="Configures the output root package name.")
    public final void setOutputRootPackageName(@Nullable String string) {
        this.outputRootPackageName = string;
    }

    @Input
    @NotNull
    public final String getOutputClassNamePrefix() {
        return this.outputClassNamePrefix;
    }

    @Option(option="outputClassNamePrefix", description="Configures the output class name prefix.")
    public final void setOutputClassNamePrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputClassNamePrefix = string;
    }

    @InputDirectory
    @Nullable
    public final File getInputRootDirectory() {
        return this.inputRootDirectory;
    }

    @Option(option="inputRootDirectory", description="Configures the input root directory.")
    public final void setInputRootDirectory(@Nullable File file) {
        this.inputRootDirectory = file;
    }

    @InputDirectory
    @Nullable
    public final File getOutputRootDirectory() {
        return this.outputRootDirectory;
    }

    @Option(option="outputRootDirectory", description="Configures the output root directory.")
    public final void setOutputRootDirectory(@Nullable File file) {
        this.outputRootDirectory = file;
    }

    @TaskAction
    public final void transcode() {
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Logger logger2 = logger;
        StringBuilder stringBuilder = new StringBuilder().append("Working on files in ");
        File file = this.inputRootDirectory;
        Intrinsics.checkNotNull((Object)file);
        logger2.trace(stringBuilder.append(file.getAbsolutePath()).toString());
        File file2 = this.inputRootDirectory;
        Intrinsics.checkNotNull((Object)file2);
        if (!file2.exists()) {
            return;
        }
        File file3 = this.outputRootDirectory;
        Intrinsics.checkNotNull((Object)file3);
        file3.mkdirs();
        StringBuilder stringBuilder2 = new StringBuilder().append("Processing ");
        File file4 = this.inputRootDirectory;
        Intrinsics.checkNotNull((Object)file4);
        logger2.trace(stringBuilder2.append(file4.getAbsolutePath()).append(" to ").append(this.outputRootPackageName).toString());
        String templateFileName = "/org/pushingpixels/aurora/tools/svgtranscoder/SvgTranscoderTemplateResizable.templ";
        File file5 = this.inputRootDirectory;
        Intrinsics.checkNotNull((Object)file5);
        File file6 = this.outputRootDirectory;
        Intrinsics.checkNotNull((Object)file6);
        String string = this.outputRootPackageName;
        Intrinsics.checkNotNull((Object)string);
        this.processFolder(file5, file6, this.outputClassNamePrefix, string, templateFileName);
    }

    protected final void processFolder(@NotNull File inputFolder, @NotNull File outputFolder, @NotNull String outputClassNamePrefix, @NotNull String outputPackageName, @NotNull String templateFile) {
        Intrinsics.checkNotNullParameter((Object)inputFolder, (String)"inputFolder");
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        Intrinsics.checkNotNullParameter((Object)outputClassNamePrefix, (String)"outputClassNamePrefix");
        Intrinsics.checkNotNullParameter((Object)outputPackageName, (String)"outputPackageName");
        Intrinsics.checkNotNullParameter((Object)templateFile, (String)"templateFile");
        this.getLogger().trace("Working on files in " + inputFolder.getAbsolutePath());
        this.transcodeAllFilesInFolder(inputFolder, outputFolder, outputClassNamePrefix, outputPackageName, templateFile);
        File[] fileArray = inputFolder.listFiles(processFolder.1.INSTANCE);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File inputSubfolder;
            File file = inputSubfolder = fileArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"inputSubfolder");
            String subfolderName = file.getName();
            this.getLogger().trace("Going into sub-folder " + subfolderName);
            File outputSubfolder = new File(outputFolder, subfolderName);
            if (!outputSubfolder.exists()) {
                outputSubfolder.mkdir();
            }
            this.processFolder(inputSubfolder, outputSubfolder, outputClassNamePrefix, outputPackageName + '.' + subfolderName, templateFile);
        }
        this.getLogger().trace("");
    }
}

