/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.tools.svgtranscoder.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.apache.batik.bridge.SVGPatternElementBridge;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pushingpixels.aurora.tools.svgtranscoder.utils.McStableGraphics2D;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/pushingpixels/aurora/tools/svgtranscoder/utils/RasterScanner;", "", "printWriter", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;)V", "processedMD5s", "Ljava/util/HashSet;", "", "hasRasters", "", "scan", "", "gvtRoot", "Lorg/apache/batik/gvt/GraphicsNode;", "scanCompositeGraphicsNode", "node", "Lorg/apache/batik/gvt/CompositeGraphicsNode;", "scanCompositeShapePainter", "painter", "Lorg/apache/batik/gvt/CompositeShapePainter;", "scanFillShapePainter", "Lorg/apache/batik/gvt/FillShapePainter;", "scanGraphicsNode", "scanMarkerShapePainter", "Lorg/apache/batik/gvt/MarkerShapePainter;", "scanPaint", "paint", "Ljava/awt/Paint;", "scanPatternPaint", "Lorg/apache/batik/gvt/PatternPaint;", "scanRasterImageNode", "Lorg/apache/batik/gvt/RasterImageNode;", "scanShapeNode", "Lorg/apache/batik/gvt/ShapeNode;", "scanShapePainter", "Lorg/apache/batik/gvt/ShapePainter;", "scanStrokeShapePainter", "Lorg/apache/batik/gvt/StrokeShapePainter;", "transcodeRenderedImage", "image", "Ljava/awt/image/RenderedImage;", "Companion", "svg-transcoder"})
public final class RasterScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintWriter printWriter;
    @NotNull
    private final HashSet<String> processedMD5s;

    public RasterScanner(@NotNull PrintWriter printWriter) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        this.printWriter = printWriter;
        this.processedMD5s = new HashSet();
    }

    public final void scan(@NotNull GraphicsNode gvtRoot) {
        Intrinsics.checkNotNullParameter((Object)gvtRoot, (String)"gvtRoot");
        this.scanGraphicsNode(gvtRoot);
    }

    public final boolean hasRasters() {
        Collection collection = this.processedMD5s;
        boolean bl = false;
        return !collection.isEmpty();
    }

    private final void scanPatternPaint(PatternPaint paint) {
        GraphicsNode graphicsNode = paint.getGraphicsNode();
        if (graphicsNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.bridge.SVGPatternElementBridge.PatternGraphicsNode");
        }
        SVGPatternElementBridge.PatternGraphicsNode pgn = (SVGPatternElementBridge.PatternGraphicsNode)graphicsNode;
        pgn.primitivePaint((Graphics2D)new McStableGraphics2D(this){
            final /* synthetic */ RasterScanner this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean drawImage(@NotNull Image img, int x, int y, @NotNull ImageObserver observer) {
                Intrinsics.checkNotNullParameter((Object)img, (String)"img");
                Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                RasterScanner.access$transcodeRenderedImage(this.this$0, (RenderedImage)((Object)img));
                return false;
            }
        });
    }

    private final void scanPaint(Paint paint) throws UnsupportedOperationException {
        if (paint instanceof PatternPaint) {
            this.scanPatternPaint((PatternPaint)paint);
        }
    }

    private final void scanShapePainter(ShapePainter painter) throws UnsupportedOperationException {
        if (painter == null) {
            return;
        }
        if (painter instanceof CompositeShapePainter) {
            this.scanCompositeShapePainter((CompositeShapePainter)painter);
            return;
        }
        if (painter instanceof FillShapePainter) {
            this.scanFillShapePainter((FillShapePainter)painter);
            return;
        }
        if (painter instanceof StrokeShapePainter) {
            this.scanStrokeShapePainter((StrokeShapePainter)painter);
            return;
        }
        if (painter instanceof MarkerShapePainter) {
            this.scanMarkerShapePainter((MarkerShapePainter)painter);
            return;
        }
        throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(painter.getClass()).getSimpleName());
    }

    private final void scanCompositeShapePainter(CompositeShapePainter painter) {
        int n = 0;
        int n2 = painter.getShapePainterCount();
        if (n < n2) {
            do {
                int i = n++;
                this.scanShapePainter(painter.getShapePainter(i));
            } while (n < n2);
        }
    }

    private final void scanFillShapePainter(FillShapePainter painter) {
        Paint paint = painter.getPaint();
        if (paint == null) {
            return;
        }
        Paint paint2 = paint;
        this.scanPaint(paint2);
    }

    private final void scanStrokeShapePainter(StrokeShapePainter painter) {
        Paint paint = painter.getPaint();
        if (paint == null) {
            return;
        }
        Paint paint2 = paint;
        this.scanPaint(paint2);
    }

    private final void scanMarkerShapePainter(MarkerShapePainter painter) {
        Marker end;
        Marker middle;
        Marker start = painter.getStartMarker();
        if (start != null) {
            GraphicsNode graphicsNode = start.getMarkerNode();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsNode, (String)"start.markerNode");
            this.scanGraphicsNode(graphicsNode);
        }
        if ((middle = painter.getMiddleMarker()) != null) {
            GraphicsNode graphicsNode = middle.getMarkerNode();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsNode, (String)"middle.markerNode");
            this.scanGraphicsNode(graphicsNode);
        }
        if ((end = painter.getEndMarker()) != null) {
            GraphicsNode graphicsNode = end.getMarkerNode();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsNode, (String)"end.markerNode");
            this.scanGraphicsNode(graphicsNode);
        }
    }

    private final void scanShapeNode(ShapeNode node) {
        ShapePainter shapePainter = node.getShapePainter();
        Intrinsics.checkNotNullExpressionValue((Object)shapePainter, (String)"node.shapePainter");
        ShapePainter sPainter = shapePainter;
        this.scanShapePainter(sPainter);
    }

    private final void scanCompositeGraphicsNode(CompositeGraphicsNode node) {
        for (Object obj : node.getChildren()) {
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.gvt.GraphicsNode");
            }
            this.scanGraphicsNode((GraphicsNode)obj);
        }
    }

    private final void transcodeRenderedImage(RenderedImage image) {
        String md5 = Companion.getMD5(image);
        if (this.processedMD5s.contains(md5)) {
            return;
        }
        this.printWriter.println("private lateinit var image" + md5 + ": WeakReference<ImageBitmap>");
        this.printWriter.println("private fun getImage" + md5 + "(): ImageBitmap? {");
        this.printWriter.println("    if (::image" + md5 + ".isInitialized) {");
        this.printWriter.println("        val result = image" + md5 + ".get()");
        this.printWriter.println("        if (result != null) {");
        this.printWriter.println("            return result");
        this.printWriter.println("        }");
        this.printWriter.println("    }");
        String encoded = RasterScanner.Companion.convertToBase64String(image);
        this.printWriter.println("    val imageData = StringBuilder(" + encoded.length() + ')');
        int imageDataStart = 0;
        do {
            int chunkLength = RangesKt.coerceAtMost((int)1000, (int)(encoded.length() - imageDataStart));
            StringBuilder stringBuilder = new StringBuilder().append("    imageData.append(\"");
            String string = encoded;
            int n = imageDataStart + chunkLength;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(imageDataStart, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.printWriter.println(stringBuilder.append(string3).append("\")").toString());
        } while ((imageDataStart += 1000) <= encoded.length());
        this.printWriter.println("    val data = org.jetbrains.skia.Data.makeFromBytes(Base64.getDecoder().decode(imageData.toString()))");
        this.printWriter.println("    val codec = org.jetbrains.skia.Codec.makeFromData(data)");
        this.printWriter.println("    val pixels = codec.readPixels()");
        this.printWriter.println("    val result = pixels.asImageBitmap()");
        this.printWriter.println("    image" + md5 + " = WeakReference(result)");
        this.printWriter.println("    return result");
        this.printWriter.println("}");
        this.processedMD5s.add(md5);
    }

    private final void scanRasterImageNode(RasterImageNode node) {
        RenderedImage renderedImage = node.getImage().createDefaultRendering();
        Intrinsics.checkNotNullExpressionValue((Object)renderedImage, (String)"node.image.createDefaultRendering()");
        RenderedImage image = renderedImage;
        this.transcodeRenderedImage(image);
    }

    private final void scanGraphicsNode(GraphicsNode node) throws UnsupportedOperationException {
        if (node instanceof ShapeNode) {
            this.scanShapeNode((ShapeNode)node);
            return;
        }
        if (node instanceof CompositeGraphicsNode) {
            this.scanCompositeGraphicsNode((CompositeGraphicsNode)node);
            return;
        }
        if (node instanceof RasterImageNode) {
            this.scanRasterImageNode((RasterImageNode)node);
            return;
        }
    }

    public static final /* synthetic */ void access$transcodeRenderedImage(RasterScanner $this, RenderedImage image) {
        $this.transcodeRenderedImage(image);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lorg/pushingpixels/aurora/tools/svgtranscoder/utils/RasterScanner$Companion;", "", "()V", "convertToBase64String", "", "renderedImage", "Ljava/awt/image/RenderedImage;", "getMD5", "svg-transcoder"})
    public static final class Companion {
        private Companion() {
        }

        private final String convertToBase64String(RenderedImage renderedImage) {
            String string;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write(renderedImage, "png", Base64.getEncoder().wrap(os));
                string = os.toString(StandardCharsets.ISO_8859_1.name());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                val os\u20269_1.name())\n            }");
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            return string;
        }

        @NotNull
        public final String getMD5(@Nullable RenderedImage renderedImage) {
            String string;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write(renderedImage, "png", Base64.getEncoder().wrap(os));
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"MD5\")");
                MessageDigest md5Digest = messageDigest;
                md5Digest.update(os.toByteArray());
                byte[] byArray = md5Digest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md5Digest.digest()");
                byte[] digest = byArray;
                StringBuilder result = new StringBuilder();
                int n = 0;
                int n2 = digest.length + -1;
                if (n <= n2) {
                    do {
                        String string2;
                        int i = n++;
                        int n3 = (digest[i] & 0xFF) + 256;
                        int n4 = 16;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)Integer.toString(n3, CharsKt.checkRadix((int)n4)), (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                        n4 = 1;
                        bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n4);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        result.append(string4);
                    } while (n <= n2);
                }
                string = result.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                val os\u2026.toString()\n            }");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

