/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.tools.svgtranscoder;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pushingpixels.aurora.tools.svgtranscoder.SvgBaseTranscoder;
import org.w3c.dom.Document;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/pushingpixels/aurora/tools/svgtranscoder/SvgTranscoder;", "Lorg/pushingpixels/aurora/tools/svgtranscoder/SvgBaseTranscoder;", "uri", "", "classname", "(Ljava/lang/String;Ljava/lang/String;)V", "transcode", "Lorg/w3c/dom/Document;", "templateStream", "Ljava/io/InputStream;", "svg-transcoder"})
@StabilityInferred(parameters=0)
public final class SvgTranscoder
extends SvgBaseTranscoder {
    @NotNull
    private final String uri;
    public static final int $stable;

    public SvgTranscoder(@NotNull String uri, @NotNull String classname) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
        super(classname);
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Document transcode(@NotNull InputStream templateStream) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)templateStream, (String)"templateStream");
        if (this.get_listener() == null) {
            return null;
        }
        UserAgentAdapter ua = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)ua);
        BridgeContext batikBridgeContext = new BridgeContext((UserAgent)ua, loader);
        batikBridgeContext.setDynamicState(2);
        ua.setBridgeContext(batikBridgeContext);
        GVTBuilder builder = new GVTBuilder();
        Document svgDoc = null;
        try {
            document = loader.loadDocument(this.uri);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"loader.loadDocument(uri)");
            svgDoc = document;
            GraphicsNode gvtRoot = builder.build(batikBridgeContext, svgDoc);
            Intrinsics.checkNotNullExpressionValue((Object)gvtRoot, (String)"gvtRoot");
            this.transcode(gvtRoot, templateStream);
            document = svgDoc;
        }
        catch (IOException ex) {
            Logger.getLogger(SvgTranscoder.class.getName()).log(Level.SEVERE, null, ex);
            document = null;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(SvgTranscoder.class.getName()).log(Level.SEVERE, null, ex);
            document = null;
        }
        finally {
            try {
                loader.dispose();
                batikBridgeContext.dispose();
            }
            catch (Throwable t) {
                Logger.getLogger(SvgTranscoder.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return document;
    }
}

