/*
 * Copyright 2020-2021 Aurora, Kirill Grouchnikov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.pushingpixels.aurora.theming.colorscheme

import androidx.compose.ui.graphics.Color

class AquaColorScheme : BaseLightColorScheme("Aqua") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(194, 224, 237)
    override val extraLightColor = Color(164, 227, 243)
    override val lightColor = Color(112, 206, 239)
    override val midColor = Color(32, 180, 226)
    override val darkColor = Color(44, 47, 140)
    override val ultraDarkColor = Color(30, 40, 100)
}

class BarbyPinkColorScheme : BaseLightColorScheme("Barby Pink") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(240, 159, 242)
    override val extraLightColor = Color(239, 153, 235)
    override val lightColor = Color(238, 139, 230)
    override val midColor = Color(231, 95, 193)
    override val darkColor = Color(150, 30, 101)
    override val ultraDarkColor = Color(111, 29, 78)
}

class BottleGreenColorScheme : BaseLightColorScheme("Bottle Green") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(145, 209, 131)
    override val extraLightColor = Color(115, 197, 99)
    override val lightColor = Color(63, 181, 59)
    override val midColor = Color(6, 139, 58)
    override val darkColor = Color(11, 75, 38)
    override val ultraDarkColor = Color(0, 14, 14)
}

class BrownColorScheme : BaseLightColorScheme("Brown") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(240, 230, 170)
    override val extraLightColor = Color(230, 219, 142)
    override val lightColor = Color(217, 179, 89)
    override val midColor = Color(190, 137, 27)
    override val darkColor = Color(162, 90, 26)
    override val ultraDarkColor = Color(94, 71, 57)
}

class CremeColorScheme : BaseLightColorScheme("Creme") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(254, 254, 252)
    override val extraLightColor = Color(238, 243, 230)
    override val lightColor = Color(235, 234, 225)
    override val midColor = Color(227, 228, 219)
    override val darkColor = Color(179, 182, 176)
    override val ultraDarkColor = Color(178, 168, 153)
}

class DesertSandColorScheme : BaseLightColorScheme("Desert Sand") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(204, 226, 135)
    override val extraLightColor = Color(187, 204, 170)
    override val lightColor = Color(182, 200, 119)
    override val midColor = Color(147, 157, 105)
    override val darkColor = Color(113, 120, 81)
    override val ultraDarkColor = Color(80, 96, 48)
}

class LightAquaColorScheme : BaseLightColorScheme("Light Aqua") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(215, 238, 250)
    override val extraLightColor = Color(194, 224, 237)
    override val lightColor = Color(164, 227, 243)
    override val midColor = Color(112, 206, 239)
    override val darkColor = Color(32, 180, 226)
    override val ultraDarkColor = Color(44, 47, 140)
}

class LightGrayColorScheme : BaseLightColorScheme("Light Gray") {
    override val foregroundColor = Color(120, 125, 130)
    override val ultraLightColor = Color(250, 251, 252)
    override val extraLightColor = Color(240, 242, 244)
    override val lightColor = Color(225, 228, 231)
    override val midColor = Color(210, 214, 218)
    override val darkColor = Color(180, 185, 190)
    override val ultraDarkColor = Color(100, 106, 112)
}

class LimeGreenColorScheme : BaseLightColorScheme("Lime Green") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(205, 255, 85)
    override val extraLightColor = Color(172, 255, 54)
    override val lightColor = Color(169, 248, 57)
    override val midColor = Color(117, 232, 39)
    override val darkColor = Color(18, 86, 0)
    override val ultraDarkColor = Color(8, 62, 0)
}

class MetallicColorScheme : BaseLightColorScheme("Metallic") {
    override val foregroundColor = Color(15, 20, 25)
    override val ultraLightColor = Color(250, 252, 255)
    override val extraLightColor = Color(240, 245, 250)
    override val lightColor = Color(200, 210, 220)
    override val midColor = Color(180, 185, 190)
    override val darkColor = Color(80, 85, 90)
    override val ultraDarkColor = Color(32, 37, 42)
}

class OliveColorScheme : BaseLightColorScheme("Olive") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(205, 212, 182)
    override val extraLightColor = Color(189, 192, 165)
    override val lightColor = Color(175, 183, 142)
    override val midColor = Color(165, 174, 129)
    override val darkColor = Color(135, 142, 102)
    override val ultraDarkColor = Color(104, 111, 67)
}

class OrangeColorScheme : BaseLightColorScheme("Orange") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(255, 250, 235)
    override val extraLightColor = Color(255, 220, 180)
    override val lightColor = Color(245, 200, 128)
    override val midColor = Color(240, 170, 50)
    override val darkColor = Color(229, 151, 0)
    override val ultraDarkColor = Color(180, 100, 0)
}

class PurpleColorScheme : BaseLightColorScheme("Purple") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(240, 220, 245)
    override val extraLightColor = Color(218, 209, 233)
    override val lightColor = Color(203, 175, 237)
    override val midColor = Color(201, 135, 226)
    override val darkColor = Color(140, 72, 170)
    override val ultraDarkColor = Color(94, 39, 114)
}

class RaspberryColorScheme : BaseLightColorScheme("Raspberry") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(254, 166, 189)
    override val extraLightColor = Color(255, 152, 177)
    override val lightColor = Color(251, 110, 144)
    override val midColor = Color(225, 52, 98)
    override val darkColor = Color(84, 28, 41)
    override val ultraDarkColor = Color(40, 0, 9)
}

class SepiaColorScheme : BaseLightColorScheme("Sepia") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(220, 182, 150)
    override val extraLightColor = Color(205, 168, 135)
    override val lightColor = Color(195, 153, 128)
    override val midColor = Color(187, 151, 102)
    override val darkColor = Color(157, 102, 72)
    override val ultraDarkColor = Color(154, 106, 84)
}

class SteelBlueColorScheme : BaseLightColorScheme("Steel Blue") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(149, 193, 219)
    override val extraLightColor = Color(130, 181, 212)
    override val lightColor = Color(118, 165, 195)
    override val midColor = Color(108, 149, 178)
    override val darkColor = Color(38, 79, 111)
    override val ultraDarkColor = Color(47, 75, 99)
}

class SunfireRedColorScheme : BaseLightColorScheme("Sunfire Red") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(225, 139, 166)
    override val extraLightColor = Color(218, 110, 130)
    override val lightColor = Color(215, 42, 23)
    override val midColor = Color(224, 20, 10)
    override val darkColor = Color(170, 28, 23)
    override val ultraDarkColor = Color(129, 23, 15)
}

class SunsetColorScheme : BaseLightColorScheme("Sunset") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(255, 142, 48)
    override val extraLightColor = Color(255, 134, 44)
    override val lightColor = Color(255, 120, 41)
    override val midColor = Color(254, 97, 30)
    override val darkColor = Color(197, 19, 55)
    override val ultraDarkColor = Color(115, 38, 80)
}

class SunGlareColorScheme : BaseLightColorScheme("Sun Glare") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(255, 255, 209)
    override val extraLightColor = Color(248, 249, 160)
    override val lightColor = Color(255, 255, 80)
    override val midColor = Color(252, 226, 55)
    override val darkColor = Color(106, 29, 0)
    override val ultraDarkColor = Color(67, 18, 0)
}

class TerracottaColorScheme : BaseLightColorScheme("Terracotta") {
    override val foregroundColor = Color(0, 0, 0)
    override val ultraLightColor = Color(250, 203, 125)
    override val extraLightColor = Color(248, 191, 114)
    override val lightColor = Color(239, 176, 105)
    override val midColor = Color(227, 147, 88)
    override val darkColor = Color(195, 113, 63)
    override val ultraDarkColor = Color(163, 87, 64)
}

class CharcoalColorScheme : BaseDarkColorScheme("Charcoal") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(110, 21, 27)
    override val extraLightColor = Color(94, 27, 36)
    override val lightColor = Color(61, 19, 29)
    override val midColor = Color(50, 20, 22)
    override val darkColor = Color(35, 15, 10)
    override val ultraDarkColor = Color(13, 8, 4)
}

class EbonyColorScheme : BaseDarkColorScheme("Ebony") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(85, 85, 85)
    override val extraLightColor = Color(75, 75, 75)
    override val lightColor = Color(60, 60, 60)
    override val midColor = Color(40, 40, 40)
    override val darkColor = Color(20, 20, 20)
    override val ultraDarkColor = Color(10, 10, 10)
}

class DarkGrayColorScheme : BaseDarkColorScheme("Dark Gray") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(155, 155, 155)
    override val extraLightColor = Color(75, 75, 75)
    override val lightColor = Color(45, 45, 45)
    override val midColor = Color(30, 30, 30)
    override val darkColor = Color(15, 15, 15)
    override val ultraDarkColor = Color(5, 5, 5)
}

class DarkMetallicColorScheme : BaseDarkColorScheme("Dark Metallic") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(100, 90, 85)
    override val extraLightColor = Color(90, 85, 80)
    override val lightColor = Color(75, 70, 65)
    override val midColor = Color(55, 45, 35)
    override val darkColor = Color(15, 10, 5)
    override val ultraDarkColor = Color(5, 3, 0)
}

class DarkVioletColorScheme : BaseDarkColorScheme("Dark Violet") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(107, 22, 124)
    override val extraLightColor = Color(89, 19, 113)
    override val lightColor = Color(83, 17, 104)
    override val midColor = Color(53, 6, 31)
    override val darkColor = Color(33, 1, 38)
    override val ultraDarkColor = Color(15, 1, 23)
}

class JadeForestColorScheme : BaseDarkColorScheme("Jade Forest") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(40, 124, 22)
    override val extraLightColor = Color(45, 113, 19)
    override val lightColor = Color(39, 104, 17)
    override val midColor = Color(6, 53, 27)
    override val darkColor = Color(7, 38, 1)
    override val ultraDarkColor = Color(10, 23, 1)
}

class UltramarineColorScheme : BaseDarkColorScheme("Ultramarine") {
    override val foregroundColor = Color(255, 255, 255)
    override val ultraLightColor = Color(46, 22, 124)
    override val extraLightColor = Color(33, 19, 113)
    override val lightColor = Color(31, 17, 104)
    override val midColor = Color(47, 6, 53)
    override val darkColor = Color(11, 1, 38)
    override val ultraDarkColor = Color(2, 1, 23)
}
