/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.layout;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.component.layout.CommandButtonLayoutManager;
import org.pushingpixels.aurora.component.layout.CommandButtonSizingConstants;
import org.pushingpixels.aurora.component.model.Command;
import org.pushingpixels.aurora.component.model.CommandButtonKind;
import org.pushingpixels.aurora.component.model.CommandButtonPresentationModel;
import org.pushingpixels.aurora.component.model.HorizontalAlignment;
import org.pushingpixels.aurora.component.model.SeparatorSizingConstants;
import org.pushingpixels.aurora.component.model.TextClick;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00f8\u0001\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J0\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b&\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006("}, d2={"Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManagerTile;", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "_density", "Landroidx/compose/ui/unit/Density;", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "(Landroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/TextStyle;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "density", "", "getDensity", "()F", "fontScale", "getFontScale", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutInfo", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonLayoutInfo;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "command", "Lorg/pushingpixels/aurora/component/model/Command;", "presentationModel", "Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;", "preLayoutInfo", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;", "getLayoutInfo-jYbf7pk", "(JLorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;)Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonLayoutInfo;", "getPreLayoutInfo", "getPreferredIconSize", "Landroidx/compose/ui/unit/Dp;", "getPreferredIconSize-chRvn1I", "(Lorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;)F", "getPreferredSize", "Landroidx/compose/ui/geometry/Size;", "getPreferredSize-bSu-EZI", "(Lorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;)J", "component"})
public class CommandButtonLayoutManagerTile
implements CommandButtonLayoutManager {
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private final Density _density;
    @NotNull
    private final TextStyle textStyle;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    private final float density;
    private final float fontScale;

    public CommandButtonLayoutManagerTile(@NotNull LayoutDirection layoutDirection, @NotNull Density _density, @NotNull TextStyle textStyle, @NotNull FontFamily.Resolver fontFamilyResolver) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)_density, (String)"_density");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.layoutDirection = layoutDirection;
        this._density = _density;
        this.textStyle = textStyle;
        this.fontFamilyResolver = fontFamilyResolver;
        this.density = this._density.getDensity();
        this.fontScale = this._density.getFontScale();
    }

    @NotNull
    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public float getDensity() {
        return this.density;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    @Override
    public float getPreferredIconSize-chRvn1I(@NotNull Command command2, @NotNull CommandButtonPresentationModel presentationModel) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        int $this$dp$iv = 32;
        boolean $i$f$getDp = false;
        return Dp.constructor-impl((float)$this$dp$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getPreferredSize-bSu-EZI(@NotNull Command command2, @NotNull CommandButtonPresentationModel presentationModel, @NotNull CommandButtonLayoutManager.CommandButtonPreLayoutInfo preLayoutInfo) {
        void other$iv;
        void arg0$iv;
        void arg0$iv2;
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)preLayoutInfo, (String)"preLayoutInfo");
        PaddingValues paddingValues = presentationModel.getContentPadding();
        float f = paddingValues.calculateTopPadding-D9Ej5fM();
        float other$iv2 = paddingValues.calculateBottomPadding-D9Ej5fM();
        boolean bl = false;
        float by = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv2 + other$iv2)));
        String buttonText = command2.getText();
        String extraText = command2.getExtraText();
        float f2 = CommandButtonSizingConstants.INSTANCE.getDefaultHorizontalContentLayoutGap-D9Ej5fM();
        float f3 = presentationModel.getHorizontalGapScaleFactor();
        boolean bl2 = false;
        float layoutHGap = this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv * other$iv)));
        boolean hasIcon = command2.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon();
        boolean hasText = ((CharSequence)buttonText).length() > 0 | extraText != null;
        boolean hasPopupIcon = command2.getSecondaryContentModel() != null;
        float prefIconSize = this.toPx-0680j_4(this.getPreferredIconSize-chRvn1I(command2, presentationModel));
        float width = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        float textHeight = 0.0f;
        if (hasText) {
            FontFamily.Resolver resolver;
            Density density;
            long l;
            TextStyle textStyle;
            width += layoutHGap;
            float textWidth = 0.0f;
            if (((CharSequence)buttonText).length() > 0) {
                textStyle = this.textStyle;
                l = ConstraintsKt.Constraints$default((int)0, (int)Integer.MAX_VALUE, (int)0, (int)0, (int)13, null);
                density = this._density;
                resolver = this.fontFamilyResolver;
                Paragraph textParagraph = ParagraphKt.Paragraph-UdtVg6A$default((String)buttonText, (TextStyle)textStyle, (long)l, (Density)density, (FontFamily.Resolver)resolver, null, null, (int)1, (boolean)false, (int)352, null);
                textWidth = textParagraph.getMaxIntrinsicWidth();
                textHeight += textParagraph.getHeight();
            }
            if (extraText != null) {
                textStyle = this.textStyle;
                l = ConstraintsKt.Constraints$default((int)0, (int)Integer.MAX_VALUE, (int)0, (int)0, (int)13, null);
                density = this._density;
                resolver = this.fontFamilyResolver;
                Paragraph extraTextParagraph = ParagraphKt.Paragraph-UdtVg6A$default((String)extraText, (TextStyle)textStyle, (long)l, (Density)density, (FontFamily.Resolver)resolver, null, null, (int)1, (boolean)false, (int)352, null);
                textWidth = Math.max(textWidth, extraTextParagraph.getMaxIntrinsicWidth());
                textHeight += extraTextParagraph.getHeight();
            }
            width += (float)((int)textWidth);
            width += layoutHGap;
        }
        if (hasPopupIcon) {
            width += (float)2 * layoutHGap;
            width += 1.0f + this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
            width += (float)2 * layoutHGap;
        }
        if (preLayoutInfo.getCommandButtonKind().getHasAction() & preLayoutInfo.getCommandButtonKind().getHasPopup()) {
            width += this.toPx-0680j_4(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM());
        }
        width += presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateEndPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
        return SizeKt.Size((float)(width -= (float)2 * layoutHGap), (float)(by + Math.max(prefIconSize, textHeight)));
    }

    @Override
    @NotNull
    public CommandButtonLayoutManager.CommandButtonPreLayoutInfo getPreLayoutInfo(@NotNull Command command2, @NotNull CommandButtonPresentationModel presentationModel) {
        boolean hasPopup;
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        boolean hasAction = command2.getAction() != null;
        boolean bl = hasPopup = command2.getSecondaryContentModel() != null;
        CommandButtonKind commandButtonKind = hasAction && hasPopup ? (presentationModel.getTextClick() == TextClick.Action ? CommandButtonKind.ActionAndPopupMainAction : CommandButtonKind.ActionAndPopupMainPopup) : (hasPopup ? CommandButtonKind.PopupOnly : CommandButtonKind.ActionOnly);
        return new CommandButtonLayoutManager.CommandButtonPreLayoutInfo(commandButtonKind, command2.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon(), CollectionsKt.listOf((Object)command2.getText()), command2.getExtraText() != null ? CollectionsKt.listOf((Object)command2.getExtraText()) : CollectionsKt.emptyList(), hasAction | command2.isActionToggle() && presentationModel.getTextClick() == TextClick.Action, CommandButtonLayoutManager.CommandButtonSeparatorOrientation.Vertical, commandButtonKind.getHasPopup());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo-jYbf7pk(long constraints, @NotNull Command command2, @NotNull CommandButtonPresentationModel presentationModel, @NotNull CommandButtonLayoutManager.CommandButtonPreLayoutInfo preLayoutInfo) {
        void other$iv;
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)preLayoutInfo, (String)"preLayoutInfo");
        long preferredSize = this.getPreferredSize-bSu-EZI(command2, presentationModel, preLayoutInfo);
        String buttonText = command2.getText();
        String buttonExtraText = command2.getExtraText();
        float f = CommandButtonSizingConstants.INSTANCE.getDefaultHorizontalContentLayoutGap-D9Ej5fM();
        float f2 = presentationModel.getHorizontalGapScaleFactor();
        boolean bl = false;
        float layoutHGap = this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv * other$iv)));
        boolean hasIcon = command2.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon();
        boolean hasText = ((CharSequence)buttonText).length() > 0 | buttonExtraText != null;
        boolean hasPopup = command2.getSecondaryContentModel() != null;
        float iconSize = this.toPx-0680j_4(this.getPreferredIconSize-chRvn1I(command2, presentationModel));
        boolean ltr = this.getLayoutDirection() == LayoutDirection.Ltr;
        Rect iconRect = Rect.Companion.getZero();
        Rect popupActionRect = Rect.Companion.getZero();
        List textLayoutInfoList = new ArrayList();
        List extraTextLayoutInfoList = new ArrayList();
        float shiftX = 0.0f;
        float finalWidth = Size.getWidth-impl((long)preferredSize);
        float finalHeight = Size.getHeight-impl((long)preferredSize);
        if (Constraints.getHasFixedWidth-impl((long)constraints) && Constraints.getMaxWidth-impl((long)constraints) > 0 && (finalWidth = (float)Constraints.getMaxWidth-impl((long)constraints)) > Size.getWidth-impl((long)preferredSize)) {
            switch (WhenMappings.$EnumSwitchMapping$0[presentationModel.getHorizontalAlignment().ordinal()]) {
                case 1: {
                    if (ltr) break;
                    shiftX = finalWidth - Size.getWidth-impl((long)preferredSize);
                    break;
                }
                case 2: {
                    shiftX = (finalWidth - Size.getWidth-impl((long)preferredSize)) / (float)2;
                    break;
                }
                case 3: {
                    if (!ltr) break;
                    shiftX = finalWidth - Size.getWidth-impl((long)preferredSize);
                }
            }
        }
        if (finalWidth < this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM())) {
            shiftX += (this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM()) - finalWidth) / 2.0f;
            finalWidth = this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM());
        }
        if (Constraints.getHasFixedHeight-impl((long)constraints) && Constraints.getMaxHeight-impl((long)constraints) > 0) {
            finalHeight = Constraints.getMaxHeight-impl((long)constraints);
        }
        PaddingValues paddingValues = presentationModel.getContentPadding();
        Rect actionClickArea = Rect.Companion.getZero();
        Rect popupClickArea = Rect.Companion.getZero();
        Rect separatorArea = Rect.Companion.getZero();
        float verticalSeparatorWidth = this.toPx-0680j_4(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM());
        if (ltr) {
            float f3;
            float x = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection())) + shiftX - layoutHGap;
            if (hasIcon) {
                float f4 = x += layoutHGap;
                float f5 = x + iconSize;
                float f6 = (finalHeight - iconSize) / (float)2;
                float f7 = (finalHeight - iconSize) / (float)2 + iconSize;
                iconRect = new Rect(f4, f6, f5, f7);
                x += iconSize + layoutHGap;
            }
            float textHeight = 0.0f;
            if (hasText) {
                x += layoutHGap;
                boolean hasExtraText = buttonExtraText != null;
                String string = command2.getText();
                TextStyle textStyle = this.textStyle;
                long l = ConstraintsKt.Constraints$default((int)0, (int)Integer.MAX_VALUE, (int)0, (int)0, (int)13, null);
                Density density = this._density;
                FontFamily.Resolver resolver = this.fontFamilyResolver;
                Paragraph paragraph = ParagraphKt.Paragraph-UdtVg6A$default((String)string, (TextStyle)textStyle, (long)l, (Density)density, (FontFamily.Resolver)resolver, null, null, (int)1, (boolean)false, (int)352, null);
                textHeight = paragraph.getHeight();
                float f8 = x;
                float f9 = x + paragraph.getMaxIntrinsicWidth();
                f3 = (finalHeight - (float)(hasExtraText ? 2 : 1) * textHeight) / 2.0f;
                float f10 = (finalHeight - (float)(hasExtraText ? 2 : 1) * textHeight) / 2.0f + textHeight;
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo(command2.getText(), new Rect(f8, f3, f9, f10));
                textLayoutInfoList.add(lineLayoutInfo);
                if (command2.getExtraText() != null) {
                    String string2 = command2.getExtraText();
                    TextStyle textStyle2 = this.textStyle;
                    long l2 = ConstraintsKt.Constraints$default((int)0, (int)Integer.MAX_VALUE, (int)0, (int)0, (int)13, null);
                    Density density2 = this._density;
                    FontFamily.Resolver resolver2 = this.fontFamilyResolver;
                    Paragraph extraParagraph22 = ParagraphKt.Paragraph-UdtVg6A$default((String)string2, (TextStyle)textStyle2, (long)l2, (Density)density2, (FontFamily.Resolver)resolver2, null, null, (int)1, (boolean)false, (int)352, null);
                    f3 = x;
                    f10 = x + extraParagraph22.getMaxIntrinsicWidth();
                    float f11 = lineLayoutInfo.getTextRect().getBottom();
                    float f12 = lineLayoutInfo.getTextRect().getBottom() + textHeight;
                    CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo(command2.getExtraText(), new Rect(f3, f11, f10, f12));
                    extraTextLayoutInfoList.add(extraLineLayoutInfo);
                    x += Math.max(lineLayoutInfo.getTextRect().getWidth(), extraLineLayoutInfo.getTextRect().getWidth());
                } else {
                    x += lineLayoutInfo.getTextRect().getWidth();
                }
                x += layoutHGap;
            }
            if (hasPopup) {
                if (hasText && hasIcon) {
                    x += (float)2 * layoutHGap;
                }
                float popupIconWidth = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
                float popupIconHeight = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconHeight-D9Ej5fM());
                float lineLayoutInfo = x;
                float extraParagraph22 = x + (float)4 + popupIconWidth;
                float extraLineLayoutInfo = (finalHeight - popupIconHeight) / 2.0f - 1.0f;
                f3 = (finalHeight - popupIconHeight) / 2.0f + popupIconHeight + 1.0f;
                popupActionRect = new Rect(lineLayoutInfo, extraLineLayoutInfo, extraParagraph22, f3);
            }
            if (hasText || hasPopup) {
                float paddingEnd = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateEndPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
                if (hasPopup) {
                    if (popupActionRect.getRight() > finalWidth - paddingEnd) {
                        shiftX = popupActionRect.getRight() - (finalWidth - paddingEnd);
                        popupActionRect = popupActionRect.translate(-shiftX, 0.0f);
                        if (hasText) {
                            ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).setTextRect(new Rect(((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getLeft(), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getTop(), RangesKt.coerceAtMost((float)((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getRight(), (float)(popupActionRect.getLeft() - (float)2 * layoutHGap)), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getBottom()));
                        }
                        if (command2.getExtraText() != null) {
                            ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).setTextRect(new Rect(((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getLeft(), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getTop(), RangesKt.coerceAtMost((float)((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getRight(), (float)(popupActionRect.getLeft() - (float)2 * layoutHGap)), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getBottom()));
                        }
                    }
                } else {
                    ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).setTextRect(new Rect(((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getLeft(), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getTop(), RangesKt.coerceAtMost((float)((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getRight(), (float)(finalWidth - paddingEnd)), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getBottom()));
                    if (command2.getExtraText() != null) {
                        ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).setTextRect(new Rect(((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getLeft(), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getTop(), RangesKt.coerceAtMost((float)((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getRight(), (float)(finalWidth - paddingEnd)), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getBottom()));
                    }
                }
            }
            float xBorderBetweenActionAndPopup = 0.0f;
            switch (WhenMappings.$EnumSwitchMapping$1[preLayoutInfo.getCommandButtonKind().ordinal()]) {
                case 1: {
                    actionClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 2: {
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 3: {
                    if (hasText || hasIcon) {
                        popupActionRect = popupActionRect.translate(verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = popupActionRect.getLeft() - 2.0f * layoutHGap;
                        actionClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        popupClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        float extraParagraph22 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        float extraLineLayoutInfo = finalHeight;
                        separatorArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, extraParagraph22, extraLineLayoutInfo);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 4: {
                    if (hasIcon) {
                        for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : textLayoutInfoList) {
                            textLayoutInfo.setTextRect(textLayoutInfo.getTextRect().translate(verticalSeparatorWidth, 0.0f));
                        }
                        for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo222 : extraTextLayoutInfoList) {
                            extraTextLayoutInfo222.setTextRect(extraTextLayoutInfo222.getTextRect().translate(verticalSeparatorWidth, 0.0f));
                        }
                        popupActionRect = popupActionRect.translate(verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = iconRect.getLeft() + iconRect.getWidth() + layoutHGap;
                        actionClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        popupClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        float extraParagraph22 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        float extraTextLayoutInfo222 = finalHeight;
                        separatorArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, extraParagraph22, extraTextLayoutInfo222);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                }
            }
        } else {
            float f13;
            float textHeight;
            float x = finalWidth - presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection())) - shiftX + layoutHGap;
            if (hasIcon) {
                textHeight = (x -= layoutHGap) - iconSize;
                float xBorderBetweenActionAndPopup = x;
                float popupIconHeight = (finalHeight - iconSize) / (float)2;
                float lineLayoutInfo = (finalHeight - iconSize) / (float)2 + iconSize;
                iconRect = new Rect(textHeight, popupIconHeight, xBorderBetweenActionAndPopup, lineLayoutInfo);
                x -= iconSize + layoutHGap;
            }
            textHeight = 0.0f;
            if (hasText) {
                x -= layoutHGap;
                boolean hasExtraText = buttonExtraText != null;
                Object lineLayoutInfo = command2.getText();
                TextStyle extraParagraph22 = this.textStyle;
                long extraTextLayoutInfo222 = ConstraintsKt.Constraints$default((int)0, (int)Integer.MAX_VALUE, (int)0, (int)0, (int)13, null);
                Density density = this._density;
                FontFamily.Resolver resolver = this.fontFamilyResolver;
                Paragraph paragraph = ParagraphKt.Paragraph-UdtVg6A$default((String)lineLayoutInfo, (TextStyle)extraParagraph22, (long)extraTextLayoutInfo222, (Density)density, (FontFamily.Resolver)resolver, null, null, (int)1, (boolean)false, (int)352, null);
                textHeight = paragraph.getHeight();
                float extraParagraph22 = x - paragraph.getMaxIntrinsicWidth();
                float extraTextLayoutInfo222 = x;
                f13 = (finalHeight - (float)(hasExtraText ? 2 : 1) * textHeight) / 2.0f;
                float f14 = (finalHeight - (float)(hasExtraText ? 2 : 1) * textHeight) / 2.0f + textHeight;
                lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo(command2.getText(), new Rect(extraParagraph22, f13, extraTextLayoutInfo222, f14));
                textLayoutInfoList.add(lineLayoutInfo);
                if (command2.getExtraText() != null) {
                    String extraTextLayoutInfo222 = command2.getExtraText();
                    TextStyle textStyle = this.textStyle;
                    long l = ConstraintsKt.Constraints$default((int)0, (int)Integer.MAX_VALUE, (int)0, (int)0, (int)13, null);
                    Density density3 = this._density;
                    FontFamily.Resolver resolver3 = this.fontFamilyResolver;
                    Paragraph extraParagraph = ParagraphKt.Paragraph-UdtVg6A$default((String)extraTextLayoutInfo222, (TextStyle)textStyle, (long)l, (Density)density3, (FontFamily.Resolver)resolver3, null, null, (int)1, (boolean)false, (int)352, null);
                    f13 = x - extraParagraph.getMaxIntrinsicWidth();
                    f14 = x;
                    float f15 = ((CommandButtonLayoutManager.TextLayoutInfo)lineLayoutInfo).getTextRect().getBottom();
                    float f16 = ((CommandButtonLayoutManager.TextLayoutInfo)lineLayoutInfo).getTextRect().getBottom() + textHeight;
                    CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo(command2.getExtraText(), new Rect(f13, f15, f14, f16));
                    extraTextLayoutInfoList.add(extraLineLayoutInfo);
                    x -= Math.max(((CommandButtonLayoutManager.TextLayoutInfo)lineLayoutInfo).getTextRect().getWidth(), extraLineLayoutInfo.getTextRect().getWidth());
                } else {
                    x -= ((CommandButtonLayoutManager.TextLayoutInfo)lineLayoutInfo).getTextRect().getWidth();
                }
                x -= layoutHGap;
            }
            if (hasPopup) {
                if (hasText && hasIcon) {
                    x -= (float)2 * layoutHGap;
                }
                float popupIconWidth = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
                float popupIconHeight = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconHeight-D9Ej5fM());
                float f17 = x - (float)4 - popupIconWidth;
                float f18 = x;
                float extraLineLayoutInfo = (finalHeight - popupIconHeight) / 2.0f - 1.0f;
                f13 = (finalHeight - popupIconHeight) / 2.0f + popupIconHeight + 1.0f;
                popupActionRect = new Rect(f17, extraLineLayoutInfo, f18, f13);
            }
            if (hasText || hasPopup) {
                float paddingEnd = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateEndPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
                if (hasPopup) {
                    if (popupActionRect.getLeft() < paddingEnd) {
                        shiftX = paddingEnd - popupActionRect.getLeft();
                        popupActionRect = popupActionRect.translate(shiftX, 0.0f);
                        if (hasText) {
                            ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).setTextRect(new Rect(RangesKt.coerceAtLeast((float)((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getLeft(), (float)(popupActionRect.getRight() + (float)2 * layoutHGap)), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getTop(), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getRight(), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getBottom()));
                            if (command2.getExtraText() != null) {
                                ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).setTextRect(new Rect(RangesKt.coerceAtLeast((float)((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getLeft(), (float)(popupActionRect.getRight() + (float)2 * layoutHGap)), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getTop(), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getRight(), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getBottom()));
                            }
                        }
                    }
                } else {
                    ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).setTextRect(new Rect(RangesKt.coerceAtLeast((float)((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getLeft(), (float)paddingEnd), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getTop(), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getRight(), ((CommandButtonLayoutManager.TextLayoutInfo)textLayoutInfoList.get(0)).getTextRect().getBottom()));
                    if (command2.getExtraText() != null) {
                        ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).setTextRect(new Rect(RangesKt.coerceAtLeast((float)((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getLeft(), (float)paddingEnd), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getTop(), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getRight(), ((CommandButtonLayoutManager.TextLayoutInfo)extraTextLayoutInfoList.get(0)).getTextRect().getBottom()));
                    }
                }
            }
            float xBorderBetweenActionAndPopup = 0.0f;
            switch (WhenMappings.$EnumSwitchMapping$1[preLayoutInfo.getCommandButtonKind().ordinal()]) {
                case 1: {
                    actionClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 2: {
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 3: {
                    if (hasText || hasIcon) {
                        popupActionRect = popupActionRect.translate(-verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = popupActionRect.getRight() + 2.0f * layoutHGap;
                        actionClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        popupClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        float f19 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        float extraLineLayoutInfo = finalHeight;
                        separatorArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, f19, extraLineLayoutInfo);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 4: {
                    if (hasIcon) {
                        for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : textLayoutInfoList) {
                            textLayoutInfo.setTextRect(textLayoutInfo.getTextRect().translate(-verticalSeparatorWidth, 0.0f));
                        }
                        for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : extraTextLayoutInfoList) {
                            extraTextLayoutInfo.setTextRect(extraTextLayoutInfo.getTextRect().translate(-verticalSeparatorWidth, 0.0f));
                        }
                        popupActionRect = popupActionRect.translate(-verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = iconRect.getLeft() - layoutHGap;
                        actionClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        popupClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        float f20 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        float f21 = finalHeight;
                        separatorArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, f20, f21);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                }
            }
        }
        return new CommandButtonLayoutManager.CommandButtonLayoutInfo(SizeKt.Size((float)finalWidth, (float)finalHeight), actionClickArea, popupClickArea, separatorArea, iconRect, textLayoutInfoList, extraTextLayoutInfoList, popupActionRect, null);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalAlignment.values().length];
            try {
                nArray[HorizontalAlignment.Leading.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlignment.Center.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlignment.Trailing.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CommandButtonKind.values().length];
            try {
                nArray[CommandButtonKind.ActionOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandButtonKind.PopupOnly.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandButtonKind.ActionAndPopupMainAction.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandButtonKind.ActionAndPopupMainPopup.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

