/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.utils;

import androidx.compose.runtime.MutableState;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.common.AuroraInternalApi;
import org.pushingpixels.aurora.component.utils.ModelStateInfo;
import org.pushingpixels.aurora.component.utils.StateContributionInfo;
import org.pushingpixels.aurora.component.utils.TransitionInfo;
import org.pushingpixels.aurora.theming.ComponentState;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001aV\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"StateTransitionTracker", "", "modelStateInfo", "Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;", "currentState", "Landroidx/compose/runtime/MutableState;", "Lorg/pushingpixels/aurora/theming/ComponentState;", "transitionInfo", "Lorg/pushingpixels/aurora/component/utils/TransitionInfo;", "enabled", "", "selected", "rollover", "pressed", "duration", "", "component"})
public final class StateKt {
    @AuroraInternalApi
    public static final void StateTransitionTracker(@NotNull ModelStateInfo modelStateInfo, @NotNull MutableState<ComponentState> currentState, @NotNull MutableState<TransitionInfo> transitionInfo, boolean enabled, boolean selected, boolean rollover, boolean pressed, int duration) {
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter(currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter(transitionInfo, (String)"transitionInfo");
        ComponentState oldState = (ComponentState)currentState.getValue();
        currentState.setValue((Object)ComponentState.Companion.getState(enabled, rollover, selected, pressed));
        if (!Intrinsics.areEqual((Object)currentState.getValue(), (Object)oldState)) {
            int tweakedDuration = 0;
            float tweakedStart = 0.0f;
            if (modelStateInfo.getStateContributionMap().containsKey(currentState.getValue())) {
                StateContributionInfo stateContributionInfo = modelStateInfo.getStateContributionMap().get(currentState.getValue());
                Intrinsics.checkNotNull((Object)stateContributionInfo);
                float transitionPosition = stateContributionInfo.getContribution();
                tweakedDuration = (int)((float)duration * (1.0f - transitionPosition));
                tweakedStart = transitionPosition;
            } else {
                tweakedStart = 0.0f;
                tweakedDuration = duration;
            }
            Map newContributionMap = new HashMap();
            if (modelStateInfo.getStateContributionMap().containsKey(currentState.getValue())) {
                for (Map.Entry<ComponentState, StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                    ComponentState contribState = entry.getKey();
                    StateContributionInfo currRange = entry.getValue();
                    float newEnd = Intrinsics.areEqual((Object)contribState, (Object)currentState.getValue()) ? 1.0f : 0.0f;
                    newContributionMap.put(contribState, new StateContributionInfo(currRange.getContribution(), newEnd));
                }
            } else {
                for (Map.Entry<ComponentState, StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                    ComponentState contribState = entry.getKey();
                    StateContributionInfo currRange = entry.getValue();
                    newContributionMap.put(contribState, new StateContributionInfo(currRange.getContribution(), 0.0f));
                }
                newContributionMap.put(currentState.getValue(), new StateContributionInfo(0.0f, 1.0f));
            }
            modelStateInfo.setStateContributionMap(newContributionMap);
            modelStateInfo.sync();
            transitionInfo.setValue((Object)new TransitionInfo(tweakedStart, 1.0f, tweakedDuration));
        }
    }
}

