/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.utils;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.ComposablesKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.CompositionLocalContext;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.SkippableUpdater;
import androidx.compose.runtime.Updater;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.layout.LayoutKt;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.node.ComposeUiNode;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.platform.ViewConfiguration;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.unit.DpSize;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pushingpixels.aurora.common.AuroraPopupManager;
import org.pushingpixels.aurora.common.AuroraSwingPopupMenu;
import org.pushingpixels.aurora.component.model.HorizontalAlignment;
import org.pushingpixels.aurora.component.model.IconContentModel;
import org.pushingpixels.aurora.component.model.IconPresentationModel;
import org.pushingpixels.aurora.component.model.LabelContentModel;
import org.pushingpixels.aurora.component.model.LabelPresentationModel;
import org.pushingpixels.aurora.component.model.RichTooltip;
import org.pushingpixels.aurora.component.model.RichTooltipPresentationModel;
import org.pushingpixels.aurora.component.model.RichTooltipSizingConstants;
import org.pushingpixels.aurora.component.model.SeparatorPresentationModel;
import org.pushingpixels.aurora.component.model.SeparatorSizingConstants;
import org.pushingpixels.aurora.component.projection.HorizontalSeparatorProjection;
import org.pushingpixels.aurora.component.projection.IconProjection;
import org.pushingpixels.aurora.component.projection.LabelProjection;
import org.pushingpixels.aurora.component.utils.CommandMenuPopupContentKt;
import org.pushingpixels.aurora.component.utils.RichTooltipBackground;
import org.pushingpixels.aurora.component.utils.RichTooltipLayoutInfo;
import org.pushingpixels.aurora.theming.AuroraLocalsKt;
import org.pushingpixels.aurora.theming.AuroraPainters;
import org.pushingpixels.aurora.theming.AuroraSkin;
import org.pushingpixels.aurora.theming.AuroraSkinKt;
import org.pushingpixels.aurora.theming.ColorSchemeAssociationKind;
import org.pushingpixels.aurora.theming.ComponentState;
import org.pushingpixels.aurora.theming.DecorationAreaType;
import org.pushingpixels.aurora.theming.PopupPlacementStrategy;
import org.pushingpixels.aurora.theming.colorscheme.AuroraColorScheme;
import org.pushingpixels.aurora.theming.colorscheme.AuroraSkinColors;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0003\u00a2\u0006\u0002\u0010\u000e\u001a%\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003\u00a2\u0006\u0002\u0010\u0012\u001ap\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0000\u001a\u0011\u0010+\u001a\u00020,*\u00020,H\u0003\u00a2\u0006\u0002\u0010-\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006."}, d2={"hasDescriptionContent", "", "Lorg/pushingpixels/aurora/component/model/RichTooltip;", "getHasDescriptionContent", "(Lorg/pushingpixels/aurora/component/model/RichTooltip;)Z", "hasFooterContent", "getHasFooterContent", "hasFooterSections", "getHasFooterSections", "RichTooltipContent", "", "richTooltip", "richTooltipPresentationModel", "Lorg/pushingpixels/aurora/component/model/RichTooltipPresentationModel;", "(Lorg/pushingpixels/aurora/component/model/RichTooltip;Lorg/pushingpixels/aurora/component/model/RichTooltipPresentationModel;Landroidx/compose/runtime/Composer;I)V", "TopLevelRichTooltipContent", "tooltipLayoutInfo", "Lorg/pushingpixels/aurora/component/utils/RichTooltipLayoutInfo;", "(Lorg/pushingpixels/aurora/component/model/RichTooltip;Lorg/pushingpixels/aurora/component/model/RichTooltipPresentationModel;Lorg/pushingpixels/aurora/component/utils/RichTooltipLayoutInfo;Landroidx/compose/runtime/Composer;I)V", "displayRichTooltipContent", "popupOriginator", "Ljava/awt/Component;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "skinColors", "Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;", "skinPainters", "Lorg/pushingpixels/aurora/theming/AuroraPainters;", "decorationAreaType", "Lorg/pushingpixels/aurora/theming/DecorationAreaType;", "compositionLocalContext", "Landroidx/compose/runtime/CompositionLocalContext;", "anchorBoundsInWindow", "Landroidx/compose/ui/geometry/Rect;", "presentationModel", "popupPlacementStrategy", "Lorg/pushingpixels/aurora/theming/PopupPlacementStrategy;", "richTooltipBackground", "Landroidx/compose/ui/Modifier;", "(Landroidx/compose/ui/Modifier;Landroidx/compose/runtime/Composer;I)Landroidx/compose/ui/Modifier;", "component"})
public final class RichTooltipPopupContentKt {
    public static final boolean getHasDescriptionContent(@NotNull RichTooltip $this$hasDescriptionContent) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDescriptionContent, (String)"<this>");
        List<String> list = $this$hasDescriptionContent.getDescriptionSections();
        return list != null ? !((Collection)list).isEmpty() : false;
    }

    public static final boolean getHasFooterSections(@NotNull RichTooltip $this$hasFooterSections) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFooterSections, (String)"<this>");
        List<String> list = $this$hasFooterSections.getFooterSections();
        return list != null ? !((Collection)list).isEmpty() : false;
    }

    public static final boolean getHasFooterContent(@NotNull RichTooltip $this$hasFooterContent) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFooterContent, (String)"<this>");
        return $this$hasFooterContent.getFooterIcon() != null || RichTooltipPopupContentKt.getHasFooterSections($this$hasFooterContent);
    }

    /*
     * WARNING - void declaration
     */
    public static final void displayRichTooltipContent(@NotNull Component popupOriginator, @NotNull LayoutDirection layoutDirection, @NotNull Density density, @NotNull TextStyle textStyle, @NotNull FontFamily.Resolver fontFamilyResolver, @NotNull AuroraSkinColors skinColors, @NotNull AuroraPainters skinPainters, @NotNull DecorationAreaType decorationAreaType, @NotNull CompositionLocalContext compositionLocalContext, @NotNull Rect anchorBoundsInWindow, @NotNull RichTooltip richTooltip, @NotNull RichTooltipPresentationModel presentationModel, @NotNull PopupPlacementStrategy popupPlacementStrategy) {
        Rectangle rectangle;
        void other$iv;
        void arg0$iv;
        float other$iv2;
        void arg0$iv2;
        Intrinsics.checkNotNullParameter((Object)popupOriginator, (String)"popupOriginator");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        Intrinsics.checkNotNullParameter((Object)skinColors, (String)"skinColors");
        Intrinsics.checkNotNullParameter((Object)skinPainters, (String)"skinPainters");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)compositionLocalContext, (String)"compositionLocalContext");
        Intrinsics.checkNotNullParameter((Object)anchorBoundsInWindow, (String)"anchorBoundsInWindow");
        Intrinsics.checkNotNullParameter((Object)richTooltip, (String)"richTooltip");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)popupPlacementStrategy, (String)"popupPlacementStrategy");
        Point popupOriginatorLocationOnScreen = popupOriginator.getLocationOnScreen();
        int offset = (int)Math.ceil(density.getDensity());
        TextStyle boldTextStyle = TextStyleKt.resolveDefaults((TextStyle)new TextStyle(0L, textStyle.getFontSize-XSAIIZE(), FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 0L, null, 262137, null), (LayoutDirection)layoutDirection);
        float f = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateLeftPadding-u2uoSUM(layoutDirection);
        float f2 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateRightPadding-u2uoSUM(layoutDirection);
        boolean $i$f$plus-5rwHm252 = false;
        float horizontalPaddingPx = Dp.constructor-impl((float)(arg0$iv2 + other$iv2)) * density.getDensity();
        other$iv2 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateTopPadding-D9Ej5fM();
        float $i$f$plus-5rwHm252 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateBottomPadding-D9Ej5fM();
        boolean bl = false;
        float verticalPaddingPx = Dp.constructor-impl((float)(arg0$iv + other$iv)) * density.getDensity();
        int verticalGapPx = (int)(RichTooltipSizingConstants.INSTANCE.getVerticalContentLayoutGap-D9Ej5fM() * density.getDensity());
        int horizontalGapPx = (int)(RichTooltipSizingConstants.INSTANCE.getHorizontalContentLayoutGap-D9Ej5fM() * density.getDensity());
        float maxContentWidthPx = RichTooltipSizingConstants.INSTANCE.getMaxWidth-D9Ej5fM() * density.getDensity() - horizontalPaddingPx;
        Paragraph titleParagraph = ParagraphKt.Paragraph-UdtVg6A$default((String)richTooltip.getTitle(), (TextStyle)boldTextStyle, (long)ConstraintsKt.Constraints$default((int)0, (int)((int)maxContentWidthPx), (int)0, (int)0, (int)13, null), (Density)density, (FontFamily.Resolver)fontFamilyResolver, null, null, (int)0, (boolean)false, (int)480, null);
        float fullContentWidth = 0.0f;
        float fullContentHeight = titleParagraph.getHeight();
        float titleWidth = 0.0f;
        if (titleParagraph.getLineCount() > 1) {
            titleWidth = maxContentWidthPx;
            fullContentWidth = maxContentWidthPx;
        } else {
            fullContentWidth = titleWidth = titleParagraph.getMaxIntrinsicWidth();
        }
        float mainIconSize = richTooltip.getMainIcon() == null ? 0.0f : presentationModel.getMainIconSize-D9Ej5fM() * density.getDensity();
        ArrayList<Size> descriptionSizes = new ArrayList<Size>();
        float descriptionTextHeightPx = 0.0f;
        if (RichTooltipPopupContentKt.getHasDescriptionContent(richTooltip)) {
            fullContentWidth = maxContentWidthPx;
            List<String> list = richTooltip.getDescriptionSections();
            Intrinsics.checkNotNull(list);
            descriptionTextHeightPx += (float)(verticalGapPx * (((Collection)list).size() - 1));
            float maxDescriptionWidthPx = richTooltip.getMainIcon() == null ? maxContentWidthPx : maxContentWidthPx - mainIconSize - (float)horizontalGapPx;
            for (String descriptionSection : richTooltip.getDescriptionSections()) {
                Paragraph descriptionParagraph = ParagraphKt.Paragraph-UdtVg6A$default((String)descriptionSection, (TextStyle)textStyle, (long)ConstraintsKt.Constraints$default((int)0, (int)((int)maxDescriptionWidthPx), (int)0, (int)0, (int)13, null), (Density)density, (FontFamily.Resolver)fontFamilyResolver, null, null, (int)0, (boolean)false, (int)480, null);
                descriptionTextHeightPx += descriptionParagraph.getHeight();
                descriptionSizes.add(Size.box-impl((long)SizeKt.Size((float)maxDescriptionWidthPx, (float)descriptionParagraph.getHeight())));
            }
        }
        if (mainIconSize > 0.0f || descriptionTextHeightPx > 0.0f) {
            fullContentHeight += (float)verticalGapPx;
            fullContentHeight += Math.max(mainIconSize, descriptionTextHeightPx);
        }
        if (RichTooltipPopupContentKt.getHasFooterContent(richTooltip)) {
            fullContentHeight += (float)verticalGapPx;
            fullContentHeight += SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM() * density.getDensity();
            fullContentHeight += (float)verticalGapPx;
        }
        float footerIconSize = richTooltip.getFooterIcon() == null ? 0.0f : presentationModel.getFooterIconSize-D9Ej5fM() * density.getDensity();
        ArrayList<Size> footerSizes = new ArrayList<Size>();
        float footerTextHeightPx = 0.0f;
        if (RichTooltipPopupContentKt.getHasFooterSections(richTooltip)) {
            fullContentWidth = maxContentWidthPx;
            List<String> list = richTooltip.getFooterSections();
            Intrinsics.checkNotNull(list);
            footerTextHeightPx += (float)(verticalGapPx * (((Collection)list).size() - 1));
            float maxFooterWidthPx = richTooltip.getFooterIcon() == null ? maxContentWidthPx : maxContentWidthPx - footerIconSize - (float)horizontalGapPx;
            for (String footerSection : richTooltip.getFooterSections()) {
                Paragraph footerParagraph = ParagraphKt.Paragraph-UdtVg6A$default((String)footerSection, (TextStyle)textStyle, (long)ConstraintsKt.Constraints$default((int)0, (int)((int)maxFooterWidthPx), (int)0, (int)0, (int)13, null), (Density)density, (FontFamily.Resolver)fontFamilyResolver, null, null, (int)0, (boolean)false, (int)480, null);
                footerTextHeightPx += footerParagraph.getHeight();
                footerSizes.add(Size.box-impl((long)SizeKt.Size((float)maxFooterWidthPx, (float)footerParagraph.getHeight())));
            }
        }
        fullContentHeight += Math.max(footerIconSize, footerTextHeightPx);
        long l = SizeKt.Size((float)((fullContentWidth += horizontalPaddingPx) + (float)(2 * offset)), (float)((fullContentHeight += verticalPaddingPx) + (float)(2 * offset)));
        long footerParagraph = SizeKt.Size((float)titleWidth, (float)titleParagraph.getHeight());
        long l2 = richTooltip.getMainIcon() == null ? Size.Companion.getZero-NH-jbRc() : SizeKt.Size((float)(presentationModel.getMainIconSize-D9Ej5fM() * density.getDensity()), (float)(presentationModel.getMainIconSize-D9Ej5fM() * density.getDensity()));
        long l3 = !RichTooltipPopupContentKt.getHasFooterContent(richTooltip) ? Size.Companion.getZero-NH-jbRc() : SizeKt.Size((float)(fullContentWidth - horizontalPaddingPx), (float)(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM() * density.getDensity()));
        long l4 = richTooltip.getFooterIcon() == null ? Size.Companion.getZero-NH-jbRc() : SizeKt.Size((float)(presentationModel.getFooterIconSize-D9Ej5fM() * density.getDensity()), (float)(presentationModel.getFooterIconSize-D9Ej5fM() * density.getDensity()));
        RichTooltipLayoutInfo tooltipLayoutInfo = new RichTooltipLayoutInfo(l, l2, footerParagraph, descriptionSizes, l3, l4, footerSizes, null);
        int fullPopupWidth = (int)Math.ceil(fullContentWidth / density.getDensity()) + 2;
        int fullPopupHeight = (int)Math.ceil(fullContentHeight / density.getDensity()) + 2;
        int initialAnchorX = layoutDirection == LayoutDirection.Ltr ? (int)((float)popupOriginatorLocationOnScreen.x + anchorBoundsInWindow.getLeft()) : (int)((float)popupOriginatorLocationOnScreen.x + anchorBoundsInWindow.getLeft() + anchorBoundsInWindow.getWidth()) - fullPopupWidth;
        long initialAnchor = IntOffsetKt.IntOffset((int)initialAnchorX, (int)((int)((float)popupOriginatorLocationOnScreen.y + anchorBoundsInWindow.getTop())));
        switch (WhenMappings.$EnumSwitchMapping$0[popupPlacementStrategy.ordinal()]) {
            case 1: {
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor), IntOffset.getY-impl((long)initialAnchor) + (int)anchorBoundsInWindow.getHeight(), fullPopupWidth, fullPopupHeight);
                break;
            }
            case 2: {
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor), IntOffset.getY-impl((long)initialAnchor) - fullPopupHeight, fullPopupWidth, fullPopupHeight);
                break;
            }
            case 3: {
                if (layoutDirection == LayoutDirection.Ltr) {
                    rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) - fullPopupWidth, IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                    break;
                }
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) + fullPopupWidth, IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                break;
            }
            case 4: {
                if (layoutDirection == LayoutDirection.Ltr) {
                    rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) + (int)anchorBoundsInWindow.getWidth(), IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                    break;
                }
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) - (int)anchorBoundsInWindow.getWidth(), IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                break;
            }
            case 5: {
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor), IntOffset.getY-impl((long)initialAnchor) + (int)anchorBoundsInWindow.getHeight() / 2 - fullPopupHeight / 2, fullPopupWidth, fullPopupHeight);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Rectangle popupRect = rectangle;
        Rectangle screenBounds = popupOriginator.getGraphicsConfiguration().getBounds();
        if (popupRect.x < 0) {
            popupRect.translate(-popupRect.x, 0);
        }
        if (popupRect.x + popupRect.width > screenBounds.width) {
            popupRect.translate(screenBounds.width - popupRect.x - popupRect.width, 0);
        }
        if (popupRect.y < 0) {
            popupRect.translate(0, -popupRect.y);
        }
        if (popupRect.y + popupRect.height > screenBounds.height) {
            popupRect.translate(0, screenBounds.height - popupRect.y - popupRect.height);
        }
        ComposePanel popupContent = new ComposePanel();
        long fillColor = skinColors.getBackgroundColorScheme(decorationAreaType).getBackgroundFillColor-0d7_KjU();
        java.awt.Color awtFillColor = CommandMenuPopupContentKt.getAwtColor-8_81llA(fillColor);
        popupContent.setBackground(awtFillColor);
        AuroraColorScheme borderScheme = skinColors.getColorScheme(DecorationAreaType.Companion.getNone(), ColorSchemeAssociationKind.Companion.getBorder(), ComponentState.Companion.getEnabled());
        long popupBorderColor = skinPainters.getBorderPainter().getRepresentativeColor-vNxB06k(borderScheme);
        java.awt.Color awtBorderColor = CommandMenuPopupContentKt.getAwtColor-8_81llA(popupBorderColor);
        float borderThickness = 1.0f / density.getDensity();
        popupContent.setBorder(new Border(awtFillColor, awtBorderColor, borderThickness){
            final /* synthetic */ java.awt.Color $awtFillColor;
            final /* synthetic */ java.awt.Color $awtBorderColor;
            final /* synthetic */ float $borderThickness;
            {
                this.$awtFillColor = $awtFillColor;
                this.$awtBorderColor = $awtBorderColor;
                this.$borderThickness = $borderThickness;
            }

            public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2d.setColor(this.$awtFillColor);
                g2d.fill(new Rectangle(0, 0, width, height));
                float thickness = 0.5f;
                g2d.setStroke(new BasicStroke(thickness, 0, 1));
                g2d.setColor(this.$awtBorderColor);
                g2d.draw(new Rectangle2D.Float(this.$borderThickness / 2.0f, this.$borderThickness / 2.0f, (float)width - this.$borderThickness, (float)height - this.$borderThickness));
                g2d.dispose();
            }

            @NotNull
            public Insets getBorderInsets(@Nullable Component c) {
                return new Insets(1, 1, 1, 1);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        });
        popupContent.setPreferredSize(new Dimension(popupRect.width, popupRect.height));
        float $this$dp$iv = (float)popupRect.width / density.getDensity();
        boolean $i$f$getDp = false;
        float f3 = Dp.constructor-impl((float)$this$dp$iv);
        $this$dp$iv = (float)popupRect.height / density.getDensity();
        $i$f$getDp = false;
        long popupDpSize = DpKt.DpSize-YgX7TsA((float)f3, (float)Dp.constructor-impl((float)$this$dp$iv));
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        AuroraSwingPopupMenu popupMenu = new AuroraSwingPopupMenu();
        popupContent.setContent((Function2)ComposableLambdaKt.composableLambdaInstance((int)434892888, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(compositionLocalContext, popupMenu, popupDpSize, richTooltip, presentationModel, tooltipLayoutInfo){
            final /* synthetic */ CompositionLocalContext $compositionLocalContext;
            final /* synthetic */ AuroraSwingPopupMenu $popupMenu;
            final /* synthetic */ long $popupDpSize;
            final /* synthetic */ RichTooltip $richTooltip;
            final /* synthetic */ RichTooltipPresentationModel $presentationModel;
            final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
            {
                this.$compositionLocalContext = $compositionLocalContext;
                this.$popupMenu = $popupMenu;
                this.$popupDpSize = $popupDpSize;
                this.$richTooltip = $richTooltip;
                this.$presentationModel = $presentationModel;
                this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                super(2);
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(@Nullable Composer $composer, int $changed) {
                if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)434892888, (int)$changed, (int)-1, (String)"org.pushingpixels.aurora.component.utils.displayRichTooltipContent.<anonymous> (RichTooltipPopupContent.kt:406)");
                    }
                    CompositionLocalKt.CompositionLocalProvider((CompositionLocalContext)this.$compositionLocalContext, (Function2)((Function2)ComposableLambdaKt.composableLambda((Composer)$composer, (int)-1122557032, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this.$popupMenu, this.$popupDpSize, this.$richTooltip, this.$presentationModel, this.$tooltipLayoutInfo){
                        final /* synthetic */ AuroraSwingPopupMenu $popupMenu;
                        final /* synthetic */ long $popupDpSize;
                        final /* synthetic */ RichTooltip $richTooltip;
                        final /* synthetic */ RichTooltipPresentationModel $presentationModel;
                        final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
                        {
                            this.$popupMenu = $popupMenu;
                            this.$popupDpSize = $popupDpSize;
                            this.$richTooltip = $richTooltip;
                            this.$presentationModel = $presentationModel;
                            this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                            super(2);
                        }

                        @Composable
                        @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                        public final void invoke(@Nullable Composer $composer, int $changed) {
                            if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventStart((int)-1122557032, (int)$changed, (int)-1, (String)"org.pushingpixels.aurora.component.utils.displayRichTooltipContent.<anonymous>.<anonymous> (RichTooltipPopupContent.kt:408)");
                                }
                                ProvidedValue[] providedValueArray = new ProvidedValue[]{AuroraLocalsKt.getLocalPopupMenu().provides((Object)this.$popupMenu), AuroraLocalsKt.getLocalWindowSize().provides((Object)DpSize.box-impl((long)this.$popupDpSize))};
                                CompositionLocalKt.CompositionLocalProvider((ProvidedValue[])providedValueArray, (Function2)((Function2)ComposableLambdaKt.composableLambda((Composer)$composer, (int)1774175960, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this.$richTooltip, this.$presentationModel, this.$tooltipLayoutInfo){
                                    final /* synthetic */ RichTooltip $richTooltip;
                                    final /* synthetic */ RichTooltipPresentationModel $presentationModel;
                                    final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
                                    {
                                        this.$richTooltip = $richTooltip;
                                        this.$presentationModel = $presentationModel;
                                        this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                                        super(2);
                                    }

                                    @Composable
                                    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                                    public final void invoke(@Nullable Composer $composer, int $changed) {
                                        if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                                            if (ComposerKt.isTraceInProgress()) {
                                                ComposerKt.traceEventStart((int)1774175960, (int)$changed, (int)-1, (String)"org.pushingpixels.aurora.component.utils.displayRichTooltipContent.<anonymous>.<anonymous>.<anonymous> (RichTooltipPopupContent.kt:413)");
                                            }
                                            RichTooltipPopupContentKt.access$TopLevelRichTooltipContent(this.$richTooltip, this.$presentationModel, this.$tooltipLayoutInfo, $composer, 520);
                                            if (ComposerKt.isTraceInProgress()) {
                                                ComposerKt.traceEventEnd();
                                            }
                                        } else {
                                            $composer.skipToGroupEnd();
                                        }
                                    }
                                })), (Composer)$composer, (int)56);
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventEnd();
                                }
                            } else {
                                $composer.skipToGroupEnd();
                            }
                        }
                    })), (Composer)$composer, (int)48);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }));
        popupMenu.add((Component)popupContent);
        AuroraPopupManager.hidePopups$default((AuroraPopupManager)AuroraPopupManager.INSTANCE, (Component)popupOriginator, null, (int)2, null);
        AuroraPopupManager.INSTANCE.showPopup(popupOriginator, Rect.Companion.getZero(), popupMenu, popupContent, popupRect, AuroraPopupManager.PopupKind.RICH_TOOLTIP);
    }

    @Composable
    private static final Modifier richTooltipBackground(Modifier $this$richTooltipBackground, Composer $composer, int $changed) {
        $composer.startReplaceableGroup(-1862247034);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1862247034, (int)$changed, (int)-1, (String)"org.pushingpixels.aurora.component.utils.richTooltipBackground (RichTooltipPopupContent.kt:438)");
        }
        Modifier modifier = $this$richTooltipBackground.then((Modifier)new RichTooltipBackground(AuroraSkin.INSTANCE.getDecorationAreaType($composer, 8), AuroraSkin.INSTANCE.getColors($composer, 8)));
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return modifier;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    private static final void TopLevelRichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, RichTooltipLayoutInfo tooltipLayoutInfo, Composer $composer, int $changed) {
        void $changed2;
        void $changed$iv$iv;
        void skippableUpdate$iv$iv;
        void $changed$iv;
        Function0 this_$iv$iv;
        void this_$iv$iv2;
        void this_$iv$iv3;
        void this_$iv;
        void this_$iv2;
        $composer = $composer.startRestartGroup(-922674026);
        int $dirty = $changed;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-922674026, (int)$dirty, (int)-1, (String)"org.pushingpixels.aurora.component.utils.TopLevelRichTooltipContent (RichTooltipPopupContent.kt:468)");
        }
        CompositionLocal compositionLocal = (CompositionLocal)CompositionLocalsKt.getLocalDensity();
        boolean $changed$iv22 = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"C:CompositionLocal.kt#9igjgp");
        Object object = $composer.consume((CompositionLocal)this_$iv2);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        int offset = (int)Math.ceil(((Density)object).getDensity());
        CompositionLocal $changed$iv22 = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        boolean $changed$iv3 = false;
        boolean $i$f$getCurrent2 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"C:CompositionLocal.kt#9igjgp");
        Object object2 = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        LayoutDirection layoutDirection = (LayoutDirection)object2;
        Modifier modifier = RichTooltipPopupContentKt.richTooltipBackground((Modifier)Modifier.Companion, $composer, 6);
        MeasurePolicy measurePolicy2 = new MeasurePolicy(tooltipLayoutInfo, richTooltip, offset, layoutDirection){
            final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
            final /* synthetic */ RichTooltip $richTooltip;
            final /* synthetic */ int $offset;
            final /* synthetic */ LayoutDirection $layoutDirection;
            {
                this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                this.$richTooltip = $richTooltip;
                this.$offset = $offset;
                this.$layoutDirection = $layoutDirection;
            }

            @NotNull
            public final MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$Layout, @NotNull List<? extends Measurable> measurables, long l) {
                Intrinsics.checkNotNullParameter((Object)$this$Layout, (String)"$this$Layout");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                int verticalGapPx = (int)$this$Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getVerticalContentLayoutGap-D9Ej5fM());
                int horizontalGapPx = (int)$this$Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getHorizontalContentLayoutGap-D9Ej5fM());
                int placeableIndex = 0;
                Ref.ObjectRef iconPlaceable = new Ref.ObjectRef();
                Placeable titlePlaceable = measurables.get(placeableIndex++).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getTitleSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getTitleSize-NH-jbRc())));
                if (this.$richTooltip.getMainIcon() != null) {
                    iconPlaceable.element = measurables.get(placeableIndex++).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getMainIconSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getMainIconSize-NH-jbRc())));
                }
                ArrayList<Placeable> descriptionPlaceables = new ArrayList<Placeable>();
                if (RichTooltipPopupContentKt.getHasDescriptionContent(this.$richTooltip)) {
                    List<String> list = this.$richTooltip.getDescriptionSections();
                    Intrinsics.checkNotNull(list);
                    int n = list.size();
                    for (int index = 0; index < n; ++index) {
                        descriptionPlaceables.add(measurables.get(placeableIndex++).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getDescriptionSizes().get(index).unbox-impl()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getDescriptionSizes().get(index).unbox-impl()))));
                    }
                }
                Ref.ObjectRef footerSeparatorPlaceable = new Ref.ObjectRef();
                if (RichTooltipPopupContentKt.getHasFooterContent(this.$richTooltip)) {
                    footerSeparatorPlaceable.element = measurables.get(placeableIndex++).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFooterSeparatorSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFooterSeparatorSize-NH-jbRc())));
                }
                Ref.ObjectRef footerIconPlaceable = new Ref.ObjectRef();
                if (this.$richTooltip.getFooterIcon() != null) {
                    footerIconPlaceable.element = measurables.get(placeableIndex++).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFooterIconSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFooterIconSize-NH-jbRc())));
                }
                ArrayList<Placeable> footerPlaceables = new ArrayList<Placeable>();
                if (RichTooltipPopupContentKt.getHasFooterSections(this.$richTooltip)) {
                    List<String> list = this.$richTooltip.getFooterSections();
                    Intrinsics.checkNotNull(list);
                    int n = list.size();
                    for (int index = 0; index < n; ++index) {
                        footerPlaceables.add(measurables.get(placeableIndex++).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFooterSizes().get(index).unbox-impl()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFooterSizes().get(index).unbox-impl()))));
                    }
                }
                return MeasureScope.layout$default((MeasureScope)$this$Layout, (int)((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFullSize-NH-jbRc())), (int)((int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFullSize-NH-jbRc())), null, (Function1)((Function1)new Function1<Placeable.PlacementScope, Unit>(this.$offset, $this$Layout, this.$layoutDirection, titlePlaceable, (Ref.ObjectRef<Placeable>)iconPlaceable, descriptionPlaceables, verticalGapPx, horizontalGapPx, this.$richTooltip, (Ref.ObjectRef<Placeable>)footerSeparatorPlaceable, (Ref.ObjectRef<Placeable>)footerIconPlaceable, footerPlaceables){
                    final /* synthetic */ int $offset;
                    final /* synthetic */ MeasureScope $this_Layout;
                    final /* synthetic */ LayoutDirection $layoutDirection;
                    final /* synthetic */ Placeable $titlePlaceable;
                    final /* synthetic */ Ref.ObjectRef<Placeable> $iconPlaceable;
                    final /* synthetic */ ArrayList<Placeable> $descriptionPlaceables;
                    final /* synthetic */ int $verticalGapPx;
                    final /* synthetic */ int $horizontalGapPx;
                    final /* synthetic */ RichTooltip $richTooltip;
                    final /* synthetic */ Ref.ObjectRef<Placeable> $footerSeparatorPlaceable;
                    final /* synthetic */ Ref.ObjectRef<Placeable> $footerIconPlaceable;
                    final /* synthetic */ ArrayList<Placeable> $footerPlaceables;
                    {
                        this.$offset = $offset;
                        this.$this_Layout = $this_Layout;
                        this.$layoutDirection = $layoutDirection;
                        this.$titlePlaceable = $titlePlaceable;
                        this.$iconPlaceable = $iconPlaceable;
                        this.$descriptionPlaceables = $descriptionPlaceables;
                        this.$verticalGapPx = $verticalGapPx;
                        this.$horizontalGapPx = $horizontalGapPx;
                        this.$richTooltip = $richTooltip;
                        this.$footerSeparatorPlaceable = $footerSeparatorPlaceable;
                        this.$footerIconPlaceable = $footerIconPlaceable;
                        this.$footerPlaceables = $footerPlaceables;
                        super(1);
                    }

                    public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                        Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                        int left = this.$offset + (int)this.$this_Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateLeftPadding-u2uoSUM(this.$layoutDirection));
                        int top = this.$offset + (int)this.$this_Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateTopPadding-D9Ej5fM());
                        Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)this.$titlePlaceable, (int)left, (int)top, (float)0.0f, (int)4, null);
                        int x = left;
                        int y = top + this.$titlePlaceable.getHeight();
                        if (this.$iconPlaceable.element != null || !((Collection)this.$descriptionPlaceables).isEmpty()) {
                            y += this.$verticalGapPx;
                        }
                        int iconBottom = y;
                        if (this.$iconPlaceable.element != null) {
                            Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)((Placeable)this.$iconPlaceable.element), (int)x, (int)y, (float)0.0f, (int)4, null);
                            x += ((Placeable)this.$iconPlaceable.element).getWidth() + this.$horizontalGapPx;
                            iconBottom = y + ((Placeable)this.$iconPlaceable.element).getHeight();
                        }
                        if (!((Collection)this.$descriptionPlaceables).isEmpty()) {
                            for (Placeable descriptionPlaceable : this.$descriptionPlaceables) {
                                Intrinsics.checkNotNullExpressionValue((Object)descriptionPlaceable, (String)"descriptionPlaceable");
                                Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)descriptionPlaceable, (int)x, (int)y, (float)0.0f, (int)4, null);
                                y += descriptionPlaceable.getHeight();
                                y += this.$verticalGapPx;
                            }
                            y -= this.$verticalGapPx;
                        }
                        y = RangesKt.coerceAtLeast((int)y, (int)iconBottom);
                        if (RichTooltipPopupContentKt.getHasFooterContent(this.$richTooltip)) {
                            Object object = this.$footerSeparatorPlaceable.element;
                            Intrinsics.checkNotNull((Object)object);
                            Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)((Placeable)object), (int)left, (int)(y += this.$verticalGapPx), (float)0.0f, (int)4, null);
                            y += ((Placeable)this.$footerSeparatorPlaceable.element).getHeight();
                            y += this.$verticalGapPx;
                        }
                        x = left;
                        if (this.$footerIconPlaceable.element != null) {
                            Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)((Placeable)this.$footerIconPlaceable.element), (int)left, (int)y, (float)0.0f, (int)4, null);
                            x += ((Placeable)this.$footerIconPlaceable.element).getWidth() + (int)this.$this_Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getHorizontalContentLayoutGap-D9Ej5fM());
                        }
                        if (!((Collection)this.$footerPlaceables).isEmpty()) {
                            for (Placeable footerPlaceable : this.$footerPlaceables) {
                                Intrinsics.checkNotNullExpressionValue((Object)footerPlaceable, (String)"footerPlaceable");
                                Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)footerPlaceable, (int)x, (int)y, (float)0.0f, (int)4, null);
                                y += footerPlaceable.getHeight();
                                y += this.$verticalGapPx;
                            }
                        }
                    }
                }), (int)4, null);
            }
        };
        $i$f$getCurrent2 = false;
        boolean $i$f$Layout = false;
        $composer.startReplaceableGroup(-1323940314);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(Layout)P(!1,2)74@2915L7,75@2970L7,76@3029L7,77@3041L460:Layout.kt#80mrfh");
        CompositionLocal compositionLocal2 = (CompositionLocal)CompositionLocalsKt.getLocalDensity();
        int $changed$iv$iv22 = 6;
        boolean $i$f$getCurrent3 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"C:CompositionLocal.kt#9igjgp");
        Object object3 = $composer.consume((CompositionLocal)this_$iv$iv3);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        Density density$iv = (Density)object3;
        CompositionLocal $changed$iv$iv22 = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        int $changed$iv$iv32 = 6;
        boolean $i$f$getCurrent4 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"C:CompositionLocal.kt#9igjgp");
        Object object4 = $composer.consume((CompositionLocal)this_$iv$iv2);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        LayoutDirection layoutDirection$iv = (LayoutDirection)object4;
        CompositionLocal $changed$iv$iv32 = (CompositionLocal)CompositionLocalsKt.getLocalViewConfiguration();
        int $changed$iv$iv42 = 6;
        int $i$f$getCurrent5 = 0;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"C:CompositionLocal.kt#9igjgp");
        Object object5 = $composer.consume((CompositionLocal)this_$iv$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        ViewConfiguration viewConfiguration$iv = (ViewConfiguration)object5;
        this_$iv$iv = ComposeUiNode.Companion.getConstructor();
        Function3 $changed$iv$iv42 = LayoutKt.materializerOf((Modifier)modifier);
        $i$f$getCurrent5 = 6 | 0x1C00 & $changed$iv << 9;
        boolean $i$f$ReusableComposeNode = false;
        if (!($composer.getApplier() instanceof Applier)) {
            ComposablesKt.invalidApplier();
        }
        $composer.startReusableNode();
        if ($composer.getInserting()) {
            void factory$iv$iv;
            $composer.createNode((Function0)factory$iv$iv);
        } else {
            $composer.useNode();
        }
        $composer.disableReusing();
        Composer $this$Layout_u24lambda_u2d0$iv = Updater.constructor-impl((Composer)$composer);
        boolean bl = false;
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)measurePolicy2, (Function2)ComposeUiNode.Companion.getSetMeasurePolicy());
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)density$iv, (Function2)ComposeUiNode.Companion.getSetDensity());
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)layoutDirection$iv, (Function2)ComposeUiNode.Companion.getSetLayoutDirection());
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)viewConfiguration$iv, (Function2)ComposeUiNode.Companion.getSetViewConfiguration());
        $composer.enableReusing();
        skippableUpdate$iv$iv.invoke((Object)SkippableUpdater.box-impl((Composer)SkippableUpdater.constructor-impl((Composer)$composer)), (Object)$composer, (Object)(0x70 & $changed$iv$iv >> 3));
        $composer.startReplaceableGroup(2058660585);
        int n = 0xE & $changed$iv$iv >> 9;
        Composer $composer2 = $composer;
        boolean bl2 = false;
        if (($changed2 & 0xB) != 2 || !$composer2.getSkipping()) {
            RichTooltipPopupContentKt.RichTooltipContent(richTooltip, richTooltipPresentationModel, $composer2, 8 | 0x70 & $dirty);
        } else {
            $composer2.skipToGroupEnd();
        }
        $composer.endReplaceableGroup();
        $composer.endNode();
        $composer.endReplaceableGroup();
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
        if (scopeUpdateScope != null) {
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(richTooltip, richTooltipPresentationModel, tooltipLayoutInfo, $changed){
                final /* synthetic */ RichTooltip $richTooltip;
                final /* synthetic */ RichTooltipPresentationModel $richTooltipPresentationModel;
                final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
                final /* synthetic */ int $$changed;
                {
                    this.$richTooltip = $richTooltip;
                    this.$richTooltipPresentationModel = $richTooltipPresentationModel;
                    this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    RichTooltipPopupContentKt.access$TopLevelRichTooltipContent(this.$richTooltip, this.$richTooltipPresentationModel, this.$tooltipLayoutInfo, $composer, this.$$changed | 1);
                }
            });
        }
    }

    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    private static final void RichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, Composer $composer, int $changed) {
        boolean $this$dp$iv;
        PaddingValues this_$iv;
        $composer = $composer.startRestartGroup(-430940238);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-430940238, (int)$changed, (int)-1, (String)"org.pushingpixels.aurora.component.utils.RichTooltipContent (RichTooltipPopupContent.kt:614)");
        }
        TextStyle resolvedTextStyle = AuroraSkinKt.resolveAuroraDefaults((Composer)$composer, (int)0);
        TextStyle textStyle = new TextStyle(0L, resolvedTextStyle.getFontSize-XSAIIZE(), FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 0L, null, 262137, null);
        CompositionLocal compositionLocal = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        boolean $changed$iv = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"C:CompositionLocal.kt#9igjgp");
        Object object = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        TextStyle boldTextStyle = TextStyle.copy-HL5avdY$default((TextStyle)TextStyleKt.resolveDefaults((TextStyle)textStyle, (LayoutDirection)((LayoutDirection)object)), (long)Color.Companion.getUnspecified-0d7_KjU(), (long)0L, null, null, null, null, null, (long)0L, null, null, null, (long)0L, null, null, null, null, (long)0L, null, (int)262142, null);
        boolean $this$dp$iv2 = false;
        boolean $i$f$getDp = false;
        this_$iv = PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)((float)$this$dp$iv2)));
        new LabelProjection(new LabelContentModel(richTooltip.getTitle(), false, null, 6, null), new LabelPresentationModel(this_$iv, 0.0f, null, null, false, boldTextStyle, 0, false, 0, null, 0.0f, 2014, null)).project(null, $composer, 64, 1);
        $composer.startReplaceableGroup(1202552855);
        if (richTooltip.getMainIcon() != null) {
            new IconProjection(new IconContentModel(richTooltip.getMainIcon(), false, 2, null), new IconPresentationModel(richTooltipPresentationModel.getMainIconSize-D9Ej5fM(), null, null, false, 14, null)).project(null, $composer, 64, 1);
        }
        $composer.endReplaceableGroup();
        $composer.startReplaceableGroup(1202553163);
        if (RichTooltipPopupContentKt.getHasDescriptionContent(richTooltip)) {
            List<String> list = richTooltip.getDescriptionSections();
            Intrinsics.checkNotNull(list);
            for (String descriptionSection : list) {
                $this$dp$iv = false;
                boolean $i$f$getDp2 = false;
                new LabelProjection(new LabelContentModel(descriptionSection, false, null, 6, null), new LabelPresentationModel(PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)((float)$this$dp$iv))), 0.0f, null, null, false, null, 0, false, 0, HorizontalAlignment.Leading, 0.0f, 1534, null)).project(null, $composer, 64, 1);
            }
        }
        $composer.endReplaceableGroup();
        if (RichTooltipPopupContentKt.getHasFooterContent(richTooltip)) {
            int $this$dp$iv3 = 6;
            boolean $i$f$getDp3 = false;
            float f = Dp.constructor-impl((float)$this$dp$iv3);
            $this$dp$iv3 = 6;
            $i$f$getDp3 = false;
            new HorizontalSeparatorProjection(null, new SeparatorPresentationModel(f, Dp.constructor-impl((float)$this$dp$iv3), null), 1, null).project(null, $composer, 0, 1);
            $composer.startReplaceableGroup(1202553896);
            if (richTooltip.getFooterIcon() != null) {
                new IconProjection(new IconContentModel(richTooltip.getFooterIcon(), false, 2, null), new IconPresentationModel(richTooltipPresentationModel.getFooterIconSize-D9Ej5fM(), null, null, false, 14, null)).project(null, $composer, 64, 1);
            }
            $composer.endReplaceableGroup();
            if (RichTooltipPopupContentKt.getHasFooterSections(richTooltip)) {
                List<String> list = richTooltip.getFooterSections();
                Intrinsics.checkNotNull(list);
                for (String footerSection : list) {
                    $this$dp$iv = false;
                    boolean $i$f$getDp4 = false;
                    new LabelProjection(new LabelContentModel(footerSection, false, null, 6, null), new LabelPresentationModel(PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)((float)$this$dp$iv))), 0.0f, null, null, false, null, 0, false, 0, HorizontalAlignment.Leading, 0.0f, 1534, null)).project(null, $composer, 64, 1);
                }
            }
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
        if (scopeUpdateScope != null) {
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(richTooltip, richTooltipPresentationModel, $changed){
                final /* synthetic */ RichTooltip $richTooltip;
                final /* synthetic */ RichTooltipPresentationModel $richTooltipPresentationModel;
                final /* synthetic */ int $$changed;
                {
                    this.$richTooltip = $richTooltip;
                    this.$richTooltipPresentationModel = $richTooltipPresentationModel;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    RichTooltipPopupContentKt.access$RichTooltipContent(this.$richTooltip, this.$richTooltipPresentationModel, $composer, this.$$changed | 1);
                }
            });
        }
    }

    public static final /* synthetic */ void access$TopLevelRichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, RichTooltipLayoutInfo tooltipLayoutInfo, Composer $composer, int $changed) {
        RichTooltipPopupContentKt.TopLevelRichTooltipContent(richTooltip, richTooltipPresentationModel, tooltipLayoutInfo, $composer, $changed);
    }

    public static final /* synthetic */ void access$RichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, Composer $composer, int $changed) {
        RichTooltipPopupContentKt.RichTooltipContent(richTooltip, richTooltipPresentationModel, $composer, $changed);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PopupPlacementStrategy.values().length];
            try {
                nArray[PopupPlacementStrategy.Downward.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPlacementStrategy.Upward.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPlacementStrategy.Startward.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPlacementStrategy.Endward.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPlacementStrategy.CenteredVertically.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

