/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.utils;

import androidx.compose.ui.draw.DrawModifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.TileMode;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.theming.ComponentState;
import org.pushingpixels.aurora.theming.DecorationAreaType;
import org.pushingpixels.aurora.theming.colorscheme.AuroraColorScheme;
import org.pushingpixels.aurora.theming.colorscheme.AuroraSkinColors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/pushingpixels/aurora/component/utils/RichTooltipBackground;", "Landroidx/compose/ui/draw/DrawModifier;", "decorationAreaType", "Lorg/pushingpixels/aurora/theming/DecorationAreaType;", "colors", "Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;", "(Lorg/pushingpixels/aurora/theming/DecorationAreaType;Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;)V", "draw", "", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "component"})
final class RichTooltipBackground
implements DrawModifier {
    @NotNull
    private final DecorationAreaType decorationAreaType;
    @NotNull
    private final AuroraSkinColors colors;

    public RichTooltipBackground(@NotNull DecorationAreaType decorationAreaType, @NotNull AuroraSkinColors colors) {
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.decorationAreaType = decorationAreaType;
        this.colors = colors;
    }

    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        AuroraColorScheme colorScheme = this.colors.getColorScheme(this.decorationAreaType, ComponentState.Companion.getEnabled());
        long startColor = colorScheme.getExtraLightColor-0d7_KjU();
        long endColor = colorScheme.getLightColor-0d7_KjU();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Color.box-impl((long)startColor)), TuplesKt.to((Object)Float.valueOf(1.0f), (Object)Color.box-impl((long)endColor))};
        Brush brush = Brush.Companion.verticalGradient-8A-3gB4(pairArray, 0.0f, Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc()), TileMode.Companion.getClamp-3opZhB0());
        DrawScope.drawRect-AsUm42w$default((DrawScope)((DrawScope)$this$draw), (Brush)brush, (long)0L, (long)0L, (float)0.0f, null, null, (int)0, (int)126, null);
        $this$draw.drawContent();
    }
}

