/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.utils;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pushingpixels.aurora.common.ColorUtilsKt;
import org.pushingpixels.aurora.component.utils.ModelStateInfo;
import org.pushingpixels.aurora.component.utils.StateContributionInfo;
import org.pushingpixels.aurora.theming.AuroraSkin;
import org.pushingpixels.aurora.theming.ColorSchemeAssociationKind;
import org.pushingpixels.aurora.theming.ComponentState;
import org.pushingpixels.aurora.theming.ComponentStateFacet;
import org.pushingpixels.aurora.theming.DecorationAreaType;
import org.pushingpixels.aurora.theming.ModelStateInfoSnapshot;
import org.pushingpixels.aurora.theming.colorscheme.AuroraColorScheme;
import org.pushingpixels.aurora.theming.colorscheme.AuroraSkinColors;
import org.pushingpixels.aurora.theming.utils.MutableColorScheme;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aD\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a@\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a0\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u001a0\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u001a?\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u001c\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\u0010\u001d\u001a0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a5\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"getStateAwareColor", "Landroidx/compose/ui/graphics/Color;", "modelStateInfo", "Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;", "currState", "Lorg/pushingpixels/aurora/theming/ComponentState;", "decorationAreaType", "Lorg/pushingpixels/aurora/theming/DecorationAreaType;", "associationKind", "Lorg/pushingpixels/aurora/theming/ColorSchemeAssociationKind;", "query", "Lkotlin/Function1;", "Lorg/pushingpixels/aurora/theming/colorscheme/AuroraColorScheme;", "(Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;Lorg/pushingpixels/aurora/theming/ComponentState;Lorg/pushingpixels/aurora/theming/DecorationAreaType;Lorg/pushingpixels/aurora/theming/ColorSchemeAssociationKind;Lkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;I)J", "getTextColor", "skinColors", "Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;", "colorSchemeAssociationKind", "isTextInFilledArea", "", "(Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;Lorg/pushingpixels/aurora/theming/ComponentState;Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;Lorg/pushingpixels/aurora/theming/DecorationAreaType;Lorg/pushingpixels/aurora/theming/ColorSchemeAssociationKind;Z)J", "getTextFillBackground", "(Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;Lorg/pushingpixels/aurora/theming/ComponentState;Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;Lorg/pushingpixels/aurora/theming/DecorationAreaType;)J", "getTextSelectionBackground", "populateColorScheme", "", "colorScheme", "Lorg/pushingpixels/aurora/theming/utils/MutableColorScheme;", "treatEnabledAsActive", "(Lorg/pushingpixels/aurora/theming/utils/MutableColorScheme;Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;Lorg/pushingpixels/aurora/theming/ComponentState;Lorg/pushingpixels/aurora/theming/DecorationAreaType;Lorg/pushingpixels/aurora/theming/ColorSchemeAssociationKind;ZLandroidx/compose/runtime/Composer;II)V", "Lorg/pushingpixels/aurora/theming/ModelStateInfoSnapshot;", "populateColorSchemeWithHighlightAlpha", "(Lorg/pushingpixels/aurora/theming/utils/MutableColorScheme;Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;Lorg/pushingpixels/aurora/theming/ComponentState;Lorg/pushingpixels/aurora/theming/DecorationAreaType;Lorg/pushingpixels/aurora/theming/ColorSchemeAssociationKind;Landroidx/compose/runtime/Composer;I)V", "component"})
public final class ColorSchemeUtilsKt {
    @Composable
    public static final void populateColorScheme(@NotNull MutableColorScheme colorScheme, @NotNull ModelStateInfo modelStateInfo, @NotNull ComponentState currState, @NotNull DecorationAreaType decorationAreaType, @NotNull ColorSchemeAssociationKind associationKind, boolean treatEnabledAsActive, @Nullable Composer $composer, int $changed, int n) {
        AuroraColorScheme auroraColorScheme;
        AuroraColorScheme auroraColorScheme2;
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter((Object)currState, (String)"currState");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)associationKind, (String)"associationKind");
        $composer = $composer.startRestartGroup(232348639);
        if ((n & 0x20) != 0) {
            treatEnabledAsActive = false;
        }
        if (treatEnabledAsActive && Intrinsics.areEqual((Object)currState, (Object)ComponentState.Companion.getEnabled())) {
            $composer.startReplaceableGroup(232349026);
            auroraColorScheme2 = AuroraSkin.INSTANCE.getColors($composer, 8).getActiveColorScheme(decorationAreaType);
            $composer.endReplaceableGroup();
            auroraColorScheme = auroraColorScheme2;
        } else {
            $composer.startReplaceableGroup(232349119);
            auroraColorScheme2 = AuroraSkin.INSTANCE.getColors($composer, 8).getColorScheme(decorationAreaType, associationKind, currState);
            $composer.endReplaceableGroup();
            auroraColorScheme = auroraColorScheme2;
        }
        AuroraColorScheme currStateScheme = auroraColorScheme;
        long ultraLight = currStateScheme.getUltraLightColor-0d7_KjU();
        long extraLight = currStateScheme.getExtraLightColor-0d7_KjU();
        long light = currStateScheme.getLightColor-0d7_KjU();
        long mid = currStateScheme.getMidColor-0d7_KjU();
        long dark = currStateScheme.getDarkColor-0d7_KjU();
        long ultraDark = currStateScheme.getUltraDarkColor-0d7_KjU();
        long foreground = currStateScheme.getForegroundColor-0d7_KjU();
        long backgroundFill = currStateScheme.getBackgroundFillColor-0d7_KjU();
        long accentedBackgroundFill = currStateScheme.getAccentedBackgroundFillColor-0d7_KjU();
        long focusRing = currStateScheme.getFocusRingColor-0d7_KjU();
        long line = currStateScheme.getLineColor-0d7_KjU();
        long selectionForeground = currStateScheme.getSelectionForegroundColor-0d7_KjU();
        long selectionBackground = currStateScheme.getSelectionBackgroundColor-0d7_KjU();
        long textBackgroundFill = currStateScheme.getTextBackgroundFillColor-0d7_KjU();
        long separatorPrimary = currStateScheme.getSeparatorPrimaryColor-0d7_KjU();
        long separatorSecondary = currStateScheme.getSeparatorSecondaryColor-0d7_KjU();
        long mark = currStateScheme.getMarkColor-0d7_KjU();
        long echo = currStateScheme.getEchoColor-0d7_KjU();
        Iterator<Map.Entry<ComponentState, StateContributionInfo>> iterator = modelStateInfo.getStateContributionMap().entrySet().iterator();
        while (iterator.hasNext()) {
            AuroraColorScheme auroraColorScheme3;
            AuroraColorScheme auroraColorScheme4;
            $composer.startReplaceableGroup(232350343);
            Map.Entry<ComponentState, StateContributionInfo> contribution = iterator.next();
            if (Intrinsics.areEqual((Object)contribution.getKey(), (Object)currState)) {
                $composer.endReplaceableGroup();
                continue;
            }
            float amount = contribution.getValue().getContribution();
            if (amount == 0.0f) {
                $composer.endReplaceableGroup();
                continue;
            }
            if (treatEnabledAsActive && Intrinsics.areEqual((Object)contribution.getKey(), (Object)ComponentState.Companion.getEnabled())) {
                $composer.startReplaceableGroup(232350925);
                auroraColorScheme4 = AuroraSkin.INSTANCE.getColors($composer, 8).getActiveColorScheme(decorationAreaType);
                $composer.endReplaceableGroup();
                auroraColorScheme3 = auroraColorScheme4;
            } else {
                $composer.startReplaceableGroup(232351026);
                auroraColorScheme4 = AuroraSkin.INSTANCE.getColors($composer, 8).getColorScheme(decorationAreaType, associationKind, contribution.getKey());
                $composer.endReplaceableGroup();
                auroraColorScheme3 = auroraColorScheme4;
            }
            AuroraColorScheme contributionScheme = auroraColorScheme3;
            ultraLight = ColorUtilsKt.interpolateTowards-jxsXWHM((long)ultraLight, (long)contributionScheme.getUltraLightColor-0d7_KjU(), (float)(1.0f - amount));
            extraLight = ColorUtilsKt.interpolateTowards-jxsXWHM((long)extraLight, (long)contributionScheme.getExtraLightColor-0d7_KjU(), (float)(1.0f - amount));
            light = ColorUtilsKt.interpolateTowards-jxsXWHM((long)light, (long)contributionScheme.getLightColor-0d7_KjU(), (float)(1.0f - amount));
            mid = ColorUtilsKt.interpolateTowards-jxsXWHM((long)mid, (long)contributionScheme.getMidColor-0d7_KjU(), (float)(1.0f - amount));
            dark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)dark, (long)contributionScheme.getDarkColor-0d7_KjU(), (float)(1.0f - amount));
            ultraDark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)ultraDark, (long)contributionScheme.getUltraDarkColor-0d7_KjU(), (float)(1.0f - amount));
            foreground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)foreground, (long)contributionScheme.getForegroundColor-0d7_KjU(), (float)(1.0f - amount));
            backgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)backgroundFill, (long)contributionScheme.getBackgroundFillColor-0d7_KjU(), (float)(1.0f - amount));
            accentedBackgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)accentedBackgroundFill, (long)contributionScheme.getAccentedBackgroundFillColor-0d7_KjU(), (float)(1.0f - amount));
            focusRing = ColorUtilsKt.interpolateTowards-jxsXWHM((long)focusRing, (long)contributionScheme.getFocusRingColor-0d7_KjU(), (float)(1.0f - amount));
            line = ColorUtilsKt.interpolateTowards-jxsXWHM((long)line, (long)contributionScheme.getLineColor-0d7_KjU(), (float)(1.0f - amount));
            selectionForeground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)selectionForeground, (long)contributionScheme.getSelectionForegroundColor-0d7_KjU(), (float)(1.0f - amount));
            selectionBackground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)selectionBackground, (long)contributionScheme.getSelectionBackgroundColor-0d7_KjU(), (float)(1.0f - amount));
            textBackgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)textBackgroundFill, (long)contributionScheme.getTextBackgroundFillColor-0d7_KjU(), (float)(1.0f - amount));
            separatorPrimary = ColorUtilsKt.interpolateTowards-jxsXWHM((long)separatorPrimary, (long)contributionScheme.getSeparatorPrimaryColor-0d7_KjU(), (float)(1.0f - amount));
            separatorSecondary = ColorUtilsKt.interpolateTowards-jxsXWHM((long)separatorSecondary, (long)contributionScheme.getSeparatorSecondaryColor-0d7_KjU(), (float)(1.0f - amount));
            mark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)mark, (long)contributionScheme.getMarkColor-0d7_KjU(), (float)(1.0f - amount));
            echo = ColorUtilsKt.interpolateTowards-jxsXWHM((long)echo, (long)contributionScheme.getEchoColor-0d7_KjU(), (float)(1.0f - amount));
            $composer.endReplaceableGroup();
        }
        colorScheme.setUltraLight-8_81llA(ultraLight);
        colorScheme.setExtraLight-8_81llA(extraLight);
        colorScheme.setLight-8_81llA(light);
        colorScheme.setMid-8_81llA(mid);
        colorScheme.setDark-8_81llA(dark);
        colorScheme.setUltraDark-8_81llA(ultraDark);
        colorScheme.setForeground-8_81llA(foreground);
        colorScheme.setBackgroundFill-8_81llA(backgroundFill);
        colorScheme.setAccentedBackgroundFill-8_81llA(accentedBackgroundFill);
        colorScheme.setFocusRing-8_81llA(focusRing);
        colorScheme.setLine-8_81llA(line);
        colorScheme.setSelectionForeground-8_81llA(selectionForeground);
        colorScheme.setSelectionBackground-8_81llA(selectionBackground);
        colorScheme.setTextBackgroundFill-8_81llA(textBackgroundFill);
        colorScheme.setSeparatorPrimary-8_81llA(separatorPrimary);
        colorScheme.setSeparatorSecondary-8_81llA(separatorSecondary);
        colorScheme.setMark-8_81llA(mark);
        colorScheme.setEcho-8_81llA(echo);
        ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
        if (scopeUpdateScope != null) {
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(colorScheme, modelStateInfo, currState, decorationAreaType, associationKind, treatEnabledAsActive, $changed, n){
                final /* synthetic */ MutableColorScheme $colorScheme;
                final /* synthetic */ ModelStateInfo $modelStateInfo;
                final /* synthetic */ ComponentState $currState;
                final /* synthetic */ DecorationAreaType $decorationAreaType;
                final /* synthetic */ ColorSchemeAssociationKind $associationKind;
                final /* synthetic */ boolean $treatEnabledAsActive;
                final /* synthetic */ int $$changed;
                final /* synthetic */ int $$default;
                {
                    this.$colorScheme = $colorScheme;
                    this.$modelStateInfo = $modelStateInfo;
                    this.$currState = $currState;
                    this.$decorationAreaType = $decorationAreaType;
                    this.$associationKind = $associationKind;
                    this.$treatEnabledAsActive = $treatEnabledAsActive;
                    this.$$changed = $$changed;
                    this.$$default = $$default;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    ColorSchemeUtilsKt.populateColorScheme(this.$colorScheme, this.$modelStateInfo, this.$currState, this.$decorationAreaType, this.$associationKind, this.$treatEnabledAsActive, $composer, this.$$changed | 1, this.$$default);
                }
            });
        }
    }

    public static final void populateColorScheme(@NotNull MutableColorScheme colorScheme, @NotNull ModelStateInfoSnapshot modelStateInfo, @NotNull AuroraSkinColors skinColors, @NotNull DecorationAreaType decorationAreaType, @NotNull ColorSchemeAssociationKind associationKind) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter((Object)skinColors, (String)"skinColors");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)associationKind, (String)"associationKind");
        AuroraColorScheme currStateScheme = skinColors.getColorScheme(decorationAreaType, associationKind, modelStateInfo.getCurrModelState());
        long ultraLight = currStateScheme.getUltraLightColor-0d7_KjU();
        long extraLight = currStateScheme.getExtraLightColor-0d7_KjU();
        long light = currStateScheme.getLightColor-0d7_KjU();
        long mid = currStateScheme.getMidColor-0d7_KjU();
        long dark = currStateScheme.getDarkColor-0d7_KjU();
        long ultraDark = currStateScheme.getUltraDarkColor-0d7_KjU();
        long foreground = currStateScheme.getForegroundColor-0d7_KjU();
        long backgroundFill = currStateScheme.getBackgroundFillColor-0d7_KjU();
        long accentedBackgroundFill = currStateScheme.getAccentedBackgroundFillColor-0d7_KjU();
        long focusRing = currStateScheme.getFocusRingColor-0d7_KjU();
        long line = currStateScheme.getLineColor-0d7_KjU();
        long selectionForeground = currStateScheme.getSelectionForegroundColor-0d7_KjU();
        long selectionBackground = currStateScheme.getSelectionBackgroundColor-0d7_KjU();
        long textBackgroundFill = currStateScheme.getTextBackgroundFillColor-0d7_KjU();
        long separatorPrimary = currStateScheme.getSeparatorPrimaryColor-0d7_KjU();
        long separatorSecondary = currStateScheme.getSeparatorSecondaryColor-0d7_KjU();
        long mark = currStateScheme.getMarkColor-0d7_KjU();
        long echo = currStateScheme.getEchoColor-0d7_KjU();
        for (Map.Entry contribution : modelStateInfo.getStateContributionMap().entrySet()) {
            float amount;
            if (Intrinsics.areEqual(contribution.getKey(), (Object)modelStateInfo.getCurrModelState()) || (amount = ((Number)contribution.getValue()).floatValue()) == 0.0f) continue;
            AuroraColorScheme contributionScheme = skinColors.getColorScheme(decorationAreaType, associationKind, (ComponentState)contribution.getKey());
            ultraLight = ColorUtilsKt.interpolateTowards-jxsXWHM((long)ultraLight, (long)contributionScheme.getUltraLightColor-0d7_KjU(), (float)(1.0f - amount));
            extraLight = ColorUtilsKt.interpolateTowards-jxsXWHM((long)extraLight, (long)contributionScheme.getExtraLightColor-0d7_KjU(), (float)(1.0f - amount));
            light = ColorUtilsKt.interpolateTowards-jxsXWHM((long)light, (long)contributionScheme.getLightColor-0d7_KjU(), (float)(1.0f - amount));
            mid = ColorUtilsKt.interpolateTowards-jxsXWHM((long)mid, (long)contributionScheme.getMidColor-0d7_KjU(), (float)(1.0f - amount));
            dark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)dark, (long)contributionScheme.getDarkColor-0d7_KjU(), (float)(1.0f - amount));
            ultraDark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)ultraDark, (long)contributionScheme.getUltraDarkColor-0d7_KjU(), (float)(1.0f - amount));
            foreground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)foreground, (long)contributionScheme.getForegroundColor-0d7_KjU(), (float)(1.0f - amount));
            backgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)backgroundFill, (long)contributionScheme.getBackgroundFillColor-0d7_KjU(), (float)(1.0f - amount));
            accentedBackgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)accentedBackgroundFill, (long)contributionScheme.getAccentedBackgroundFillColor-0d7_KjU(), (float)(1.0f - amount));
            focusRing = ColorUtilsKt.interpolateTowards-jxsXWHM((long)focusRing, (long)contributionScheme.getFocusRingColor-0d7_KjU(), (float)(1.0f - amount));
            line = ColorUtilsKt.interpolateTowards-jxsXWHM((long)line, (long)contributionScheme.getLineColor-0d7_KjU(), (float)(1.0f - amount));
            selectionForeground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)selectionForeground, (long)contributionScheme.getSelectionForegroundColor-0d7_KjU(), (float)(1.0f - amount));
            selectionBackground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)selectionBackground, (long)contributionScheme.getSelectionBackgroundColor-0d7_KjU(), (float)(1.0f - amount));
            textBackgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)textBackgroundFill, (long)contributionScheme.getTextBackgroundFillColor-0d7_KjU(), (float)(1.0f - amount));
            separatorPrimary = ColorUtilsKt.interpolateTowards-jxsXWHM((long)separatorPrimary, (long)contributionScheme.getSeparatorPrimaryColor-0d7_KjU(), (float)(1.0f - amount));
            separatorSecondary = ColorUtilsKt.interpolateTowards-jxsXWHM((long)separatorSecondary, (long)contributionScheme.getSeparatorSecondaryColor-0d7_KjU(), (float)(1.0f - amount));
            mark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)mark, (long)contributionScheme.getMarkColor-0d7_KjU(), (float)(1.0f - amount));
            echo = ColorUtilsKt.interpolateTowards-jxsXWHM((long)echo, (long)contributionScheme.getEchoColor-0d7_KjU(), (float)(1.0f - amount));
        }
        colorScheme.setUltraLight-8_81llA(ultraLight);
        colorScheme.setExtraLight-8_81llA(extraLight);
        colorScheme.setLight-8_81llA(light);
        colorScheme.setMid-8_81llA(mid);
        colorScheme.setDark-8_81llA(dark);
        colorScheme.setUltraDark-8_81llA(ultraDark);
        colorScheme.setForeground-8_81llA(foreground);
        colorScheme.setBackgroundFill-8_81llA(backgroundFill);
        colorScheme.setAccentedBackgroundFill-8_81llA(accentedBackgroundFill);
        colorScheme.setFocusRing-8_81llA(focusRing);
        colorScheme.setLine-8_81llA(line);
        colorScheme.setSelectionForeground-8_81llA(selectionForeground);
        colorScheme.setSelectionBackground-8_81llA(selectionBackground);
        colorScheme.setTextBackgroundFill-8_81llA(textBackgroundFill);
        colorScheme.setSeparatorPrimary-8_81llA(separatorPrimary);
        colorScheme.setSeparatorSecondary-8_81llA(separatorSecondary);
        colorScheme.setMark-8_81llA(mark);
        colorScheme.setEcho-8_81llA(echo);
    }

    @Composable
    public static final void populateColorSchemeWithHighlightAlpha(@NotNull MutableColorScheme colorScheme, @NotNull ModelStateInfo modelStateInfo, @NotNull ComponentState currState, @NotNull DecorationAreaType decorationAreaType, @NotNull ColorSchemeAssociationKind associationKind, @Nullable Composer $composer, int $changed) {
        Object var53_19;
        Object v0;
        float f;
        AuroraColorScheme currStateScheme;
        AuroraSkinColors skinColors;
        block3: {
            Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
            Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
            Intrinsics.checkNotNullParameter((Object)currState, (String)"currState");
            Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
            Intrinsics.checkNotNullParameter((Object)associationKind, (String)"associationKind");
            $composer = $composer.startRestartGroup(-675566910);
            skinColors = AuroraSkin.INSTANCE.getColors($composer, 8);
            currStateScheme = skinColors.getColorScheme(decorationAreaType, associationKind, currState);
            float currHighlightAlpha = skinColors.getHighlightAlpha(decorationAreaType, currState);
            Iterable iterable = modelStateInfo.getStateContributionMap().entrySet();
            f = currHighlightAlpha;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)currState)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Object v1 = var53_19 = v0;
        Intrinsics.checkNotNull(v1);
        float currHighlightAmount = f * ((StateContributionInfo)((Map.Entry)v1).getValue()).getContribution();
        long ultraLight = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getUltraLightColor-0d7_KjU(), (float)currHighlightAmount);
        long extraLight = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getExtraLightColor-0d7_KjU(), (float)currHighlightAmount);
        long light = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getLightColor-0d7_KjU(), (float)currHighlightAmount);
        long mid = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getMidColor-0d7_KjU(), (float)currHighlightAmount);
        long dark = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getDarkColor-0d7_KjU(), (float)currHighlightAmount);
        long ultraDark = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getUltraDarkColor-0d7_KjU(), (float)currHighlightAmount);
        long foreground = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getForegroundColor-0d7_KjU(), (float)currHighlightAmount);
        long backgroundFill = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getBackgroundFillColor-0d7_KjU(), (float)currHighlightAmount);
        long accentedBackgroundFill = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getAccentedBackgroundFillColor-0d7_KjU(), (float)currHighlightAmount);
        long focusRing = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getFocusRingColor-0d7_KjU(), (float)currHighlightAmount);
        long line = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getLineColor-0d7_KjU(), (float)currHighlightAmount);
        long selectionForeground = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getSelectionForegroundColor-0d7_KjU(), (float)currHighlightAmount);
        long selectionBackground = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getSelectionBackgroundColor-0d7_KjU(), (float)currHighlightAmount);
        long textBackgroundFill = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getTextBackgroundFillColor-0d7_KjU(), (float)currHighlightAmount);
        long separatorPrimary = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getSeparatorPrimaryColor-0d7_KjU(), (float)currHighlightAmount);
        long separatorSecondary = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getSeparatorSecondaryColor-0d7_KjU(), (float)currHighlightAmount);
        long mark = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getMarkColor-0d7_KjU(), (float)currHighlightAmount);
        long echo = ColorUtilsKt.byAlpha-DxMtmZc((long)currStateScheme.getEchoColor-0d7_KjU(), (float)currHighlightAmount);
        for (Map.Entry<ComponentState, StateContributionInfo> contribution : modelStateInfo.getStateContributionMap().entrySet()) {
            float alpha;
            float amount;
            if (Intrinsics.areEqual((Object)contribution.getKey(), (Object)currState) || (amount = (alpha = skinColors.getHighlightAlpha(decorationAreaType, contribution.getKey())) * contribution.getValue().getContribution()) == 0.0f) continue;
            AuroraColorScheme contributionScheme = skinColors.getColorScheme(decorationAreaType, associationKind, contribution.getKey());
            ultraLight = ColorUtilsKt.interpolateTowards-jxsXWHM((long)ultraLight, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getUltraLightColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            extraLight = ColorUtilsKt.interpolateTowards-jxsXWHM((long)extraLight, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getExtraLightColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            light = ColorUtilsKt.interpolateTowards-jxsXWHM((long)light, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getLightColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            mid = ColorUtilsKt.interpolateTowards-jxsXWHM((long)mid, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getMidColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            dark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)dark, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getDarkColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            ultraDark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)ultraDark, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getUltraDarkColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            foreground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)foreground, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getForegroundColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            backgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)backgroundFill, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getBackgroundFillColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            accentedBackgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)accentedBackgroundFill, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getAccentedBackgroundFillColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            focusRing = ColorUtilsKt.interpolateTowards-jxsXWHM((long)focusRing, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getFocusRingColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            line = ColorUtilsKt.interpolateTowards-jxsXWHM((long)line, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getLineColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            selectionForeground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)selectionForeground, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getSelectionForegroundColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            selectionBackground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)selectionBackground, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getSelectionBackgroundColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            textBackgroundFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)textBackgroundFill, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getTextBackgroundFillColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            separatorPrimary = ColorUtilsKt.interpolateTowards-jxsXWHM((long)separatorPrimary, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getSeparatorPrimaryColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            separatorSecondary = ColorUtilsKt.interpolateTowards-jxsXWHM((long)separatorSecondary, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getSeparatorSecondaryColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            mark = ColorUtilsKt.interpolateTowards-jxsXWHM((long)mark, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getMarkColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
            echo = ColorUtilsKt.interpolateTowards-jxsXWHM((long)echo, (long)ColorUtilsKt.byAlpha-DxMtmZc((long)contributionScheme.getEchoColor-0d7_KjU(), (float)amount), (float)(1.0f - amount));
        }
        colorScheme.setUltraLight-8_81llA(ultraLight);
        colorScheme.setExtraLight-8_81llA(extraLight);
        colorScheme.setLight-8_81llA(light);
        colorScheme.setMid-8_81llA(mid);
        colorScheme.setDark-8_81llA(dark);
        colorScheme.setUltraDark-8_81llA(ultraDark);
        colorScheme.setForeground-8_81llA(foreground);
        colorScheme.setBackgroundFill-8_81llA(backgroundFill);
        colorScheme.setAccentedBackgroundFill-8_81llA(accentedBackgroundFill);
        colorScheme.setFocusRing-8_81llA(focusRing);
        colorScheme.setLine-8_81llA(line);
        colorScheme.setSelectionForeground-8_81llA(selectionForeground);
        colorScheme.setSelectionBackground-8_81llA(selectionBackground);
        colorScheme.setTextBackgroundFill-8_81llA(textBackgroundFill);
        colorScheme.setSeparatorPrimary-8_81llA(separatorPrimary);
        colorScheme.setSeparatorSecondary-8_81llA(separatorSecondary);
        colorScheme.setMark-8_81llA(mark);
        colorScheme.setEcho-8_81llA(echo);
        ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
        if (scopeUpdateScope != null) {
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(colorScheme, modelStateInfo, currState, decorationAreaType, associationKind, $changed){
                final /* synthetic */ MutableColorScheme $colorScheme;
                final /* synthetic */ ModelStateInfo $modelStateInfo;
                final /* synthetic */ ComponentState $currState;
                final /* synthetic */ DecorationAreaType $decorationAreaType;
                final /* synthetic */ ColorSchemeAssociationKind $associationKind;
                final /* synthetic */ int $$changed;
                {
                    this.$colorScheme = $colorScheme;
                    this.$modelStateInfo = $modelStateInfo;
                    this.$currState = $currState;
                    this.$decorationAreaType = $decorationAreaType;
                    this.$associationKind = $associationKind;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    ColorSchemeUtilsKt.populateColorSchemeWithHighlightAlpha(this.$colorScheme, this.$modelStateInfo, this.$currState, this.$decorationAreaType, this.$associationKind, $composer, this.$$changed | 1);
                }
            });
        }
    }

    @Composable
    public static final long getStateAwareColor(@NotNull ModelStateInfo modelStateInfo, @NotNull ComponentState currState, @NotNull DecorationAreaType decorationAreaType, @NotNull ColorSchemeAssociationKind associationKind, @NotNull Function1<? super AuroraColorScheme, Color> query, @Nullable Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter((Object)currState, (String)"currState");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)associationKind, (String)"associationKind");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        $composer.startReplaceableGroup(-52977640);
        AuroraColorScheme currStateScheme = AuroraSkin.INSTANCE.getColors($composer, 8).getColorScheme(decorationAreaType, associationKind, currState);
        long result2 = ((Color)query.invoke((Object)currStateScheme)).unbox-impl();
        if (currState.isDisabled() || modelStateInfo.getStateContributionMap().size() == 1) {
            long l = result2;
            $composer.endReplaceableGroup();
            return l;
        }
        Iterator<Map.Entry<ComponentState, StateContributionInfo>> iterator = modelStateInfo.getStateContributionMap().entrySet().iterator();
        while (iterator.hasNext()) {
            $composer.startReplaceableGroup(-52976983);
            Map.Entry<ComponentState, StateContributionInfo> contribution = iterator.next();
            if (Intrinsics.areEqual((Object)contribution.getKey(), (Object)currState)) {
                $composer.endReplaceableGroup();
                continue;
            }
            float amount = contribution.getValue().getContribution();
            if (amount == 0.0f) {
                $composer.endReplaceableGroup();
                continue;
            }
            AuroraColorScheme contributionScheme = AuroraSkin.INSTANCE.getColors($composer, 8).getColorScheme(decorationAreaType, associationKind, contribution.getKey());
            result2 = ColorUtilsKt.interpolateTowards-jxsXWHM((long)result2, (long)((Color)query.invoke((Object)contributionScheme)).unbox-impl(), (float)(1.0f - amount));
            $composer.endReplaceableGroup();
        }
        long l = result2;
        $composer.endReplaceableGroup();
        return l;
    }

    public static final long getTextColor(@NotNull ModelStateInfo modelStateInfo, @NotNull ComponentState currState, @NotNull AuroraSkinColors skinColors, @NotNull DecorationAreaType decorationAreaType, @NotNull ColorSchemeAssociationKind colorSchemeAssociationKind, boolean isTextInFilledArea) {
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter((Object)currState, (String)"currState");
        Intrinsics.checkNotNullParameter((Object)skinColors, (String)"skinColors");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)colorSchemeAssociationKind, (String)"colorSchemeAssociationKind");
        Map<ComponentState, StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        ComponentState tweakedCurrState = currState;
        if (!isTextInFilledArea) {
            tweakedCurrState = currState.isDisabled() ? ComponentState.Companion.getDisabledUnselected() : ComponentState.Companion.getEnabled();
            activeStates = null;
        }
        AuroraColorScheme colorScheme = skinColors.getColorScheme(decorationAreaType, colorSchemeAssociationKind, tweakedCurrState);
        long foreground = 0L;
        if (tweakedCurrState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            foreground = colorScheme.getForegroundColor-0d7_KjU();
        } else {
            float aggrRed = 0.0f;
            float aggrGreen = 0.0f;
            float aggrBlue = 0.0f;
            for (Map.Entry<ComponentState, StateContributionInfo> entry : activeStates.entrySet()) {
                ComponentState activeState = entry.getKey();
                StateContributionInfo value = entry.getValue();
                float contribution = value.getContribution();
                AuroraColorScheme activeColorScheme = skinColors.getColorScheme(decorationAreaType, colorSchemeAssociationKind, activeState);
                long activeForeground = activeColorScheme.getForegroundColor-0d7_KjU();
                aggrRed += contribution * Color.getRed-impl((long)activeForeground);
                aggrGreen += contribution * Color.getGreen-impl((long)activeForeground);
                aggrBlue += contribution * Color.getBlue-impl((long)activeForeground);
            }
            foreground = ColorKt.Color$default((float)aggrRed, (float)aggrGreen, (float)aggrBlue, (float)1.0f, null, (int)16, null);
        }
        float baseAlpha = skinColors.getAlpha(decorationAreaType, tweakedCurrState);
        if (baseAlpha < 1.0f) {
            AuroraColorScheme backgroundColorScheme = skinColors.getColorScheme(decorationAreaType, tweakedCurrState.isDisabled() ? ComponentState.Companion.getDisabledUnselected() : ComponentState.Companion.getEnabled());
            long bgFillColor = backgroundColorScheme.getBackgroundFillColor-0d7_KjU();
            foreground = ColorUtilsKt.interpolateTowards-jxsXWHM((long)foreground, (long)bgFillColor, (float)baseAlpha);
        }
        return foreground;
    }

    public static final long getTextSelectionBackground(@NotNull ModelStateInfo modelStateInfo, @NotNull ComponentState currState, @NotNull AuroraSkinColors skinColors, @NotNull DecorationAreaType decorationAreaType) {
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter((Object)currState, (String)"currState");
        Intrinsics.checkNotNullParameter((Object)skinColors, (String)"skinColors");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Map<ComponentState, StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        ComponentState tweakedCurrState = currState;
        if (Intrinsics.areEqual((Object)currState, (Object)ComponentState.Companion.getEnabled())) {
            tweakedCurrState = ComponentState.Companion.getSelected();
        }
        long result2 = skinColors.getColorScheme(decorationAreaType, tweakedCurrState).getTextBackgroundFillColor-0d7_KjU();
        if (!tweakedCurrState.isDisabled() && activeStates.size() > 1) {
            for (Map.Entry<ComponentState, StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == tweakedCurrState) continue;
                if (activeState == ComponentState.Companion.getEnabled()) {
                    activeState = ComponentState.Companion.getSelected();
                }
                if ((contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = skinColors.getAlpha(decorationAreaType, activeState)) == 0.0f) continue;
                long active = skinColors.getColorScheme(decorationAreaType, activeState).getTextBackgroundFillColor-0d7_KjU();
                result2 = ColorUtilsKt.interpolateTowards-jxsXWHM((long)result2, (long)active, (float)(1.0f - contribution * alpha));
            }
        }
        return result2;
    }

    public static final long getTextFillBackground(@NotNull ModelStateInfo modelStateInfo, @NotNull ComponentState currState, @NotNull AuroraSkinColors skinColors, @NotNull DecorationAreaType decorationAreaType) {
        Intrinsics.checkNotNullParameter((Object)modelStateInfo, (String)"modelStateInfo");
        Intrinsics.checkNotNullParameter((Object)currState, (String)"currState");
        Intrinsics.checkNotNullParameter((Object)skinColors, (String)"skinColors");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        ComponentState stateForQuery = currState.isDisabled() ? ComponentState.Companion.getDisabledUnselected() : ComponentState.Companion.getEnabled();
        AuroraColorScheme fillColorScheme = skinColors.getColorScheme(decorationAreaType, ColorSchemeAssociationKind.Companion.getFill(), stateForQuery);
        long textBackgroundFillColor = fillColorScheme.getTextBackgroundFillColor-0d7_KjU();
        float lightnessFactor = fillColorScheme.isDark() ? 0.1f : 0.4f;
        long lighterFill = ColorUtilsKt.lighter-DxMtmZc((long)textBackgroundFillColor, (float)lightnessFactor);
        lighterFill = ColorUtilsKt.interpolateTowards-jxsXWHM((long)lighterFill, (long)textBackgroundFillColor, (float)0.6f);
        float selectionStrength = modelStateInfo.strength(ComponentStateFacet.Companion.getSelection());
        float rolloverStrength = modelStateInfo.strength(ComponentStateFacet.Companion.getRollover());
        float activeStrength = Math.max(selectionStrength, rolloverStrength) / 4.0f;
        textBackgroundFillColor = ColorUtilsKt.interpolateTowards-jxsXWHM((long)lighterFill, (long)textBackgroundFillColor, (float)activeStrength);
        return textBackgroundFillColor;
    }
}

