/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.common.AuroraInternalApi;
import org.pushingpixels.aurora.component.utils.StateContributionInfo;
import org.pushingpixels.aurora.theming.ComponentState;
import org.pushingpixels.aurora.theming.ComponentStateFacet;
import org.pushingpixels.aurora.theming.ModelStateInfoSnapshot;

@AuroraInternalApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/pushingpixels/aurora/component/utils/ModelStateInfo;", "", "startModelState", "Lorg/pushingpixels/aurora/theming/ComponentState;", "(Lorg/pushingpixels/aurora/theming/ComponentState;)V", "activeStrength", "", "getActiveStrength", "()F", "setActiveStrength", "(F)V", "stateContributionMap", "", "Lorg/pushingpixels/aurora/component/utils/StateContributionInfo;", "getStateContributionMap", "()Ljava/util/Map;", "setStateContributionMap", "(Ljava/util/Map;)V", "clear", "", "currModelState", "dumpState", "stateTransitionPosition", "getSnapshot", "Lorg/pushingpixels/aurora/theming/ModelStateInfoSnapshot;", "strength", "facet", "Lorg/pushingpixels/aurora/theming/ComponentStateFacet;", "sync", "updateActiveStates", "position", "component"})
@StabilityInferred(parameters=0)
public final class ModelStateInfo {
    @NotNull
    private Map<ComponentState, StateContributionInfo> stateContributionMap;
    private float activeStrength;
    public static final int $stable = 8;

    public ModelStateInfo(@NotNull ComponentState startModelState) {
        Intrinsics.checkNotNullParameter((Object)startModelState, (String)"startModelState");
        this.activeStrength = 0.0f;
        this.stateContributionMap = new HashMap();
        Map<ComponentState, StateContributionInfo> map = this.stateContributionMap;
        StateContributionInfo stateContributionInfo = new StateContributionInfo(1.0f, 1.0f);
        boolean bl = false;
        map.put(startModelState, stateContributionInfo);
        this.sync();
    }

    @NotNull
    public final Map<ComponentState, StateContributionInfo> getStateContributionMap() {
        return this.stateContributionMap;
    }

    public final void setStateContributionMap(@NotNull Map<ComponentState, StateContributionInfo> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.stateContributionMap = map;
    }

    public final float getActiveStrength() {
        return this.activeStrength;
    }

    public final void setActiveStrength(float f) {
        this.activeStrength = f;
    }

    public final void sync() {
        this.activeStrength = 0.0f;
        Object object = this.stateContributionMap;
        boolean bl = false;
        Iterator<Map.Entry<ComponentState, StateContributionInfo>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            ComponentState activeState = (ComponentState)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            StateContributionInfo value = (StateContributionInfo)object3.getValue();
            if (!activeState.isActive()) continue;
            object3 = this;
            ((ModelStateInfo)object3).activeStrength += value.getContribution();
        }
    }

    public final float strength(@NotNull ComponentStateFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        float result2 = 0.0f;
        Object object = this.stateContributionMap;
        boolean bl = false;
        Iterator<Map.Entry<ComponentState, StateContributionInfo>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            ComponentState activeState = (ComponentState)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            StateContributionInfo value = (StateContributionInfo)object3.getValue();
            if (!activeState.isFacetActive(facet)) continue;
            result2 += value.getContribution();
        }
        return result2;
    }

    public final void clear(@NotNull ComponentState currModelState) {
        Intrinsics.checkNotNullParameter((Object)currModelState, (String)"currModelState");
        this.stateContributionMap.clear();
        Map<ComponentState, StateContributionInfo> map = this.stateContributionMap;
        StateContributionInfo stateContributionInfo = new StateContributionInfo(1.0f, 1.0f);
        boolean bl = false;
        map.put(currModelState, stateContributionInfo);
        this.sync();
    }

    public final void updateActiveStates(float position) {
        for (StateContributionInfo pair : this.stateContributionMap.values()) {
            pair.updateContribution(position);
        }
        this.sync();
    }

    public final void dumpState(@NotNull ComponentState currModelState, float stateTransitionPosition) {
        Intrinsics.checkNotNullParameter((Object)currModelState, (String)"currModelState");
        Object object = "######";
        boolean bl = false;
        System.out.println(object);
        object = "Curr state " + currModelState + ", position " + stateTransitionPosition;
        bl = false;
        System.out.println(object);
        Object object2 = this.stateContributionMap;
        boolean bl2 = false;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            Object object3 = object2 = object.next();
            boolean bl3 = false;
            ComponentState state = (ComponentState)object3.getKey();
            Object object4 = object2;
            boolean bl4 = false;
            StateContributionInfo currRange = (StateContributionInfo)object4.getValue();
            object4 = "\t " + state + " at " + currRange.getContribution() + " [" + currRange.getStart() + "-" + currRange.getEnd() + "]";
            bl4 = false;
            System.out.println(object4);
        }
        object = "\tActive strength " + this.activeStrength;
        boolean bl5 = false;
        System.out.println(object);
        object = "######";
        bl5 = false;
        System.out.println(object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ModelStateInfoSnapshot getSnapshot(@NotNull ComponentState currModelState) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)currModelState, (String)"currModelState");
        Map<ComponentState, StateContributionInfo> map = this.stateContributionMap;
        ComponentState componentState = currModelState;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$key$value;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_14 = $dstr$key$value;
            boolean bl3 = false;
            ComponentState key = (ComponentState)var13_14.getKey();
            void var14_15 = $dstr$key$value;
            boolean bl4 = false;
            StateContributionInfo value = (StateContributionInfo)var14_15.getValue();
            Pair pair = TuplesKt.to((Object)key, (Object)Float.valueOf(value.getContribution()));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        float f = this.activeStrength;
        Map map2 = MapsKt.toMap((Iterable)collection);
        ComponentState componentState2 = componentState;
        return new ModelStateInfoSnapshot(componentState2, map2, f);
    }
}

