/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.layout;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpRect;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.component.layout.CommandButtonLayoutManager;
import org.pushingpixels.aurora.component.layout.CommandButtonSizingConstants;
import org.pushingpixels.aurora.component.model.Command;
import org.pushingpixels.aurora.component.model.CommandButtonKind;
import org.pushingpixels.aurora.component.model.CommandButtonPresentationModel;
import org.pushingpixels.aurora.component.model.HorizontalAlignment;
import org.pushingpixels.aurora.component.model.SeparatorSizingConstants;
import org.pushingpixels.aurora.component.model.TextClick;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J0\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b&\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManagerSmall;", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "_density", "Landroidx/compose/ui/unit/Density;", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/TextStyle;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "density", "", "getDensity", "()F", "fontScale", "getFontScale", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutInfo", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonLayoutInfo;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "command", "Lorg/pushingpixels/aurora/component/model/Command;", "presentationModel", "Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;", "preLayoutInfo", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;", "getLayoutInfo-jYbf7pk", "(JLorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;)Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonLayoutInfo;", "getPreLayoutInfo", "getPreferredIconSize", "Landroidx/compose/ui/unit/Dp;", "getPreferredIconSize-chRvn1I", "(Lorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;)F", "getPreferredSize", "Landroidx/compose/ui/geometry/Size;", "getPreferredSize-bSu-EZI", "(Lorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;)J", "component"})
public class CommandButtonLayoutManagerSmall
implements CommandButtonLayoutManager {
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private final Density _density;
    @NotNull
    private final TextStyle textStyle;
    @NotNull
    private final Font.ResourceLoader resourceLoader;
    private final float density;
    private final float fontScale;

    public CommandButtonLayoutManagerSmall(@NotNull LayoutDirection layoutDirection, @NotNull Density _density, @NotNull TextStyle textStyle, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)_density, (String)"_density");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.layoutDirection = layoutDirection;
        this._density = _density;
        this.textStyle = textStyle;
        this.resourceLoader = resourceLoader;
        this.density = this._density.getDensity();
        this.fontScale = this._density.getFontScale();
    }

    @NotNull
    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public float getDensity() {
        return this.density;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    @Override
    public float getPreferredIconSize-chRvn1I(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        int $this$dp$iv = 16;
        boolean $i$f$getDp = false;
        return Dp.constructor-impl((float)$this$dp$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getPreferredSize-bSu-EZI(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel, @NotNull CommandButtonLayoutManager.CommandButtonPreLayoutInfo preLayoutInfo) {
        void other$iv;
        void arg0$iv;
        void arg0$iv2;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)preLayoutInfo, (String)"preLayoutInfo");
        PaddingValues paddingValues = presentationModel.getContentPadding();
        float f = paddingValues.calculateTopPadding-D9Ej5fM();
        float other$iv2 = paddingValues.calculateBottomPadding-D9Ej5fM();
        boolean $i$f$plus-5rwHm252 = false;
        float by = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv2 + other$iv2)));
        other$iv2 = CommandButtonSizingConstants.INSTANCE.getDefaultHorizontalContentLayoutGap-D9Ej5fM();
        float $i$f$plus-5rwHm252 = presentationModel.getHorizontalGapScaleFactor();
        boolean bl = false;
        float layoutHGap = this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv * other$iv)));
        boolean hasIcon = command.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon();
        boolean hasPopup = command.getSecondaryContentModel() != null;
        float prefIconSize = this.toPx-0680j_4(this.getPreferredIconSize-chRvn1I(command, presentationModel));
        float width = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        if (hasPopup) {
            width += (float)2 * layoutHGap;
            width += 1.0f + this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
            width += (float)2 * layoutHGap;
        }
        if (preLayoutInfo.getCommandButtonKind().getHasAction() & preLayoutInfo.getCommandButtonKind().getHasPopup()) {
            width += this.toPx-0680j_4(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM());
        }
        width += presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateEndPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
        return SizeKt.Size((float)(width -= (float)2 * layoutHGap), (float)(by + prefIconSize));
    }

    @Override
    @NotNull
    public CommandButtonLayoutManager.CommandButtonPreLayoutInfo getPreLayoutInfo(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel) {
        boolean hasPopup;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        boolean hasAction = command.getAction() != null;
        boolean bl = hasPopup = command.getSecondaryContentModel() != null;
        CommandButtonKind commandButtonKind = hasAction && hasPopup ? (presentationModel.getTextClick() == TextClick.Action ? CommandButtonKind.ActionAndPopupMainAction : CommandButtonKind.ActionAndPopupMainPopup) : (hasPopup ? CommandButtonKind.PopupOnly : CommandButtonKind.ActionOnly);
        return new CommandButtonLayoutManager.CommandButtonPreLayoutInfo(commandButtonKind, command.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), hasAction | command.isActionToggle() && presentationModel.getTextClick() == TextClick.Action, CommandButtonLayoutManager.CommandButtonSeparatorOrientation.Vertical, commandButtonKind.getHasPopup());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo-jYbf7pk(long constraints, @NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel, @NotNull CommandButtonLayoutManager.CommandButtonPreLayoutInfo preLayoutInfo) {
        void other$iv;
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)preLayoutInfo, (String)"preLayoutInfo");
        long preferredSize = this.getPreferredSize-bSu-EZI(command, presentationModel, preLayoutInfo);
        float paddingTop = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(presentationModel.getContentPadding().calculateTopPadding-D9Ej5fM());
        float paddingBottom = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(presentationModel.getContentPadding().calculateBottomPadding-D9Ej5fM());
        float f = CommandButtonSizingConstants.INSTANCE.getDefaultHorizontalContentLayoutGap-D9Ej5fM();
        float f2 = presentationModel.getHorizontalGapScaleFactor();
        boolean bl = false;
        float layoutHGap = this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv * other$iv)));
        boolean hasIcon = command.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon();
        boolean hasPopup = command.getSecondaryContentModel() != null;
        float iconSize = this.toPx-0680j_4(this.getPreferredIconSize-chRvn1I(command, presentationModel));
        boolean ltr = this.getLayoutDirection() == LayoutDirection.Ltr;
        Rect iconRect = Rect.Companion.getZero();
        Rect popupActionRect = Rect.Companion.getZero();
        float shiftX = 0.0f;
        float finalWidth = Size.getWidth-impl((long)preferredSize);
        float finalHeight = Size.getHeight-impl((long)preferredSize);
        if (Constraints.getHasFixedWidth-impl((long)constraints) && Constraints.getMaxWidth-impl((long)constraints) > 0 && (finalWidth = (float)Constraints.getMaxWidth-impl((long)constraints)) > Size.getWidth-impl((long)preferredSize)) {
            HorizontalAlignment horizontalAlignment = presentationModel.getHorizontalAlignment();
            int n = WhenMappings.$EnumSwitchMapping$0[horizontalAlignment.ordinal()];
            switch (n) {
                case 1: {
                    shiftX = 0.0f;
                    break;
                }
                case 2: {
                    shiftX = (finalWidth - Size.getWidth-impl((long)preferredSize)) / (float)2;
                    break;
                }
                case 3: {
                    if (!ltr) break;
                    shiftX = finalWidth - Size.getWidth-impl((long)preferredSize);
                }
            }
        }
        if (finalWidth < this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM())) {
            shiftX += (this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM()) - finalWidth) / 2.0f;
            finalWidth = this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM());
        }
        if (Constraints.getHasFixedHeight-impl((long)constraints) && Constraints.getMaxHeight-impl((long)constraints) > 0) {
            finalHeight = Constraints.getMaxHeight-impl((long)constraints);
        }
        PaddingValues paddingValues = presentationModel.getContentPadding();
        Rect actionClickArea = Rect.Companion.getZero();
        Rect popupClickArea = Rect.Companion.getZero();
        Rect separatorArea = Rect.Companion.getZero();
        float verticalSeparatorWidth = this.toPx-0680j_4(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM());
        if (ltr) {
            float f3;
            float f4;
            float f5;
            float f6;
            float x = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection())) + shiftX - layoutHGap;
            if (hasIcon) {
                float iconTop = paddingTop + (finalHeight - iconSize - paddingTop - paddingBottom) / (float)2;
                float f7 = x += layoutHGap;
                f6 = x + iconSize;
                f5 = iconTop + iconSize;
                iconRect = new Rect(f7, iconTop, f6, f5);
                x += iconSize + layoutHGap;
            }
            if (hasPopup) {
                float popupIconWidth = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
                float popupIconHeight = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconHeight-D9Ej5fM());
                f6 = x += (float)2 * layoutHGap;
                f5 = x + popupIconWidth;
                f4 = (finalHeight - popupIconHeight) / 2.0f - 1.0f;
                f3 = (finalHeight - popupIconHeight) / 2.0f + popupIconHeight + 1.0f;
                popupActionRect = new Rect(f6, f4, f5, f3);
                x += (float)2 * layoutHGap;
            }
            float xBorderBetweenActionAndPopup = 0.0f;
            CommandButtonKind popupIconHeight = preLayoutInfo.getCommandButtonKind();
            int n = WhenMappings.$EnumSwitchMapping$1[popupIconHeight.ordinal()];
            switch (n) {
                case 1: {
                    actionClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 2: {
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 3: 
                case 4: {
                    if (hasIcon) {
                        popupActionRect = popupActionRect.translate(verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = iconRect.getRight() + layoutHGap;
                        actionClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        popupClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        f5 = xBorderBetweenActionAndPopup;
                        f4 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        f3 = finalHeight;
                        separatorArea = new Rect(f5, 0.0f, f4, f3);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                }
            }
        } else {
            float f8;
            float f9;
            float f10;
            float f11;
            float popupIconHeight;
            float x = finalWidth - presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection())) - shiftX;
            if (hasIcon) {
                float iconTop = paddingTop + (finalHeight - iconSize - paddingTop - paddingBottom) / (float)2;
                popupIconHeight = x - iconSize;
                f11 = x;
                f10 = iconTop + iconSize;
                iconRect = new Rect(popupIconHeight, iconTop, f11, f10);
                x -= iconSize + layoutHGap;
            }
            if (hasPopup) {
                float popupIconWidth = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
                popupIconHeight = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconHeight-D9Ej5fM());
                f11 = (x -= (float)2 * layoutHGap) - popupIconWidth;
                f10 = x;
                f9 = (finalHeight - popupIconHeight) / 2.0f - 1.0f;
                f8 = (finalHeight - popupIconHeight) / 2.0f + popupIconHeight + 1.0f;
                popupActionRect = new Rect(f11, f9, f10, f8);
                x -= (float)2 * layoutHGap;
            }
            float xBorderBetweenActionAndPopup = 0.0f;
            CommandButtonKind commandButtonKind = preLayoutInfo.getCommandButtonKind();
            int n = WhenMappings.$EnumSwitchMapping$1[commandButtonKind.ordinal()];
            switch (n) {
                case 1: {
                    actionClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 2: {
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 3: 
                case 4: {
                    if (hasIcon) {
                        popupActionRect = popupActionRect.translate(-verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = iconRect.getLeft() - layoutHGap;
                        actionClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        popupClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        f10 = xBorderBetweenActionAndPopup;
                        f9 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        f8 = finalHeight;
                        separatorArea = new Rect(f10, 0.0f, f9, f8);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                }
            }
        }
        return new CommandButtonLayoutManager.CommandButtonLayoutInfo(SizeKt.Size((float)finalWidth, (float)finalHeight), actionClickArea, popupClickArea, separatorArea, iconRect, CollectionsKt.emptyList(), CollectionsKt.emptyList(), popupActionRect, null);
    }

    @Stable
    public long toDpSize-k-rfVVM(long $this$toDpSize_u2dk_u2drfVVM) {
        return CommandButtonLayoutManager.DefaultImpls.toDpSize-k-rfVVM(this, $this$toDpSize_u2dk_u2drfVVM);
    }

    @Stable
    public int roundToPx-0680j_4(float $this$roundToPx_u2d0680j_4) {
        return CommandButtonLayoutManager.DefaultImpls.roundToPx-0680j_4(this, $this$roundToPx_u2d0680j_4);
    }

    @Stable
    public float toPx-0680j_4(float $this$toPx_u2d0680j_4) {
        return CommandButtonLayoutManager.DefaultImpls.toPx-0680j_4(this, $this$toPx_u2d0680j_4);
    }

    @Stable
    public long toSp-0xMU5do(float $this$toSp_u2d0xMU5do) {
        return CommandButtonLayoutManager.DefaultImpls.toSp-0xMU5do(this, $this$toSp_u2d0xMU5do);
    }

    @Stable
    @NotNull
    public Rect toRect(@NotNull DpRect $this$toRect) {
        return CommandButtonLayoutManager.DefaultImpls.toRect(this, $this$toRect);
    }

    @Stable
    public long toSize-XkaWNTQ(long $this$toSize_u2dXkaWNTQ) {
        return CommandButtonLayoutManager.DefaultImpls.toSize-XkaWNTQ(this, $this$toSize_u2dXkaWNTQ);
    }

    @Stable
    public int roundToPx--R2X_6o(long $this$roundToPx_u2d_u2dR2X_6o) {
        return CommandButtonLayoutManager.DefaultImpls.roundToPx--R2X_6o(this, $this$roundToPx_u2d_u2dR2X_6o);
    }

    @Stable
    public float toDp-GaN1DYA(long $this$toDp_u2dGaN1DYA) {
        return CommandButtonLayoutManager.DefaultImpls.toDp-GaN1DYA(this, $this$toDp_u2dGaN1DYA);
    }

    @Stable
    public float toPx--R2X_6o(long $this$toPx_u2d_u2dR2X_6o) {
        return CommandButtonLayoutManager.DefaultImpls.toPx--R2X_6o(this, $this$toPx_u2d_u2dR2X_6o);
    }

    @Stable
    public float toDp-u2uoSUM(float $this$toDp_u2du2uoSUM) {
        return CommandButtonLayoutManager.DefaultImpls.toDp-u2uoSUM((CommandButtonLayoutManager)this, $this$toDp_u2du2uoSUM);
    }

    @Stable
    public long toSp-kPz2Gy4(float $this$toSp_u2dkPz2Gy4) {
        return CommandButtonLayoutManager.DefaultImpls.toSp-kPz2Gy4((CommandButtonLayoutManager)this, $this$toSp_u2dkPz2Gy4);
    }

    @Stable
    public float toDp-u2uoSUM(int $this$toDp_u2du2uoSUM) {
        return CommandButtonLayoutManager.DefaultImpls.toDp-u2uoSUM((CommandButtonLayoutManager)this, $this$toDp_u2du2uoSUM);
    }

    @Stable
    public long toSp-kPz2Gy4(int $this$toSp_u2dkPz2Gy4) {
        return CommandButtonLayoutManager.DefaultImpls.toSp-kPz2Gy4((CommandButtonLayoutManager)this, $this$toSp_u2dkPz2Gy4);
    }

    @NotNull
    public MeasureResult layout(int width, int height, @NotNull Map<AlignmentLine, Integer> alignmentLines, @NotNull Function1<? super Placeable.PlacementScope, Unit> placementBlock) {
        return CommandButtonLayoutManager.DefaultImpls.layout(this, width, height, alignmentLines, placementBlock);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.Leading.ordinal()] = 1;
            nArray[HorizontalAlignment.Center.ordinal()] = 2;
            nArray[HorizontalAlignment.Trailing.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CommandButtonKind.values().length];
            nArray[CommandButtonKind.ActionOnly.ordinal()] = 1;
            nArray[CommandButtonKind.PopupOnly.ordinal()] = 2;
            nArray[CommandButtonKind.ActionAndPopupMainAction.ordinal()] = 3;
            nArray[CommandButtonKind.ActionAndPopupMainPopup.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

