/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.utils;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposablesKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.CompositionLocalContext;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.SkippableUpdater;
import androidx.compose.runtime.Updater;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.awt.ComposeWindow;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutKt;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.node.ComposeUiNode;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.platform.ViewConfiguration;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.FrameWindowScope;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pushingpixels.aurora.common.AuroraPopupManager;
import org.pushingpixels.aurora.component.model.HorizontalAlignment;
import org.pushingpixels.aurora.component.model.IconContentModel;
import org.pushingpixels.aurora.component.model.IconPresentationModel;
import org.pushingpixels.aurora.component.model.LabelContentModel;
import org.pushingpixels.aurora.component.model.LabelPresentationModel;
import org.pushingpixels.aurora.component.model.RichTooltip;
import org.pushingpixels.aurora.component.model.RichTooltipPresentationModel;
import org.pushingpixels.aurora.component.model.RichTooltipSizingConstants;
import org.pushingpixels.aurora.component.model.SeparatorPresentationModel;
import org.pushingpixels.aurora.component.model.SeparatorSizingConstants;
import org.pushingpixels.aurora.component.projection.HorizontalSeparatorProjection;
import org.pushingpixels.aurora.component.projection.IconProjection;
import org.pushingpixels.aurora.component.projection.LabelProjection;
import org.pushingpixels.aurora.component.utils.CommandMenuPopupContentKt;
import org.pushingpixels.aurora.component.utils.RichTooltipBackground;
import org.pushingpixels.aurora.component.utils.RichTooltipLayoutInfo;
import org.pushingpixels.aurora.theming.AuroraPainters;
import org.pushingpixels.aurora.theming.AuroraSkin;
import org.pushingpixels.aurora.theming.AuroraSkinKt;
import org.pushingpixels.aurora.theming.ColorSchemeAssociationKind;
import org.pushingpixels.aurora.theming.ComponentState;
import org.pushingpixels.aurora.theming.DecorationAreaType;
import org.pushingpixels.aurora.theming.PopupPlacementStrategy;
import org.pushingpixels.aurora.theming.colorscheme.AuroraColorScheme;
import org.pushingpixels.aurora.theming.colorscheme.AuroraSkinColors;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0003\u00a2\u0006\u0002\u0010\u000e\u001a%\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003\u00a2\u0006\u0002\u0010\u0012\u001ap\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0000\u001a\u0011\u0010+\u001a\u00020,*\u00020,H\u0003\u00a2\u0006\u0002\u0010-\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006."}, d2={"hasDescriptionContent", "", "Lorg/pushingpixels/aurora/component/model/RichTooltip;", "getHasDescriptionContent", "(Lorg/pushingpixels/aurora/component/model/RichTooltip;)Z", "hasFooterContent", "getHasFooterContent", "hasFooterSections", "getHasFooterSections", "RichTooltipContent", "", "richTooltip", "richTooltipPresentationModel", "Lorg/pushingpixels/aurora/component/model/RichTooltipPresentationModel;", "(Lorg/pushingpixels/aurora/component/model/RichTooltip;Lorg/pushingpixels/aurora/component/model/RichTooltipPresentationModel;Landroidx/compose/runtime/Composer;I)V", "TopLevelRichTooltipContent", "tooltipLayoutInfo", "Lorg/pushingpixels/aurora/component/utils/RichTooltipLayoutInfo;", "(Lorg/pushingpixels/aurora/component/model/RichTooltip;Lorg/pushingpixels/aurora/component/model/RichTooltipPresentationModel;Lorg/pushingpixels/aurora/component/utils/RichTooltipLayoutInfo;Landroidx/compose/runtime/Composer;I)V", "displayRichTooltipContent", "currentWindow", "Landroidx/compose/ui/awt/ComposeWindow;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "skinColors", "Lorg/pushingpixels/aurora/theming/colorscheme/AuroraSkinColors;", "skinPainters", "Lorg/pushingpixels/aurora/theming/AuroraPainters;", "decorationAreaType", "Lorg/pushingpixels/aurora/theming/DecorationAreaType;", "compositionLocalContext", "Landroidx/compose/runtime/CompositionLocalContext;", "anchorBoundsInWindow", "Landroidx/compose/ui/geometry/Rect;", "presentationModel", "popupPlacementStrategy", "Lorg/pushingpixels/aurora/theming/PopupPlacementStrategy;", "richTooltipBackground", "Landroidx/compose/ui/Modifier;", "(Landroidx/compose/ui/Modifier;Landroidx/compose/runtime/Composer;I)Landroidx/compose/ui/Modifier;", "component"})
public final class RichTooltipPopupContentKt {
    public static final boolean getHasDescriptionContent(@NotNull RichTooltip $this$hasDescriptionContent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasDescriptionContent, (String)"<this>");
        List<String> list = $this$hasDescriptionContent.getDescriptionSections();
        if (list == null) {
            bl = false;
        } else {
            boolean bl2;
            Collection collection = list;
            boolean bl3 = false;
            bl = bl2 = !collection.isEmpty();
        }
        return bl;
    }

    public static final boolean getHasFooterSections(@NotNull RichTooltip $this$hasFooterSections) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasFooterSections, (String)"<this>");
        List<String> list = $this$hasFooterSections.getFooterSections();
        if (list == null) {
            bl = false;
        } else {
            boolean bl2;
            Collection collection = list;
            boolean bl3 = false;
            bl = bl2 = !collection.isEmpty();
        }
        return bl;
    }

    public static final boolean getHasFooterContent(@NotNull RichTooltip $this$hasFooterContent) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFooterContent, (String)"<this>");
        return $this$hasFooterContent.getFooterIcon() != null || RichTooltipPopupContentKt.getHasFooterSections($this$hasFooterContent);
    }

    /*
     * WARNING - void declaration
     */
    public static final void displayRichTooltipContent(@NotNull ComposeWindow currentWindow, @NotNull LayoutDirection layoutDirection, @NotNull Density density, @NotNull TextStyle textStyle, @NotNull Font.ResourceLoader resourceLoader, @NotNull AuroraSkinColors skinColors, @NotNull AuroraPainters skinPainters, @NotNull DecorationAreaType decorationAreaType, @NotNull CompositionLocalContext compositionLocalContext, @NotNull Rect anchorBoundsInWindow, @NotNull RichTooltip richTooltip, @NotNull RichTooltipPresentationModel presentationModel, @NotNull PopupPlacementStrategy popupPlacementStrategy) {
        Rectangle rectangle;
        Collection descriptionParagraph;
        void other$iv;
        void arg0$iv;
        float other$iv2;
        void arg0$iv2;
        Intrinsics.checkNotNullParameter((Object)currentWindow, (String)"currentWindow");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)skinColors, (String)"skinColors");
        Intrinsics.checkNotNullParameter((Object)skinPainters, (String)"skinPainters");
        Intrinsics.checkNotNullParameter((Object)decorationAreaType, (String)"decorationAreaType");
        Intrinsics.checkNotNullParameter((Object)compositionLocalContext, (String)"compositionLocalContext");
        Intrinsics.checkNotNullParameter((Object)anchorBoundsInWindow, (String)"anchorBoundsInWindow");
        Intrinsics.checkNotNullParameter((Object)richTooltip, (String)"richTooltip");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)popupPlacementStrategy, (String)"popupPlacementStrategy");
        ComposeWindow popupContentWindow = new ComposeWindow(null, 1, null);
        popupContentWindow.setFocusableWindowState(false);
        popupContentWindow.setType(Window.Type.POPUP);
        popupContentWindow.setAlwaysOnTop(true);
        popupContentWindow.setUndecorated(true);
        popupContentWindow.setResizable(false);
        Point locationOnScreen = currentWindow.getLocationOnScreen();
        float f = density.getDensity();
        boolean bl = false;
        int offset = (int)Math.ceil(f);
        TextStyle boldTextStyle = TextStyleKt.resolveDefaults((TextStyle)new TextStyle(0L, textStyle.getFontSize-XSAIIZE(), FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 0L, null, 262137, null), (LayoutDirection)layoutDirection);
        float f2 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateLeftPadding-u2uoSUM(layoutDirection);
        float f3 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateRightPadding-u2uoSUM(layoutDirection);
        boolean $i$f$plus-5rwHm252 = false;
        float horizontalPaddingPx = Dp.constructor-impl((float)(arg0$iv2 + other$iv2)) * density.getDensity();
        other$iv2 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateTopPadding-D9Ej5fM();
        float $i$f$plus-5rwHm252 = RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateBottomPadding-D9Ej5fM();
        boolean bl2 = false;
        float verticalPaddingPx = Dp.constructor-impl((float)(arg0$iv + other$iv)) * density.getDensity();
        int verticalGapPx = (int)(RichTooltipSizingConstants.INSTANCE.getVerticalContentLayoutGap-D9Ej5fM() * density.getDensity());
        int horizontalGapPx = (int)(RichTooltipSizingConstants.INSTANCE.getHorizontalContentLayoutGap-D9Ej5fM() * density.getDensity());
        float maxContentWidthPx = RichTooltipSizingConstants.INSTANCE.getMaxWidth-D9Ej5fM() * density.getDensity() - horizontalPaddingPx;
        Paragraph titleParagraph = ParagraphKt.Paragraph$default((String)richTooltip.getTitle(), (TextStyle)boldTextStyle, null, null, (int)0, (boolean)false, (float)maxContentWidthPx, (Density)density, (Font.ResourceLoader)resourceLoader, (int)60, null);
        float fullContentWidth = 0.0f;
        float fullContentHeight = titleParagraph.getHeight();
        float titleWidth = 0.0f;
        if (titleParagraph.getLineCount() > 1) {
            titleWidth = maxContentWidthPx;
            fullContentWidth = maxContentWidthPx;
        } else {
            fullContentWidth = titleWidth = titleParagraph.getMaxIntrinsicWidth();
        }
        float mainIconSize = richTooltip.getMainIcon() == null ? 0.0f : presentationModel.getMainIconSize-D9Ej5fM() * density.getDensity();
        ArrayList<Size> descriptionSizes = new ArrayList<Size>();
        float descriptionTextHeightPx = 0.0f;
        if (RichTooltipPopupContentKt.getHasDescriptionContent(richTooltip)) {
            fullContentWidth = maxContentWidthPx;
            List<String> list = richTooltip.getDescriptionSections();
            Intrinsics.checkNotNull(list);
            Collection collection = list;
            boolean bl3 = false;
            descriptionTextHeightPx += (float)(verticalGapPx * (collection.size() - 1));
            float maxDescriptionWidthPx = richTooltip.getMainIcon() == null ? maxContentWidthPx : maxContentWidthPx - mainIconSize - (float)horizontalGapPx;
            for (String descriptionSection : richTooltip.getDescriptionSections()) {
                descriptionParagraph = ParagraphKt.Paragraph$default((String)descriptionSection, (TextStyle)textStyle, null, null, (int)0, (boolean)false, (float)maxDescriptionWidthPx, (Density)density, (Font.ResourceLoader)resourceLoader, (int)60, null);
                descriptionTextHeightPx += descriptionParagraph.getHeight();
                descriptionSizes.add(Size.box-impl((long)SizeKt.Size((float)maxDescriptionWidthPx, (float)descriptionParagraph.getHeight())));
            }
        }
        if (mainIconSize > 0.0f || descriptionTextHeightPx > 0.0f) {
            fullContentHeight += (float)verticalGapPx;
            boolean maxDescriptionWidthPx = false;
            fullContentHeight += Math.max(mainIconSize, descriptionTextHeightPx);
        }
        if (RichTooltipPopupContentKt.getHasFooterContent(richTooltip)) {
            fullContentHeight += (float)verticalGapPx;
            fullContentHeight += SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM() * density.getDensity();
            fullContentHeight += (float)verticalGapPx;
        }
        float footerIconSize = richTooltip.getFooterIcon() == null ? 0.0f : presentationModel.getFooterIconSize-D9Ej5fM() * density.getDensity();
        ArrayList<Size> footerSizes = new ArrayList<Size>();
        float footerTextHeightPx = 0.0f;
        if (RichTooltipPopupContentKt.getHasFooterSections(richTooltip)) {
            fullContentWidth = maxContentWidthPx;
            List<String> list = richTooltip.getFooterSections();
            Intrinsics.checkNotNull(list);
            descriptionParagraph = list;
            boolean bl4 = false;
            footerTextHeightPx += (float)(verticalGapPx * (descriptionParagraph.size() - 1));
            float maxFooterWidthPx = richTooltip.getFooterIcon() == null ? maxContentWidthPx : maxContentWidthPx - footerIconSize - (float)horizontalGapPx;
            for (String footerSection : richTooltip.getFooterSections()) {
                Paragraph footerParagraph322 = ParagraphKt.Paragraph$default((String)footerSection, (TextStyle)textStyle, null, null, (int)0, (boolean)false, (float)maxFooterWidthPx, (Density)density, (Font.ResourceLoader)resourceLoader, (int)60, null);
                footerTextHeightPx += footerParagraph322.getHeight();
                footerSizes.add(Size.box-impl((long)SizeKt.Size((float)maxFooterWidthPx, (float)footerParagraph322.getHeight())));
            }
        }
        boolean maxFooterWidthPx = false;
        fullContentHeight += Math.max(footerIconSize, footerTextHeightPx);
        long l = SizeKt.Size((float)((fullContentWidth += horizontalPaddingPx) + (float)(2 * offset)), (float)((fullContentHeight += verticalPaddingPx) + (float)(2 * offset)));
        long footerParagraph322 = SizeKt.Size((float)titleWidth, (float)titleParagraph.getHeight());
        long l2 = richTooltip.getMainIcon() == null ? Size.Companion.getZero-NH-jbRc() : SizeKt.Size((float)(presentationModel.getMainIconSize-D9Ej5fM() * density.getDensity()), (float)(presentationModel.getMainIconSize-D9Ej5fM() * density.getDensity()));
        long l3 = !RichTooltipPopupContentKt.getHasFooterContent(richTooltip) ? Size.Companion.getZero-NH-jbRc() : SizeKt.Size((float)(fullContentWidth - horizontalPaddingPx), (float)(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM() * density.getDensity()));
        long l4 = richTooltip.getFooterIcon() == null ? Size.Companion.getZero-NH-jbRc() : SizeKt.Size((float)(presentationModel.getFooterIconSize-D9Ej5fM() * density.getDensity()), (float)(presentationModel.getFooterIconSize-D9Ej5fM() * density.getDensity()));
        RichTooltipLayoutInfo tooltipLayoutInfo = new RichTooltipLayoutInfo(l, l2, footerParagraph322, descriptionSizes, l3, l4, footerSizes, null);
        float footerSection = fullContentWidth / density.getDensity();
        boolean footerParagraph322 = false;
        int fullPopupWidth = (int)Math.ceil(footerSection) + 4;
        float footerParagraph322 = fullContentHeight / density.getDensity();
        boolean bl5 = false;
        int fullPopupHeight = (int)Math.ceil(footerParagraph322) + 4;
        int initialAnchorX = layoutDirection == LayoutDirection.Ltr ? (int)((float)locationOnScreen.x + anchorBoundsInWindow.getLeft()) : (int)((float)locationOnScreen.x + anchorBoundsInWindow.getLeft() + anchorBoundsInWindow.getWidth()) - fullPopupWidth;
        long initialAnchor = IntOffsetKt.IntOffset((int)initialAnchorX, (int)((int)((float)locationOnScreen.y + anchorBoundsInWindow.getTop())));
        PopupPlacementStrategy popupPlacementStrategy2 = popupPlacementStrategy;
        int n = WhenMappings.$EnumSwitchMapping$0[popupPlacementStrategy2.ordinal()];
        switch (n) {
            case 1: {
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor), IntOffset.getY-impl((long)initialAnchor) + (int)anchorBoundsInWindow.getHeight(), fullPopupWidth, fullPopupHeight);
                break;
            }
            case 2: {
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor), IntOffset.getY-impl((long)initialAnchor) - fullPopupHeight, fullPopupWidth, fullPopupHeight);
                break;
            }
            case 3: {
                if (layoutDirection == LayoutDirection.Ltr) {
                    rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) - fullPopupWidth, IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                    break;
                }
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) + fullPopupWidth, IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                break;
            }
            case 4: {
                if (layoutDirection == LayoutDirection.Ltr) {
                    rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) + (int)anchorBoundsInWindow.getWidth(), IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                    break;
                }
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor) - (int)anchorBoundsInWindow.getWidth(), IntOffset.getY-impl((long)initialAnchor), fullPopupWidth, fullPopupHeight);
                break;
            }
            case 5: {
                rectangle = new Rectangle(IntOffset.getX-impl((long)initialAnchor), IntOffset.getY-impl((long)initialAnchor) + (int)anchorBoundsInWindow.getHeight() / 2 - fullPopupHeight / 2, fullPopupWidth, fullPopupHeight);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Rectangle popupRect = rectangle;
        Rectangle screenBounds = popupContentWindow.getGraphicsConfiguration().getBounds();
        if (popupRect.x < 0) {
            popupRect.translate(-popupRect.x, 0);
        }
        if (popupRect.x + popupRect.width > screenBounds.width) {
            popupRect.translate(screenBounds.width - popupRect.x - popupRect.width, 0);
        }
        if (popupRect.y < 0) {
            popupRect.translate(0, -popupRect.y);
        }
        if (popupRect.y + popupRect.height > screenBounds.height) {
            popupRect.translate(0, screenBounds.height - popupRect.y - popupRect.height);
        }
        popupContentWindow.setBounds(popupRect);
        AuroraColorScheme borderScheme = skinColors.getColorScheme(DecorationAreaType.Companion.getNone(), ColorSchemeAssociationKind.Companion.getBorder(), ComponentState.Companion.getEnabled());
        long popupBorderColor = skinPainters.getBorderPainter().getRepresentativeColor-vNxB06k(borderScheme);
        java.awt.Color awtBorderColor = CommandMenuPopupContentKt.getAwtColor-8_81llA(popupBorderColor);
        long fillColor = skinColors.getBackgroundColorScheme(decorationAreaType).getBackgroundFillColor-0d7_KjU();
        java.awt.Color awtFillColor = CommandMenuPopupContentKt.getAwtColor-8_81llA(fillColor);
        float borderThickness = 1.0f / density.getDensity();
        popupContentWindow.getRootPane().setBorder(new Border(awtFillColor, awtBorderColor, borderThickness){
            final /* synthetic */ java.awt.Color $awtFillColor;
            final /* synthetic */ java.awt.Color $awtBorderColor;
            final /* synthetic */ float $borderThickness;
            {
                this.$awtFillColor = $awtFillColor;
                this.$awtBorderColor = $awtBorderColor;
                this.$borderThickness = $borderThickness;
            }

            public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                if (graphics == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2d.setColor(this.$awtFillColor);
                g2d.fill(new Rectangle(0, 0, width, height));
                float thickness = 0.5f;
                g2d.setStroke(new BasicStroke(thickness, 0, 1));
                g2d.setColor(this.$awtBorderColor);
                g2d.draw(new Rectangle2D.Float(this.$borderThickness / 2.0f, this.$borderThickness / 2.0f, (float)width - this.$borderThickness, (float)height - this.$borderThickness));
                g2d.dispose();
            }

            @NotNull
            public Insets getBorderInsets(@Nullable Component c) {
                return new Insets(1, 1, 1, 1);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        });
        popupContentWindow.setCompositionLocalContext(compositionLocalContext);
        popupContentWindow.setContent((Function3)ComposableLambdaKt.composableLambdaInstance((int)-985542881, (boolean)true, (Object)new Function3<FrameWindowScope, Composer, Integer, Unit>(layoutDirection, richTooltip, presentationModel, tooltipLayoutInfo){
            final /* synthetic */ LayoutDirection $layoutDirection;
            final /* synthetic */ RichTooltip $richTooltip;
            final /* synthetic */ RichTooltipPresentationModel $presentationModel;
            final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
            {
                this.$layoutDirection = $layoutDirection;
                this.$richTooltip = $richTooltip;
                this.$presentationModel = $presentationModel;
                this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                super(3);
            }

            @Composable
            public final void invoke(@NotNull FrameWindowScope $this$setContent, @Nullable Composer $composer, int $changed) {
                Intrinsics.checkNotNullParameter((Object)$this$setContent, (String)"$this$setContent");
                ProvidedValue[] providedValueArray = new ProvidedValue[]{CompositionLocalsKt.getLocalLayoutDirection().provides((Object)this.$layoutDirection)};
                CompositionLocalKt.CompositionLocalProvider((ProvidedValue[])providedValueArray, (Function2)((Function2)ComposableLambdaKt.composableLambda((Composer)$composer, (int)-819898336, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this.$richTooltip, this.$presentationModel, this.$tooltipLayoutInfo){
                    final /* synthetic */ RichTooltip $richTooltip;
                    final /* synthetic */ RichTooltipPresentationModel $presentationModel;
                    final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
                    {
                        this.$richTooltip = $richTooltip;
                        this.$presentationModel = $presentationModel;
                        this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                        super(2);
                    }

                    @Composable
                    public final void invoke(@Nullable Composer $composer, int $changed) {
                        if (($changed & 0xB ^ 2) != 0 || !$composer.getSkipping()) {
                            RichTooltipPopupContentKt.access$TopLevelRichTooltipContent(this.$richTooltip, this.$presentationModel, this.$tooltipLayoutInfo, $composer, 520);
                        } else {
                            $composer.skipToGroupEnd();
                        }
                    }
                })), (Composer)$composer, (int)56);
            }
        }));
        popupContentWindow.invalidate();
        popupContentWindow.validate();
        popupContentWindow.setVisible(true);
        AuroraPopupManager.hidePopups$default((AuroraPopupManager)AuroraPopupManager.INSTANCE, (ComposeWindow)currentWindow, null, (int)2, null);
        AuroraPopupManager.INSTANCE.addPopup(currentWindow, popupContentWindow, AuroraPopupManager.PopupKind.RICH_TOOLTIP);
    }

    @Composable
    private static final Modifier richTooltipBackground(Modifier $this$richTooltipBackground, Composer $composer, int $changed) {
        $composer.startReplaceableGroup(1426848923);
        Modifier modifier = $this$richTooltipBackground.then((Modifier)new RichTooltipBackground(AuroraSkin.INSTANCE.getDecorationAreaType($composer, 8), AuroraSkin.INSTANCE.getColors($composer, 8)));
        $composer.endReplaceableGroup();
        return modifier;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    private static final void TopLevelRichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, RichTooltipLayoutInfo tooltipLayoutInfo, Composer $composer, int $changed) {
        void $changed2;
        void $changed$iv$iv;
        void skippableUpdate$iv$iv;
        void $changed$iv;
        Function0 this_$iv$iv;
        void this_$iv$iv2;
        void this_$iv$iv3;
        void this_$iv;
        void this_$iv22;
        $composer = $composer.startRestartGroup(-352471090);
        int $dirty = $changed;
        CompositionLocal compositionLocal = (CompositionLocal)CompositionLocalsKt.getLocalDensity();
        boolean $changed$iv22 = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)103361330, (String)"C:CompositionLocal.kt#9igjgp");
        Object object = $composer.consume((CompositionLocal)this_$iv22);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        float this_$iv22 = ((Density)object).getDensity();
        $changed$iv22 = false;
        int offset = (int)Math.ceil(this_$iv22);
        CompositionLocal $changed$iv22 = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        boolean $changed$iv3 = false;
        boolean $i$f$getCurrent2 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)103361330, (String)"C:CompositionLocal.kt#9igjgp");
        Object object2 = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        LayoutDirection layoutDirection = (LayoutDirection)object2;
        Modifier modifier = RichTooltipPopupContentKt.richTooltipBackground((Modifier)Modifier.Companion, $composer, 6);
        MeasurePolicy measurePolicy2 = new MeasurePolicy(tooltipLayoutInfo, richTooltip, offset, layoutDirection){
            final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
            final /* synthetic */ RichTooltip $richTooltip;
            final /* synthetic */ int $offset;
            final /* synthetic */ LayoutDirection $layoutDirection;
            {
                this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                this.$richTooltip = $richTooltip;
                this.$offset = $offset;
                this.$layoutDirection = $layoutDirection;
            }

            @NotNull
            public final MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$Layout, @NotNull List<? extends Measurable> measurables, long $noName_1) {
                int n;
                int index;
                int n2;
                Intrinsics.checkNotNullParameter((Object)$this$Layout, (String)"$this$Layout");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                int verticalGapPx = (int)$this$Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getVerticalContentLayoutGap-D9Ej5fM());
                int horizontalGapPx = (int)$this$Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getHorizontalContentLayoutGap-D9Ej5fM());
                int placeableIndex = 0;
                Ref.ObjectRef iconPlaceable = new Ref.ObjectRef();
                int n3 = placeableIndex;
                placeableIndex = n3 + 1;
                Placeable titlePlaceable = measurables.get(n3).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getTitleSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getTitleSize-NH-jbRc())));
                if (this.$richTooltip.getMainIcon() != null) {
                    n3 = placeableIndex;
                    placeableIndex = n3 + 1;
                    iconPlaceable.element = measurables.get(n3).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getMainIconSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getMainIconSize-NH-jbRc())));
                }
                ArrayList<Placeable> descriptionPlaceables = new ArrayList<Placeable>();
                if (RichTooltipPopupContentKt.getHasDescriptionContent(this.$richTooltip)) {
                    int n4 = 0;
                    List<String> list = this.$richTooltip.getDescriptionSections();
                    Intrinsics.checkNotNull(list);
                    n2 = list.size();
                    if (n4 < n2) {
                        do {
                            index = n4++;
                            n = placeableIndex;
                            placeableIndex = n + 1;
                            descriptionPlaceables.add(measurables.get(n).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getDescriptionSizes().get(index).unbox-impl()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getDescriptionSizes().get(index).unbox-impl()))));
                        } while (n4 < n2);
                    }
                }
                Ref.ObjectRef footerSeparatorPlaceable = new Ref.ObjectRef();
                if (RichTooltipPopupContentKt.getHasFooterContent(this.$richTooltip)) {
                    n2 = placeableIndex;
                    placeableIndex = n2 + 1;
                    footerSeparatorPlaceable.element = measurables.get(n2).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFooterSeparatorSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFooterSeparatorSize-NH-jbRc())));
                }
                Ref.ObjectRef footerIconPlaceable = new Ref.ObjectRef();
                if (this.$richTooltip.getFooterIcon() != null) {
                    index = placeableIndex;
                    placeableIndex = index + 1;
                    footerIconPlaceable.element = measurables.get(index).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFooterIconSize-NH-jbRc()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFooterIconSize-NH-jbRc())));
                }
                ArrayList<Placeable> footerPlaceables = new ArrayList<Placeable>();
                if (RichTooltipPopupContentKt.getHasFooterSections(this.$richTooltip)) {
                    n = 0;
                    List<String> list = this.$richTooltip.getFooterSections();
                    Intrinsics.checkNotNull(list);
                    int n5 = list.size();
                    if (n < n5) {
                        do {
                            int index2 = n++;
                            int n6 = placeableIndex;
                            placeableIndex = n6 + 1;
                            footerPlaceables.add(measurables.get(n6).measure-BRTryo0(Constraints.Companion.fixed-JhjzzOo((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFooterSizes().get(index2).unbox-impl()), (int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFooterSizes().get(index2).unbox-impl()))));
                        } while (n < n5);
                    }
                }
                return MeasureScope.DefaultImpls.layout$default((MeasureScope)$this$Layout, (int)((int)Size.getWidth-impl((long)this.$tooltipLayoutInfo.getFullSize-NH-jbRc())), (int)((int)Size.getHeight-impl((long)this.$tooltipLayoutInfo.getFullSize-NH-jbRc())), null, (Function1)((Function1)new Function1<Placeable.PlacementScope, Unit>(this.$offset, $this$Layout, this.$layoutDirection, titlePlaceable, (Ref.ObjectRef<Placeable>)iconPlaceable, descriptionPlaceables, verticalGapPx, horizontalGapPx, this.$richTooltip, (Ref.ObjectRef<Placeable>)footerSeparatorPlaceable, (Ref.ObjectRef<Placeable>)footerIconPlaceable, footerPlaceables){
                    final /* synthetic */ int $offset;
                    final /* synthetic */ MeasureScope $this_Layout;
                    final /* synthetic */ LayoutDirection $layoutDirection;
                    final /* synthetic */ Placeable $titlePlaceable;
                    final /* synthetic */ Ref.ObjectRef<Placeable> $iconPlaceable;
                    final /* synthetic */ ArrayList<Placeable> $descriptionPlaceables;
                    final /* synthetic */ int $verticalGapPx;
                    final /* synthetic */ int $horizontalGapPx;
                    final /* synthetic */ RichTooltip $richTooltip;
                    final /* synthetic */ Ref.ObjectRef<Placeable> $footerSeparatorPlaceable;
                    final /* synthetic */ Ref.ObjectRef<Placeable> $footerIconPlaceable;
                    final /* synthetic */ ArrayList<Placeable> $footerPlaceables;
                    {
                        this.$offset = $offset;
                        this.$this_Layout = $this_Layout;
                        this.$layoutDirection = $layoutDirection;
                        this.$titlePlaceable = $titlePlaceable;
                        this.$iconPlaceable = $iconPlaceable;
                        this.$descriptionPlaceables = $descriptionPlaceables;
                        this.$verticalGapPx = $verticalGapPx;
                        this.$horizontalGapPx = $horizontalGapPx;
                        this.$richTooltip = $richTooltip;
                        this.$footerSeparatorPlaceable = $footerSeparatorPlaceable;
                        this.$footerIconPlaceable = $footerIconPlaceable;
                        this.$footerPlaceables = $footerPlaceables;
                        super(1);
                    }

                    public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                        int y;
                        int x;
                        int left;
                        block11: {
                            block10: {
                                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                                left = this.$offset + (int)this.$this_Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateLeftPadding-u2uoSUM(this.$layoutDirection));
                                int top = this.$offset + (int)this.$this_Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getContentPadding().calculateTopPadding-D9Ej5fM());
                                Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)this.$titlePlaceable, (int)left, (int)top, (float)0.0f, (int)4, null);
                                x = left;
                                y = top + this.$titlePlaceable.getHeight();
                                if (this.$iconPlaceable.element != null) break block10;
                                Collection collection = this.$descriptionPlaceables;
                                boolean bl = false;
                                if (!(!collection.isEmpty())) break block11;
                            }
                            y += this.$verticalGapPx;
                        }
                        int iconBottom = y;
                        if (this.$iconPlaceable.element != null) {
                            Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)((Placeable)this.$iconPlaceable.element), (int)x, (int)y, (float)0.0f, (int)4, null);
                            x += ((Placeable)this.$iconPlaceable.element).getWidth() + this.$horizontalGapPx;
                            iconBottom = y + ((Placeable)this.$iconPlaceable.element).getHeight();
                        }
                        Iterator<Placeable> iterator = this.$descriptionPlaceables;
                        boolean bl = false;
                        if (!iterator.isEmpty()) {
                            for (Placeable descriptionPlaceable : this.$descriptionPlaceables) {
                                Intrinsics.checkNotNullExpressionValue((Object)descriptionPlaceable, (String)"descriptionPlaceable");
                                Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)descriptionPlaceable, (int)x, (int)y, (float)0.0f, (int)4, null);
                                y += descriptionPlaceable.getHeight();
                                y += this.$verticalGapPx;
                            }
                            y -= this.$verticalGapPx;
                        }
                        y = RangesKt.coerceAtLeast((int)y, (int)iconBottom);
                        if (RichTooltipPopupContentKt.getHasFooterContent(this.$richTooltip)) {
                            Object object = this.$footerSeparatorPlaceable.element;
                            Intrinsics.checkNotNull((Object)object);
                            Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)((Placeable)object), (int)left, (int)(y += this.$verticalGapPx), (float)0.0f, (int)4, null);
                            y += ((Placeable)this.$footerSeparatorPlaceable.element).getHeight();
                            y += this.$verticalGapPx;
                        }
                        x = left;
                        if (this.$footerIconPlaceable.element != null) {
                            Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)((Placeable)this.$footerIconPlaceable.element), (int)left, (int)y, (float)0.0f, (int)4, null);
                            x += ((Placeable)this.$footerIconPlaceable.element).getWidth() + (int)this.$this_Layout.toPx-0680j_4(RichTooltipSizingConstants.INSTANCE.getHorizontalContentLayoutGap-D9Ej5fM());
                        }
                        iterator = this.$footerPlaceables;
                        boolean descriptionPlaceable = false;
                        if (!iterator.isEmpty()) {
                            for (Placeable footerPlaceable : this.$footerPlaceables) {
                                Intrinsics.checkNotNullExpressionValue((Object)footerPlaceable, (String)"footerPlaceable");
                                Placeable.PlacementScope.placeRelative$default((Placeable.PlacementScope)$this$layout, (Placeable)footerPlaceable, (int)x, (int)y, (float)0.0f, (int)4, null);
                                y += footerPlaceable.getHeight();
                                y += this.$verticalGapPx;
                            }
                        }
                    }
                }), (int)4, null);
            }

            public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull List<? extends IntrinsicMeasurable> measurables, int width) {
                return MeasurePolicy.DefaultImpls.maxIntrinsicHeight((MeasurePolicy)this, (IntrinsicMeasureScope)$this$maxIntrinsicHeight, measurables, (int)width);
            }

            public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull List<? extends IntrinsicMeasurable> measurables, int height) {
                return MeasurePolicy.DefaultImpls.maxIntrinsicWidth((MeasurePolicy)this, (IntrinsicMeasureScope)$this$maxIntrinsicWidth, measurables, (int)height);
            }

            public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull List<? extends IntrinsicMeasurable> measurables, int width) {
                return MeasurePolicy.DefaultImpls.minIntrinsicHeight((MeasurePolicy)this, (IntrinsicMeasureScope)$this$minIntrinsicHeight, measurables, (int)width);
            }

            public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull List<? extends IntrinsicMeasurable> measurables, int height) {
                return MeasurePolicy.DefaultImpls.minIntrinsicWidth((MeasurePolicy)this, (IntrinsicMeasureScope)$this$minIntrinsicWidth, measurables, (int)height);
            }
        };
        $i$f$getCurrent2 = false;
        boolean $i$f$Layout = false;
        $composer.startReplaceableGroup(1376089394);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(Layout)P(!1,2)72@2847L7,73@2902L7,74@2961L7,75@2973L460:Layout.kt#80mrfh");
        CompositionLocal compositionLocal2 = (CompositionLocal)CompositionLocalsKt.getLocalDensity();
        int $changed$iv$iv22 = 6;
        boolean $i$f$getCurrent3 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)103361330, (String)"C:CompositionLocal.kt#9igjgp");
        Object object3 = $composer.consume((CompositionLocal)this_$iv$iv3);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        Density density$iv = (Density)object3;
        CompositionLocal $changed$iv$iv22 = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        int $changed$iv$iv32 = 6;
        boolean $i$f$getCurrent4 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)103361330, (String)"C:CompositionLocal.kt#9igjgp");
        Object object4 = $composer.consume((CompositionLocal)this_$iv$iv2);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        LayoutDirection layoutDirection$iv = (LayoutDirection)object4;
        CompositionLocal $changed$iv$iv32 = (CompositionLocal)CompositionLocalsKt.getLocalViewConfiguration();
        int $changed$iv$iv42 = 6;
        int $i$f$getCurrent5 = 0;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)103361330, (String)"C:CompositionLocal.kt#9igjgp");
        Object object5 = $composer.consume((CompositionLocal)this_$iv$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        ViewConfiguration viewConfiguration$iv = (ViewConfiguration)object5;
        this_$iv$iv = ComposeUiNode.Companion.getConstructor();
        Function3 $changed$iv$iv42 = LayoutKt.materializerOf((Modifier)modifier);
        $i$f$getCurrent5 = 6 | 0x1C00 & $changed$iv << 9;
        boolean $i$f$ReusableComposeNode = false;
        if (!($composer.getApplier() instanceof Applier)) {
            ComposablesKt.invalidApplier();
        }
        $composer.startReusableNode();
        if ($composer.getInserting()) {
            void factory$iv$iv;
            $composer.createNode((Function0)factory$iv$iv);
        } else {
            $composer.useNode();
        }
        $composer.disableReusing();
        Composer $this$Layout_u24lambda_u2d0$iv = Updater.constructor-impl((Composer)$composer);
        boolean bl = false;
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)measurePolicy2, (Function2)ComposeUiNode.Companion.getSetMeasurePolicy());
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)density$iv, (Function2)ComposeUiNode.Companion.getSetDensity());
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)layoutDirection$iv, (Function2)ComposeUiNode.Companion.getSetLayoutDirection());
        Updater.set-impl((Composer)$this$Layout_u24lambda_u2d0$iv, (Object)viewConfiguration$iv, (Function2)ComposeUiNode.Companion.getSetViewConfiguration());
        $composer.enableReusing();
        skippableUpdate$iv$iv.invoke((Object)SkippableUpdater.box-impl((Composer)SkippableUpdater.constructor-impl((Composer)$composer)), (Object)$composer, (Object)(0x70 & $changed$iv$iv >> 3));
        $composer.startReplaceableGroup(2058660585);
        int n = 0xE & $changed$iv$iv >> 9;
        Composer $composer2 = $composer;
        boolean bl2 = false;
        if (($changed2 & 0xB ^ 2) != 0 || !$composer2.getSkipping()) {
            RichTooltipPopupContentKt.RichTooltipContent(richTooltip, richTooltipPresentationModel, $composer2, 8 | 0x70 & $dirty);
        } else {
            $composer2.skipToGroupEnd();
        }
        $composer.endReplaceableGroup();
        $composer.endNode();
        $composer.endReplaceableGroup();
        modifier = $composer.endRestartGroup();
        if (modifier != null) {
            modifier.updateScope((Function2)new Function2<Composer, Integer, Unit>(richTooltip, richTooltipPresentationModel, tooltipLayoutInfo, $changed){
                final /* synthetic */ RichTooltip $richTooltip;
                final /* synthetic */ RichTooltipPresentationModel $richTooltipPresentationModel;
                final /* synthetic */ RichTooltipLayoutInfo $tooltipLayoutInfo;
                final /* synthetic */ int $$changed;
                {
                    this.$richTooltip = $richTooltip;
                    this.$richTooltipPresentationModel = $richTooltipPresentationModel;
                    this.$tooltipLayoutInfo = $tooltipLayoutInfo;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    RichTooltipPopupContentKt.access$TopLevelRichTooltipContent(this.$richTooltip, this.$richTooltipPresentationModel, this.$tooltipLayoutInfo, $composer, this.$$changed | 1);
                }
            });
        }
    }

    @Composable
    private static final void RichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, Composer $composer, int $changed) {
        ScopeUpdateScope scopeUpdateScope;
        boolean $this$dp$iv;
        PaddingValues this_$iv;
        $composer = $composer.startRestartGroup(1202551080);
        TextStyle resolvedTextStyle = AuroraSkinKt.resolveAuroraDefaults((Composer)$composer, (int)0);
        TextStyle textStyle = new TextStyle(0L, resolvedTextStyle.getFontSize-XSAIIZE(), FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 0L, null, 262137, null);
        CompositionLocal compositionLocal = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        boolean $changed$iv = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)103361330, (String)"C:CompositionLocal.kt#9igjgp");
        Object object = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        TextStyle boldTextStyle = TextStyle.copy-HL5avdY$default((TextStyle)TextStyleKt.resolveDefaults((TextStyle)textStyle, (LayoutDirection)((LayoutDirection)object)), (long)Color.Companion.getUnspecified-0d7_KjU(), (long)0L, null, null, null, null, null, (long)0L, null, null, null, (long)0L, null, null, null, null, (long)0L, null, (int)262142, null);
        boolean $this$dp$iv2 = false;
        boolean $i$f$getDp = false;
        this_$iv = PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)((float)$this$dp$iv2)));
        new LabelProjection(new LabelContentModel(richTooltip.getTitle(), false, null, 6, null), new LabelPresentationModel(this_$iv, 0.0f, null, null, false, boldTextStyle, 0, false, 0, null, 0.0f, 2014, null)).project(null, $composer, 64, 1);
        $composer.startReplaceableGroup(1202552091);
        if (richTooltip.getMainIcon() != null) {
            new IconProjection(new IconContentModel(richTooltip.getMainIcon(), false, 2, null), new IconPresentationModel(richTooltipPresentationModel.getMainIconSize-D9Ej5fM(), null, null, false, 14, null)).project(null, $composer, 64, 1);
        }
        $composer.endReplaceableGroup();
        $composer.startReplaceableGroup(1202552399);
        if (RichTooltipPopupContentKt.getHasDescriptionContent(richTooltip)) {
            List<String> list = richTooltip.getDescriptionSections();
            Intrinsics.checkNotNull(list);
            for (String descriptionSection : list) {
                $this$dp$iv = false;
                boolean $i$f$getDp2 = false;
                new LabelProjection(new LabelContentModel(descriptionSection, false, null, 6, null), new LabelPresentationModel(PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)((float)$this$dp$iv))), 0.0f, null, null, false, null, 0, false, 0, HorizontalAlignment.Leading, 0.0f, 1534, null)).project(null, $composer, 64, 1);
            }
        }
        $composer.endReplaceableGroup();
        if (RichTooltipPopupContentKt.getHasFooterContent(richTooltip)) {
            int $this$dp$iv3 = 6;
            boolean $i$f$getDp3 = false;
            float f = Dp.constructor-impl((float)$this$dp$iv3);
            $this$dp$iv3 = 6;
            $i$f$getDp3 = false;
            new HorizontalSeparatorProjection(null, new SeparatorPresentationModel(f, Dp.constructor-impl((float)$this$dp$iv3), null), 1, null).project(null, $composer, 0, 1);
            $composer.startReplaceableGroup(1202553132);
            if (richTooltip.getFooterIcon() != null) {
                new IconProjection(new IconContentModel(richTooltip.getFooterIcon(), false, 2, null), new IconPresentationModel(richTooltipPresentationModel.getFooterIconSize-D9Ej5fM(), null, null, false, 14, null)).project(null, $composer, 64, 1);
            }
            $composer.endReplaceableGroup();
            if (RichTooltipPopupContentKt.getHasFooterSections(richTooltip)) {
                List<String> list = richTooltip.getFooterSections();
                Intrinsics.checkNotNull(list);
                for (String footerSection : list) {
                    $this$dp$iv = false;
                    boolean $i$f$getDp4 = false;
                    new LabelProjection(new LabelContentModel(footerSection, false, null, 6, null), new LabelPresentationModel(PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)((float)$this$dp$iv))), 0.0f, null, null, false, null, 0, false, 0, HorizontalAlignment.Leading, 0.0f, 1534, null)).project(null, $composer, 64, 1);
                }
            }
        }
        if ((scopeUpdateScope = $composer.endRestartGroup()) != null) {
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(richTooltip, richTooltipPresentationModel, $changed){
                final /* synthetic */ RichTooltip $richTooltip;
                final /* synthetic */ RichTooltipPresentationModel $richTooltipPresentationModel;
                final /* synthetic */ int $$changed;
                {
                    this.$richTooltip = $richTooltip;
                    this.$richTooltipPresentationModel = $richTooltipPresentationModel;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    RichTooltipPopupContentKt.access$RichTooltipContent(this.$richTooltip, this.$richTooltipPresentationModel, $composer, this.$$changed | 1);
                }
            });
        }
    }

    public static final /* synthetic */ void access$TopLevelRichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, RichTooltipLayoutInfo tooltipLayoutInfo, Composer $composer, int $changed) {
        RichTooltipPopupContentKt.TopLevelRichTooltipContent(richTooltip, richTooltipPresentationModel, tooltipLayoutInfo, $composer, $changed);
    }

    public static final /* synthetic */ void access$RichTooltipContent(RichTooltip richTooltip, RichTooltipPresentationModel richTooltipPresentationModel, Composer $composer, int $changed) {
        RichTooltipPopupContentKt.RichTooltipContent(richTooltip, richTooltipPresentationModel, $composer, $changed);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PopupPlacementStrategy.values().length];
            nArray[PopupPlacementStrategy.Downward.ordinal()] = 1;
            nArray[PopupPlacementStrategy.Upward.ordinal()] = 2;
            nArray[PopupPlacementStrategy.Startward.ordinal()] = 3;
            nArray[PopupPlacementStrategy.Endward.ordinal()] = 4;
            nArray[PopupPlacementStrategy.CenteredVertically.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

