/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.component.layout;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpRect;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.aurora.component.layout.CommandButtonLayoutManager;
import org.pushingpixels.aurora.component.layout.CommandButtonSizingConstants;
import org.pushingpixels.aurora.component.model.Command;
import org.pushingpixels.aurora.component.model.CommandButtonKind;
import org.pushingpixels.aurora.component.model.CommandButtonPresentationModel;
import org.pushingpixels.aurora.component.model.HorizontalAlignment;
import org.pushingpixels.aurora.component.model.SeparatorSizingConstants;
import org.pushingpixels.aurora.component.model.TextClick;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ5\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b$\u0010%J0\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006-"}, d2={"Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManagerMedium;", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "_density", "Landroidx/compose/ui/unit/Density;", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/TextStyle;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "density", "", "getDensity", "()F", "fontScale", "getFontScale", "iconTextGapFactor", "getIconTextGapFactor", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutInfo", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonLayoutInfo;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "command", "Lorg/pushingpixels/aurora/component/model/Command;", "presentationModel", "Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;", "preLayoutInfo", "Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;", "getLayoutInfo-jYbf7pk", "(JLorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;)Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonLayoutInfo;", "getPreLayoutInfo", "getPreferredIconSize", "Landroidx/compose/ui/unit/Dp;", "getPreferredIconSize-chRvn1I", "(Lorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;)F", "getPreferredSize", "Landroidx/compose/ui/geometry/Size;", "getPreferredSize-bSu-EZI", "(Lorg/pushingpixels/aurora/component/model/Command;Lorg/pushingpixels/aurora/component/model/CommandButtonPresentationModel;Lorg/pushingpixels/aurora/component/layout/CommandButtonLayoutManager$CommandButtonPreLayoutInfo;)J", "hasIcon", "", "hasIcon$component", "component"})
public class CommandButtonLayoutManagerMedium
implements CommandButtonLayoutManager {
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private final Density _density;
    @NotNull
    private final TextStyle textStyle;
    @NotNull
    private final Font.ResourceLoader resourceLoader;
    private final float density;
    private final float fontScale;

    public CommandButtonLayoutManagerMedium(@NotNull LayoutDirection layoutDirection, @NotNull Density _density, @NotNull TextStyle textStyle, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)_density, (String)"_density");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.layoutDirection = layoutDirection;
        this._density = _density;
        this.textStyle = textStyle;
        this.resourceLoader = resourceLoader;
        this.density = this._density.getDensity();
        this.fontScale = this._density.getFontScale();
    }

    @NotNull
    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public float getDensity() {
        return this.density;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    protected float getIconTextGapFactor() {
        return 1.0f;
    }

    @Override
    public float getPreferredIconSize-chRvn1I(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        int $this$dp$iv = 16;
        boolean $i$f$getDp = false;
        return Dp.constructor-impl((float)$this$dp$iv);
    }

    public boolean hasIcon$component(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        return command.getIcon() != null || presentationModel.getForceAllocateSpaceForIcon();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getPreferredSize-bSu-EZI(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel, @NotNull CommandButtonLayoutManager.CommandButtonPreLayoutInfo preLayoutInfo) {
        void other$iv;
        void arg0$iv;
        void arg0$iv2;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)preLayoutInfo, (String)"preLayoutInfo");
        PaddingValues paddingValues = presentationModel.getContentPadding();
        float f = paddingValues.calculateTopPadding-D9Ej5fM();
        float other$iv2 = paddingValues.calculateBottomPadding-D9Ej5fM();
        boolean $i$f$plus-5rwHm252 = false;
        float by = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv2 + other$iv2)));
        String buttonText = command.getText();
        float $i$f$plus-5rwHm252 = CommandButtonSizingConstants.INSTANCE.getDefaultHorizontalContentLayoutGap-D9Ej5fM();
        float f2 = presentationModel.getHorizontalGapScaleFactor();
        boolean bl = false;
        float layoutHGap = this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv * other$iv)));
        boolean hasIcon = this.hasIcon$component(command, presentationModel);
        boolean hasText = buttonText != null;
        boolean hasPopup = command.getSecondaryContentModel() != null;
        float prefIconSize = this.toPx-0680j_4(this.getPreferredIconSize-chRvn1I(command, presentationModel));
        float width = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        float textHeight = 0.0f;
        if (hasText) {
            width += hasIcon ? layoutHGap * this.getIconTextGapFactor() : layoutHGap;
            TextStyle textStyle = this.textStyle;
            Density density = this._density;
            Font.ResourceLoader resourceLoader = this.resourceLoader;
            Paragraph paragraph = ParagraphKt.Paragraph$default((String)buttonText, (TextStyle)textStyle, null, null, (int)1, (boolean)false, (float)Float.POSITIVE_INFINITY, (Density)density, (Font.ResourceLoader)resourceLoader, (int)44, null);
            width += paragraph.getMaxIntrinsicWidth();
            textHeight = paragraph.getHeight();
            width += layoutHGap;
        }
        if (hasPopup) {
            if (hasText && hasIcon) {
                width += (float)2 * layoutHGap;
            }
            width += 1.0f + this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
            width += (float)2 * layoutHGap;
        }
        if (preLayoutInfo.getCommandButtonKind().getHasAction() & preLayoutInfo.getCommandButtonKind().getHasPopup()) {
            width += this.toPx-0680j_4(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM());
        }
        width += presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateEndPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection()));
        boolean bl2 = false;
        return SizeKt.Size((float)(width -= (float)2 * layoutHGap), (float)(by + Math.max(prefIconSize, textHeight)));
    }

    @Override
    @NotNull
    public CommandButtonLayoutManager.CommandButtonPreLayoutInfo getPreLayoutInfo(@NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel) {
        boolean hasPopup;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        boolean hasAction = command.getAction() != null;
        boolean bl = hasPopup = command.getSecondaryContentModel() != null;
        CommandButtonKind commandButtonKind = hasAction && hasPopup ? (presentationModel.getTextClick() == TextClick.Action ? CommandButtonKind.ActionAndPopupMainAction : CommandButtonKind.ActionAndPopupMainPopup) : (hasPopup ? CommandButtonKind.PopupOnly : CommandButtonKind.ActionOnly);
        return new CommandButtonLayoutManager.CommandButtonPreLayoutInfo(commandButtonKind, this.hasIcon$component(command, presentationModel), CollectionsKt.listOf((Object)command.getText()), CollectionsKt.emptyList(), hasAction | command.isActionToggle() && presentationModel.getTextClick() == TextClick.Action, CommandButtonLayoutManager.CommandButtonSeparatorOrientation.Vertical, commandButtonKind.getHasPopup());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo-jYbf7pk(long constraints, @NotNull Command command, @NotNull CommandButtonPresentationModel presentationModel, @NotNull CommandButtonLayoutManager.CommandButtonPreLayoutInfo preLayoutInfo) {
        void other$iv;
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)preLayoutInfo, (String)"preLayoutInfo");
        long preferredSize = this.getPreferredSize-bSu-EZI(command, presentationModel, preLayoutInfo);
        float paddingTop = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(presentationModel.getContentPadding().calculateTopPadding-D9Ej5fM());
        float paddingBottom = presentationModel.getVerticalGapScaleFactor() * this.toPx-0680j_4(presentationModel.getContentPadding().calculateBottomPadding-D9Ej5fM());
        String buttonText = command.getText();
        float f = CommandButtonSizingConstants.INSTANCE.getDefaultHorizontalContentLayoutGap-D9Ej5fM();
        float f2 = presentationModel.getHorizontalGapScaleFactor();
        boolean bl = false;
        float layoutHGap = this.toPx-0680j_4(Dp.constructor-impl((float)(arg0$iv * other$iv)));
        boolean hasIcon = this.hasIcon$component(command, presentationModel);
        boolean hasText = buttonText != null;
        boolean hasPopup = command.getSecondaryContentModel() != null;
        float iconSize = this.toPx-0680j_4(this.getPreferredIconSize-chRvn1I(command, presentationModel));
        boolean ltr = this.getLayoutDirection() == LayoutDirection.Ltr;
        Rect iconRect = Rect.Companion.getZero();
        Rect popupActionRect = Rect.Companion.getZero();
        boolean bl2 = false;
        List textLayoutInfoList = new ArrayList();
        float shiftX = 0.0f;
        float finalWidth = Size.getWidth-impl((long)preferredSize);
        float finalHeight = Size.getHeight-impl((long)preferredSize);
        if (Constraints.getHasFixedWidth-impl((long)constraints) && Constraints.getMaxWidth-impl((long)constraints) > 0 && (finalWidth = (float)Constraints.getMaxWidth-impl((long)constraints)) > Size.getWidth-impl((long)preferredSize)) {
            HorizontalAlignment horizontalAlignment = presentationModel.getHorizontalAlignment();
            int n = WhenMappings.$EnumSwitchMapping$0[horizontalAlignment.ordinal()];
            switch (n) {
                case 1: {
                    shiftX = 0.0f;
                    break;
                }
                case 2: {
                    shiftX = (finalWidth - Size.getWidth-impl((long)preferredSize)) / (float)2;
                    break;
                }
                case 3: {
                    if (!ltr) break;
                    shiftX = finalWidth - Size.getWidth-impl((long)preferredSize);
                }
            }
        }
        if (finalWidth < this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM())) {
            shiftX += (this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM()) - finalWidth) / 2.0f;
            finalWidth = this.toPx-0680j_4(presentationModel.getMinWidth-D9Ej5fM());
        }
        if (Constraints.getHasFixedHeight-impl((long)constraints) && Constraints.getMaxHeight-impl((long)constraints) > 0) {
            finalHeight = Constraints.getMaxHeight-impl((long)constraints);
        }
        PaddingValues paddingValues = presentationModel.getContentPadding();
        Rect actionClickArea = Rect.Companion.getZero();
        Rect popupClickArea = Rect.Companion.getZero();
        Rect separatorArea = Rect.Companion.getZero();
        float verticalSeparatorWidth = this.toPx-0680j_4(SeparatorSizingConstants.INSTANCE.getThickness-D9Ej5fM());
        if (ltr) {
            float f3;
            float f4;
            float f5;
            float x = presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection())) + shiftX - layoutHGap;
            if (hasIcon) {
                float iconTop = paddingTop + (finalHeight - iconSize - paddingTop - paddingBottom) / (float)2;
                float f6 = x += layoutHGap;
                float f7 = x + iconSize;
                float f8 = iconTop + iconSize;
                iconRect = new Rect(f6, iconTop, f7, f8);
                x += iconSize + layoutHGap;
            }
            float textHeight = 0.0f;
            if (hasText) {
                x += hasIcon ? layoutHGap * this.getIconTextGapFactor() : layoutHGap;
                String string = command.getText();
                TextStyle textStyle = this.textStyle;
                Density density = this._density;
                Font.ResourceLoader resourceLoader = this.resourceLoader;
                Paragraph paragraph = ParagraphKt.Paragraph$default((String)string, (TextStyle)textStyle, null, null, (int)1, (boolean)false, (float)Float.POSITIVE_INFINITY, (Density)density, (Font.ResourceLoader)resourceLoader, (int)44, null);
                textHeight = paragraph.getHeight();
                float textTop = paddingTop + (finalHeight - textHeight - paddingTop - paddingBottom) / 2.0f;
                f5 = x;
                f4 = x + paragraph.getMaxIntrinsicWidth();
                f3 = textTop + textHeight;
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo(command.getText(), new Rect(f5, textTop, f4, f3));
                textLayoutInfoList.add(lineLayoutInfo);
                x += lineLayoutInfo.getTextRect().getWidth();
                x += layoutHGap;
            }
            if (hasPopup) {
                if (hasText && hasIcon) {
                    x += (float)2 * layoutHGap;
                }
                float popupIconWidth = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
                float popupIconHeight2 = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconHeight-D9Ej5fM());
                if (!hasText && !hasIcon) {
                    x += (finalWidth - (float)2 * layoutHGap - 1.0f - popupIconWidth) / 2.0f;
                }
                float lineLayoutInfo = x;
                f5 = x + (float)4 + popupIconWidth;
                f4 = (finalHeight - popupIconHeight2) / 2.0f - 1.0f;
                f3 = (finalHeight - popupIconHeight2) / 2.0f + popupIconHeight2 + 1.0f;
                popupActionRect = new Rect(lineLayoutInfo, f4, f5, f3);
            }
            float xBorderBetweenActionAndPopup = 0.0f;
            CommandButtonKind popupIconHeight2 = preLayoutInfo.getCommandButtonKind();
            int lineLayoutInfo = WhenMappings.$EnumSwitchMapping$1[popupIconHeight2.ordinal()];
            switch (lineLayoutInfo) {
                case 1: {
                    actionClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 2: {
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 3: {
                    if (hasText || hasIcon) {
                        popupActionRect = popupActionRect.translate(verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = popupActionRect.getLeft() - 2.0f * layoutHGap;
                        actionClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        popupClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        f5 = xBorderBetweenActionAndPopup;
                        f4 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        f3 = finalHeight;
                        separatorArea = new Rect(f5, 0.0f, f4, f3);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 4: {
                    if (hasIcon) {
                        for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo22 : textLayoutInfoList) {
                            textLayoutInfo22.setTextRect(textLayoutInfo22.getTextRect().translate(verticalSeparatorWidth, 0.0f));
                        }
                        popupActionRect = popupActionRect.translate(verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = iconRect.getLeft() + iconRect.getWidth() + layoutHGap;
                        actionClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        popupClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        float f9 = xBorderBetweenActionAndPopup;
                        float textLayoutInfo22 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        f3 = finalHeight;
                        separatorArea = new Rect(f9, 0.0f, textLayoutInfo22, f3);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                }
            }
        } else {
            float f10;
            float textLayoutInfo22;
            float f11;
            float popupIconHeight;
            float x = finalWidth - presentationModel.getHorizontalGapScaleFactor() * this.toPx-0680j_4(PaddingKt.calculateStartPadding((PaddingValues)paddingValues, (LayoutDirection)this.getLayoutDirection())) - shiftX + layoutHGap;
            if (hasIcon) {
                float iconTop = paddingTop + (finalHeight - iconSize - paddingTop - paddingBottom) / (float)2;
                float xBorderBetweenActionAndPopup = (x -= layoutHGap) - iconSize;
                popupIconHeight = x;
                float lineLayoutInfo = iconTop + iconSize;
                iconRect = new Rect(xBorderBetweenActionAndPopup, iconTop, popupIconHeight, lineLayoutInfo);
                x -= iconSize + layoutHGap;
            }
            float textHeight = 0.0f;
            if (hasText) {
                x -= hasIcon ? layoutHGap * this.getIconTextGapFactor() : layoutHGap;
                String popupIconHeight2 = command.getText();
                Object lineLayoutInfo = this.textStyle;
                Density density = this._density;
                Font.ResourceLoader textLayoutInfo22 = this.resourceLoader;
                Paragraph paragraph = ParagraphKt.Paragraph$default((String)popupIconHeight2, (TextStyle)lineLayoutInfo, null, null, (int)1, (boolean)false, (float)Float.POSITIVE_INFINITY, (Density)density, (Font.ResourceLoader)textLayoutInfo22, (int)44, null);
                textHeight = paragraph.getHeight();
                float textTop = paddingTop + (finalHeight - textHeight - paddingTop - paddingBottom) / 2.0f;
                f11 = x - paragraph.getMaxIntrinsicWidth();
                textLayoutInfo22 = x;
                f10 = textTop + textHeight;
                lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo(command.getText(), new Rect(f11, textTop, textLayoutInfo22, f10));
                textLayoutInfoList.add(lineLayoutInfo);
                x -= ((CommandButtonLayoutManager.TextLayoutInfo)lineLayoutInfo).getTextRect().getWidth();
                x -= layoutHGap;
            }
            if (hasPopup) {
                if (hasText && hasIcon) {
                    x -= (float)2 * layoutHGap;
                }
                float popupIconWidth = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconWidth-D9Ej5fM());
                popupIconHeight = this.toPx-0680j_4(CommandButtonSizingConstants.INSTANCE.getPopupIconHeight-D9Ej5fM());
                if (!hasText && !hasIcon) {
                    x -= (finalWidth - (float)2 * layoutHGap - 1.0f - popupIconWidth) / 2.0f;
                }
                float f12 = x - (float)4 - popupIconWidth;
                f11 = x;
                textLayoutInfo22 = (finalHeight - popupIconHeight) / 2.0f - 1.0f;
                f10 = (finalHeight - popupIconHeight) / 2.0f + popupIconHeight + 1.0f;
                popupActionRect = new Rect(f12, textLayoutInfo22, f11, f10);
            }
            float xBorderBetweenActionAndPopup = 0.0f;
            CommandButtonKind commandButtonKind = preLayoutInfo.getCommandButtonKind();
            int n = WhenMappings.$EnumSwitchMapping$1[commandButtonKind.ordinal()];
            switch (n) {
                case 1: {
                    actionClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 2: {
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 3: {
                    if (hasText || hasIcon) {
                        popupActionRect = popupActionRect.translate(-verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = popupActionRect.getRight() + 2.0f * layoutHGap;
                        actionClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        popupClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        f11 = xBorderBetweenActionAndPopup;
                        textLayoutInfo22 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        f10 = finalHeight;
                        separatorArea = new Rect(f11, 0.0f, textLayoutInfo22, f10);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                    break;
                }
                case 4: {
                    if (hasIcon) {
                        for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : textLayoutInfoList) {
                            textLayoutInfo.setTextRect(textLayoutInfo.getTextRect().translate(-verticalSeparatorWidth, 0.0f));
                        }
                        popupActionRect = popupActionRect.translate(-verticalSeparatorWidth, 0.0f);
                        xBorderBetweenActionAndPopup = iconRect.getLeft() - layoutHGap;
                        actionClickArea = new Rect(xBorderBetweenActionAndPopup, 0.0f, finalWidth, finalHeight);
                        popupClickArea = new Rect(0.0f, 0.0f, xBorderBetweenActionAndPopup, finalHeight);
                        float f13 = xBorderBetweenActionAndPopup;
                        float f14 = xBorderBetweenActionAndPopup + verticalSeparatorWidth;
                        f10 = finalHeight;
                        separatorArea = new Rect(f13, 0.0f, f14, f10);
                        break;
                    }
                    popupClickArea = new Rect(0.0f, 0.0f, finalWidth, finalHeight);
                }
            }
        }
        return new CommandButtonLayoutManager.CommandButtonLayoutInfo(SizeKt.Size((float)finalWidth, (float)finalHeight), actionClickArea, popupClickArea, separatorArea, iconRect, textLayoutInfoList, CollectionsKt.emptyList(), popupActionRect, null);
    }

    @Stable
    public long toDpSize-k-rfVVM(long $this$toDpSize_u2dk_u2drfVVM) {
        return CommandButtonLayoutManager.DefaultImpls.toDpSize-k-rfVVM(this, $this$toDpSize_u2dk_u2drfVVM);
    }

    @Stable
    public int roundToPx-0680j_4(float $this$roundToPx_u2d0680j_4) {
        return CommandButtonLayoutManager.DefaultImpls.roundToPx-0680j_4(this, $this$roundToPx_u2d0680j_4);
    }

    @Stable
    public float toPx-0680j_4(float $this$toPx_u2d0680j_4) {
        return CommandButtonLayoutManager.DefaultImpls.toPx-0680j_4(this, $this$toPx_u2d0680j_4);
    }

    @Stable
    public long toSp-0xMU5do(float $this$toSp_u2d0xMU5do) {
        return CommandButtonLayoutManager.DefaultImpls.toSp-0xMU5do(this, $this$toSp_u2d0xMU5do);
    }

    @Stable
    @NotNull
    public Rect toRect(@NotNull DpRect $this$toRect) {
        return CommandButtonLayoutManager.DefaultImpls.toRect(this, $this$toRect);
    }

    @Stable
    public long toSize-XkaWNTQ(long $this$toSize_u2dXkaWNTQ) {
        return CommandButtonLayoutManager.DefaultImpls.toSize-XkaWNTQ(this, $this$toSize_u2dXkaWNTQ);
    }

    @Stable
    public int roundToPx--R2X_6o(long $this$roundToPx_u2d_u2dR2X_6o) {
        return CommandButtonLayoutManager.DefaultImpls.roundToPx--R2X_6o(this, $this$roundToPx_u2d_u2dR2X_6o);
    }

    @Stable
    public float toDp-GaN1DYA(long $this$toDp_u2dGaN1DYA) {
        return CommandButtonLayoutManager.DefaultImpls.toDp-GaN1DYA(this, $this$toDp_u2dGaN1DYA);
    }

    @Stable
    public float toPx--R2X_6o(long $this$toPx_u2d_u2dR2X_6o) {
        return CommandButtonLayoutManager.DefaultImpls.toPx--R2X_6o(this, $this$toPx_u2d_u2dR2X_6o);
    }

    @Stable
    public float toDp-u2uoSUM(float $this$toDp_u2du2uoSUM) {
        return CommandButtonLayoutManager.DefaultImpls.toDp-u2uoSUM((CommandButtonLayoutManager)this, $this$toDp_u2du2uoSUM);
    }

    @Stable
    public long toSp-kPz2Gy4(float $this$toSp_u2dkPz2Gy4) {
        return CommandButtonLayoutManager.DefaultImpls.toSp-kPz2Gy4((CommandButtonLayoutManager)this, $this$toSp_u2dkPz2Gy4);
    }

    @Stable
    public float toDp-u2uoSUM(int $this$toDp_u2du2uoSUM) {
        return CommandButtonLayoutManager.DefaultImpls.toDp-u2uoSUM((CommandButtonLayoutManager)this, $this$toDp_u2du2uoSUM);
    }

    @Stable
    public long toSp-kPz2Gy4(int $this$toSp_u2dkPz2Gy4) {
        return CommandButtonLayoutManager.DefaultImpls.toSp-kPz2Gy4((CommandButtonLayoutManager)this, $this$toSp_u2dkPz2Gy4);
    }

    @NotNull
    public MeasureResult layout(int width, int height, @NotNull Map<AlignmentLine, Integer> alignmentLines, @NotNull Function1<? super Placeable.PlacementScope, Unit> placementBlock) {
        return CommandButtonLayoutManager.DefaultImpls.layout(this, width, height, alignmentLines, placementBlock);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.Leading.ordinal()] = 1;
            nArray[HorizontalAlignment.Center.ordinal()] = 2;
            nArray[HorizontalAlignment.Trailing.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CommandButtonKind.values().length];
            nArray[CommandButtonKind.ActionOnly.ordinal()] = 1;
            nArray[CommandButtonKind.PopupOnly.ordinal()] = 2;
            nArray[CommandButtonKind.ActionAndPopupMainAction.ordinal()] = 3;
            nArray[CommandButtonKind.ActionAndPopupMainPopup.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

