/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.common;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.ComposeWindow;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\bJ\u001c\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/pushingpixels/aurora/common/AuroraPopupManager;", "", "()V", "shownPath", "Ljava/util/ArrayList;", "Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupInfo;", "Lkotlin/collections/ArrayList;", "addPopup", "", "originator", "Landroidx/compose/ui/awt/ComposeWindow;", "popupWindow", "popupKind", "Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupKind;", "hideLastPopup", "hidePopups", "PopupInfo", "PopupKind", "common"})
@StabilityInferred(parameters=0)
public final class AuroraPopupManager {
    @NotNull
    public static final AuroraPopupManager INSTANCE = new AuroraPopupManager();
    @NotNull
    private static final ArrayList<PopupInfo> shownPath;
    public static final int $stable;

    private AuroraPopupManager() {
    }

    public final void addPopup(@NotNull ComposeWindow originator, @NotNull ComposeWindow popupWindow, @NotNull PopupKind popupKind) {
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
        Intrinsics.checkNotNullParameter((Object)((Object)popupKind), (String)"popupKind");
        shownPath.add(new PopupInfo(originator, popupWindow, popupKind));
        popupWindow.invalidate();
        popupWindow.validate();
        popupWindow.setVisible(true);
        popupWindow.pack();
    }

    public final void hideLastPopup() {
        if (shownPath.size() == 0) {
            return;
        }
        PopupInfo last = (PopupInfo)CollectionsKt.removeLast((List)shownPath);
        ComposeWindow lastPopupWindow = last.getPopupWindow();
        if (lastPopupWindow.isDisplayable()) {
            lastPopupWindow.setVisible(false);
            lastPopupWindow.dispose();
        }
    }

    public final void hidePopups(@Nullable ComposeWindow originator, @Nullable PopupKind popupKind) {
        while (shownPath.size() > 0) {
            PopupInfo popupInfo = shownPath.get(shownPath.size() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)popupInfo, (String)"shownPath[shownPath.size - 1]");
            PopupInfo currLastShown = popupInfo;
            if (Intrinsics.areEqual((Object)currLastShown.getPopupWindow(), (Object)originator)) {
                return;
            }
            if (popupKind != null && currLastShown.getPopupKind() != popupKind) {
                return;
            }
            PopupInfo last = (PopupInfo)CollectionsKt.removeLast((List)shownPath);
            ComposeWindow lastPopupWindow = last.getPopupWindow();
            if (!lastPopupWindow.isDisplayable()) continue;
            lastPopupWindow.setVisible(false);
            lastPopupWindow.dispose();
        }
    }

    public static /* synthetic */ void hidePopups$default(AuroraPopupManager auroraPopupManager, ComposeWindow composeWindow, PopupKind popupKind, int n, Object object) {
        if ((n & 2) != 0) {
            popupKind = null;
        }
        auroraPopupManager.hidePopups(composeWindow, popupKind);
    }

    static {
        boolean bl = false;
        shownPath = new ArrayList();
        $stable = 8;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupKind;", "", "(Ljava/lang/String;I)V", "POPUP", "RICH_TOOLTIP", "common"})
    public static final class PopupKind
    extends Enum<PopupKind> {
        public static final /* enum */ PopupKind POPUP = new PopupKind();
        public static final /* enum */ PopupKind RICH_TOOLTIP = new PopupKind();
        private static final /* synthetic */ PopupKind[] $VALUES;

        public static PopupKind[] values() {
            return (PopupKind[])$VALUES.clone();
        }

        public static PopupKind valueOf(String value) {
            return Enum.valueOf(PopupKind.class, value);
        }

        static {
            $VALUES = popupKindArray = new PopupKind[]{PopupKind.POPUP, PopupKind.RICH_TOOLTIP};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupInfo;", "", "originator", "Landroidx/compose/ui/awt/ComposeWindow;", "popupWindow", "popupKind", "Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupKind;", "(Landroidx/compose/ui/awt/ComposeWindow;Landroidx/compose/ui/awt/ComposeWindow;Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupKind;)V", "getOriginator", "()Landroidx/compose/ui/awt/ComposeWindow;", "getPopupKind", "()Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupKind;", "getPopupWindow", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "common"})
    private static final class PopupInfo {
        @NotNull
        private final ComposeWindow originator;
        @NotNull
        private final ComposeWindow popupWindow;
        @NotNull
        private final PopupKind popupKind;

        public PopupInfo(@NotNull ComposeWindow originator, @NotNull ComposeWindow popupWindow, @NotNull PopupKind popupKind) {
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
            Intrinsics.checkNotNullParameter((Object)((Object)popupKind), (String)"popupKind");
            this.originator = originator;
            this.popupWindow = popupWindow;
            this.popupKind = popupKind;
        }

        @NotNull
        public final ComposeWindow getOriginator() {
            return this.originator;
        }

        @NotNull
        public final ComposeWindow getPopupWindow() {
            return this.popupWindow;
        }

        @NotNull
        public final PopupKind getPopupKind() {
            return this.popupKind;
        }

        @NotNull
        public final ComposeWindow component1() {
            return this.originator;
        }

        @NotNull
        public final ComposeWindow component2() {
            return this.popupWindow;
        }

        @NotNull
        public final PopupKind component3() {
            return this.popupKind;
        }

        @NotNull
        public final PopupInfo copy(@NotNull ComposeWindow originator, @NotNull ComposeWindow popupWindow, @NotNull PopupKind popupKind) {
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
            Intrinsics.checkNotNullParameter((Object)((Object)popupKind), (String)"popupKind");
            return new PopupInfo(originator, popupWindow, popupKind);
        }

        public static /* synthetic */ PopupInfo copy$default(PopupInfo popupInfo, ComposeWindow composeWindow, ComposeWindow composeWindow2, PopupKind popupKind, int n, Object object) {
            if ((n & 1) != 0) {
                composeWindow = popupInfo.originator;
            }
            if ((n & 2) != 0) {
                composeWindow2 = popupInfo.popupWindow;
            }
            if ((n & 4) != 0) {
                popupKind = popupInfo.popupKind;
            }
            return popupInfo.copy(composeWindow, composeWindow2, popupKind);
        }

        @NotNull
        public String toString() {
            return "PopupInfo(originator=" + this.originator + ", popupWindow=" + this.popupWindow + ", popupKind=" + this.popupKind + ")";
        }

        public int hashCode() {
            int result = this.originator.hashCode();
            result = result * 31 + this.popupWindow.hashCode();
            result = result * 31 + this.popupKind.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PopupInfo)) {
                return false;
            }
            PopupInfo popupInfo = (PopupInfo)other;
            if (!Intrinsics.areEqual((Object)this.originator, (Object)popupInfo.originator)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.popupWindow, (Object)popupInfo.popupWindow)) {
                return false;
            }
            return this.popupKind == popupInfo.popupKind;
        }
    }
}

