/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.common;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b*\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u001b\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a \u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0002\u001a\u001f\u0010\"\u001a\u00020\u0002*\u00020\u00022\u0006\u0010#\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b$\u0010%\u001a\u001f\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010'\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b(\u0010%\u001a'\u0010)\u001a\u00020\u0002*\u00020\u00022\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b,\u0010-\u001a'\u0010.\u001a\u00020\u001a*\u00020\u00022\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b/\u00100\u001a\u0017\u00101\u001a\u00020\u0002*\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b2\u00103\u001a\u001f\u00104\u001a\u00020\u0002*\u00020\u00022\u0006\u0010'\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b5\u0010%\u001a\u001f\u00106\u001a\u00020\u0002*\u00020\u00022\u0006\u0010#\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b7\u0010%\u001a\u001f\u00108\u001a\u00020\u0002*\u00020\u00022\u0006\u00109\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b:\u0010;\u001a\u001f\u00108\u001a\u00020\u0002*\u00020\u00022\u0006\u0010<\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b=\u0010%\u001a\u001f\u0010>\u001a\u00020\u0002*\u00020\u00022\u0006\u0010?\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b@\u0010%\u001a\u001f\u0010A\u001a\u00020\u0002*\u00020\u00022\u0006\u0010B\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bC\u0010%\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00028F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006D"}, d2={"colorBrightness", "", "Landroidx/compose/ui/graphics/Color;", "getColorBrightness-8_81llA", "(J)F", "colorStrength", "getColorStrength-8_81llA", "hexadecimal", "", "getHexadecimal-8_81llA", "(J)Ljava/lang/String;", "EOCF_sRGB", "srgb", "HSBtoRGB", "from", "", "([F)J", "OECF_sRGB", "linear", "RGBtoHSB", "RGBtoHSB-8_81llA", "(J)[F", "r", "g", "b", "fromArgb", "", "encodeChannel", "number", "getColorBrightness", "getInterpolatedChannelValue", "value1", "value2", "value1Likeness", "byAlpha", "alpha", "byAlpha-DxMtmZc", "(JF)J", "darker", "diff", "darker-DxMtmZc", "interpolateTowards", "other", "thisLikeness", "interpolateTowards-jxsXWHM", "(JJF)J", "interpolateTowardsAsRGB", "interpolateTowardsAsRGB-jxsXWHM", "(JJF)I", "inverted", "inverted-8_81llA", "(J)J", "lighter", "lighter-DxMtmZc", "withAlpha", "withAlpha-DxMtmZc", "withBrightness", "brightnessSource", "withBrightness--OWjLjI", "(JJ)J", "brightnessFactor", "withBrightness-DxMtmZc", "withHueShift", "hueShift", "withHueShift-DxMtmZc", "withSaturation", "factor", "withSaturation-DxMtmZc", "common"})
public final class ColorUtilsKt {
    public static final long interpolateTowards-jxsXWHM(long $this$interpolateTowards, long other, float thisLikeness) {
        boolean bl = thisLikeness >= 0.0f && thisLikeness <= 1.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Color likeness should be in 0.0-1.0 range [is " + thisLikeness + "]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float alpha1 = Color.getAlpha-impl((long)$this$interpolateTowards);
        float alpha2 = Color.getAlpha-impl((long)other);
        float r = ColorUtilsKt.getInterpolatedChannelValue(Color.getRed-impl((long)$this$interpolateTowards), Color.getRed-impl((long)other), thisLikeness);
        float g = ColorUtilsKt.getInterpolatedChannelValue(Color.getGreen-impl((long)$this$interpolateTowards), Color.getGreen-impl((long)other), thisLikeness);
        float b = ColorUtilsKt.getInterpolatedChannelValue(Color.getBlue-impl((long)$this$interpolateTowards), Color.getBlue-impl((long)other), thisLikeness);
        float a = alpha1 == alpha2 ? alpha1 : thisLikeness * alpha1 + (1.0f - thisLikeness) * alpha2;
        float f = 1.0f;
        boolean bl5 = false;
        a = Math.min(a, f);
        f = 0.0f;
        bl5 = false;
        a = Math.max(a, f);
        return ColorKt.Color((float)r, (float)g, (float)b, (float)a, (ColorSpace)Color.getColorSpace-impl((long)$this$interpolateTowards));
    }

    public static final int interpolateTowardsAsRGB-jxsXWHM(long $this$interpolateTowardsAsRGB, long other, float thisLikeness) {
        boolean bl = thisLikeness >= 0.0f && thisLikeness <= 1.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Color likeness should be in 0.0-1.0 range [is " + thisLikeness + "]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float alpha1 = Color.getAlpha-impl((long)$this$interpolateTowardsAsRGB);
        float alpha2 = Color.getAlpha-impl((long)other);
        float r = ColorUtilsKt.getInterpolatedChannelValue(Color.getRed-impl((long)$this$interpolateTowardsAsRGB), Color.getRed-impl((long)other), thisLikeness);
        float g = ColorUtilsKt.getInterpolatedChannelValue(Color.getGreen-impl((long)$this$interpolateTowardsAsRGB), Color.getGreen-impl((long)other), thisLikeness);
        float b = ColorUtilsKt.getInterpolatedChannelValue(Color.getBlue-impl((long)$this$interpolateTowardsAsRGB), Color.getBlue-impl((long)other), thisLikeness);
        float a = alpha1 == alpha2 ? alpha1 : thisLikeness * alpha1 + (1.0f - thisLikeness) * alpha2;
        float f = 1.0f;
        boolean bl5 = false;
        a = Math.min(a, f);
        f = 0.0f;
        bl5 = false;
        a = Math.max(a, f);
        return (int)(a * 255.0f + 0.5f) << 24 | (int)(r * 255.0f + 0.5f) << 16 | (int)(g * 255.0f + 0.5f) << 8 | (int)(b * 255.0f + 0.5f);
    }

    private static final float getInterpolatedChannelValue(float value1, float value2, float value1Likeness) {
        float optical2;
        if (value1 == value2) {
            return value1;
        }
        if (value1Likeness == 1.0f) {
            return value1;
        }
        if (value1Likeness == 0.0f) {
            return value2;
        }
        float optical1 = ColorUtilsKt.EOCF_sRGB(value1);
        float interpolatedOptical = value1Likeness * optical1 + (1.0f - value1Likeness) * (optical2 = ColorUtilsKt.EOCF_sRGB(value2));
        float interpolatedElectro = ColorUtilsKt.OECF_sRGB(interpolatedOptical);
        float result = interpolatedElectro;
        if (result < 0.0f) {
            result = 0.0f;
        }
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    private static final float OECF_sRGB(float linear) {
        float f;
        if (linear <= 0.0031308f) {
            f = linear * 12.92f;
        } else {
            float f2 = linear;
            float f3 = 0.41666666f;
            boolean bl = false;
            f = (float)Math.pow(f2, f3) * 1.055f - 0.055f;
        }
        return f;
    }

    private static final float EOCF_sRGB(float srgb) {
        float f;
        if (srgb <= 0.04045f) {
            f = srgb / 12.92f;
        } else {
            float f2 = (srgb + 0.055f) / 1.055f;
            float f3 = 2.4f;
            boolean bl = false;
            f = (float)Math.pow(f2, f3);
        }
        return f;
    }

    @NotNull
    public static final float[] RGBtoHSB(int fromArgb) {
        int r = fromArgb >>> 16 & 0xFF;
        int g = fromArgb >>> 8 & 0xFF;
        int b = fromArgb >>> 0 & 0xFF;
        return ColorUtilsKt.RGBtoHSB((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    @NotNull
    public static final float[] RGBtoHSB-8_81llA(long from) {
        return ColorUtilsKt.RGBtoHSB(Color.getRed-impl((long)from), Color.getGreen-impl((long)from), Color.getBlue-impl((long)from));
    }

    @NotNull
    public static final float[] RGBtoHSB(float r, float g, float b) {
        float[] result = new float[3];
        boolean bl = false;
        float f = Math.max(r, g);
        boolean bl2 = false;
        float xmax = Math.max(f, b);
        bl2 = false;
        float f2 = Math.min(r, g);
        boolean bl3 = false;
        float xmin = Math.min(f2, b);
        float chroma = xmax - xmin;
        result[2] = xmax;
        result[1] = result[2] == 0.0f ? 0.0f : chroma / result[2];
        if (chroma == 0.0f) {
            result[0] = 0.0f;
        } else {
            result[0] = xmax == r ? 0.16666667f * ((g - b) / chroma) : (xmax == g ? 0.16666667f * ((float)2 + (b - r) / chroma) : 0.16666667f * ((float)4 + (r - g) / chroma));
            if (result[0] < 0.0f) {
                result[0] = 0.0f;
            }
        }
        return result;
    }

    public static final long HSBtoRGB(@NotNull float[] from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        float hue = from[0];
        float saturation = from[1];
        float brightness = from[2];
        if (saturation == 0.0f) {
            return ColorKt.Color$default((float)brightness, (float)brightness, (float)brightness, (float)0.0f, null, (int)24, null);
        }
        float hue360 = hue * 360.0f;
        float hue360sharp = hue360 / 60.0f;
        float chroma = saturation * brightness;
        float f = hue360sharp % (float)2 - 1.0f;
        boolean bl = false;
        float x = chroma * (1.0f - Math.abs(f));
        float m = brightness - chroma;
        if (hue360sharp >= 0.0f && hue360sharp <= 1.0f) {
            return ColorKt.Color$default((float)(chroma + m), (float)(x + m), (float)m, (float)0.0f, null, (int)24, null);
        }
        if (hue360sharp <= 2.0f) {
            return ColorKt.Color$default((float)(x + m), (float)(chroma + m), (float)m, (float)0.0f, null, (int)24, null);
        }
        if (hue360sharp <= 3.0f) {
            return ColorKt.Color$default((float)m, (float)(chroma + m), (float)(x + m), (float)0.0f, null, (int)24, null);
        }
        if (hue360sharp <= 4.0f) {
            return ColorKt.Color$default((float)m, (float)(x + m), (float)(chroma + m), (float)0.0f, null, (int)24, null);
        }
        if (hue360sharp <= 5.0f) {
            return ColorKt.Color$default((float)(x + m), (float)m, (float)(chroma + m), (float)0.0f, null, (int)24, null);
        }
        return ColorKt.Color$default((float)(chroma + m), (float)m, (float)(x + m), (float)0.0f, null, (int)24, null);
    }

    public static final long withBrightness--OWjLjI(long $this$withBrightness, long brightnessSource) {
        float[] hsbvalsOrig = ColorUtilsKt.RGBtoHSB-8_81llA($this$withBrightness);
        float[] hsbvalsBrightnessSrc = ColorUtilsKt.RGBtoHSB-8_81llA(brightnessSource);
        float[] fArray = new float[]{hsbvalsOrig[0], hsbvalsOrig[1], (hsbvalsBrightnessSrc[2] + hsbvalsOrig[2]) / 2.0f};
        return ColorUtilsKt.byAlpha-DxMtmZc(ColorUtilsKt.HSBtoRGB(fArray), Color.getAlpha-impl((long)$this$withBrightness));
    }

    public static final long withBrightness-DxMtmZc(long $this$withBrightness, float brightnessFactor) {
        float[] hsbvalsOrig = ColorUtilsKt.RGBtoHSB-8_81llA($this$withBrightness);
        float newBrightness = brightnessFactor > 0.0f ? hsbvalsOrig[2] + (1.0f - hsbvalsOrig[2]) * brightnessFactor : hsbvalsOrig[2] + hsbvalsOrig[2] * brightnessFactor;
        float[] fArray = new float[]{hsbvalsOrig[0], hsbvalsOrig[1], newBrightness};
        return ColorUtilsKt.byAlpha-DxMtmZc(ColorUtilsKt.HSBtoRGB(fArray), Color.getAlpha-impl((long)$this$withBrightness));
    }

    public static final long inverted-8_81llA(long $this$inverted) {
        return ColorKt.Color$default((float)(1.0f - Color.getRed-impl((long)$this$inverted)), (float)(1.0f - Color.getGreen-impl((long)$this$inverted)), (float)(1.0f - Color.getBlue-impl((long)$this$inverted)), (float)Color.getAlpha-impl((long)$this$inverted), null, (int)16, null);
    }

    public static final long withAlpha-DxMtmZc(long $this$withAlpha, float alpha) {
        return ColorKt.Color((float)Color.getRed-impl((long)$this$withAlpha), (float)Color.getGreen-impl((long)$this$withAlpha), (float)Color.getBlue-impl((long)$this$withAlpha), (float)alpha, (ColorSpace)Color.getColorSpace-impl((long)$this$withAlpha));
    }

    public static final long byAlpha-DxMtmZc(long $this$byAlpha, float alpha) {
        return ColorKt.Color((float)Color.getRed-impl((long)$this$byAlpha), (float)Color.getGreen-impl((long)$this$byAlpha), (float)Color.getBlue-impl((long)$this$byAlpha), (float)(Color.getAlpha-impl((long)$this$byAlpha) * alpha), (ColorSpace)Color.getColorSpace-impl((long)$this$byAlpha));
    }

    public static final long withSaturation-DxMtmZc(long $this$withSaturation, float factor) {
        float red = Color.getRed-impl((long)$this$withSaturation);
        float green = Color.getGreen-impl((long)$this$withSaturation);
        float blue = Color.getBlue-impl((long)$this$withSaturation);
        if (red == green || green == blue) {
            return $this$withSaturation;
        }
        float[] hsbvals = ColorUtilsKt.RGBtoHSB-8_81llA($this$withSaturation);
        float saturation = hsbvals[1];
        saturation = (double)factor > 0.0 ? saturation + factor * (1.0f - saturation) : saturation + factor * saturation;
        float[] fArray = new float[]{hsbvals[0], saturation, hsbvals[2]};
        return ColorUtilsKt.byAlpha-DxMtmZc(ColorUtilsKt.HSBtoRGB(fArray), Color.getAlpha-impl((long)$this$withSaturation));
    }

    public static final long withHueShift-DxMtmZc(long $this$withHueShift, float hueShift) {
        float[] hsbvals = ColorUtilsKt.RGBtoHSB-8_81llA($this$withHueShift);
        float hue = hsbvals[0];
        if ((double)(hue += hueShift) < 0.0) {
            hue += 1.0f;
        }
        if ((double)hue > 1.0) {
            hue -= 1.0f;
        }
        float[] fArray = new float[]{hue, hsbvals[1], hsbvals[2]};
        return ColorUtilsKt.byAlpha-DxMtmZc(ColorUtilsKt.HSBtoRGB(fArray), Color.getAlpha-impl((long)$this$withHueShift));
    }

    public static final long lighter-DxMtmZc(long $this$lighter, float diff) {
        return ColorUtilsKt.interpolateTowards-jxsXWHM($this$lighter, Color.Companion.getWhite-0d7_KjU(), 1.0f - diff);
    }

    public static final long darker-DxMtmZc(long $this$darker, float diff) {
        return ColorUtilsKt.interpolateTowards-jxsXWHM($this$darker, Color.Companion.getBlack-0d7_KjU(), 1.0f - diff);
    }

    public static final float getColorBrightness-8_81llA(long $this$colorBrightness) {
        return ColorUtilsKt.getColorBrightness(Color.getRed-impl((long)$this$colorBrightness), Color.getGreen-impl((long)$this$colorBrightness), Color.getBlue-impl((long)$this$colorBrightness));
    }

    public static final float getColorStrength-8_81llA(long $this$colorStrength) {
        float f = ColorUtilsKt.getColorBrightness-8_81llA($this$colorStrength);
        float f2 = ColorUtilsKt.getColorBrightness-8_81llA(ColorUtilsKt.inverted-8_81llA($this$colorStrength));
        boolean bl = false;
        return Math.max(f, f2);
    }

    public static final float getColorBrightness(float r, float g, float b) {
        return (2126.0f * r + 7152.0f * g + 722.0f * b) / 10000.0f;
    }

    private static final String encodeChannel(float number) {
        boolean bl = !(number < 0.0f) && !(number > 1.0f);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "" + number;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String hex = "0123456789ABCDEF";
        int asInt = (int)(255.0f * number + 0.5f);
        char hexaDigit1 = hex.charAt(asInt / 16);
        char hexaDigit2 = hex.charAt(asInt % 16);
        return "" + hexaDigit1 + hexaDigit2;
    }

    @NotNull
    public static final String getHexadecimal-8_81llA(long $this$hexadecimal) {
        return "#" + ColorUtilsKt.encodeChannel(Color.getAlpha-impl((long)$this$hexadecimal)) + ColorUtilsKt.encodeChannel(Color.getRed-impl((long)$this$hexadecimal)) + ColorUtilsKt.encodeChannel(Color.getGreen-impl((long)$this$hexadecimal)) + ColorUtilsKt.encodeChannel(Color.getBlue-impl((long)$this$hexadecimal));
    }
}

