/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.aurora.common;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.ComposeWindow;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/pushingpixels/aurora/common/AuroraPopupManager;", "", "()V", "shownPath", "Ljava/util/ArrayList;", "Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupInfo;", "Lkotlin/collections/ArrayList;", "addPopup", "", "originator", "Landroidx/compose/ui/awt/ComposeWindow;", "popupWindow", "hideLastPopup", "hidePopups", "PopupInfo", "common"})
@StabilityInferred(parameters=0)
public final class AuroraPopupManager {
    @NotNull
    public static final AuroraPopupManager INSTANCE = new AuroraPopupManager();
    @NotNull
    private static final ArrayList<PopupInfo> shownPath;
    public static final int $stable;

    private AuroraPopupManager() {
    }

    public final void addPopup(@NotNull ComposeWindow originator, @NotNull ComposeWindow popupWindow) {
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
        shownPath.add(new PopupInfo(originator, popupWindow));
        popupWindow.invalidate();
        popupWindow.validate();
        popupWindow.setVisible(true);
        popupWindow.pack();
    }

    public final void hideLastPopup() {
        if (shownPath.size() == 0) {
            return;
        }
        PopupInfo last = (PopupInfo)CollectionsKt.removeLast((List)shownPath);
        ComposeWindow lastPopupWindow = last.getPopupWindow();
        if (lastPopupWindow.isDisplayable()) {
            lastPopupWindow.setVisible(false);
            lastPopupWindow.dispose();
        }
    }

    public final void hidePopups(@Nullable ComposeWindow originator) {
        while (shownPath.size() > 0) {
            if (Intrinsics.areEqual((Object)shownPath.get(shownPath.size() - 1).getPopupWindow(), (Object)originator)) {
                return;
            }
            PopupInfo last = (PopupInfo)CollectionsKt.removeLast((List)shownPath);
            ComposeWindow lastPopupWindow = last.getPopupWindow();
            if (!lastPopupWindow.isDisplayable()) continue;
            lastPopupWindow.setVisible(false);
            lastPopupWindow.dispose();
        }
    }

    static {
        boolean bl = false;
        shownPath = new ArrayList();
        $stable = 8;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/pushingpixels/aurora/common/AuroraPopupManager$PopupInfo;", "", "originator", "Landroidx/compose/ui/awt/ComposeWindow;", "popupWindow", "(Landroidx/compose/ui/awt/ComposeWindow;Landroidx/compose/ui/awt/ComposeWindow;)V", "getOriginator", "()Landroidx/compose/ui/awt/ComposeWindow;", "getPopupWindow", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "common"})
    private static final class PopupInfo {
        @NotNull
        private final ComposeWindow originator;
        @NotNull
        private final ComposeWindow popupWindow;

        public PopupInfo(@NotNull ComposeWindow originator, @NotNull ComposeWindow popupWindow) {
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
            this.originator = originator;
            this.popupWindow = popupWindow;
        }

        @NotNull
        public final ComposeWindow getOriginator() {
            return this.originator;
        }

        @NotNull
        public final ComposeWindow getPopupWindow() {
            return this.popupWindow;
        }

        @NotNull
        public final ComposeWindow component1() {
            return this.originator;
        }

        @NotNull
        public final ComposeWindow component2() {
            return this.popupWindow;
        }

        @NotNull
        public final PopupInfo copy(@NotNull ComposeWindow originator, @NotNull ComposeWindow popupWindow) {
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
            return new PopupInfo(originator, popupWindow);
        }

        public static /* synthetic */ PopupInfo copy$default(PopupInfo popupInfo, ComposeWindow composeWindow, ComposeWindow composeWindow2, int n, Object object) {
            if ((n & 1) != 0) {
                composeWindow = popupInfo.originator;
            }
            if ((n & 2) != 0) {
                composeWindow2 = popupInfo.popupWindow;
            }
            return popupInfo.copy(composeWindow, composeWindow2);
        }

        @NotNull
        public String toString() {
            return "PopupInfo(originator=" + this.originator + ", popupWindow=" + this.popupWindow + ')';
        }

        public int hashCode() {
            int result = this.originator.hashCode();
            result = result * 31 + this.popupWindow.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PopupInfo)) {
                return false;
            }
            PopupInfo popupInfo = (PopupInfo)other;
            if (!Intrinsics.areEqual((Object)this.originator, (Object)popupInfo.originator)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.popupWindow, (Object)popupInfo.popupWindow);
        }
    }
}

