/*
 * Decompiled with CFR 0.152.
 */
package reactor.groovy.config;

import java.util.List;
import reactor.core.composable.Deferred;
import reactor.core.composable.Stream;
import reactor.event.Event;
import reactor.event.registry.Registration;
import reactor.event.routing.ConsumerFilteringEventRouter;
import reactor.event.routing.ConsumerInvoker;
import reactor.event.support.CallbackEvent;
import reactor.filter.Filter;
import reactor.function.Consumer;
import reactor.function.support.CancelConsumerException;

public class StreamEventRouter
extends ConsumerFilteringEventRouter {
    public static final String KEY_HEADER = "___key";
    private final Deferred<Event<?>, Stream<Event<?>>> stream;

    public StreamEventRouter(Filter filter, ConsumerInvoker consumerInvoker, Deferred<Event<?>, Stream<Event<?>>> stream) {
        super(filter, consumerInvoker);
        this.stream = stream;
    }

    public void route(final Object key, final Event<?> event, final List<Registration<? extends Consumer<? extends Event<?>>>> consumers, final Consumer<?> completionConsumer, final Consumer<Throwable> errorConsumer) {
        try {
            event.getHeaders().set(KEY_HEADER, (Object)key.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.stream.acceptEvent((Event)new CallbackEvent(event.getHeaders(), event, new Consumer<Event<?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(Event<?> _event) {
                Event hydratedEvent = event.copy(_event != null ? _event.getData() : null);
                if (null != consumers) {
                    for (Registration reg : StreamEventRouter.this.getFilter().filter(consumers, key)) {
                        if (reg.isCancelled() || reg.isPaused()) continue;
                        try {
                            if (null != reg.getSelector().getHeaderResolver()) {
                                event.getHeaders().setAll(reg.getSelector().getHeaderResolver().resolve(key));
                            }
                            StreamEventRouter.this.getConsumerInvoker().invoke((Consumer)reg.getObject(), Void.TYPE, (Object)event);
                        }
                        catch (CancelConsumerException cancel) {
                            reg.cancel();
                        }
                        catch (Throwable t) {
                            if (null != hydratedEvent.getErrorConsumer()) {
                                hydratedEvent.consumeError(t);
                            } else if (null != errorConsumer) {
                                errorConsumer.accept((Object)t);
                            }
                            StreamEventRouter.this.stream.accept(t);
                        }
                        finally {
                            if (reg.isCancelAfterUse()) {
                                reg.cancel();
                            }
                        }
                    }
                }
                if (null != completionConsumer) {
                    try {
                        StreamEventRouter.this.getConsumerInvoker().invoke(completionConsumer, Void.TYPE, (Object)hydratedEvent);
                    }
                    catch (Exception e) {
                        if (null != errorConsumer) {
                            errorConsumer.accept((Object)e);
                        }
                        StreamEventRouter.this.stream.accept((Throwable)e);
                    }
                }
            }
        }));
    }
}

