/*
 * Decompiled with CFR 0.152.
 */
package reactor.groovy.config;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import reactor.convert.Converter;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Composable;
import reactor.core.composable.Deferred;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.Streams;
import reactor.core.spec.ReactorSpec;
import reactor.core.spec.Reactors;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.routing.ArgumentConvertingConsumerInvoker;
import reactor.event.routing.ConsumerInvoker;
import reactor.event.routing.EventRouter;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.event.support.CallbackEvent;
import reactor.filter.Filter;
import reactor.filter.FirstFilter;
import reactor.filter.PassThroughFilter;
import reactor.filter.RandomFilter;
import reactor.filter.RoundRobinFilter;
import reactor.function.Consumer;
import reactor.function.Predicate;
import reactor.function.Supplier;
import reactor.groovy.config.DSLUtils;
import reactor.groovy.config.StreamEventRouter;
import reactor.groovy.support.ClosureEventConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactorBuilder
implements Supplier<Reactor>,
GroovyObject {
    private static final Selector noSelector;
    private static final Filter DEFAULT_FILTER;
    private static final String ROUND_ROBIN = "round-robin";
    private static final String PUB_SUB = "all";
    private static final String RANDOM = "random";
    private static final String FIRST = "first";
    private Environment env;
    private Converter converter;
    private EventRouter router;
    private ConsumerInvoker consumerInvoker;
    private Dispatcher dispatcher;
    private Filter filter;
    private boolean override;
    private String dispatcherName;
    private final String name;
    private final SortedSet<HeadAndTail> streams;
    private final Map<String, Object> ext;
    private final Map<Selector, List<Consumer>> consumers;
    private final Map<String, ReactorBuilder> reactorMap;
    private final List<ReactorBuilder> childNodes;
    private Reactor reactor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1401738539455;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public ReactorBuilder(String string, Map<String, ReactorBuilder> map) {
        void name;
        void reactorMap;
        MetaClass metaClass;
        List list;
        Map map2;
        Map map3;
        boolean bl;
        this.override = bl = false;
        TreeSet<HeadAndTail> treeSet = new TreeSet<HeadAndTail>();
        this.streams = treeSet;
        this.ext = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.consumers = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.childNodes = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var9_9 = reactorMap;
        this.reactorMap = var9_9;
        void var10_10 = name;
        this.name = var10_10;
    }

    public ReactorBuilder(String name, Map<String, ReactorBuilder> reactorMap, Reactor reactor) {
        this(name, reactorMap);
        Reactor reactor2;
        this.reactor = reactor2 = reactor;
    }

    public void rehydrate(ReactorBuilder r) {
        ConsumerInvoker consumerInvoker;
        EventRouter eventRouter;
        String string;
        Dispatcher dispatcher;
        Filter filter;
        Converter converter;
        Converter converter2 = this.converter;
        this.converter = converter = DefaultTypeTransformation.booleanUnbox((Object)converter2) ? converter2 : r.getConverter();
        Filter filter2 = this.filter;
        this.filter = filter = DefaultTypeTransformation.booleanUnbox((Object)filter2) ? filter2 : r.getFilter();
        Dispatcher dispatcher2 = this.dispatcher;
        this.dispatcher = dispatcher = DefaultTypeTransformation.booleanUnbox((Object)dispatcher2) ? dispatcher2 : r.getDispatcher();
        String string2 = this.dispatcherName;
        this.dispatcherName = string = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : r.dispatcherName;
        EventRouter eventRouter2 = this.router;
        this.router = eventRouter = DefaultTypeTransformation.booleanUnbox((Object)eventRouter2) ? eventRouter2 : r.getRouter();
        ConsumerInvoker consumerInvoker2 = this.consumerInvoker;
        this.consumerInvoker = consumerInvoker = DefaultTypeTransformation.booleanUnbox((Object)consumerInvoker2) ? consumerInvoker2 : r.getConsumerInvoker();
        if (!this.override) {
            this.streams.addAll(r.streams);
            this.childNodes.addAll(r.childNodes);
        }
        Object entry = null;
        Iterator iterator = DefaultGroovyMethods.iterator(r.ext);
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(this.ext, ((Map.Entry)ScriptBytecodeAdapter.castToType(entry, Map.Entry.class)).getKey())))) continue;
            Object v = ((Map.Entry)ScriptBytecodeAdapter.castToType(entry, Map.Entry.class)).getValue();
            DefaultGroovyMethods.putAt(this.ext, ((Map.Entry)ScriptBytecodeAdapter.castToType(entry, Map.Entry.class)).getKey(), v);
        }
    }

    public void init() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.name)) {
            ReactorBuilder r = (ReactorBuilder)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.reactorMap, (Object)this.name), ReactorBuilder.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)r)) {
                this.rehydrate(r);
                this.addConsumersFrom(r);
            }
            ReactorBuilder reactorBuilder = this;
            DefaultGroovyMethods.putAt(this.reactorMap, (Object)this.name, (Object)reactorBuilder);
        }
    }

    public Object ext(String k) {
        return DefaultGroovyMethods.getAt(this.ext, (Object)k);
    }

    public void ext(String k, Object v) {
        Object object = v;
        DefaultGroovyMethods.putAt(this.ext, (Object)k, (Object)object);
    }

    public void exts(Map<String, Object> map) {
        this.ext.putAll(map);
    }

    public Filter routingStrategy(String strategy) {
        Filter filter;
        String string = strategy;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ROUND_ROBIN)) {
            RoundRobinFilter roundRobinFilter = new RoundRobinFilter();
            this.filter = roundRobinFilter;
            return roundRobinFilter;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)RANDOM)) {
            RandomFilter randomFilter = new RandomFilter();
            this.filter = randomFilter;
            return randomFilter;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)FIRST)) {
            FirstFilter firstFilter = new FirstFilter();
            this.filter = firstFilter;
            return firstFilter;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PUB_SUB)) {
            // empty if block
        }
        this.filter = filter = DEFAULT_FILTER;
        return filter;
    }

    public ReactorBuilder dispatcher(String dispatcher) {
        Dispatcher dispatcher2;
        String string;
        this.dispatcherName = string = dispatcher;
        Environment environment = this.env;
        this.dispatcher = dispatcher2 = environment != null ? environment.getDispatcher(dispatcher) : null;
        return this;
    }

    public ReactorBuilder on(@DelegatesTo(strategy=1, value=ClosureEventConsumer.ReplyDecorator.class) Closure closure) {
        return this.on(noSelector, (Consumer)new ClosureEventConsumer((Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class)));
    }

    public ReactorBuilder on(String selector, @DelegatesTo(strategy=1, value=ClosureEventConsumer.ReplyDecorator.class) Closure closure) {
        return this.on(Selectors.object((Object)selector), (Consumer)new ClosureEventConsumer((Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class)));
    }

    public ReactorBuilder on(Consumer consumer) {
        return this.on(noSelector, consumer);
    }

    public ReactorBuilder on(String selector, Consumer closure) {
        return this.on(Selectors.object((Object)selector), closure);
    }

    public ReactorBuilder on(Selector selector, @DelegatesTo(strategy=1, value=ClosureEventConsumer.ReplyDecorator.class) Closure closure) {
        return this.on(selector, (Consumer)new ClosureEventConsumer((Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class)));
    }

    public ReactorBuilder on(Selector selector, Consumer closure) {
        Object object = DefaultGroovyMethods.getAt(this.consumers, (Object)selector);
        List list = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        List list2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        DefaultGroovyMethods.putAt(this.consumers, (Object)selector, (Object)list2);
        DefaultGroovyMethods.leftShift((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.consumers, (Object)selector), Collection.class)), (Object)closure);
        return this;
    }

    public void stream(@DelegatesTo(strategy=1, value=Stream.class) Closure<Stream> closure) {
        this.stream((Selector)null, closure);
    }

    public void stream(Deferred<Event<?>, Stream<Event<?>>> head, Stream<Event<?>> tail) {
        this.stream(null, head, tail);
    }

    public void stream(String selector, @DelegatesTo(strategy=1, value=Stream.class) Closure<Stream> closure) {
        this.stream(Selectors.$((Object)selector), closure);
    }

    public void stream(Selector selector, @DelegatesTo(strategy=1, value=Stream.class) Closure<Stream> closure) {
        Deferred head = (Deferred)ScriptBytecodeAdapter.castToType((Object)Streams.defer().get(), Deferred.class);
        Stream newTail = (Stream)ScriptBytecodeAdapter.castToType((Object)DSLUtils.delegateFirstAndRun(head.compose(), closure), Stream.class);
        this.stream(selector, head, newTail);
    }

    public void stream(Selector selector, Deferred<Event<?>, Stream<Event<?>>> head, Stream<Event<?>> tail) {
        if (DefaultTypeTransformation.booleanUnbox(tail)) {
            DefaultGroovyMethods.leftShift(this.streams, (Object)new HeadAndTail(this, head, tail, selector));
        }
    }

    public Reactor get() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.reactor)) {
            return this.reactor;
        }
        ReactorSpec spec = (ReactorSpec)ScriptBytecodeAdapter.castToType((Object)Reactors.reactor().env(this.env), ReactorSpec.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.dispatcherName)) {
            spec.dispatcher(this.dispatcherName);
        } else {
            spec.dispatcher(this.dispatcher);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.converter)) {
            spec.converters(new Converter[]{this.converter});
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.router)) {
            spec.eventRouter(this.router);
        } else if (DefaultTypeTransformation.booleanUnbox(this.streams)) {
            Deferred deferred = null;
            Stream tail = null;
            HeadAndTail stream = null;
            HeadAndTail anticipatedStream = null;
            Iterator it = this.streams.iterator();
            boolean first = true;
            while (it.hasNext() || DefaultTypeTransformation.booleanUnbox(anticipatedStream)) {
                Stream stream2;
                HeadAndTail headAndTail;
                HeadAndTail headAndTail2 = anticipatedStream;
                stream = headAndTail = DefaultTypeTransformation.booleanUnbox(headAndTail2) ? headAndTail2 : (HeadAndTail)ScriptBytecodeAdapter.castToType(it.next(), HeadAndTail.class);
                Object var10_10 = null;
                anticipatedStream = (HeadAndTail)ScriptBytecodeAdapter.castToType(var10_10, HeadAndTail.class);
                if (first) {
                    boolean bl;
                    first = bl = false;
                    Object object = Streams.defer().get();
                    deferred = (Deferred)ScriptBytecodeAdapter.castToType((Object)object, Deferred.class);
                    Composable composable = deferred.compose();
                    tail = (Stream)ScriptBytecodeAdapter.castToType((Object)composable, Stream.class);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)stream.getSelector())) {
                    if (it.hasNext()) {
                        Object e = it.next();
                        anticipatedStream = (HeadAndTail)ScriptBytecodeAdapter.castToType(e, HeadAndTail.class);
                    } else {
                        HeadAndTail headAndTail3;
                        Deferred finalDeferred = (Deferred)ScriptBytecodeAdapter.castToType((Object)Streams.defer().get(), Deferred.class);
                        anticipatedStream = headAndTail3 = new HeadAndTail(this, finalDeferred, (Stream)ScriptBytecodeAdapter.castToType((Object)finalDeferred.compose(), Stream.class), null);
                    }
                    tail.filter((Predicate)new EventRouterPredicate(this, stream.getSelector()), anticipatedStream.getTail()).connect(stream.getHead().compose());
                } else {
                    tail.connect(stream.getHead().compose());
                }
                tail = stream2 = stream.getTail();
            }
            tail.consumeEvent((Consumer)new Consumer<Event>(this){
                public /* synthetic */ ReactorBuilder this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    MetaClass metaClass;
                    ReactorBuilder reactorBuilder;
                    this.this$0 = reactorBuilder = p0;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void accept(Event eventEvent) {
                    if (ScriptBytecodeAdapter.compareEqual(eventEvent.getClass(), CallbackEvent.class)) {
                        ((CallbackEvent)ScriptBytecodeAdapter.castToType((Object)eventEvent, CallbackEvent.class)).callback();
                    }
                }

                public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void this$dist$set$1(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object this$dist$get$1(String name) {
                    return ScriptBytecodeAdapter.getGroovyObjectProperty(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$1(name, args);
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$1(name, val);
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$1(name);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    1.__$swapInit();
                }

                public /* synthetic */ void super$1$notify() {
                    super.notify();
                }

                public /* synthetic */ int super$1$hashCode() {
                    return super.hashCode();
                }

                public /* synthetic */ String super$1$toString() {
                    return super.toString();
                }

                public /* synthetic */ Object super$1$clone() {
                    return super.clone();
                }

                public /* synthetic */ void super$1$wait() {
                    super.wait();
                }

                public /* synthetic */ void super$1$wait(long l, int n) {
                    super.wait(l, n);
                }

                public /* synthetic */ void super$1$wait(long l) {
                    super.wait(l);
                }

                public /* synthetic */ void super$1$notifyAll() {
                    super.notifyAll();
                }

                public /* synthetic */ boolean super$1$equals(Object object) {
                    return super.equals(object);
                }

                public /* synthetic */ void super$1$finalize() {
                    super.finalize();
                }

                public /* synthetic */ Class super$1$getClass() {
                    return super.getClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = 1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            Filter filter = this.filter;
            ConsumerInvoker consumerInvoker = this.consumerInvoker;
            spec.eventRouter((EventRouter)new StreamEventRouter(DefaultTypeTransformation.booleanUnbox((Object)filter) ? filter : DEFAULT_FILTER, (ConsumerInvoker)(DefaultTypeTransformation.booleanUnbox((Object)consumerInvoker) ? consumerInvoker : new ArgumentConvertingConsumerInvoker(this.converter)), deferred));
        } else {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.filter)) {
                spec.eventFilter(this.filter);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.consumerInvoker)) {
                spec.consumerInvoker(this.consumerInvoker);
            }
        }
        Object object = spec.get();
        this.reactor = (Reactor)ScriptBytecodeAdapter.castToType((Object)object, Reactor.class);
        if (DefaultTypeTransformation.booleanUnbox(this.childNodes)) {
            ReactorBuilder childNode = null;
            Iterator<ReactorBuilder> iterator = this.childNodes.iterator();
            while (iterator.hasNext()) {
                childNode = (ReactorBuilder)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ReactorBuilder.class);
                childNode.get();
            }
        }
        if (DefaultTypeTransformation.booleanUnbox(this.consumers)) {
            Map.Entry perSelectorConsumers = null;
            Iterator<Map.Entry<Selector, List<Consumer>>> iterator = this.consumers.entrySet().iterator();
            while (iterator.hasNext()) {
                perSelectorConsumers = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Consumer consumer = null;
                Iterator iterator2 = ((List)perSelectorConsumers.getValue()).iterator();
                while (iterator2.hasNext()) {
                    consumer = (Consumer)ScriptBytecodeAdapter.castToType(iterator2.next(), Consumer.class);
                    this.reactor.on((Selector)ScriptBytecodeAdapter.castToType(perSelectorConsumers.getKey(), Selector.class), consumer);
                }
            }
        }
        return this.reactor;
    }

    public void addConsumersFrom(ReactorBuilder from) {
        Map<Selector, List<Consumer>> fromConsumers = from.consumers;
        Map.Entry consumerEntry = null;
        Object _consumerEntry = null;
        Iterator iterator = DefaultGroovyMethods.iterator(fromConsumers);
        while (iterator.hasNext()) {
            Map.Entry entry;
            _consumerEntry = iterator.next();
            consumerEntry = entry = (Map.Entry)ScriptBytecodeAdapter.castToType(_consumerEntry, Map.Entry.class);
            Consumer consumer = null;
            Iterator iterator2 = ((List)consumerEntry.getValue()).iterator();
            while (iterator2.hasNext()) {
                consumer = (Consumer)ScriptBytecodeAdapter.castToType(iterator2.next(), Consumer.class);
                this.on((Selector)ScriptBytecodeAdapter.castToType(consumerEntry.getKey(), Selector.class), consumer);
            }
        }
    }

    public ReactorBuilder reactor(@DelegatesTo(strategy=1, value=NestedReactorBuilder.class) Closure c) {
        return this.reactor(null, c);
    }

    public ReactorBuilder reactor(String reactorName, @DelegatesTo(strategy=1, value=NestedReactorBuilder.class) Closure c) {
        NestedReactorBuilder builder = new NestedReactorBuilder(this, reactorName, this, this.reactor);
        builder.init();
        DSLUtils.delegateFirstAndRun(builder, c);
        DefaultGroovyMethods.leftShift(this.childNodes, (Object)builder);
        return builder;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Environment pfaccess$0(ReactorBuilder $that) {
        return $that.getEnv();
    }

    public static /* synthetic */ Map<Selector, List<Consumer>> pfaccess$1(ReactorBuilder $that) {
        return $that.consumers;
    }

    public static /* synthetic */ Map<String, ReactorBuilder> pfaccess$2(ReactorBuilder $that) {
        return $that.reactorMap;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ReactorBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        Selector selector;
        ReactorBuilder.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1401738539455 = l;
        Long l2 = 1401738539455L;
        __timeStamp = l2;
        noSelector = selector = Selectors.anonymous();
        PassThroughFilter passThroughFilter = new PassThroughFilter();
        DEFAULT_FILTER = passThroughFilter;
    }

    public static final String getROUND_ROBIN() {
        return ROUND_ROBIN;
    }

    public static final String getPUB_SUB() {
        return PUB_SUB;
    }

    public static final String getRANDOM() {
        return RANDOM;
    }

    public static final String getFIRST() {
        return FIRST;
    }

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment environment) {
        this.env = environment;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public EventRouter getRouter() {
        return this.router;
    }

    public void setRouter(EventRouter eventRouter) {
        this.router = eventRouter;
    }

    public ConsumerInvoker getConsumerInvoker() {
        return this.consumerInvoker;
    }

    public void setConsumerInvoker(ConsumerInvoker consumerInvoker) {
        this.consumerInvoker = consumerInvoker;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean getOverride() {
        return this.override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean bl) {
        this.override = bl;
    }

    public final String getName() {
        return this.name;
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(ReactorBuilder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ReactorBuilder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EventRouterPredicate
    implements Predicate<Event<?>>,
    GroovyObject {
        private final Selector sel;
        public /* synthetic */ ReactorBuilder this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public EventRouterPredicate(ReactorBuilder $p$, Selector sel) {
            Selector selector;
            MetaClass metaClass;
            ReactorBuilder reactorBuilder;
            this.this$0 = reactorBuilder = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.sel = selector = sel;
        }

        public boolean test(Event<?> event) {
            return this.sel.matches(event.getHeaders().get(StreamEventRouter.KEY_HEADER));
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(EventRouterPredicate.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, EventRouterPredicate.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(EventRouterPredicate.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != EventRouterPredicate.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            EventRouterPredicate.__$swapInit();
        }

        public final Selector getSel() {
            return this.sel;
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(EventRouterPredicate.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = EventRouterPredicate.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class HeadAndTail
    implements Comparable<HeadAndTail>,
    GroovyObject {
        private final Deferred<Event<?>, Stream<Event<?>>> head;
        private final Stream<Event<?>> tail;
        private final Selector selector;
        public /* synthetic */ ReactorBuilder this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public HeadAndTail(ReactorBuilder $p$, Deferred<Event<?>, Stream<Event<?>>> head, Stream<Event<?>> tail, Selector selector) {
            Selector selector2;
            MetaClass metaClass;
            ReactorBuilder reactorBuilder;
            this.this$0 = reactorBuilder = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Deferred<Event<?>, Stream<Event<?>>> deferred = head;
            this.head = deferred;
            Stream<Event<?>> stream = tail;
            this.tail = stream;
            this.selector = selector2 = selector;
        }

        @Override
        public int compareTo(HeadAndTail o) {
            return DefaultTypeTransformation.booleanUnbox((Object)this.selector) ? 1 : 0;
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(HeadAndTail.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, HeadAndTail.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(HeadAndTail.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HeadAndTail.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            HeadAndTail.__$swapInit();
        }

        public final Deferred<Event<?>, Stream<Event<?>>> getHead() {
            return this.head;
        }

        public final Stream<Event<?>> getTail() {
            return this.tail;
        }

        public final Selector getSelector() {
            return this.selector;
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(HeadAndTail.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = HeadAndTail.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public final class NestedReactorBuilder
    extends ReactorBuilder {
        public /* synthetic */ ReactorBuilder this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NestedReactorBuilder(ReactorBuilder $p$, String reactorName, ReactorBuilder parent, Reactor reactor) {
            ReactorBuilder reactorBuilder;
            this.this$0 = reactorBuilder = $p$;
            super(reactorName, (Map)ScriptBytecodeAdapter.castToType((Object)parent.getProperty("reactorMap"), Map.class), reactor);
            this.rehydrate(parent);
            Environment environment = parent.getEnv();
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)environment, NestedReactorBuilder.class, (GroovyObject)this, (String)"env");
            ((Map)this.getProperty("consumers")).putAll((Map)ScriptBytecodeAdapter.castToType((Object)parent.getProperty("consumers"), Map.class));
        }

        public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NestedReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$2(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NestedReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$2(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(NestedReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NestedReactorBuilder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NestedReactorBuilder.__$swapInit();
        }

        public /* synthetic */ void super$2$addConsumersFrom(ReactorBuilder reactorBuilder) {
            super.addConsumersFrom(reactorBuilder);
        }

        public /* synthetic */ EventRouter super$2$getRouter() {
            return super.getRouter();
        }

        public /* synthetic */ void super$2$stream(String string, Closure closure) {
            super.stream(string, (Closure<Stream>)closure);
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        public /* synthetic */ ReactorBuilder super$2$reactor(String string, Closure closure) {
            return super.reactor(string, closure);
        }

        public /* synthetic */ Reactor super$2$get() {
            return super.get();
        }

        public /* synthetic */ void super$2$rehydrate(ReactorBuilder reactorBuilder) {
            super.rehydrate(reactorBuilder);
        }

        public /* synthetic */ ReactorBuilder super$2$on(String string, Consumer consumer) {
            return super.on(string, consumer);
        }

        public /* synthetic */ Converter super$2$getConverter() {
            return super.getConverter();
        }

        public /* synthetic */ void super$2$setConsumerInvoker(ConsumerInvoker consumerInvoker) {
            super.setConsumerInvoker(consumerInvoker);
        }

        public /* synthetic */ Environment super$2$getEnv() {
            return super.getEnv();
        }

        public /* synthetic */ void super$2$setDispatcher(Dispatcher dispatcher) {
            super.setDispatcher(dispatcher);
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ Object super$2$invokeMethod(String string, Object object) {
            return super.invokeMethod(string, object);
        }

        public /* synthetic */ ReactorBuilder super$2$dispatcher(String string) {
            return super.dispatcher(string);
        }

        public /* synthetic */ Filter super$2$getFilter() {
            return super.getFilter();
        }

        public /* synthetic */ void super$2$exts(Map map) {
            super.exts(map);
        }

        public /* synthetic */ Dispatcher super$2$getDispatcher() {
            return super.getDispatcher();
        }

        public /* synthetic */ void super$2$stream(Selector selector, Deferred deferred, Stream stream) {
            super.stream(selector, deferred, stream);
        }

        public /* synthetic */ ReactorBuilder super$2$on(Selector selector, Closure closure) {
            return super.on(selector, closure);
        }

        public /* synthetic */ boolean super$2$getOverride() {
            return super.getOverride();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Object super$2$getProperty(String string) {
            return super.getProperty(string);
        }

        public /* synthetic */ void super$2$setConverter(Converter converter) {
            super.setConverter(converter);
        }

        public /* synthetic */ ReactorBuilder super$2$on(String string, Closure closure) {
            return super.on(string, closure);
        }

        public /* synthetic */ void super$2$setOverride(boolean bl) {
            super.setOverride(bl);
        }

        public /* synthetic */ boolean super$2$isOverride() {
            return super.isOverride();
        }

        public /* synthetic */ Filter super$2$routingStrategy(String string) {
            return super.routingStrategy(string);
        }

        public /* synthetic */ void super$2$setProperty(String string, Object object) {
            super.setProperty(string, object);
        }

        public /* synthetic */ void super$2$stream(Closure closure) {
            super.stream((Closure<Stream>)closure);
        }

        public /* synthetic */ void super$2$setFilter(Filter filter) {
            super.setFilter(filter);
        }

        public /* synthetic */ void super$2$stream(Deferred deferred, Stream stream) {
            super.stream(deferred, stream);
        }

        public /* synthetic */ Object super$2$this$dist$invoke$1(String string, Object object) {
            return super.this$dist$invoke$1(string, object);
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ Object super$2$ext(String string) {
            return super.ext(string);
        }

        public /* synthetic */ void super$2$setMetaClass(MetaClass metaClass) {
            super.setMetaClass(metaClass);
        }

        public /* synthetic */ void super$2$init() {
            super.init();
        }

        public /* synthetic */ void super$2$this$dist$set$1(String string, Object object) {
            super.this$dist$set$1(string, object);
        }

        public /* synthetic */ void super$2$ext(String string, Object object) {
            super.ext(string, object);
        }

        public /* synthetic */ ReactorBuilder super$2$on(Selector selector, Consumer consumer) {
            return super.on(selector, consumer);
        }

        public /* synthetic */ void super$2$setEnv(Environment environment) {
            super.setEnv(environment);
        }

        public /* synthetic */ ReactorBuilder super$2$on(Consumer consumer) {
            return super.on(consumer);
        }

        public /* synthetic */ MetaClass super$2$getMetaClass() {
            return super.getMetaClass();
        }

        public /* synthetic */ ConsumerInvoker super$2$getConsumerInvoker() {
            return super.getConsumerInvoker();
        }

        public /* synthetic */ Object super$2$this$dist$get$1(String string) {
            return super.this$dist$get$1(string);
        }

        public /* synthetic */ void super$2$stream(Selector selector, Closure closure) {
            super.stream(selector, (Closure<Stream>)closure);
        }

        public /* synthetic */ String super$2$getName() {
            return super.getName();
        }

        public /* synthetic */ void super$2$setRouter(EventRouter eventRouter) {
            super.setRouter(eventRouter);
        }

        public /* synthetic */ ReactorBuilder super$2$reactor(Closure closure) {
            return super.reactor(closure);
        }

        public /* synthetic */ ReactorBuilder super$2$on(Closure closure) {
            return super.on(closure);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NestedReactorBuilder.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NestedReactorBuilder.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

