/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.tree.JCTree;
import java.util.regex.Pattern;

public class Javac {
    private static final Pattern PRIMITIVE_TYPE_NAME_PATTERN = Pattern.compile("^(boolean|byte|short|int|long|float|double|char)$");
    public static final int CTC_BOOLEAN = Javac.getCtcInt(TypeTags.class, "BOOLEAN");
    public static final int CTC_INT = Javac.getCtcInt(TypeTags.class, "INT");
    public static final int CTC_DOUBLE = Javac.getCtcInt(TypeTags.class, "DOUBLE");
    public static final int CTC_FLOAT = Javac.getCtcInt(TypeTags.class, "FLOAT");
    public static final int CTC_SHORT = Javac.getCtcInt(TypeTags.class, "SHORT");
    public static final int CTC_BYTE = Javac.getCtcInt(TypeTags.class, "BYTE");
    public static final int CTC_LONG = Javac.getCtcInt(TypeTags.class, "LONG");
    public static final int CTC_CHAR = Javac.getCtcInt(TypeTags.class, "CHAR");
    public static final int CTC_VOID = Javac.getCtcInt(TypeTags.class, "VOID");
    public static final int CTC_NONE = Javac.getCtcInt(TypeTags.class, "NONE");
    public static final int CTC_NOT_EQUAL = Javac.getCtcInt(JCTree.class, "NE");
    public static final int CTC_NOT = Javac.getCtcInt(JCTree.class, "NOT");
    public static final int CTC_BITXOR = Javac.getCtcInt(JCTree.class, "BITXOR");
    public static final int CTC_UNSIGNED_SHIFT_RIGHT = Javac.getCtcInt(JCTree.class, "USR");
    public static final int CTC_MUL = Javac.getCtcInt(JCTree.class, "MUL");
    public static final int CTC_PLUS = Javac.getCtcInt(JCTree.class, "PLUS");
    public static final int CTC_BOT = Javac.getCtcInt(TypeTags.class, "BOT");
    public static final int CTC_EQUAL = Javac.getCtcInt(JCTree.class, "EQ");

    private Javac() {
    }

    public static boolean isPrimitive(JCTree.JCExpression ref) {
        String typeName = ref.toString();
        return PRIMITIVE_TYPE_NAME_PATTERN.matcher(typeName).matches();
    }

    public static Object calculateGuess(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)expr;
            if (lit.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                return ((Number)lit.value).intValue() != 0;
            }
            return lit.value;
        }
        if (expr instanceof JCTree.JCIdent || expr instanceof JCTree.JCFieldAccess) {
            String x = expr.toString();
            if (x.endsWith(".class")) {
                x = x.substring(0, x.length() - 6);
            } else {
                int idx = x.lastIndexOf(46);
                if (idx > -1) {
                    x = x.substring(idx + 1);
                }
            }
            return x;
        }
        return null;
    }

    public static int getCtcInt(Class<?> ctcLocation, String identifier) {
        try {
            return (Integer)ctcLocation.getField(identifier).get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

