/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableList<T>
implements Iterable<T> {
    private Object[] content;
    private static final ImmutableList<?> EMPTY = new ImmutableList(new Object[0]);

    public static <T> ImmutableList<T> of() {
        return EMPTY;
    }

    public static <T> ImmutableList<T> of(T a) {
        return new ImmutableList<T>(new Object[]{a});
    }

    public static <T> ImmutableList<T> of(T a, T b) {
        return new ImmutableList<T>(new Object[]{a, b});
    }

    public static <T> ImmutableList<T> of(T a, T b, T c) {
        return new ImmutableList<T>(new Object[]{a, b, c});
    }

    public static <T> ImmutableList<T> of(T a, T b, T c, T d) {
        return new ImmutableList<T>(new Object[]{a, b, c, d});
    }

    public static <T> ImmutableList<T> of(T a, T b, T c, T d, T e) {
        return new ImmutableList<T>(new Object[]{a, b, c, d, e});
    }

    public static <T> ImmutableList<T> of(T a, T b, T c, T d, T e, T f, T ... g) {
        Object[] objectArray;
        if (g == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = g;
        }
        T[] rest = objectArray;
        Object[] val = new Object[rest.length + 6];
        System.arraycopy(rest, 0, val, 6, rest.length);
        val[0] = a;
        val[1] = b;
        val[2] = c;
        val[3] = d;
        val[4] = e;
        val[5] = f;
        return new ImmutableList<T>(val);
    }

    public static <T> ImmutableList<T> copyOf(Collection<? extends T> list) {
        return new ImmutableList<T>(list.toArray());
    }

    public static <T> ImmutableList<T> copyOf(Iterable<? extends T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T o : iterable) {
            list.add(o);
        }
        return ImmutableList.copyOf(list);
    }

    private ImmutableList(Object[] content) {
        this.content = content;
    }

    public ImmutableList<T> replaceElementAt(int idx, T newValue) {
        Object[] newContent = (Object[])this.content.clone();
        newContent[idx] = newValue;
        return new ImmutableList<T>(newContent);
    }

    public ImmutableList<T> append(T newValue) {
        int len = this.content.length;
        Object[] newContent = new Object[len + 1];
        System.arraycopy(this.content, 0, newContent, 0, len);
        newContent[len] = newValue;
        return new ImmutableList<T>(newContent);
    }

    public ImmutableList<T> prepend(T newValue) {
        int len = this.content.length;
        Object[] newContent = new Object[len + 1];
        System.arraycopy(this.content, 0, newContent, 1, len);
        newContent[0] = newValue;
        return new ImmutableList<T>(newContent);
    }

    public int indexOf(T val) {
        int len = this.content.length;
        if (val == null) {
            for (int i = 0; i < len; ++i) {
                if (this.content[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            if (!val.equals(this.content[i])) continue;
            return i;
        }
        return -1;
    }

    public ImmutableList<T> removeElement(T val) {
        int idx = this.indexOf(val);
        return idx == -1 ? this : this.removeElementAt(idx);
    }

    public ImmutableList<T> removeElementAt(int idx) {
        int len = this.content.length;
        Object[] newContent = new Object[len - 1];
        if (idx > 0) {
            System.arraycopy(this.content, 0, newContent, 0, idx);
        }
        if (idx < len - 1) {
            System.arraycopy(this.content, idx + 1, newContent, idx, len - idx - 1);
        }
        return new ImmutableList<T>(newContent);
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public int size() {
        return this.content.length;
    }

    public T get(int idx) {
        return (T)this.content[idx];
    }

    public boolean contains(T in) {
        if (in == null) {
            for (Object e : this.content) {
                if (e != null) continue;
                return true;
            }
            return false;
        }
        for (Object e : this.content) {
            if (!in.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ImmutableList.this.content.length;
            }

            @Override
            public T next() {
                if (this.idx < ImmutableList.this.content.length) {
                    return ImmutableList.this.content[this.idx++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("List is immutable");
            }
        };
    }

    public String toString() {
        return Arrays.toString(this.content);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutableList)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Arrays.equals(this.content, ((ImmutableList)obj).content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }
}

