// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFTableStatusVer15 implements OFTableStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFTableStatusVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 24;
    // maximum OF message length: 16 bit, unsigned
    final static int MAXIMUM_LENGTH = 0xFFFF;

        private final static long DEFAULT_XID = 0x0L;

    // OF message fields
    private final long xid;
    private final OFTableReason reason;
    private final OFTableDesc table;
//

    // package private constructor - used by readers, builders, and factory
    OFTableStatusVer15(long xid, OFTableReason reason, OFTableDesc table) {
        if(reason == null) {
            throw new NullPointerException("OFTableStatusVer15: property reason cannot be null");
        }
        if(table == null) {
            throw new NullPointerException("OFTableStatusVer15: property table cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.reason = reason;
        this.table = table;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_STATUS;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public long getRole()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }

    @Override
    public OFTableReason getReason() {
        return reason;
    }

    @Override
    public OFTableDesc getTable() {
        return table;
    }



    public OFTableStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFTableStatus.Builder {
        final OFTableStatusVer15 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFTableReason reason;
        private boolean tableSet;
        private OFTableDesc table;

        BuilderWithParent(OFTableStatusVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_STATUS;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFTableStatus.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getRole()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }

    @Override
    public OFTableStatus.Builder setRole(long role) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }
    @Override
    public OFTableReason getReason() {
        return reason;
    }

    @Override
    public OFTableStatus.Builder setReason(OFTableReason reason) {
        this.reason = reason;
        this.reasonSet = true;
        return this;
    }
    @Override
    public OFTableDesc getTable() {
        return table;
    }

    @Override
    public OFTableStatus.Builder setTable(OFTableDesc table) {
        this.table = table;
        this.tableSet = true;
        return this;
    }


        @Override
        public OFTableStatus build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                OFTableReason reason = this.reasonSet ? this.reason : parentMessage.reason;
                if(reason == null)
                    throw new NullPointerException("Property reason must not be null");
                OFTableDesc table = this.tableSet ? this.table : parentMessage.table;
                if(table == null)
                    throw new NullPointerException("Property table must not be null");

                //
                return new OFTableStatusVer15(
                    xid,
                    reason,
                    table
                );
        }

    }

    static class Builder implements OFTableStatus.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFTableReason reason;
        private boolean tableSet;
        private OFTableDesc table;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_STATUS;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFTableStatus.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getRole()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }

    @Override
    public OFTableStatus.Builder setRole(long role) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }
    @Override
    public OFTableReason getReason() {
        return reason;
    }

    @Override
    public OFTableStatus.Builder setReason(OFTableReason reason) {
        this.reason = reason;
        this.reasonSet = true;
        return this;
    }
    @Override
    public OFTableDesc getTable() {
        return table;
    }

    @Override
    public OFTableStatus.Builder setTable(OFTableDesc table) {
        this.table = table;
        this.tableSet = true;
        return this;
    }
//
        @Override
        public OFTableStatus build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            if(!this.reasonSet)
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            if(reason == null)
                throw new NullPointerException("Property reason must not be null");
            if(!this.tableSet)
                throw new IllegalStateException("Property table doesn't have default value -- must be set");
            if(table == null)
                throw new NullPointerException("Property table must not be null");


            return new OFTableStatusVer15(
                    xid,
                    reason,
                    table
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFTableStatus> {
        @Override
        public OFTableStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 6
            byte version = bb.readByte();
            if(version != (byte) 0x6)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got="+version);
            // fixed value property type == 31
            byte type = bb.readByte();
            if(type != (byte) 0x1f)
                throw new OFParseError("Wrong type: Expected=OFType.TABLE_STATUS(31), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            OFTableReason reason = OFTableReasonSerializerVer15.readFrom(bb);
            // pad: 7 bytes
            bb.skipBytes(7);
            OFTableDesc table = OFTableDescVer15.READER.readFrom(bb);

            OFTableStatusVer15 tableStatusVer15 = new OFTableStatusVer15(
                    xid,
                      reason,
                      table
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", tableStatusVer15);
            return tableStatusVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFTableStatusVer15Funnel FUNNEL = new OFTableStatusVer15Funnel();
    static class OFTableStatusVer15Funnel implements Funnel<OFTableStatusVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFTableStatusVer15 message, PrimitiveSink sink) {
            // fixed value property version = 6
            sink.putByte((byte) 0x6);
            // fixed value property type = 31
            sink.putByte((byte) 0x1f);
            // FIXME: skip funnel of length
            sink.putLong(message.xid);
            OFTableReasonSerializerVer15.putTo(message.reason, sink);
            // skip pad (7 bytes)
            message.table.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFTableStatusVer15> {
        @Override
        public void write(ByteBuf bb, OFTableStatusVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property version = 6
            bb.writeByte((byte) 0x6);
            // fixed value property type = 31
            bb.writeByte((byte) 0x1f);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeInt(U32.t(message.xid));
            OFTableReasonSerializerVer15.writeTo(bb, message.reason);
            // pad: 7 bytes
            bb.writeZero(7);
            message.table.writeTo(bb);

            // update length field
            int length = bb.writerIndex() - startIndex;
            if (length > MAXIMUM_LENGTH) {
                throw new IllegalArgumentException("OFTableStatusVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFTableStatusVer15(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("reason=").append(reason);
        b.append(", ");
        b.append("table=").append(table);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFTableStatusVer15 other = (OFTableStatusVer15) obj;

        if( xid != other.xid)
            return false;
        if (reason == null) {
            if (other.reason != null)
                return false;
        } else if (!reason.equals(other.reason))
            return false;
        if (table == null) {
            if (other.table != null)
                return false;
        } else if (!table.equals(other.table))
            return false;
        return true;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFTableStatusVer15 other = (OFTableStatusVer15) obj;

        // ignore XID
        if (reason == null) {
            if (other.reason != null)
                return false;
        } else if (!reason.equals(other.reason))
            return false;
        if (table == null) {
            if (other.table != null)
                return false;
        } else if (!table.equals(other.table))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + ((reason == null) ? 0 : reason.hashCode());
        result = prime * result + ((table == null) ? 0 : table.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        final int prime = 31;
        int result = 1;

        // ignore XID
        result = prime * result + ((reason == null) ? 0 : reason.hashCode());
        result = prime * result + ((table == null) ? 0 : table.hashCode());
        return result;
    }

}
